import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class contains symmetrization routines.
   The goal is to apply a symmetrization operation
   which decreases the energy overall.  I am not
   sure how to prove that these work.  The only idea
   I have so far is to show that both the bow energies
   and the base energies are decreased.   Given an array
   of points like this:

                           3

                       2       0

                           1

    all connecting to the infinite point (4), the base
    energy is  
    (01)+(12)+(23)+(30). The bow energies are 
    (40)+(02)+(40)  and 
    (41)+(13)+(34).  
*/


    public class Symmetrize {

	/**This tests the energy difference for power laws.*/

	public static double[][] energyDiff(int choice,double e,Complex[] z) {
	    Complex[] w0=symm(0,z);
	    Complex[] w1=symm(1,z);
  	    double[][] initial=EnergyPower.energyList(e,z);
	    double[][] total=  EnergyPower.energyList(e,w0);
	    double[][] middle=EnergyPower.energyList(e,w1);

	    double[][] test=new double[5][5];
	    for(int i=0;i<5;++i) {
		for(int j=i+1;j<5;++j) {
		    if(choice==0) test[i][j]=initial[i][j]-total[i][j];
		    if(choice==1) test[i][j]=initial[i][j]-middle[i][j];
		    if(choice==2) test[i][j]=middle[i][j]-total[i][j];
		}
	    }
	    return test;
	}


	public static Complex[] symm(int choice,Complex[] z) {
	    if(choice==0) return symm0(z);
	    if(choice==1) return symm1(z);
	    return null;
	}


	/**Here is the init->final symmetrization routine*/

    public static Complex[] symm0(Complex[] z) {
	double d02=.5*(z[0].x-z[2].x);
	double d13=.5*(z[3].y-z[1].y);
	Complex[] W=new Complex[4];
	W[0]=new Complex(+d02,0);
	W[1]=new Complex(0,-d13);
	W[2]=new Complex(-d02,0);
	W[3]=new Complex(0,+d13);
	return W;
    }

	/**Here is the init->middle symmetrization routine*/

    public static Complex[] symm1(Complex[] z) {
	double d02=.5*(z[0].x-z[2].x);
	double d13=.5*(z[3].y-z[1].y);
	Complex[] W=new Complex[4];
	W[0]=new Complex(+d02,z[0].y);
	W[1]=new Complex(0,z[1].y);
	W[2]=new Complex(-d02,z[2].y);
	W[3]=new Complex(0,z[3].y);
	return W;
    }

}

    
