import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This tests the difference in energy before and after the 
   chosen symmetrization operation.  As the program runs, it
   computes the minimimum energy change over many trials and
   reports the answer every million trials.  The symmetrization
   operation is good this minimum remains positive.*/

public class SymmetrizeTester implements Runnable {
    boolean HALT;
    Manager M;

    public SymmetrizeTester() {
	HALT=true;
    }
    public SymmetrizeTester(Manager m) {
	M=m;
	HALT=true;
    }


    public void run() {
	M.P.COUNT=0;
	HALT=false;
	int[] b=new int[16];
	double min=100;
	long count=0;
	long count2=0;
	while(HALT==false) {
	   double test=doTest();
	   if(count==1000000) {
                 System.out.println(count2+" million: min="+min);
		 count=0;
		 ++count2;
		 M.P.COUNT=count2;
	   }
	   ++count;
	   if(min>test) min=test;
	   if(min>0) M.P.STATUS=+1;
	   if(min<0) M.P.STATUS=-1;
	   if((min<0)&&(min>-Math.pow(10,-15))) M.P.STATUS=2;
	   M.P.repaint();
	}
	System.out.println("done "+count2+" "+count);
    }



    public double doTest() {
	int t=M.C.RAN.mode;
	double[] custom=new double[9];
	for(int i=0;i<7;++i) custom[i]=1.0*M.C.CUSTOM[i].val/512;
	Complex[] z=RandomGenerator.randomConfig(t,custom); //config
	double s=getExponent();
	double min=1;
	double[][] d=Symmetrize.energyDiff(M.C.MODE.mode,s,z);
	double test=sum(d);
	test=test+SymmTesterExtra.fudge(M.C.FUDGE.mode,s,z); 
	if(M.C.FAIL.mode==2) sendConfig(z);
	if((M.C.ANALYZE.mode==1)&&(test<0)) SymmTesterExtra.analyzeFail(z);
	if((test<0)&&(M.C.FAIL.mode==1)) sendConfig(z);
	return test;
    }

    public double getExponent() {
	int s1=M.C.RANGE1.val;         
	int s2=M.C.RANGE2.val;  
	double t=Math.random();
	return (1-t)*s1+t*s2;
    }

    public double sum(double[][] d) {
	double tot=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		tot=tot+M.S.BOND[i][j]*d[i][j];
	    }
	}
	return tot;
    }

    public double max(double[][] d) {
	double max=-1;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		if(M.S.BOND[i][j]==1) {
		    if(max<d[i][j]) max=d[i][j];
		}
	    }
	}
	return max;
    }

    public void sendConfig(Complex[] z) {
        for(int i=0;i<4;++i) {
           M.P.Z[i]=z[i];
	}
	M.P.repaint();
    } 


}
    
