import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This file gives the data for the affine cubes
   used in the monograph.  The first half of the
   file is accessed by the file SymmPoly1.java.
   The second half of the file is accessed by
   SymmPoly2.java*/

public class AffineCubeData {

    /**These are the data for the affine cube coverings of
       Omega'_1 and Omega'_3 in the monograph. This data
       should match the domains in the files  
       debug_symmpoly1_trace 
       debug_symmpoly1_det
    */

    public static int[][] A11() {
	int[][] d={{498,432},{0,16},{-32,16},{348,465},{0,64}};
	return d;
    }

    public static int[][] A12() {
	int[][] d={{432,416},{0,16},{-32,16},{348,465},{0,64}};
	return d;
    }

    public static int[][] A31() {
	int[][] d={{498,432},{0,16},{-16,32},{-348,-465},{0,64}};
	return d;
    }

    public static int[][] A32() {
	int[][] d={{432,416},{0,16},{-16,32},{-348,-465},{0,64}};
	return d;
    }

    /**These are the data for the affine cube coverings of
       Omega''_2 in the monograph. This data
       should match the domains in the file 
       debug_symmpoly2
    */

    public static int[][] B00() {
	int[][] d={{416,498},{0,16},{348,465},{0,-24}};
	return d;
    }


    public static int[][] B01() {
	int[][] d={{416,498},{0,16},{364,449},{0,-64}};
	return d;
    }

    public static int[][] B10() {
	int[][] d={{416,498},{0,16},{348,465},{0,24}};
	return d;
    }


    public static int[][] B11() {
	int[][] d={{416,498},{0,16},{364,449},{0,64}};
	return d;
    }


    /**This is just one function which lets you
       grab the relevant data based on the indices*/

    public static int[][] X(int i,int k) {
	if((i==0)&&(k==0)) return A11();
	if((i==0)&&(k==1)) return A12();
	if((i==0)&&(k==2)) return A31();
	if((i==0)&&(k==3)) return A32();
	if((i==1)&&(k==0)) return B00();
	if((i==1)&&(k==1)) return B01();
	if((i==1)&&(k==2)) return B10();
	if((i==1)&&(k==3)) return B11();
	return null;
    }


}

