import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This class is a rational number P/Q.  It allows us to
do arithmetic operations with rational numbers having a
very large number of digits*/

public class BigRational {
    BigInteger P;
    BigInteger Q;

    public BigRational() {}

    /**Constructors*/

    public BigRational(long p,long q) {
	Long pp=new Long(p);
	Long qq=new Long(q);
	P=new BigInteger(pp.toString());
	Q=new BigInteger(qq.toString());
    }

    public BigRational(long p) {
	Long pp=new Long(p);
	P=new BigInteger(pp.toString());
	Q=new BigInteger("1");
    }


    public BigRational(BigRational R) {
	P=new BigInteger(R.P.toString());
	Q=new BigInteger(R.Q.toString());
    }

    public BigRational(BigInteger P0,BigInteger Q0) {
	P=new BigInteger(P0.toString());
	Q=new BigInteger(Q0.toString());
    }

    public BigRational(String p,String q) {
	P=new BigInteger(p);
	Q=new BigInteger(q);
    }
    /**End constructors*/

    /** reduces to lowest terms*/

    public void reduce() {
	BigInteger C=P.gcd(Q);
	P=P.divide(C);
	Q=Q.divide(C);
    }

    /**Here are the basic arithmetic operations*/

    public BigRational add(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.add(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }

    public BigRational subtract(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.subtract(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }

    public BigRational multiply(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.P);
	Y.reduce();
	return(Y);
    }
    public BigRational divide(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.P);
	Y.P=P.multiply(X.Q);
	Y.reduce();
	return(Y);
    }


    /**Additional operations*/

    public BigRational invert() {
	BigRational Y=new BigRational(Q,P);
	return(Y);
    }

    public BigRational negate() {
	BigRational Z=new BigRational(0,1);
	return Z.subtract(this);
    }

    /**Comparison routines*/

    public boolean isZero() {
	if(P.signum()==0) return true;
	return false;
    }

    public boolean isPositive() {
	int a=P.signum()*Q.signum();
	if(a==1) return true;
	return false;
    }

    public boolean isNegative() {
	int a=P.signum()*Q.signum();
	if(a==-1) return true;
	return false;
    }


}


    

