import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is our class for a polynomial in 5 variables.
   The polynomial is a list of monomials (Mono5 classes).
   The number count tells the number of terms*/


public class Poly5 {

    Mono5[] m=new Mono5[200000];
    int count;

    public Poly5() {
    }

    public Poly5(Poly5 P) {
	this.count=P.count;
	for(int i=0;i<this.count;++i) this.m[i]=new Mono5(P.m[i]);
    }

    /**With this constructor the 0th term gives the coefficient*/

    public Poly5(long[][] a) {
	this.count=a.length;
	for(int i=0;i<this.count;++i) {
	    long c=a[i][0];
	    long[] b={a[i][1],a[i][2],a[i][3],a[i][4],a[i][5],a[i][5]};
	    this.m[i]=new Mono5(c,b);
	}
    }

    /**This replaces the polynomial P by the polynomial -P*/
    public Poly5 negate() {
	Poly5 P=new Poly5();
	P.count=this.count;
	for(int i=0;i<P.count;++i) P.m[i]=this.m[i].negate();
	return P;
    }

    /**This adds 2 polynomials together*/
    public static Poly5 plus(Poly5 P,Poly5 Q) {
	Poly5 R=new Poly5();
	int c=0;
	for(int i=0;i<P.count;++i) {
	    R.m[c]=new Mono5(P.m[i]);
	    ++c;
	}

	for(int i=0;i<Q.count;++i) {
	    R.m[c]=new Mono5(Q.m[i]);
	    ++c;
	}
	R.count=c;
	R=PolyCompress.main(R);
	return(R);
    }

    /**This subtracts two polynomials*/
    public static Poly5 minus(Poly5 P,Poly5 Q) {
	return plus(P,Q.negate());
    }

    /**This multiplies two polynomials*/
    public static Poly5 times(Poly5 P,Poly5 Q) {
	Poly5 R=new Poly5();
	int c=0;
	for(int i=0;i<P.count;++i) {
	    for(int j=0;j<Q.count;++j) {
		R.m[c]=Mono5.times(P.m[i],Q.m[j]);
		++c;
	    }
	}
	R.count=c;
	R=PolyCompress.main(R);
	return(R);
    }

    /**This composes one polynomial with another.  That is, we
       have some polynomial F(x0,...,x4) and we have a list of
       polynomials P1,...,P4 and we make the new polynomial
       G(x0,...,x4)=F(P0,...,P4).*/

    public Poly5 compose(Poly5[] P) {
	Poly5 Q=constant(new BigRational("0","1"));
	for(int i=0;i<this.count;++i) {
	    Poly5 X=compose(this.m[i],P);
	    Q=plus(Q,X);
	}
	Q=PolyCompress.main(Q);
	return Q;
    }


    /**This is a piece in the previous routine.  We do the
       composition operation just for monomials*/

    public static Poly5 compose(Mono5 m,Poly5[] P) {
	Poly5 Q=constant(new BigRational("1","1"));
	for(int i=0;i<5;++i) Q=times(Q,power(P[i],m.e[i]));
	Q=Q.scale(m.c);
	return Q;
    }

    /**kth partial derivative*/

    public Poly5 diff(int k) {
	Poly5 P=new Poly5();
	P.count=this.count;
	for(int i=0;i<P.count;++i) P.m[i]=m[i].diff(k);
	P=PolyCompress.main(P);
	return P;
    }

    /**This clears the denominators of a polynomial so that
       the whole thing has integer coefficients.  The output
       polynomial is a multiple of the input polynomial. */

    public void clearDenominator() {
	for(int k=0;k<this.count;++k) clearDenominator(k);
    }

    /**This is a piece of the clearDenominator routine*/

    public void clearDenominator(int k) {
	BigRational r=new BigRational(this.m[k].c);
	r=r.invert();
	r.Q=new BigInteger("1");
	for(int i=0;i<count;++i) m[i].c=m[i].c.multiply(r);
    }

    /**This raises a polynomial to a non-negative integer power*/

    public static Poly5 power(Poly5 P,int e) {
	Poly5 Q=constant(new BigRational("1","1"));
	for(int i=0;i<e;++i) Q=times(Q,P);
	return Q;
    }


    /**This scales the polynomial by the rational n*/

    public Poly5 scale(BigRational n) {
	Poly5 A=constant(n);
	A=times(A,this);
	return(A);
    }


    /**This creates a constant polynomial*/

    public static Poly5 constant(BigRational n) {
	Poly5 I=new Poly5();
	I.count=1;
	int[] a={0,0,0,0,0};
	I.m[0]=new Mono5(n,a);
	return(I);
    }

    /**This evaluates a polynomial at a rational*/

    public BigRational evaluate(BigRational[] x) {
	BigRational a=new BigRational("0","1");
	for(int i=0;i<count;++i) {
	    a=a.add(m[i].evaluate(x));
	}
	return(a);
    }

    /**Here is the positive dominance test.  This tests
       for weak positive dominance, in which all the
       rooted rectangular coefficient sums are non-negative
       and the total coefficient sum is positive*/

    public static boolean isPositiveDominant(Poly5 P) {
	int[] E=P.degree();
	for(int i0=0;i0<=E[0];++i0) {
	for(int i1=0;i1<=E[1];++i1) {
	for(int i2=0;i2<=E[2];++i2) {
	for(int i3=0;i3<=E[3];++i3) {
	for(int i4=0;i4<=E[4];++i4) {
	    int[] I={i0,i1,i2,i3,i4};
	    BigRational SUM=new BigRational("0","1");
	    for(int j=0;j<P.count;++j) {
		boolean test=isDominated(P.m[j].e,I);
		if(test==true) {
		    SUM=SUM.add(P.m[j].c);
		}
	    }
            if(SUM.isNegative()==true) return false;
	}}}}}
        BigRational SUM=new BigRational("0","1");
        for(int j=0;j<P.count;++j) SUM=SUM.add(P.m[j].c);
	if(SUM.isPositive()==false) return false;
	return(true);
    }

    /**This is a component of the positive dominance test. 
       It returns true if e[k]<=I[k] for all k*/

    public static boolean isDominated(int[] e,int[] I) {
	for(int i=0;i<5;++i) if(e[i]>I[i]) return(false);
	return(true);
    }


    /**This computes the degree in all the variables and
       returns a list*/

    public int[] degree() {
	int[] a=new int[5];
	for(int i=0;i<5;++i) a[i]=degree(i);
	return(a);
    }

    /**This computes the degree in the kth variable*/
    public int degree(int k) {
	int max=0;
	for(int i=0;i<count;++i) {
	    if(max<m[i].e[k]) max=m[i].e[k];
	}
	return(max);
    }


}
