import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is a special class which gathers together like terms
   in polynomials.  When we add, subtract, or multiply polynomials,
   we expand things out in the most straightforward way.  This
   routine then compresses the result so that like terms are
   grouped together.  For instance (x+y)(x+y) = x^2 + xy + xy + y^2
   is compressed to x^2+2xy+y^2*/


public class PolyCompress {


    /**Here is the main routine*/

    public static Poly5 main(Poly5 P) {
	Poly5 Q=collectLike(P);
	Poly5 R=weedOutZeros(Q);
	return(R);
    }


    /**This routine weeds out terms which have 0 as
       coefficients.*/


    public static Poly5 weedOutZeros(Poly5 Q) {
	Poly5 R=new Poly5();
	int c=0;
	for(int i=0;i<Q.count;++i) {
	    if(Q.m[i].c.isZero()==false) {
		R.m[c]=new Mono5(Q.m[i]);
		++c;
	    }
	}
	R.count=c;
	return(R);
    }


    /**This routine gathers together the like terms,
       but does not weed out the terms whose final
       coefficient is 0*/

    public static Poly5 collectLike(Poly5 P) {
	int[][] LIST=exponentList(P);
	Poly5 Q=new Poly5();
	Q.count=LIST.length;
	for(int i=0;i<LIST.length;++i) {
	    Q.m[i]=new Mono5();
	    Q.m[i].c=new BigRational("0","1");
	    Q.m[i].e=LIST[i];
	    for(int j=0;j<P.count;++j) {
		if(match(P.m[j].e,LIST[i])==true) {
		    Q.m[i].c=Q.m[i].c.add(P.m[j].c);
		}
	    }
	}
	return(Q);
    }

    /**This gets the complete list of nonzero exponents.
       This does not keep track of the coefficients of
       the corresponding monomials*/

    public static int[][] exponentList(Poly5 P) {
	int[][] LIST=new int[P.count][5];
	int c=0;
	for(int i=0;i<P.count;++i) {
	    if(onList(P.m[i].e,LIST,c)==false) {
		LIST[c]=P.m[i].e;
		++c;
	    }
	}
	int[][] LIST2=new int[c][5];
	for(int i=0;i<c;++i) LIST2[i]=LIST[i];
	return(LIST2);
    }

    /**This decides if one integer list (a) is on a list (LIST) of integer lists.
       Here `length' is the length of the list*/
 
    public static boolean onList(int[] a,int[][] LIST,int length) {
	for(int i=0;i<length;++i) {
	    if(match(a,LIST[i])==true) return(true);
	}
	return(false);
    }

    /**This decides if two integer lists match exactly.
       It is used for deciding when two monomials are
       multiples of each other*/

    public static boolean match(int[] a,int[] b) {
	if(a.length!=b.length) return(false);
	for(int i=0;i<a.length;++i) {
	    if(a[i]!=b[i]) return(false);
	}
	return(true);
    }


}

