import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is the class for a rational function in 5 variables.
   The function is P/Q where P and Q are polynomials*/

public class PolyRat {
    Poly5 P,Q;

    /**Constructors*/

    /**This takes p as input and returns p/1*/

    public PolyRat(Poly5 p) {
	this.P=p;
	long[][] q={{1,0,0,0,0,0}};
	this.Q=new Poly5(q);
    }

    /**this returns p/q*/

    public PolyRat(Poly5 p,Poly5 q) {
	this.P=p;
	this.Q=q;
    }

    /**End constructors*/


    /**This starts with the rational function R and returns -R*/

    public PolyRat negate() {
	return new PolyRat(this.P.negate(),this.Q);
    }

    /**This adds two rational functions*/

    public static PolyRat plus(PolyRat R1,PolyRat R2) {
	Poly5 P=Poly5.plus(Poly5.times(R1.P,R2.Q),Poly5.times(R1.Q,R2.P));
	Poly5 Q=Poly5.times(R1.Q,R2.Q);
	P=PolyCompress.main(P);
	Q=PolyCompress.main(Q);
	PolyRat X=new PolyRat(P,Q);
	return X;
    }

    /**This subtracts two rational functions*/

    public static PolyRat minus(PolyRat R1,PolyRat R2) {
	return plus(R1,R2.negate());
    }

    /**This does the same thing as the polynomial composition
       function, except for a rational function*/

    public PolyRat compose(Poly5[] X) {
	Poly5 PP=this.P.compose(X);
	Poly5 QQ=this.Q.compose(X);
	PolyRat R=new PolyRat(PP,QQ);
	return R;
    }

    /**This scales a rational function by r*/

    public void scale(BigRational r) {
	P=P.scale(r);
    }


    /**Evaluation.  This is just for debugging purposes*/

    public BigRational evaluate(long[] t) {
	BigRational[] T=new BigRational[t.length];
	for(int i=0;i<t.length;++i) T[i]=new BigRational(t[i]);
	return evaluate(T);
    }

    public BigRational evaluate(BigRational[] t) {
	BigRational p=P.evaluate(t);
	BigRational q=Q.evaluate(t);
	BigRational r=p.divide(q);
	return r;
    }

}

