import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This file controls the arithmetic graph window.*/



public class ArithmeticGraph extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    AffineTransform[] A=new AffineTransform[5];
    Complex SOURCE;
    ComputeArithmeticGraph CAG;
    Documentation DOC;
    Output OUT; 






    Point JX;
    ListenSquare[] ACTION=new ListenSquare[10];
    Complex MOVE;

    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[3];
    ListenSquare[] L=new ListenSquare[3];  
    SelectInteger[] IS=new SelectInteger[3];

    Color[] COLOR=new Color[1000000];
    GeneralPath[] GP=new GeneralPath[1000000];
    int[] STYLE=new int[1000000];

    int SELECT=-1;
    int type=3;
    int count=0;
    ListenSquare INFO;

    public ArithmeticGraph addManager(Manager M) {
	ArithmeticGraph XX=this;
	XX.M=M;
	return(XX);
    }



    public ArithmeticGraph() {
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	DOC=new Documentation();

        SOURCE=new Complex(0,0);

	L[0]=new ListenSquare(0,0,80,38,Color.white); L[0].on=1;
	INFO=new ListenSquare(0,0,12,12,Color.black);

	setScales(230,10);
	makeConsole();
    }

    public void makeConsole() {
	 I[0]=new SelectIntegerKeyboard(15,2,40,14,0,10000);    //Xcoord
	 I[1]=new SelectIntegerKeyboard(15,22,40,14,0,10000);    //Ycoord
	 IS[0]=new SelectInteger(60,2,30,14,0,-10000,10000,1);    //Xcoord backup
	 IS[1]=new SelectInteger(60,22,30,14,0,-10000,10000,1);    //Ycoord backup
	 IS[2]=new SelectInteger(400,2,30,14,2,1,5,1);    //thickness
         ACTION[0]=new ListenSquare(150,2,13,13,Color.white);    //delete
         ACTION[1]=new ListenSquare(98,2,43,32,Color.white);     //move cursor to origin
         ACTION[2]=new ListenSquare(150,22,13,13,Color.white);   //reflect

	 for(int i=0;i<3;++i) ACTION[i].on=1; 
    }

    public void paint(Graphics gfx) {
      OUT=new Output("Output/graph_markings");
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      //background
      g.setColor(Color.black);
      try {g.setColor(M.C.CON_G.BASIC.M[0].C);} catch(Exception e) {}
      g.fillRect(0,0,this.getWidth(),this.getHeight());
      
      int mode=0;
      try {
         mode=M.C.CON_G.SCALE.mode;
      }
      catch(Exception e) {}
      //if(mode==1) drawSquare(g);
      try {if(mode==0) drawRegions(g);}
      catch(Exception e) {}
      drawPath(g);
      try{if(mode==0) drawMarker(g);}
      catch(Exception e) {}
      try {if(mode==0) drawLines(g);}
      catch(Exception e) {}



      drawControls(g);
      INFO.infoRender(g);
    }


    /**These are all the auxilliary markings.*/

      public void drawLines(Graphics2D g) {

	  /*hexagrid */
	  if(M.C.CON_G.HEX.L[0].on==1) ArithmeticGraphMarkings.drawHexagrid(g,M,OUT);
	  if(M.C.CON_G.HEX.L[1].on==1) ArithmeticGraphMarkings.drawGrid1(g,M,OUT);
	  if(M.C.CON_G.HEX.L[2].on==1) ArithmeticGraphMarkings.drawGrid2(g,M,OUT);
	  if(M.C.CON_G.HEX.L[3].on==1) ArithmeticGraphMarkings.drawGrid3(g,M,OUT);
	  if(M.C.CON_G.HEX.L[4].on==1) ArithmeticGraphMarkings.drawGrid4(g,M,OUT);
	  if(M.C.CON_G.HEX.L[5].on==1) ArithmeticGraphMarkings.drawGrid5(g,M,OUT);
	  if(M.C.CON_G.HEX.L[6].on==1) ArithmeticGraphMarkings.drawGrid6(g,M,OUT);
	  /*more lines*/
          if(M.C.CON_G.LINE.L[0].on==1) ArithmeticGraphMarkings.drawBarrier(g,M,OUT);
	  if(M.C.CON_G.LINE.L[1].on==1) ArithmeticGraphMarkings.drawIotaWall(g,M,OUT);
	  if(M.C.CON_G.LINE.L[2].on==1) ArithmeticGraphMarkings.drawSymmLine(g,M,OUT);

      }


      public void drawRegions(Graphics2D g) {

	  /*regions*/
          if(M.C.CON_G.REGION.L[5].on==1) ArithmeticGraphMarkings.drawTent(g,M,OUT);
	  if(M.C.CON_G.REGION.L[1].on==1) ArithmeticGraphMarkings.drawRoom(g,M,OUT);
          if(M.C.CON_G.REGION.L[2].on==1) ArithmeticGraphMarkings.drawDecomp(g,M,OUT);
          if(M.C.CON_G.REGION.L[3].on==1) ArithmeticGraphMarkings.drawDecomp2(g,M,OUT);
          if(M.C.CON_G.REGION.L[4].on==1) ArithmeticGraphMarkings.drawKite(g,M,OUT);	  
          if(M.C.CON_G.REGION.L[6].on==1) ArithmeticGraphMarkings.drawTraps(g,M,OUT);	    
          if(M.C.CON_G.REGION.L[7].on==1) ArithmeticGraphMarkings.drawPeriodBox(g,M,OUT);	  

	  /*basics*/
          if(M.C.CON_G.BASIC.L[1].on==1) ArithmeticGraphMarkings.drawAxesGraph(g,M,OUT);
	  if(M.C.CON_G.BASIC.L[2].on==1) ArithmeticGraphMarkings.drawZ2Grid(g,M,OUT);
          if(M.C.CON_G.BASIC.L[3].on==1) ArithmeticGraphMarkings.drawBaseline(g,M,OUT);
	  if(M.C.CON_G.BASIC.L[4].on==1) ArithmeticGraphMarkings.drawRational(g,M,OUT);
	  if(M.C.EXPORT.mode==1) OUT.tclBgSet(M.C.CON_G.BASIC.M[0].C);
      }

      public void drawMarker(Graphics2D g) {
	  if(M.C.CON_G.BASIC.L[5].on==1) drawSource(g,M.C.CON_G.BASIC.M[5].C,SOURCE,.5);
      }




    public void drawSquare(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	float x=(float)(.5);
	gp.moveTo(-x,0);
	gp.lineTo(-x,1);
	gp.lineTo(x,1);
	gp.lineTo(x,0);
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);

    }


    /**this is the general routine*/

    public void drawPath(Graphics2D g) {
	int thickness=2;
	try {thickness=IS[2].val;}
	catch(Exception e) {}
	GeneralPath gp2=new GeneralPath();

	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	  g.setColor(COLOR[i]);
          g.setStroke(new BasicStroke((float)(thickness)));
	  gp=new GeneralPath(GP[i]);
          gp=transform(gp);

	  if(STYLE[i]==0) {
	     g.setColor(COLOR[i]);
	     g.draw(gp);
	  }

	  if(STYLE[i]==1) {
	     g.setColor(COLOR[i]);
	     g.fill(gp);
	  }

	  if(STYLE[i]==2) {
	     g.setColor(COLOR[i]);
	     g.fill(gp);
	     g.setColor(Color.white);
	     g.draw(gp);
	  }

	}
        g.setStroke(new BasicStroke(1));
    }

    public void drawControls(Graphics2D g) {
	L[0].w=getWidth()-1;
	L[0].render(g,Color.blue);
        for(int i=0;i<2;++i)  I[i].render(g,new Color(200,0,200),Color.black,Color.yellow,Color.white);
	for(int i=0;i<2;++i) IS[i].render(g,new Color(200,0,200),Color.white,new Color(0,0,0,0));
	for(int i=2;i<3;++i) IS[i].render(g,new Color(200,0,200),Color.white,Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,10));	
	g.setColor(Color.white);
	for(int i=0;i<2;++i) ACTION[i].render(g,new Color(200,0,200));  
	g.setColor(Color.white);
        g.drawString("delete",170,13);
        //g.drawString("reflect",170,33);
        g.drawString("line width",400,33);
	g.drawString("(0,0)",108,22);
    }


    /**output to TCL file*/

    public void savePathLines() {
	Output temp=new Output("Output/graph");
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	    gp=new GeneralPath(GP[i]);
	    temp.lineWrite(gp,COLOR[i]);
	}
    }
    public void savePathPolys() {
	Output temp=new Output("Output/graph");
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	    gp=new GeneralPath(GP[i]);
	    temp.polyWrite(gp,COLOR[i]);
	}
    }


    /** for master picture theorem demo*/
    public void sendToPE() {
	double A=M.C.SES.getParameter();
	double q=M.C.SES.getDenominator();
	int i=(int)(SOURCE.x);
	int j=(int)(SOURCE.y);
	int[] mp=TorusMap.finalPlus(A,i,j);
	int[] mm=TorusMap.finalMinus(A,i,j);
	double t=2*SOURCE.x*A+2*SOURCE.y+.001/q;
	  if(M.C.CON_P.PEC.DISPLAY.L[6].on==1) {
              M.C.CON_P.PEC.hearGraph(A,t,mm,mp,M);
	      M.PE.current=t;
	      M.PE.repaint();
	  }
    }






    public void selectPoint(Point X) {

	//integer valued selection
        MOVE=unTransform(X);
	MOVE.x=1*Math.floor(MOVE.x+.5);
	MOVE.y=1*Math.floor(MOVE.y+.5);

	int test=-1;
	for(int i=0;i<count;++i) {
	    if(GP[i].intersects(MOVE.x-.5,MOVE.y-.5,1,1)==true) test=i;
	}
	if(test!=-1) SELECT=test;
	  I[0].val=(int)(MOVE.x);
	  I[1].val=(int)(MOVE.y);
	  IS[0].val=(int)(MOVE.x);
	  IS[1].val=(int)(MOVE.y);
	  SOURCE=new Complex(MOVE);
	  sendToPE();
    }



    /*add new path to list: invoked by the arithmetic graph computer*/

    public void nextPathLast(GeneralPath X,int style) {
       GP[count]=new GeneralPath(X);
       STYLE[count]=style;
       COLOR[count]=M.C.CS.C;
       ++count;
    }

    /*deleting*/

    public void alterGraph(Point X) {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	ArithmeticGraphBox AGB=new ArithmeticGraphBox(p,q);

	int mode=-1;
	for(int i=0;i<3;++i) if(ACTION[i].inside(X)==1) mode=i;

	try {
	    if(mode==0) GP[SELECT].reset();
	    if(mode==2) GP[SELECT]=AGB.reflect(GP[SELECT]);
	}
        catch(Exception e){}
    }





    public void toOrigin() {
	I[0].val=0;
	I[1].val=0;
	IS[0].val=0;
	IS[1].val=0;
    }




    /**mouse events */
   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}


   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       DOC.M=this.M;
       MouseData J=MouseData.process(e,M.C.MOUSE.mode);
       doMouseClick(J.X,J.mode);
   }

   public void mouseMoved(MouseEvent e) {
       try {MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	   JX=J.X; }
       catch (Exception ee) {}
   }


   public void doMouseClick(Point X,int mode) {
       int test=L[0].inside(X);

       //click inside top rim
       if(test==1) {
          if(INFO.inside(X)==1) DOC.arithmeticGraphInfo();
          for(int i=0;i<3;++i) IS[i].modify(X);
          I[0].val=IS[0].val;
          I[1].val=IS[1].val; 
	  if(ACTION[1].inside(X)==1) toOrigin(); 
          SOURCE=new Complex(I[0].val,I[1].val);
	  sendToPE();
          for(int i=0;i<2;++i) {
	  I[i].on=0;
	  if(I[i].inside(X)==1) I[i].on=1;
	  }
          alterGraph(X);
       }


       //click outside top rim
       if(test==0) {
         if(mode==1)  scaleUp(X,0);
         if(mode==3)  scaleUp(X,1);
         if((M.C.EXPORT.mode==0)&&(mode==2))  selectPoint(X);
         if((M.C.EXPORT.mode==1)&&(mode==2))  savePathLines();
         if((M.C.EXPORT.mode==2)&&(mode==2))  savePathPolys();
       }

       repaint();
       M.C.repaint();
   }


/**done with mouse events*/




/**key events */

    public void keyTyped(KeyEvent e) {

	for(int i=0;i<2;++i) {
	    if(I[i].on==1) I[i].modifySign(e);
	    IS[i].val=I[i].val;
	}
        repaint();

	SOURCE=new Complex(I[0].val,I[1].val);
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(JX,test);

	if(ch=='a') forceGo(0);
	if(ch=='s') forceGo(1);
	if(ch=='d') forceGo(2);
	if(ch=='f') forceGo(8);
	if(ch=='g') forceGo(9);

    }
 
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

    public void forceGo(int j) {
	M.C.CON_G.CHOICE.forceMode(j);
	M.C.repaint();
    	CAG=new ComputeArithmeticGraph(SOURCE,M);
        new Thread(CAG).start();
    }


/**done with key events */


}
