import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ArithmeticGraphMarkings {
    public ArithmeticGraphMarkings() {
    }

    public static void drawAxesGraph(Graphics2D g,Manager M,Output OUT) {
	GeneralPath gp=new GeneralPath(); 
	Color  CC=M.C.CON_G.BASIC.M[1].C;
	int WW=1000;
	gp.moveTo(0,0);
        gp.lineTo(-WW,0);
	gp.lineTo(+WW,0);
	gp.lineTo(0,0);
        gp.lineTo(0,-WW);
	gp.lineTo(0,WW);
	if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,CC,CC);
	gp=M.R.transform(gp);
        g.setColor(CC);
	g.draw(gp);  
    }



    public static void drawRational(Graphics2D g,Manager M,Output OUT) {
	 Color COL=M.C.CON_G.BASIC.M[4].C;
          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int y=M.R.getHeight();
	  Integer P=new Integer(pp[0]);
	  Integer Q=new Integer(pp[1]);  
          g.setFont(new Font("Helvetica",Font.PLAIN,60));
	  g.setColor(COL);
	  g.drawString(P.toString(),10,y-80);
          g.setStroke(new BasicStroke((float)(4)));
	  g.drawLine(5,y-71,110,y-71);
	  g.drawString(Q.toString(),10,y-20);
	  g.setColor(Color.white);
          g.setStroke(new BasicStroke(1));


    }

    public static void drawBaseline(Graphics2D g,Manager M,Output OUT) {
	  double A=M.C.SES.getParameter();
          Color COL=M.C.CON_G.BASIC.M[3].C;
          int WW=200;
	  GeneralPath gp=new GeneralPath(); 
	  gp.moveTo((float)(-WW),(float)(WW*A));
	  gp.lineTo((float)(+WW),(float)(-WW*A));
	  g.setColor(COL);
          if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,COL,COL);
	  gp=M.R.transform(gp);
	  g.fill(gp);  
          g.draw(gp);
    }




    public static void drawZ2Grid(Graphics2D g,Manager M,Output OUT) {
	GeneralPath gp=new GeneralPath(); 
	Complex z=M.R.SOURCE;
	int i1=(int)(z.x);
	int j1=(int)(z.y);
        Color COL=M.C.CON_G.BASIC.M[2].C;
	for(int i=-40;i<=40;++i) {
	    gp.moveTo(-40+i1,i+j1);
	    gp.lineTo(+40+i1,i+j1);
            if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,COL,COL);
   	    gp=M.R.transform(gp); 
	    g.setColor(COL);
	    g.draw(gp);
	    gp.reset();
	}

	for(int i=-40;i<=40;++i) {
	    gp.moveTo(i+i1,40+j1);
	    gp.lineTo(i+i1,-40+j1);
            if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,COL,COL);
   	    gp=M.R.transform(gp); 
	    g.setColor(COL);
	    g.draw(gp);
	    gp.reset();
	}

    }


    public static void drawRoom(Graphics2D g,Manager M,Output OUT) {
          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];
	      Color COL1=M.C.CON_G.REGION.M[1].C;
	      Color COL2=M.C.CON_G.REGION.M[0].C;
	      ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	      GeneralPath gp=B.basicBox();   
              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,COL1,COL2);
	      gp=M.R.transform(gp);
	      g.setColor(COL1);
	      g.fill(gp);
	      g.setColor(COL2);
	      g.draw(gp);
    }


    public static void drawPeriodBox(Graphics2D g,Manager M,Output OUT) {
          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];
	      Color COL1=M.C.CON_G.REGION.M[7].C;
	      Color COL2=M.C.CON_G.REGION.M[0].C;
	      ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	      GeneralPath gp=B.periodBox();   
              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,COL1,COL2);
	      gp=M.R.transform(gp);
	      g.setColor(COL1);
	      g.fill(gp);
	      g.setColor(COL2);
	      g.draw(gp);
    }




    public static void drawKite(Graphics2D g,Manager M,Output OUT) {
           int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];


	      Color COL1=M.C.CON_G.REGION.M[4].C;
	      Color COL2=M.C.CON_G.REGION.M[0].C;
	      ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	      GeneralPath gp=B.arithmeticKite();   
              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp,COL1,COL2);
	      gp=M.R.transform(gp);
	      g.setColor(COL1);
	      g.fill(gp);
	      g.setColor(COL2);
	      g.draw(gp);
    }








    public static void drawHexagrid(Graphics2D g,Manager M,Output OUT) {
	drawGrid1(g,M,OUT);
	drawGrid2(g,M,OUT);
	drawGrid3(g,M,OUT);
	drawGrid4(g,M,OUT);
	drawGrid5(g,M,OUT);
	drawGrid6(g,M,OUT);
    }



   public static void drawGrid1(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];
	  int z=1;
	  if((p*q)%2==0) z=2;

              Color COL1=M.C.CON_G.HEX.M[1].C;
	      double x1=1.0*(p*q)/(p+q);
	      double y1=x1+(q-p)/2.0;
	      GeneralPath gp=new GeneralPath();
	      gp.moveTo(0,0);
	      gp.lineTo(q,-p);
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	        for(int i=-15;i<=15;++i) {
		    for(int j=-15;j<15;++j) {
		      AT=AffineTransform.getTranslateInstance(i*q+j*x1*z,-i*p+j*y1*z);
		      gp2=new GeneralPath(gp);
		      gp2.transform(AT);   
                      if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	              gp2=M.R.transform(gp2);
                      g.setColor(COL1);
                      g.draw(gp2);
		    }
		}
   }




public static void drawGrid2(Graphics2D g,Manager M,Output OUT) {

           int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1]; 
          int z=1;
	  if((p*q)%2==0) z=2;

              Color COL1=M.C.CON_G.HEX.M[2].C;
	      double x1=1.0*(p*q)/(p+q);
	      double y1=x1+(q-p)/2.0;
	      GeneralPath gp=new GeneralPath();
	      gp.moveTo(0,0);
	      gp.lineTo((float)(z*x1),(float)(z*y1));
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		  for(int j=-15;j<15;++j) {
		      AT=AffineTransform.getTranslateInstance(.5*i*q*z+j*x1*z,-.5*i*p*z+j*y1*z);
		      gp2=new GeneralPath(gp);
		      gp2.transform(AT);   
                      if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	              gp2=M.R.transform(gp2);
                      g.setColor(COL1);
                      g.draw(gp2);
		  }
	      }
}



public static void drawGrid3(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];


              Color COL1=M.C.CON_G.HEX.M[3].C;
	      GeneralPath gp=new GeneralPath();
	      gp.moveTo(0,-20*q);
	      gp.lineTo(0,20*q);
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);
	      }
}




public static void drawGrid4(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];

              Color COL1=M.C.CON_G.HEX.M[4].C;
	      GeneralPath gp=new GeneralPath();
	      float x1=(float)(-q);
	      float y1=(float)( p);
	      float x2=(float)(q);
	      float y2=(float)((p+q)*(p+q)/(4.0*p)-p);
	      gp.moveTo(x1-20*x2,y1-20*y2);
	      gp.lineTo(x1+20*x2,y1+20*y2);
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);
	      }
    }


public static void drawGrid5(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];

              Color COL1=M.C.CON_G.HEX.M[5].C;
	      GeneralPath gp=new GeneralPath();
	      float x1=(float)( q);
	      float y1=(float)(-p);
	      float x2=(float)(.5*p-.5*q);
	      float y2=(float)((q*q-p*p)/(4.0*q)+p);
	      gp.moveTo(x1-20*x2,y1-20*y2);
	      gp.lineTo(x1+20*x2,y1+20*y2);
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);

	      }
}



public static void drawGrid6(Graphics2D g,Manager M,Output OUT) {
           int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];

              Color COL1=M.C.CON_G.HEX.M[6].C;
	      GeneralPath gp=new GeneralPath();
	      float x1=(float)(-q);
	      float y1=(float)( p);
	      float x2=(float)(2*q);
	      float y2=(float)(q-p);
	      gp.moveTo(x1-20*x2,y1-20*y2);
	      gp.lineTo(x1+20*x2,y1+20*y2);
	      gp.closePath();
	      GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);

	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);
    }
}





  public static void drawIotaWall(Graphics2D g,Manager M,Output OUT) {
	    int p=M.C.SES.getNumerator();
     	    int q=M.C.SES.getDenominator();
	    ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	    GeneralPath gp=B.iotaWall();
            Color COL1=M.C.CON_G.LINE.M[1].C;
             GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);
	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);
	      }
  }



  public static void drawSymmLine(Graphics2D g,Manager M,Output OUT) {
	  int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];

	    ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	    GeneralPath gp=B.symmLine();
            Color COL1=M.C.CON_G.LINE.M[2].C;
             GeneralPath gp2=new GeneralPath();
	      AffineTransform AT=AffineTransform.getTranslateInstance(0,0);
	      g.setColor(COL1);
	      for(int i=-15;i<=15;++i) {
		 AT=AffineTransform.getTranslateInstance(.5*i*q,-.5*i*p);
		 gp2=new GeneralPath(gp);
		 gp2.transform(AT);   
                 if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL1);
	         gp2=M.R.transform(gp2);
                 g.draw(gp2);
	      }
  }




      public static void drawBarrier(Graphics2D g,Manager M,Output OUT) {
        int[] pp=M.C.getParameter();
	int p=pp[0];
	int q=pp[1];
	int test0=(p+q)%2;
	if(test0==1) {
	  GeneralPath gp=new GeneralPath();
	  GeneralPath gp2=new GeneralPath();
	  int[] a1=MathRational.RPLUS(p,q);
	  int[] a2=MathRational.RMINUS(p,q);
          Color COL1=M.C.CON_G.LINE.M[0].C;
          int r,s;

	  r=a1[0];
	  s=a1[1];
          int test=(r+s)+(p+q);

	  if(test%2==0) {
	      r=a2[0];
	      s=a2[1];
	  }

	  
	  gp.reset();
	  gp.moveTo((float)(0-12*q),(float)( 12*p+(r+s)/2.0));
	  gp.lineTo((float)(0+12*q),(float)(-12*p+(r+s)/2.0));
	  gp.closePath();
          if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,COL1,COL1);
          gp=M.R.transform(gp);
          g.setColor(COL1);
          g.draw(gp); 
	  
	}
      }



    public static void drawTent(Graphics2D g,Manager M,Output OUT) {

	int[] pp=M.C.getParameter();
	int p1=pp[0];
	int q1=pp[1];

	pp=M.C.getMemoryParameter();
	int p2=pp[0];
	int q2=pp[1];

        int p=p1;
	int q=q1;
	int P=p2;
	int Q=q2;

	if(p1>p2) {
	    p=p2;
	    q=q2;
	    P=p1;
	    Q=q1;
	  }


	/*this is the odd-odd case*/
	int test=p1*q1*p2*q2;
	if(test%2==1) {
	   double s=1.0*p1/q1-1.0*p2/q2;
	   if(q1>q2) s=-s;
           double a=M.C.SES.SER.computeDiophantine();
	   double K1=computeOddDiophantine1(p,q,a);
	   double K2=computeOddDiophantine2(p,q,a);
	   if(s<0) drawTentPositive(g,M,OUT,p,q,K1);
	   if(s>0) drawTentNegative(g,M,OUT,p,q,K2);
	}


	/*this is the Farey-related case*/
	test=p1*q2-p2*q1;
	test=test*test;
	if(test==1) {
	    double K=1.0*Q/q;
            double s=1.0*p1/q1-1.0*p2/q2;
	    if(q1>q2) s=-s;
            if(s<0) drawTentPositive(g,M,OUT,p,q,K);
	    if(s>0) drawTentNegative(g,M,OUT,p,q,K);
	}


    }


    public static double computeOddDiophantine1(int p,int q,double a) {
	int[] c=MathRational.RPLUS(p,q);
	int c1=c[1];
	double K=Math.floor(a-1.0*c1/q)+1+1.0*c1/q;
	return(K);
    }

    public static double computeOddDiophantine2(int p,int q,double a) {
	int[] c=MathRational.RPLUS(p,q);
	int c1=c[1];
	double K=Math.floor(a+1.0*c1/q)+1-1.0*c1/q;
	return(K);
    }






    public static void drawTentPositive(Graphics2D g,Manager M,Output OUT,int p,int q,double K) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(-q),(float)(p));
       	double x=.5*((1+K)*p+(-1+K)*q);
       	double y=(1+K)*q*q+4*p*q-(1+K)*p*p;
       	y=y/(4*q);
       	gp.lineTo((float)(x),(float)(y));	
        gp.lineTo((float)(K*q),(float)(-K*p));
	gp.closePath();
        Color COL1=M.C.CON_G.REGION.M[0].C;	
        Color COL2=M.C.CON_G.REGION.M[5].C;
        g.setColor(COL1);
	GeneralPath gp2=new GeneralPath(gp);
	if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL2,COL1);
	GeneralPath gp3=M.R.transform(gp);
        g.setColor(COL2);
	g.fill(gp3);
	g.setColor(COL1);
        g.draw(gp3);
    }

    public static void drawTentNegative(Graphics2D g,Manager M,Output OUT,int p,int q,double K) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(q),(float)(-p));
        gp.lineTo((float)(-K*q),(float)(K*p));
	double x=.5*((1+K)*p+(1-K)*q);
	double y=(1+K)*q*q+4*K*p*q-(1+K)*p*p;
	y=y/(4*q);
	gp.lineTo((float)(x),(float)(y));
	gp.closePath();

	Color COL1=M.C.CON_G.REGION.M[0].C;	
        Color COL2=M.C.CON_G.REGION.M[5].C;
        g.setColor(COL1);
	GeneralPath gp2=new GeneralPath(gp);
	if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL2,COL1);
	gp=M.R.transform(gp);
        g.setColor(COL2);
	g.fill(gp);
	g.setColor(COL1);
        g.draw(gp);
    }







    public static void drawDecomp(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];  

          int test=(p*q)%2;
	  if(test==1) {

	    int[] a=MathRational.RPLUS(p,q);
	    double lambda=1.0*a[1]/q;

	    Color COL1=M.C.CON_G.REGION.M[2].C;
	    Color COL2=M.C.CON_G.REGION.M[0].C;
	    ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);

	    GeneralPath gp1=new GeneralPath();
	    GeneralPath gp2=new GeneralPath();

	      if(lambda<.5) {
	         gp1=B.sonBox1(); 
	         gp2=B.fatherBox1(); 
	      }  

	      if(lambda>.5) {
	         gp1=B.sonBox2(); 
	         gp2=B.fatherBox2();  
	      }  

              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp1,COL1,COL2);
	      gp1=M.R.transform(gp1);  
	      g.setColor(COL1);
	      g.fill(gp1);
	      g.setColor(COL2);
	      g.draw(gp1);

              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL2);
	      gp2=M.R.transform(gp2);
	      g.setColor(COL1);
	      g.fill(gp2);
	      g.setColor(COL2);
	      g.draw(gp2);
	  }
    }



    public static void drawDecomp2(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];  

          int test=(p*q)%2;
	  if(test==1) {

	    int[] a=MathRational.RPLUS(p,q);
	    double lambda=1.0*a[1]/q;

	    Color COL1=M.C.CON_G.REGION.M[3].C;
	    Color COL2=M.C.CON_G.REGION.M[0].C;
	    ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);

	    GeneralPath gp1=new GeneralPath();
	    GeneralPath gp2=new GeneralPath();

	      if(lambda<.5) {
	         gp1=B.sonBox1(); 
	         gp2=B.fatherBox1(); 
	      }  

	      if(lambda>.5) {
	         gp1=B.sonBox2(); 
	         gp2=B.fatherBox2();  
	      } 

	      GeneralPath gp3=new GeneralPath();
	      GeneralPath gp4=new GeneralPath();
	      AffineTransform AT=new AffineTransform();

	      for(int i=-5;i<5;++i) {
                  AT=AffineTransform.getTranslateInstance(i*q,-i*p);
		  gp3=new GeneralPath(gp1);
		  gp4=new GeneralPath(gp2);
		  gp3.transform(AT);
		  gp4.transform(AT);

                  if(M.C.EXPORT.mode==1) OUT.polyWrite(gp3,COL1,COL2);
	          gp3=M.R.transform(gp3);  
	          g.setColor(COL1);
	          g.fill(gp3);
	          g.setColor(COL2);
	          g.draw(gp3);

                  if(M.C.EXPORT.mode==1) OUT.polyWrite(gp4,COL1,COL2);
	          gp4=M.R.transform(gp4);
	          g.setColor(COL1);
	          g.fill(gp4);
	          g.setColor(COL2);
	          g.draw(gp4);
	      }
	  }
    }



    public static void drawTraps(Graphics2D g,Manager M,Output OUT) {

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];  

          Color COL1=M.C.CON_G.REGION.M[6].C;
	  Color COL2=M.C.CON_G.REGION.M[0].C;
	  ArithmeticGraphBox B=new ArithmeticGraphBox(p,q);
	  GeneralPath gp1=new GeneralPath();
	  GeneralPath gp2=new GeneralPath();


          int test=(p*q)%2;



	  if(test==1) {

	    int[] a=MathRational.RPLUS(p,q);
	    double lambda=1.0*a[1]/q;

	      if(lambda<.5) {
	         gp1=B.OddEvenBox1();
	         gp2=B.sonBox1(); 
	      }  

	      if(lambda>.5) {
	         gp1=B.OddEvenBox2();
	         gp2=B.sonBox2(); 
	      }  
	  }



	  if(test==0) {

	    int[] a=MathRational.RMINUS(p,q);
	    int test2=(a[0]+a[1])%2;

	      if(test2==1) {
	         gp1=B.EvenEvenBox1();   
	         gp2=B.EvenOddBox1();
	      }  

	      if(test2==0) {
	         gp1=B.EvenEvenBox2();   
	         gp2=B.EvenOddBox2();
	      }  

	  }





              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp1,COL1,COL2);
	      gp1=M.R.transform(gp1);  
	      g.setColor(COL1);
	      g.fill(gp1);
	      g.setColor(COL2);
	      g.draw(gp1);

              if(M.C.EXPORT.mode==1) OUT.polyWrite(gp2,COL1,COL2);
	      gp2=M.R.transform(gp2);  
	      g.setColor(COL1);
	      g.fill(gp2);
	      g.setColor(COL2);
	      g.draw(gp2);

    }
}
