import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeArithmeticGraph implements Runnable {
    Manager M;
    Complex SOURCE;
    int halt;
    double A;
    int[][] LIST=new int[2][100000];
    int LOW=0;
    int CLOSED=0;

    public ComputeArithmeticGraph() {
    }

    public ComputeArithmeticGraph(Complex z,Manager MM) {
	this.SOURCE=new Complex(z.x,z.y);
	this.M=MM;
    }


    public void run() {
	int mode=M.C.CON_G.getOption();
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	if(mode< 4)   LOW=0;
	if(mode==0)  orbitPlot2();        //both directions
	if(mode==1)  orbitPlot(0);         //forwards
	if(mode==2)  orbitPlot(1);         //backwards
     	if(mode==3)  periodPlot(p,q,0,0,0,1);  //period plot
	if(mode==4)  pivotPlot();           //pivot arc
	if(mode==5)  monsterPlot();           //all even predecessors
	if(mode==6)  lowPlot(0);           //all even low components
     	if(mode==7)  lowPlot(1);           //all odd  low components
        if(mode==8)  blockPlot1();          //block plot
        if(mode==9)  blockPlot2();          //block plot
     	if(mode==10)  comparePlot();        //comparison

    }

    public void sendMessage(int c) {
           if((c>0)&&(c%100==0)) {
	      Integer COUNT=new Integer(c);
	      M.C.PROGRESS=COUNT.toString();
	      M.C.repaint();
	   }
    }


    /***********plotting routines**********/

    public GeneralPath straighten(int p,int q,GeneralPath gp1) {
	int mode=M.C.CON_G.SCALE.mode;
	if(mode==0) return(gp1);
	ArithmeticGraphBox AGB=new ArithmeticGraphBox(p,q);
	GeneralPath gp2=AGB.straighten(gp1);
	return(gp2);
    }


    public void orbitPlot(int direction) {
	int m=(int)(SOURCE.x);
	int n=(int)(SOURCE.y);
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	int parity=(direction+m+n+100000)%2;
	periodPlot(p,q,m,n,parity,0);
    }

    public void orbitPlot2() {
	int m=(int)(SOURCE.x);
	int n=(int)(SOURCE.y);
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	periodPlot2(p,q,m,n,0);
    }


    /*STOP=1 -- plot 1 period in the unstable case.
      STOP=0 -- no constraints */

    public void periodPlot(int p,int q,int m,int n,int dir,int STOP) {
	CLOSED=0;
	GeneralPath gp=getPeriodPlot(p,q,m,n,dir,STOP);	
        int style=M.C.CON_G.STYLE.mode;
	if(CLOSED==0) style=0;
	gp=straighten(p,q,gp);
	M.R.nextPathLast(gp,style);
	M.R.repaint();
    }

    public void periodPlot2(int p,int q,int m,int n,int STOP) {
	CLOSED=0;
	GeneralPath gp=getPeriodPlot(p,q,m,n,0,STOP);
	if(CLOSED==0) {
            GeneralPath gp2=getPeriodPlot(p,q,m,n,1,STOP);
	    gp.append(gp2,false);
	}
        int style=M.C.CON_G.STYLE.mode;
	if(CLOSED==0) style=0;	
        gp=straighten(p,q,gp);
	M.R.nextPathLast(gp,style);
	M.R.repaint();
    }


    public GeneralPath getPeriodPlot(int pp,int qq,int m,int n,int dir,int STOP) {
        GeneralPath gp=new GeneralPath();
	A=1.0*pp/qq;
	ArithmeticPoint P1=new ArithmeticPoint(m,n,-1);
	ArithmeticPoint P2=new ArithmeticPoint(m,n,-1);
	double LIM=M.C.CON_G.getLimit();
	int count=0;
	int closed=0;

	halt=1;
        gp.moveTo(P1.m,P1.n);
       	while((halt==1)&&(count<LIM)) {
	    P2=firstReturn(P1,A,dir);
	    gp.lineTo(P2.m,P2.n);
	    if((P2.m==m)&&(P2.n==n)) closed=1;
	    if((STOP==1)&&(P2.m-m==qq)&&(P2.n-n==-pp)) closed=1;
	    if((STOP==1)&&(P2.m-m==-qq)&&(P2.n-n==pp)) closed=1;
	    if(closed==1) halt=0;
	    recordLow(P2);
            P1=new ArithmeticPoint(P2);
	    sendMessage(count);
	    ++count;
	}
	halt=0;
	CLOSED=closed;
	
	return(gp);
    }


    public void decompPlot() {
	CLOSED=0;	
        int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	GeneralPath gp=getDecompPlot();
        int style=M.C.CON_G.STYLE.mode;
	if(CLOSED==0) style=0;
	gp=straighten(p,q,gp);
	M.R.nextPathLast(gp,style);
	M.R.repaint();
    }


    public GeneralPath getDecompPlot() {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	A=1.0*p/q;
	int[] x1=MathRational.RMINUS(p,q);
        GeneralPath gp=new GeneralPath();
	ArithmeticPoint P1=new ArithmeticPoint(-x1[1],x1[0]+1,-1);
	ArithmeticPoint P2=new ArithmeticPoint();
	double LIM=M.C.CON_G.getLimit();
	int count=0;
	int closed=0;
	halt=1;
        gp.moveTo(P1.m,P1.n);
       	while((halt==1)&&(count<LIM)) {
	    P2=firstReturn(P1,A,-1);
	    gp.lineTo(P2.m,P2.n);
	    if((P2.m==-x1[1]+q)&&(P2.n==x1[0]-p+1)) {closed=1;}
            if(closed==1) halt=0;
            P1=new ArithmeticPoint(P2);
	    sendMessage(count);
	    ++count;
	}
	halt=0;	
	CLOSED=closed;
	return(gp);
    }










    public void recordLow(ArithmeticPoint P2) {
          if(P2.testLow(A)==1) {
	     LIST[0][LOW]=P2.m;
	     LIST[1][LOW]=P2.n;
	     ++LOW;
	      }
    }


    
    public void pivotPlot() {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	A=1.0*p/q;
	int[] x=MathRational.pivot(p,q);
        GeneralPath gp=new GeneralPath();
	ArithmeticPoint P1=new ArithmeticPoint(x[0],x[1],-1);
	ArithmeticPoint P2=new ArithmeticPoint(x[0],x[1], 1);
	double LIM=M.C.CON_G.getLimit();
	int count=0;

	halt=1;
        gp.moveTo(P1.m,P1.n);
       	while((halt==1)&&(count<LIM)) {
	    P2=firstReturn(P1,A,-1);
	    gp.lineTo(P2.m,P2.n);
	    if((P2.m==x[2])&&(P2.n==x[3])) halt=0;
            P1=new ArithmeticPoint(P2);
	    sendMessage(count);
	    ++count;
	}
	halt=0;	
	gp=straighten(p,q,gp);
	M.R.nextPathLast(gp,0);
	M.R.repaint();
    }






    public void monsterPlot() {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	Color[] C={new Color(0,0,255),new Color(255,0,0),new Color(255,255,0)};
	int parity=0;
	int test=(p*q)%2;
        M.C.CS.C=C[0];
	if(test==0) {
	  while(q>1) {
  	    M.C.CS.C=C[parity];
	    periodPlot(p,q,0,0,0,1);
	    int[] x=MathRational.evenPredecessor(p,q);
	    p=x[0];
	    q=x[1];
	    parity=(parity+1)%3;
	  }
	}
    }








    /*These routines measure the location of a point with respect to the
      floor grid.*/

	public static double linearV0(int p,int q,double m,double n) {
	    double a=p*m+q*n;
	    return(a);
	}

	public static double linearV(int p,int q,double m,double n) {
	    double a=linearV0(p,q,m,n);
	    double b=linearV0(p,q,0,.5*(p+q)); 
            double t=0.5;
	    if((p+q)%2==0) t=1.0;
	    return(t*a/b);
	}

	public static double linearW0(int p,int q,double m,double n) {
            double a=2*p*q;
	    double b=2*p*q+q*q-p*p;
	    double f=-b*m+a*n;
	    return(f);
	}

        public static double linearW(int p,int q,double m,double n) {
	    double t=1.0;
	    if((p+q)%2==0) t=2.0;
	   double a=linearW0(p,q,m,n);
	   double b=linearW0(p,q,q,-p);
	  return(t*a/b);
	}






    public void blockPlot1() {
 	double A=M.C.SES.getParameter();
 	ArithmeticGraphLocal L;
  	int i2=(int)(SOURCE.x);
  	int j2=(int)(SOURCE.y);
 	GeneralPath gp=new GeneralPath();
 	int LIM1=M.C.CON_G.getWidthLimit();
 	int LIM2=M.C.CON_G.getHeightLimit();
 	int i,j;
  	i=-LIM1;
 	j=-LIM2;
	halt=1;

	while((j<LIM2)&&(halt==1)) {
	    L=doLocal(i+i2,j+j2,A);	
            M.R.nextPathLast(L.gp,0);
	    if(i<LIM1) ++i;
	    if(i==LIM1) {
                   Integer JJ=new Integer(j);
	           M.C.PROGRESS=JJ.toString();
	           M.C.repaint(); 
                   ++j;
		   i=-LIM1;
	    }
	}
	halt=0;
	M.R.repaint();   
    }


    public void blockPlot2() {
 	double A=M.C.SES.getParameter();
  	double[] a={1.0,-A};
	double s=ArithmeticGraphBox.slopeW(A);
 	double[] b={1.0/s,1.0};
 	ArithmeticGraphLocal L;
  	int i2=(int)(SOURCE.x);
  	int j2=(int)(SOURCE.y);
 	GeneralPath gp=new GeneralPath();
 	int LIM1=M.C.CON_G.getWidthLimit();
 	int LIM2=M.C.CON_G.getHeightLimit();
 	int i,j;
  	i=-LIM1;
 	j=-LIM2;
	halt=1;

	while((j<LIM2)&&(halt==1)) {
	    int i3=(int)(.5*i*a[0]+.5*j*b[0]);
	    int j3=(int)(.5*i*a[1]+.5*j*b[1]);

	    L=doLocal(i2+i3,j2+j3,A);  
            M.R.nextPathLast(L.gp,0);
	    if(i<LIM1) ++i;
	    if(i==LIM1) {
                   Integer JJ=new Integer(j);
	           M.C.PROGRESS=JJ.toString();
	           M.C.repaint(); 
                   ++j;
		   i=-LIM1;
	    }
	}
	halt=0;		
	M.R.repaint();   

    }

    public void comparePlot() {	
	int LIM1=M.C.CON_G.getWidthLimit();
	int LIM2=M.C.CON_G.getHeightLimit();
	ArithmeticGraphLocal L1;	
        ArithmeticGraphLocal L2;
	double A1=M.C.SES.getParameter();
	double A2=M.C.SES.SER.getMemoryParameter();	
        int i2=(int)(SOURCE.x);
	int j2=(int)(SOURCE.y);

	halt=1;
	GeneralPath gp=new GeneralPath();
	int i=-LIM1;
	int j=-LIM2;
	while((j<LIM2)&&(halt==1)) {
		int jj=(int)(j-i*A1);
	        L1=doLocal(i+i2,jj+j2,A1);
	        L2=doLocal(i+i2,jj+j2,A2);
		L1.toType();
		L2.toType();
		if(L1.match(L2)==0) {
     	           L1.gp=makeDiamond(i+i2,jj+j2);
		   gp.append(L1.gp,false);
		}
	        if(i<LIM1) ++i;
		if(i==LIM1) {
                   Integer JJ=new Integer(j);
	           M.C.PROGRESS=JJ.toString();
	           M.C.repaint();
		   i=-LIM1;
		   ++j;
		}
	}

	halt=0;		
        int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	gp=straighten(p,q,gp);
	M.R.nextPathLast(gp,0);
	M.R.repaint();   
    }

    /*This just makes a little marker around the point*/

    public GeneralPath makeDiamond(int i,int jj) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(i-.25),(float)(jj- 0));
	gp.lineTo((float)(i- 0),(float)(jj-.25));
	gp.moveTo((float)(i- 0),(float)(jj-.25));
	gp.lineTo((float)(i+.25),(float)(jj- 0));
	gp.moveTo((float)(i+.25),(float)(jj- 0));
	gp.lineTo((float)(i- 0),(float)(jj+.25));
	gp.moveTo((float)(i- 0),(float)(jj+.25));
	gp.lineTo((float)(i-.25),(float)(jj- 0));
	return(gp);
    }



    /*This routine plots one period's worth of components 
      that have low vertices.  We keep track of a LIST of
      already plotted low vertices, so that we don't plot
      things redundantly.*/

    public void lowPlot(int choice) {
	int test,parity;
	int q=M.C.SES.getDenominator();
	int p=M.C.SES.getNumerator();
	double A=1.0*p/q;

	for(int i=0;i<q;++i) {
	    int j=(int)(Math.floor(-i*A))+1;   //keeps near the baseline
	    if(i==0) j=0;                      //gets the point (0,0)

	    /*Here we avoid redundant plotting*/
	    test=0;
	    for(int ii=LOW-1;ii>=0;--ii) {
		if((i==LIST[0][ii])&&(j==LIST[1][ii])) test=1; 
	    }

	    parity=(i+j+100001)%2;

	    if((test==0)&&(parity==choice)) {
		periodPlot(p,q,i,j,0,1);
	    }
	}
	halt=0;
	LOW=0;
	M.R.repaint();   
    }




    /** routines associated to the return map */

    public Complex toComplex(ArithmeticPoint P,double AA) {
	double d=2*AA*P.m+2*P.n+.00000001;
	return(new Complex(d,P.y));
    }

    public ArithmeticPoint firstReturn(ArithmeticPoint P,double AA,int direction) {
	PinwheelMap RM=new PinwheelMap(AA);
        int[] ret=new int[3];
	ArithmeticPoint PP=new ArithmeticPoint(P);
	if(direction==1) PP.y=-P.y;
	Complex z=toComplex(PP,AA);
	ret=RM.doReturnIntegral(z);
	ArithmeticPoint Q=new ArithmeticPoint(P.m+ret[0],P.n+ret[1],ret[2]);
	if(direction==1) Q.y=-Q.y;
	return(Q);
    }

    public ArithmeticGraphLocal doLocal(int i,int j,double AA) {
	ArithmeticGraphLocal L=new ArithmeticGraphLocal();
	ArithmeticPoint P1=new ArithmeticPoint(i,j,-1);
	ArithmeticPoint P2=new ArithmeticPoint();
	ArithmeticPoint P3=new ArithmeticPoint();
	Complex test=toComplex(P1,AA);
        P2=firstReturn(P1,AA,0);
        P3=firstReturn(P1,AA,1);
	L.x[0]=P2.m-P1.m;
	L.x[1]=P2.n-P1.n;
        L.x[2]=P3.m-P1.m;
	L.x[3]=P3.n-P1.n;	  
        L.gp=new GeneralPath();
	L.gp.moveTo(P1.m,P1.n);
	L.gp.lineTo(P2.m,P2.n);	
	L.gp.moveTo(P1.m,P1.n);	
	L.gp.lineTo(P3.m,P3.n);
	L.gp.closePath();
	return(L);
    }



    /*This is just a wrapper class for a pair of integers and a double*/

    public class ArithmeticPoint {
	int m,n;
	double y;
	public ArithmeticPoint() {}
	public ArithmeticPoint(ArithmeticPoint P) {
	    m=P.m;
	    n=P.n;
	    y=P.y;
	}

	public ArithmeticPoint(int mm,int nn,double yy) {
	    m=mm;
	    n=nn;
	    y=yy;
	}

	public int testLow(double A) {
	    double t1=A*m+n;
	    double t2=t1-1;
	    if(t1<0) return(0);
	    if(t2>0) return(0);
	    return(1);
	}

    }

}

