import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/* This routine is currently not hooked up*/

public class ComputeHexagridDemo implements Runnable {
    Manager M;
    int halt;
    double A;

    public ComputeHexagridDemo() {
    }

    public ComputeHexagridDemo(Manager MM) {
	this.M=MM;
    }


    public void run() {
       hexagrid();	
    }


    /*These routines do the maps deltaPlus and deltaMinus from the proof of
      Statement 2 of the Hexagrid Theorem in the monograph */


    public double[] deltaPlus(double A1,int i,int j) {
              double[] u=TorusMap.phiPlus3D(A1,i,j);
	      u=translate(A1,u); 
	      return(u);
    }


    public double[] deltaMinus(double A1,int i,int j) {
              double[] u=TorusMap.phiPlus3D(A1,i,j);
	      u=translate(A1,u); 
	      u[0]=u[0]-A1;
	      u[1]=u[1]+A1;
	      return(u);
    }




    /* The input for this routine is a point u=(x,y,z) in R^3.  In the background is
       the lattice Lambda(A) defined in connection with the master picture
       theorem.  This routine applies vectors in Lambda(A) to arrange that
       x+y=A and z in [0,1). This map is the main ingredient in the maps
       Delta+ and Delta- from the monograph*/

    public double[] translate(double A1,double[] u) {
	double[] v=new double[3];
	v[0]=u[0];
	v[1]=u[1];
	v[2]=u[2];
	double xval=u[0]+u[1]-A1;


	double d1=Math.abs(xval-1-A1);
	if(d1<.00001) {
	    v[0]=v[0]-1-A1;
	}
	double d2=Math.abs(xval-2);
	if(d2<.00001) {
	    v[0]=v[0]-1+A1;
	    v[1]=v[1]-1-A1;
	}

	double d3=Math.abs(xval-2*A1);
	    if(d3<.00001) {
		v[0]=v[0]-1-3*A1;
		v[1]=v[1]+1+A1;
	    }

	    double d4=Math.abs(xval-(A1-1));
	    if(d4<.00001) {
		v[0]=v[0]-2*A1;
		v[1]=v[1]+1+A1;
	    }
	return(v);
    }







    //need to grab parameter from rational parameter window

    public void hexagrid() {
	int mode=M.C.CON_P.PEC.IS[0].val;
	int parity=mode%2;

	double A1=M.C.SES.getParameter();
	int[] pp=M.C.getParameter();
	int DEP=pp[0]*pp[1];
	if(DEP>100000) DEP=100000;

	double s=1+1/(2.0*A1)-A1/2.0;   //slope of the wall
	halt=1;
	int test=0;
	double[] u=new double[3];

	    for(int j=0;j<=DEP;++j) {
	    int bound=(int)(Math.floor(1.0*j/s));
	      for(int i=bound-1;i<=bound+2;++i) {

		  test=testRange(pp[0],pp[1],i,j,mode);   //close enough to wall
		 if(test==1) {

		      if(parity==0) u=deltaPlus(A1,i,j);
		      if(parity==1) u=deltaMinus(A1,i,j);
                      M.PE.POINT[M.PE.point]=new Complex(u[0],u[2]);  
		      M.PE.POINTCOLOR[M.PE.point]=Color.white;
		      ++M.PE.point;
		  }
	      }
	    }
	    halt=0;	
	    M.PE.repaint();   
	    M.C.repaint();
    }





    /*This routine tests whether or not a given lattice point
      (m,n) crosses the wall through the origin associated to
      the parameter p/q*/

    public int testRange(int p,int q,int m,int n,int mode2) {
	int mode=mode2/2+1;
	int test=0;
	double a=1.0*p/q;
	if(mode==1) test=nearDiagonal1(p,q,m,n);
	if(mode==2) test=nearDiagonal2(p,q,m,n);
	if(mode==3) test=nearDiagonal3(p,q,m,n);
	if(mode==4) test=nearDiagonal4(p,q,m,n);
	return(test);
    }


    /*These routines test whether or not a given lattice point crosses the
      wall through the origin in a suitable direction.  Here the wall through
      the origin is the line parallel to the vector W from the monograph.*/

	public static double diagonalFunction(int p,int q,double m,double n) {
	    double a=2*p*q;
	    double b=2*p*q+q*q-p*p;
	    double f=-b*m+a*n;
	    return(f);
	}

	/* This tests whether the (0,1) edge emanating from (m,n)
           crosses the wall */

	public static int nearDiagonal1(int p,int q,double m,double n) {
	    double test1=diagonalFunction(p,q,m,n);
	    double test2=diagonalFunction(p,q,m,n+1);
	    int val=0;
            if((test1<0)&&(test2>0)) val=1;
	    return(val);
	}


	/* This tests whether the (-1,-1) edge emanating from (m,n)
	   crosses the wall*/

	public static int nearDiagonal2(int p,int q,double m,double n) {
	    double test1=diagonalFunction(p,q,m,n);
	    double test2=diagonalFunction(p,q,m-1,n-1);
	    int val=0;
            if((test1<0)&&(test2>0)) val=1;
	    return(val);
	}


	/* This tests whether the (-1,0) edge emanating from (m,n)
	   crosses the wall*/

	public static int nearDiagonal3(int p,int q,double m,double n) {
	    double test1=diagonalFunction(p,q,m,n);
	    double test2=diagonalFunction(p,q,m-1,n);
	    int val=0;
            if((test1<0)&&(test2>0)) val=1;
	    return(val);
	}



	/* This tests whether the (-1,1) edge emanating from (m,n)
	   crosses the wall*/


	public static int nearDiagonal4(int p,int q,double m,double n) {
	    double test1=diagonalFunction(p,q,m,n);
	    double test2=diagonalFunction(p,q,m-1,n+1);
	    int val=0;
            if((test1<0)&&(test2>0)) val=1;
	    return(val);
	}








}

