import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeMasterDemo implements Runnable {
    Manager M;
    int halt;

    public ComputeMasterDemo() {
    }

    public ComputeMasterDemo(Manager MM) {
	this.M=MM;
    }


    public void run() {
	torusPlot();
    }








    public Complex toComplex(int[][] X,double AA) {
	double d=toDouble(X[0][0],X[0][1],AA);
	Complex z1=new Complex(d,X[1][0]);
        return(z1);
    }


    public double toDouble(int x,int y,double AA) {
       	return(2*AA*x+2*y);
    }


    public int[][] firstReturn(int[][] X,double AA) {
	PinwheelMap RM=new PinwheelMap(AA);
            int[] temp3=new int[2];
	    Complex z1=toComplex(X,AA);
	    temp3=RM.doReturnIntegral(z1);
	    int[][] Y=new int[2][2];
	    Y[0][0]=X[0][0]+temp3[0];
	    Y[0][1]=X[0][1]+temp3[1];
	    Y[1][0]=temp3[2];
	    Y[1][1]=0;
	    return(Y);
    }

    public static Color computeColor(double A,Complex z,Manager M) {
	Color COL=Color.black;
	PinwheelMap Ret=new PinwheelMap(A);
	int[] test=new int[2];
	test=Ret.doReturnIntegral(z);
	return(M.C.CON_P.getColorAbsolute(test[0],test[1],255));
    }


    public static int[] computePair(double A,Complex z,Manager M) {
	Color COL=Color.black;
	PinwheelMap Ret=new PinwheelMap(A);
	int[] test=new int[2];
	test=Ret.doReturnIntegral(z);
	return(test);
    }

    public static int[] computeSpectrum(double A,Complex z,Manager M) {
	Color COL=Color.black;
	PinwheelMap Ret=new PinwheelMap(A);
	int[] test=new int[2];
	test=Ret.mapSpectrum(z);
	return(test);
    }
   




    //here is the main routine 

    public void torusPlot() {
	M.PE.point=0;
	torusPlot(0);
	torusPlot(1);
	M.PE.repaint();
    }


    public void torusPlot(int which) {	
	Color COL=Color.black;
	Complex Z=M.C.CON_P.getFiber();
	double A=Z.y;
        double LIM=Math.pow(2,M.C.CON_P.PEC.IS[4].val);  //plot density
	Complex z=new Complex();
	halt=1;
	double offset=2*Z.x;  

	int i=0;
	while((i<LIM)&&(halt==1)) {

	    //determine point
	    z.x=2.0*i+offset+.00000001;
	    z.y=1.0;
	    if(which==1) z.y=-1;
	    if(i%2==1)   z.y=-z.y;

	    //determine return pair
	    COL=computeColor(A,z,M);                   

	    //determine image in torus
	    Complex ww=new Complex();                   
	    if(which==0) ww=TorusMap.phiPlus(A,z.x);
	    if(which==1) ww=TorusMap.phiMinus(A,z.x);
	    if(which==1) ww=Complex.plus(ww,new Complex(2+A,1));
            M.PE.addPoint(ww,COL);
	    ++i;
	    if(i%512==0) {
	          Integer COUNT=new Integer(i);
	           M.C.PROGRESS=COUNT.toString();
		   M.C.repaint();
	    }
	}

	halt=0;
    }






}

