import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/*  This file serves as a sanity check that the Pinwheel lemma is correct.
the return-to-strip map is computed in 2 ways

1. using the dynamics
2. using the pinwheel lemma construction

The two outputs are then compared on a large set of parameters. */




public class ComputePinwheel implements Runnable {
    Manager M;
    int halt;

    public ComputePinwheel() {
    }

    public ComputePinwheel(Manager MM) {
	this.M=MM;
    }


    public void run() {
     checkPinwheel(); 
    }

    public void sendMessage(int c) {
	      Integer COUNT=new Integer(c);
	      M.C.PROGRESS=COUNT.toString();
	      M.C.repaint();
    }


    public static int[] computePair(double A,Complex z,Manager M) {
	Color COL=Color.black;
	PinwheelMap Ret=new PinwheelMap(A);
	int[] test=new int[2];
	test=Ret.doReturnIntegral(z);
	return(test);
    }

    public static int[] computeSpectrum(double A,Complex z,Manager M) {
	Color COL=Color.black;
	PinwheelMap Ret=new PinwheelMap(A);
	int[] test=new int[2];
	test=Ret.mapSpectrum(z);
	return(test);
    }

    public Complex doOldReturn(double A,Complex z) {
	if(z.x>0) return(doOldReturnPlus(A,z));
	return(doOldReturnMinus(A,z));
    }

    public Complex doOldReturnPlus(double A,Complex z) {
	PolyWedge QQ=PolyWedge.setQuad(A);
	int test=0;
	double y;
	Complex w=new Complex(z);
	while(test==0) {
	    w=ComputeTile.nextComplex(w,QQ);
	    w=ComputeTile.nextComplex(w,QQ);
	    y=Math.abs(w.y)-1;
	    if((w.x>0)&&(y*y<.01)) test=1;
	}
	return(w);
    }

    public Complex doOldReturnMinus(double A,Complex z) {
	PolyWedge QQ=PolyWedge.setQuad(A);
	int test=0;
	double y;
	Complex w=new Complex(z);
	while(test==0) {
	    w=ComputeTile.nextComplex(w,QQ);
	    w=ComputeTile.nextComplex(w,QQ);
	    y=Math.abs(w.y)-1;
	    if((w.x<0)&&(y*y<.01)) test=1;
	}
	return(w);
    }



    public int testReturn(double A,Complex z) {
	PinwheelMap PW=new PinwheelMap(A);
	Complex z1=PW.doReturn(z);
	Complex z2=doOldReturn(A,z);
	double d=Complex.dist(z1,z2);
	if(d<.00001) return(0);
	return(1);
    }

    public void checkPinwheel() {
	double pDens=Math.pow(2.0,M.C.CON_E.INT[0].val);
	double xDens=Math.pow(2.0,M.C.CON_E.INT[1].val);
	double range=Math.pow(2.0,M.C.CON_E.INT[2].val);
	double A=0;
	int test2=0;
	int test=0;
        Complex z=new Complex();
	PinwheelMap RM=new PinwheelMap(0);
	int i=1;
	int j=1;
	halt=1;
	while((j<pDens)&&(halt==1)&&(test2==0)) {
	    A=1.0*j/pDens;

	    z=new Complex(.000001+range*i/xDens,1);
	    test=testReturn(A,z);
	    if(test==1) test2=1;
	    z=new Complex(.000001+range*i/xDens,-1);
	    test=testReturn(A,z);
	    if(test==1) test2=1;

	    ++i;
	    if(i==xDens) {
		i=1;
		++j;
		sendMessage(j);
	    }
	}
	halt=0;
    }

}

