import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeProof implements Runnable {
    Manager M;
    int halt;

    public ComputeProof() {}

    public ComputeProof(Manager MM) {
	this.M=MM;
    }


    public void run() {
	int a=M.C.CON_E.CHECK.mode;
	if(a==1) doProof1();
	if(a==2) doProof2();
	if(a==3) doProof3();
	if(a==4) doProof4();
	if(a==5) doProof5();
    }




    /**proof of embedding theorem */


    public void doProof1() {

	for(int i=0;i<14;++i) {
	    for(int j=14;j<28;++j) {
		int test=checkImmersion(i,j);
	    }
	}

	for(int i=0;i<14;++i) {
	    for(int j=14;j<28;++j) {
		int test=checkEmbedding1(i,j);
	    }
	}

    }

    public int checkImmersion(int i,int j) {
	TorusPolytopes PL=new TorusPolytopes();
	Polytope P1=new Polytope(PL.P[i]);
	Polytope P2=Polytope.shift(new Vector4(1,1,0,0),PL.P[j]);
	if(P1.type[1]!=P2.type[1]) return(1);
	if(P1.type[2]!=P2.type[2]) return(1);
	if((P1.type[1]==0)&&(P1.type[2]==0)) return(1);
	int test=checkDisjointCloud(P1,P2);
	System.out.println("immersion "+P1.type[1]+" "+P1.type[2]+"   "+test);
	return(test);
    }

    public int checkEmbedding1(int i,int j) {
	TorusPolytopes PL=new TorusPolytopes();
	Polytope P1=new Polytope(PL.P[i]);
	Polytope P2=PL.P[j];
	P2=Polytope.shift(new Vector4(-1,-1,0,0),P2);   //should be minus
	if((P1.type[1]!=1)||(P1.type[2]!= 1)) return(1);
	if((P2.type[1]!=1)||(P2.type[2]!=-1)) return(1);
	int test=checkDisjointCloud(P1,P2);
	System.out.println("enbedding" + "   "+test);
	return(test);
    }




    /**general routine for checking the disjointness of polytopess in our tiling*/

    public int checkDisjointCloud(Polytope P1,Polytope P2) {
	int test=0;
	Polytope Q1=new Polytope();
	for(int i1=-10;i1<=10;++i1) {
	for(int i2=-10;i2<=10;++i2) {
	    Q1=Polytope.gamma(i1,i2,0,P1);
	    test=Polytope.testDisjoint(Q1,P2);
	    if(test==0) return(0);
	}
	}
	return(1);
    }


    public int checkDisjointCloud2(Polytope P1,Polytope P2) {
	int test=0;
	Polytope Q1=new Polytope();
	for(int i1=-10;i1<=10;++i1) {
	for(int i2=-10;i2<=10;++i2) {
	    for(int i3=-2;i3<=2;++i3) {
	    Q1=Polytope.gamma(i1,i2,i3,P1);

	    test=Polytope.testDisjoint(Q1,P2);
	    if(test==0) return(0);
	}
	}
	}
	return(1);
    }


    public int hyperplaneCloud(Polytope P,int choice) {
	int test=0;
	Polytope Q=new Polytope();
	for(int i1=-10;i1<=10;++i1) {
	    for(int i2=-10;i2<10;++i2) {
	    for(int i3=-10;i3<10;++i3) {
	    Q=Polytope.gamma(i1,i2,i3,P);
	    Polytope R=Polytope.hyperplaneIntersect(Q);
	    if(R!=null) {
		if(R.count==3) R.simplePrint();
		if(R.count==2) {
		    int aa=(int)(R.V[0].x[1]);
		    int h2=(int)(R.V[0].x[2]);
		    int bb=(int)(R.V[1].x[1]);
		    if((h2>=0)&&(h2<=1)&&(aa+bb==1)) R.simplePrint();
		}
	    }
	    }}}
	return(0);
    }


    public int hyperplaneCloud2(Polytope P,int choice) {
	int test=0;
	Polytope Q=new Polytope();
	for(int i1=-10;i1<=10;++i1) {
	    for(int i2=-10;i2<10;++i2) {
	    for(int i3=-10;i3<10;++i3) {
	    Q=Polytope.gamma(i1,i2,i3,P);
	    Polytope R=Polytope.hyperplaneIntersect(Q);
	    if(R!=null) {  
                  int h2=(int)(R.V[0].x[2]);
		  if((h2>=0)&&(h2<=1)&&(R.count>=3)) R.simplePrint();
	    }
	    }}}
	return(0);
    }







    /**proof of statement 1 of the Hexagrid Theorem */

    public void doProof2() {

	for(int i=0;i<=3;++i) {
	    for(int j=14;j<28;++j) {
		int test=checkFloor(i,j);
	    }
	}

	System.out.println("");
	for(int i=4;i<=7;++i) {
	    for(int j=1;j<14;++j) {
		int test=checkFloor(i,j);
	    }
	}
    }

    public int checkFloor(int i,int j) {
	TorusPolytopes PL=new TorusPolytopes();
	Polytope P1=new Polytope(PL.Q[i]);
	Polytope P2=new Polytope(PL.P[j]);
	if(P1.type[1]!=P2.type[1]) return(1);
	if(P1.type[2]!=P2.type[2]) return(1);
        int test=checkDisjointCloud2(P1,P2);
	System.out.println("test " +test);
	return(test);
    }




    /**proof of statement 2 of the Hexagrid theorem*/

    public void doProof3() {
	System.out.println("start");
	TorusPolytopes PL=new TorusPolytopes();

      for(int i=0;i<8;++i) {
      Polytope P1=new Polytope(PL.S[i]);

	for(int j=0;j<14;++j) {
	    Polytope P2=new Polytope(PL.P[j]);
            int test=checkDisjointCloud(P1,P2);
	    if(P1.type[1]!=P2.type[1]) test=1;
	    if(P1.type[2]!=P2.type[2]) test=1;
	    if(test==0) System.out.println(i+" "+j+"    "+P1.type[1]+" "+P1.type[2]);
	}

	P1=Polytope.shift(new Vector4(-1,-1,0,0),P1);
	for(int j=14;j<28;++j) {  
	    Polytope P2=new Polytope(PL.P[j]);
            int test=checkDisjointCloud(P1,P2);  
            if(P1.type[1]!=P2.type[1]) test=1;
	    if(P1.type[2]!=P2.type[2]) test=1;

            if(test==0) System.out.println(i+" "+j+"    "+P1.type[1]+" "+P1.type[2]);
	}
      }
      System.out.println("done");
    }


    public void doProof4() {
	int max=0;	
        TorusPolytopes PL=new TorusPolytopes();

	for(int j=0;j<14;++j) {
           Polytope P=new Polytope(PL.P[j]);
             int t1=P.type[1];
	    int t2=P.type[2];
	    int go=0;
	    if((t1==-1)&&(t2==-1)) go=1;
	    if((t1==-1)&&(t2== 1)) go=1;
	    if(go==1) {
		max=hyperplaneCloud(P,0);
	    }
	}


	for(int j=14;j<28;++j) {
           Polytope P=new Polytope(PL.P[j]);
             int t1=P.type[1];
	    int t2=P.type[2];
	    int go=0;
	    if((t1==-1)&&(t2==-1)) go=1;
	    if((t1==-1)&&(t2== 1)) go=1;
	    if(go==1) {
		max=hyperplaneCloud(P,1);
	    }
	}
    

    System.out.println("done");
    }



    public void doProof5() {
	int max=0;	
        TorusPolytopes PL=new TorusPolytopes();

	for(int j=0;j<14;++j) {
           Polytope P=new Polytope(PL.P[j]);
             int t1=P.type[1];
	    int t2=P.type[2];
	    int go=0;
	    if((t1==0)&&(t2==1)) go=1;
	    if((t1==-1)&&(t2==0)) go=1;
	    if(go==1) {
		max=hyperplaneCloud2(P,0);
	    }
	}


	for(int j=14;j<28;++j) {
           Polytope P=new Polytope(PL.P[j]);
             int t1=P.type[1];
	    int t2=P.type[2];
	    int go=0;
            if((t1==0)&&(t2==1)) go=1;
	    if((t1==-1)&&(t2==0)) go=1;
	    if(go==1) {
		max=hyperplaneCloud2(P,1);
	    }
	}
    

    System.out.println("done");
    }

}

