import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeTile implements Runnable {
    int halt;
    int block;
    PolyWedge WEDGE;
    double A;
    PolyVector VECTOR;
    Complex SOURCE;
    Manager M;
    int MODE;


    public ComputeTile() {}

    public ComputeTile(Complex z,Manager MM,int mode) {
	WEDGE=PolyWedge.setQuad(MM.C.SES.getParameter());
	this.SOURCE=z;
	this.M=MM;
	this.MODE=mode;
    }


    public void run() {
	if(M.C.CON_T.MULTI.mode< 4) makeTile();
	if(M.C.CON_T.MULTI.mode==4) diamondTotal();
    }






  public void makeTile() {

       PinwheelMap RM=new PinwheelMap(M.C.SES.getParameter());
       Complex z=goodStart(SOURCE);
	
       int sector=RM.findSector(z);
       Complex z1=RM.doMap(sector%4,z);

       double[][] d=new double[4][2];
       for(int i=0;i<4;++i) {
	   d[i][0]=1;   //min
	   d[i][1]=-1;  //max
       }

        PolyWedge WEDGE=new PolyWedge(); 
        halt=1;
	int test=0;
	int count=0;
	double dist=0;  
	int orbit=0;
	int max=0;
	//    VECTOR=PolyVector.bigSquare(SOURCE);

	int choice=0;
	int big=0;

	while((halt==1)&&(test==0)) {
	    choice=(sector+count)%4;
            double temp=RM.getStripPosition(choice,z);
            orbit=orbit+(int)(Math.abs(RM.getDepth(choice,z)));
	    if(orbit>999999999) big=1;
	    z=RM.doMap(choice,z);
	    if((choice==1)&&(max<z.x)) max=(int)(z.x);


	    if(d[choice][0]>temp) d[choice][0]=temp;
	    if(d[choice][1]<temp) d[choice][1]=temp;

            if((count>0)&&(count%100000==0)) {
		Integer COUNT=new Integer(count);
		M.C.PROGRESS=COUNT.toString();
		M.C.repaint();
	    }

	    ++count;
	    dist=Complex.dist(z1,z);
	    if((count>6)&&(dist<.00001)) test=1;
	}

	for(int i=0;i<4;++i) {
	    d[i][0]=-d[i][0];
	    d[i][1]=1-d[i][1];
	}

	PolyWedge WEDGE1=RM.rhomb1(d[1][0],d[0][0],d[1][1],d[0][1],SOURCE);
	PolyWedge WEDGE2=RM.rhomb2(d[2][0],d[3][0],d[2][1],d[3][1],SOURCE);
	WEDGE=WEDGE1.polyChop(WEDGE1,WEDGE2);

        halt=0;
       	WEDGE.radius=max;
	if(big==1) orbit=0;
	WEDGE.orbit=orbit-1;
	M.P.nextOrbit(WEDGE);  
	M.P.repaint();	
	M.C.repaint();
    }








    public void firstReturn(double x,int k) {

        halt=1;
	int test=0;
	int choice=0;
	double y;

	Complex z=new Complex(x,k);
	while((halt==1)&&(test==0)) {
	    z=nextComplex(z,WEDGE);
	    y=Math.abs(z.y);
	    if(y*y<.01) test=1;
	}
    }


  public static int findGoodVertex(Complex w,PolyWedge Q) {
	int index=0;
	for(int i=1;i<4;++i) {
	    int test=Complex.isPositivelyOriented(w,Q.z[index],Q.z[i]);
	    if(test==1) {
		index=i;
	    }
	}
	return(index);
    }

    public static PolyWedge nextPoly(PolyWedge P,PolyWedge Q) {
	int k=findGoodVertex(P.getCenter(),Q);
	PolyWedge PP=new PolyWedge();
	for(int i=0;i<P.count;++i) {
	    Complex Z=new Complex(Q.z[k]);
	    Z=Complex.plus(Z,Z);
	    Z=Complex.minus(Z,P.z[i]);
	    PP.z[i]=new Complex(Z);
	}
	PP.count=P.count;
	PP.history=k;
	return(PP);
    }


    public static Complex nextComplex(Complex z,PolyWedge Q) {
	int k=findGoodVertex(z,Q);
	Complex Z=new Complex(Q.z[k]);
	Z=Complex.plus(Z,Z);
	Z=Complex.minus(Z,z);
	return(Z);
    }


    public Complex goodStart(Complex z) {
	Complex w=new Complex(z);
	for(int i=0;i<100;++i) {
	    if((w.x>0)&&(Math.abs(w.y)<w.x+1)) return(w);
	         w=nextComplex(w,WEDGE);
	         w=nextComplex(w,WEDGE);
	}
	return(z);
    }












    /**diamond fill routines*/



  public PolyWedge singleCore() {

       SOURCE.y=0;
       PinwheelMap RM=new PinwheelMap(M.C.SES.getParameter());
       Complex z=new Complex(SOURCE);
       int sector=1;

       double[][] d=new double[4][2];
       for(int i=0;i<4;++i) {
	   d[i][0]=1;   //min
	   d[i][1]=-1;  //max
       }

        PolyWedge WEDGE=new PolyWedge(); 
        halt=1;
	int test=0;
	int count=0;
	double dist=0;  
	int orbit=0;
	int max=0;
        VECTOR=PolyVector.bigSquare(SOURCE);

	int choice=0;
	int big=0;

	for(count=0;count<9;++count) {
	    choice=(sector+count)%4;
            double temp=RM.getStripPosition(choice,z);
	    z=RM.doMap(choice,z);
	    if(d[choice][0]>temp) d[choice][0]=temp;
	    if(d[choice][1]<temp) d[choice][1]=temp;
	}

	for(int i=0;i<4;++i) {
	    d[i][0]=-d[i][0];
	    d[i][1]=1-d[i][1];
	}

	PolyWedge WEDGE1=RM.rhomb1(d[1][0],d[0][0],d[1][1],d[0][1],SOURCE);
	PolyWedge WEDGE2=RM.rhomb2(d[2][0],d[3][0],d[2][1],d[3][1],SOURCE);
	WEDGE=WEDGE1.polyChop(WEDGE1,WEDGE2);
	return(WEDGE);
  }

    public double extractMaxX(PolyWedge WEDGE) {
	double max=0;
	for(int i=0;i<WEDGE.count;++i) {
	    if(max<WEDGE.z[i].x) max=WEDGE.z[i].x;
	}
	return(max);
    }


    public int shapeClassify(PolyWedge X) {
	if(X.count>4) return(2);
	if(X.recognizeRhombus()==1) return(1);
	return(0);
    }





    public Icon fillDiamond(int nn) {
	Icon X=new Icon();

	int n=4*nn-1;
	if(nn<0) n=3;
	X.n=0;
	int count=0;
	SOURCE.x=n+.000001;
	if(nn==0) SOURCE.x=WEDGE.z[2].x+.000001;    //0th diamond override
	while(SOURCE.x<n+4) {
	    double oldX=SOURCE.x;
            PolyWedge WEDGE=singleCore();
	    X.D[count]=WEDGE;
	    double max=extractMaxX(WEDGE);
	    SOURCE.x=max+.000001;
	    X.w[count]=SOURCE.x-oldX;
	    X.t[count]=shapeClassify(WEDGE);
	    ++count;
	}
	X.n=count;
	return(X);
    }





    public void diamondSingle() {

	int n=(int)((SOURCE.x+1)/4.0);
	Icon X=fillDiamond(n);
	for(int i=0;i<X.n;++i) {
	   if(X.t[i]==0) M.C.CS.C=Color.red;
	   if(X.t[i]==1) M.C.CS.C=new Color(0,0,150);
	   if(X.t[i]==2) M.C.CS.C=new Color(0,100,100);
 	   M.P.nextOrbit(X.D[i]);  
	}
	M.P.repaint();
    }






	public static double dec(double x) {
	    return(x-Math.floor(x+.5));
	}

       public static Complex diamondInvariant(double A,double n) {
	 double x=1/(1+A);
	 double y=2*A/((1+A)*(1+A));
	 x=dec(x*n);
	 y=dec(y*n);
	 Complex z=new Complex(x,y);
	 return(z);
	}




    public void diamondTotal() {
	double A=M.C.SES.getParameter();
	Icon X=new Icon();
	double LIM=Math.pow(2,M.C.CON_T.TCC.INT[0].val-2);
	halt=1;
	int n=-1;
	int n2=0;
	int MOD=M.C.SES.getNumerator()+M.C.SES.getDenominator();
	Complex z=new Complex();

        while((halt==1)&&(n<=LIM)) {

	    if(n>0) {
               X=fillDiamond(n);

	       for(int i=0;i<X.n;++i) {
	         if(X.t[i]==0) M.C.CS.C=Color.red;
	         if(X.t[i]==1) M.C.CS.C=new Color(0,0,150);
	         if(X.t[i]==2) M.C.CS.C=new Color(0,100,100);
 	         M.P.nextOrbit(X.D[i]);  
	       }

	       Complex w=diamondInvariant(A,n);
	    }
	    n=n+1;
            if(n%256==0) sendMessage(n);
	}


    halt=0;
    M.C.repaint();
    M.P.repaint();
    }

    public void sendMessage(int n) {
	 Integer N=new Integer(n);
	 M.C.PROGRESS=N.toString();
	 M.C.repaint();
    }




    public int match(int k,int[] a,int[] b) {
	for(int i=0;i<k;++i) {
	    if(a[i]!=b[i]) return(0);
	}
	return(1);
    }

    public int match(int k,int[] a,int[][] B) {
	for(int j=0;j<B[0][0];++j) {
	    if(match(k,a,B[j])==1) return(1);
	}
	return(0);
    }


   public class Icon {
    int n;
    double[] w=new double[6];
    int[] t=new int[6];
    PolyWedge[] D=new PolyWedge[6];


    public Icon() {}

   }



}









