import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This is the class for the main control window.*/


public class ControlCanvas extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ControlPanel GLOBAL,EXPORT,MODULE,MOUSE;
    ControlTiling   CON_T;
    ControlGraph    CON_G;
    ControlTorus    CON_P;
    ControlExtra    CON_E;

    ListenSquare[] MM=new ListenSquare[5];
  
    SelectColor CS;
    ListenSquare GO,HALT,RESET;
    String PROGRESS="";
    Documentation DOC;
    ShapeEntrySystem SES;

    //runnable modules
    ComputeArithmeticGraph CAG;
    ComputeProof COMP;
    ComputePinwheel CSAN;
    ComputeMasterDemo CMPD;
    ComputeHexagridDemo CHD;

    public ControlCanvas addManager(Manager M) {
	ControlCanvas Q=this;
	Q.M=M;
	return(Q);
    }

     public ControlCanvas() {
	 addMouseListener(this);
  	 addMouseMotionListener(this);
 	 addKeyListener(this);
	 DOC=new Documentation();
	 CON_T=new ControlTiling(110,10);
	 CON_G=new ControlGraph(110,10);
	 CON_P=new ControlTorus(110,10);
	 CON_E=new ControlExtra(110,10);
	 SES=new ShapeEntrySystem(427,3);

	 setControlPanels();
	 setStartStop();
	 CS=new SelectColor(M,3,328,420,65);

	 //runnable modules
	 CAG=new ComputeArithmeticGraph(); 
	 COMP=new ComputeProof();
	 CMPD=new ComputeMasterDemo();
	 CHD=new ComputeHexagridDemo();
	 CSAN=new ComputePinwheel();


	 //mouse emulator
	 MM[0]=new ListenSquare(3,1,14,14,Color.white);
	 MM[1]=new ListenSquare(26,1,14,14,Color.white);
	 MM[2]=new ListenSquare(40,1,14,14,Color.white);
	 MM[3]=new ListenSquare(54,1,14,14,Color.white);
	 MM[4]=new ListenSquare(86,2,12,12,Color.white);
	 MM[0].on=1;
     }

    public void setStartStop() { 
         RESET=  new ListenSquare(530,3,72,30,Color.white);
         GO=  new ListenSquare(3,250,40,30,Color.white);
	 HALT=new ListenSquare(3,285,80,30,Color.white);
	 GO.on=1;	 
         HALT.on=1;
	 RESET.on=1;
    }

    public void setControlPanels() {	 
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(160,0,160),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(0,160,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C3={new Color(200,0,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C4={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

	 //mouse emulator
	 String[] MouseString={"not needed","button 1 (Z)","button 2 (X)", "button 3 (C)", "mouse emulator"};
	 int[] MouseState={1,0,0,0};
         MOUSE=new ControlPanel(C3,MouseString,MouseState,4);

	 //global
	 String[] GlobalString={"tiling", "graph", "torus", "checks","controls"};
	 int[] GlobalState={1,0,0,0};
         GLOBAL=new ControlPanel(C3,GlobalString,GlobalState,4);

	 //export
	 String[] ExportString={"no","yes","yes","export"};
	 int[] ExportState={1,0,0};
         EXPORT=new ControlPanel(C3,ExportString,ExportState,3);

    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(GLOBAL.mode==0) CON_T.render(g);
      if(GLOBAL.mode==1) CON_G.render(g);
      if(GLOBAL.mode==2) CON_P.render(g);
      if(GLOBAL.mode==3) CON_E.render(g);
      GLOBAL.render(g,3,3,95);
      EXPORT.render(g,3,88,95);  
      MOUSE.render(g,3,158,95);
      SES.render(g); 
      drawResetButton(g);
      drawGoButton(g);
      CS.render(g); 
      haltDraw(g);
   }


    //getting the parameter

    public int[] getParameter() {
	int[] x=new int[2];
	x[0]=SES.getNumerator();
	x[1]=SES.getDenominator();
	return(x);
    }

    public int[] getMemoryParameter() {
	int[] x=new int[2];
	x[0]=SES.SER.J[0].val;
	x[1]=SES.SER.J[1].val;
	return(x);
    }



    /**the background*/

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,50,50));
	g.fillRect(103,3,320,320);
	g.setColor(Color.white);
	g.drawRect(103,3,320,320);
    }


    /*The halt button -- activated when something is computing*/

  public void haltDraw(Graphics2D g) {
      int test=0;
        if(CAG.halt==1) test=1;
        if(COMP.halt==1) test=1;
        if(CSAN.halt==1) test=1;
        if(M.P.TC.halt==1) test=1;


      if(test==1) {
	    HALT.render(g,new Color(220,0,0));
            g.setColor(Color.white);
            g.setFont(new Font("Helvetica",Font.PLAIN,12));
	    g.drawString("halt",(int)(HALT.x+3),(int)(HALT.y+11));
            g.setFont(new Font("Helvetica",Font.PLAIN,10));
	    g.drawString(PROGRESS,(int)(HALT.x+3),(int)(HALT.y+23));
      }
  }


    //the GO button

    public void drawGoButton(Graphics2D g) {
	 int test=0;
	 if(GLOBAL.mode==1) test=1;
	 if(GLOBAL.mode==3) test=1;
	 if((GLOBAL.mode==2)&&(CON_P.MODE.val==6)) test=1;
	 if((GLOBAL.mode==2)&&(CON_P.MODE.val==8)) test=1;

	 if(test==1) {
            GO.render(g,new Color(200,0,0));
	    g.setFont(new Font("Helvetica",Font.PLAIN,20));
	    g.setColor(Color.white);	 
	    g.drawString("go",(int)(GO.x+6),(int)(GO.y+20));
	 }
    }


    public void drawResetButton(Graphics2D g) {
	 g.setFont(new Font("Helvetica",Font.PLAIN,20));
	RESET.render(g,new Color(200,0,200));
	g.setColor(Color.white);	 
	g.drawString("reset",(int)(RESET.x+6),(int)(RESET.y+20));
    }


   public void resetStuff(Point X) {
        M.P.QUAD.z[2]=new Complex(SES.getParameter(),0);
       	M.P.tile=0;
	M.P.orbit=0;
        M.R.count=0;
   }


   public void doAction(Point X,int mode) {
      if(GO.inside(X)==1) {
        //arithmetic grapher


	if(GLOBAL.mode==1) {
	          CAG=new ComputeArithmeticGraph(M.R.SOURCE,M);
                  new Thread(CAG).start();
	   }

	//hexagrid statement 2 demo
	if((GLOBAL.mode==2)&&(CON_P.MODE.val==6)) {
                CHD=new ComputeHexagridDemo(M);
                new Thread(CHD).start();
	}

	//master picture demo
	if((GLOBAL.mode==2)&&(CON_P.MODE.val==8)) {
                CMPD=new ComputeMasterDemo(M);
                new Thread(CMPD).start();
	}


	//pinwheel check

	if((GLOBAL.mode==3)&&(CON_E.CHECK.mode==0)) {
	    CSAN=new ComputePinwheel(M);
                 new Thread(CSAN).start();
	}

	//proofs from the monograph

	if((GLOBAL.mode==3)&&(CON_E.CHECK.mode>=1)) {
	    COMP=new ComputeProof(M);
                 new Thread(COMP).start();
	}



      }
   }



      //halt computations

       public void haltComputations() {
	    M.P.TC.halt=0;
	    CAG.halt=0;  
	    COMP.halt=0; 
	    CMPD.halt=0;
	    CSAN.halt=0;
       }


    //set the shape parameter
     public void selectShape(MouseEvent e) {
	int sh_info=SES.process(e);  
                  M.P.QUAD.z[2]=new Complex(SES.getParameter(),0);
	if(sh_info==20) DOC.shapeInfo();
	if(sh_info==101) DOC.shapeRational1();
     }



    //mouse button action


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e,MOUSE.mode);
	DOC.M=this.M;

	int test=GLOBAL.switchMode(J.X);
	if(test==20) DOC.global_info();

	test=MOUSE.switchMode(J.X);
	if(test==20) DOC.mouse_info();


	test=EXPORT.switchMode(J.X);
	if(test==20) DOC.export_info();

	if(GLOBAL.mode==0) CON_T.process(e,CS.C,M);
	if(GLOBAL.mode==1) CON_G.process(e,CS.C,M);
	if(GLOBAL.mode==2) CON_P.process(e,CS.C,M);
	if(GLOBAL.mode==3) CON_E.process(e,CS.C,M);

	doAction(J.X,J.mode);

	selectShape(e);
	if(RESET.inside(J.X)==1) resetStuff(J.X); 
	if(HALT.inside(J.X)==1) haltComputations();         //halt computations
	CS.process(e,DOC); 
	repaint();
	M.P.repaint();
	M.R.repaint();
	M.PE.repaint();
    }


    public void mousePressed(MouseEvent e) {
	M.PE.point=0;
	M.PE.path=0;
    }

   public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {	
        MouseData J=MouseData.process(e,MOUSE.mode);
	CON_P.process(e,CS.C,M);
                  M.PE.repaint();	
	repaint();
    }

    public void keyTyped(KeyEvent e) {
	if(GLOBAL.mode==1) CON_G.processKey(e);
                  SES.processKey(e);
   	    repaint();
	}
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

