import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlExtra {
    Manager M;
    Documentation DOC;
    int x,y;
    ControlPanel CHECK;
    SelectInteger[] INT=new SelectInteger[4];

    public ControlExtra(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation(); 
	Color[] C0={new Color(0,180,180),Color.white,Color.white,Color.black,Color.red};

	String[] CheckString={"pinwheel check","embedding proof","hexagrid 1 proof","hexagrid 2 proof 1","hexagrid 2 proof 2","hexagrid 2 proof 3","extra computations"};
	int[] CheckState={1,0,0,0,0,0};
	 CHECK=new ControlPanel(C0,CheckString,CheckState,6);

	 INT[0]=new SelectInteger(x+150,y+5,30,15,8,1,20,1);   //pinwheel parameter density
	 INT[1]=new SelectInteger(x+150,y+55,30,15,10,1,20,1);   //pinwheel sample density
	 INT[2]=new SelectInteger(x+150,y+105,30,15,3,1,8,1);   //pinwheel sample extent

    }

    public void render(Graphics2D g) {
	CHECK.render(g,x,y,120);
	if(CHECK.mode==0) drawPinwheel(g);
    }

    public void drawPinwheel(Graphics2D g) {
	g.setColor(new Color(0,180,180));
	g.fillRect(x+130,y,130,142);
	g.setColor(Color.white);
	g.drawRect(x+130,y,130,142);
         INT[0].render2(g,new Color(255,50,0),Color.white,Color.white);
         INT[1].render2(g,new Color(255,50,0),Color.white,Color.white);
         INT[2].render2(g,new Color(255,50,0),Color.white,Color.white);
	 g.setColor(Color.black);
	 g.drawString("number of parameters",x+140,y+35);
	 g.drawString("points per parameter",x+140,y+85);
	 g.drawString("total length covered",x+140,y+135);
    }



    public void pinwheelSelectProcess(Point X) {
	INT[0].modify(X);
	INT[1].modify(X);
	INT[2].modify(X);
    }

    public void process(MouseEvent e,Color C,Manager MM) {	
        MouseData J=MouseData.process(e);
	int test=CHECK.switchMode(J.X);
	DOC.M=MM;
	if(test==20) DOC.sanityInfo();
	if(CHECK.mode==0) pinwheelSelectProcess(J.X);
    }
}

