import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlGraph {
    ControlPanelColor HEX,LINE,REGION,BASIC;  
    SelectInteger WIDTH,HEIGHT,LIMIT;
    ListenSquare INFO=new ListenSquare();
    ControlPanel STYLE,CHOICE,SCALE;
    Documentation DOC;
    ListenSquare BW;
    int x,y;




    public ControlGraph(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation();
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(150,150,150)};

	 //hexagrid
	 String[] HexString={"total","ceiling","wall","door","door","door","door","hexagrid"};
	 Color[] HexColor={Color.white,new Color(250,0,255),new Color(255,0,255),new Color(0,200,0),new Color(0,200,0),new Color(0,0,255),new Color(0,0,255)};
	 int[] HexState={0,0,0,0,0,0,0};
         HEX=new ControlPanelColor(C1,HexString,HexState,7,HexColor);



	 //more lines
	 String[] LineString={"barrier","iota(wall)","symm line","more lines"};
	 Color[] LineColor={new Color(255,155,0),new Color(255,0,255),Color.blue};
	 int[] LineState={0,0,0};
         LINE=new ControlPanelColor(C1,LineString,LineState,3,LineColor);


	 //basics
	 String[] BasicString={"bgcolor","axes","Z+Z grid","baseline","rational","marker","basics"};
	 Color[] BasicColor={Color.black,new Color(0,100,100),new Color(0,0,255,60),new Color(100,100,255),new Color(155,0,255),Color.yellow};
	 int[] BasicState={0,1,1,1,0,1};
         BASIC=new ControlPanelColor(C1,BasicString,BasicState,6,BasicColor);

	 //special regions
	 String[] RegionString={"outline","room","decomp","decomp+","arith.kite","dio lemma","traps","period","regions"};
	 Color[] RegionColor={Color.white,new Color(100,0,0,200),new Color(0,0,250,200),new Color(0,0,250,200),new Color(0,0,255,200),new Color(200,0,0,200),new Color(200,0,200,200),new Color(200,0,200),new Color(40,0,40)};
	 int[] RegionState={0,0,0,0,0,0,0,0};
         REGION=new ControlPanelColor(C1,RegionString,RegionState,8,RegionColor);

         String[] Choice1String={"basic (A)","forward (S)","backward (D)","period","pivot arc","monster","low -- even","low -- odd","block1 (F)","block2 (G)","compare","plot mode"};
         int[] Choice1State={1,0,0,0,0,0,0,0,0,0,0,0,0};
         CHOICE=new ControlPanel(C1,Choice1String,Choice1State,11);

         String[] styleString={"outline","solid","solid+white","draw style"};
         int[] styleState={1,0,0};
         STYLE=new ControlPanel(C1,styleString,styleState,3);

         String[] scaleString={"integral","affine","scale"};
         int[] scaleState={1,0};
         SCALE=new ControlPanel(C1,scaleString,scaleState,2);



	 LIMIT=new SelectInteger(x+10,y+290,36,16,12,1,18,1); 
	 WIDTH=new SelectInteger(x+10,y+290,36,16,7,1,15,1);   
	 HEIGHT=new SelectInteger(x+130,y+290,36,16,3,1,15,1);
          INFO=new ListenSquare(x+72,y-5,12,12,Color.white);
	  BW=new ListenSquare(x+120,y+220,50,20,Color.white);
    }


    public void blackAndWhite() {
	BASIC.M[0].C=Color.white;
	BASIC.L[1].on=0;
	BASIC.M[1].C=new Color(160,160,160);
	BASIC.L[2].on=0;
	BASIC.M[2].C=new Color(220,220,220);
	BASIC.M[3].C=new Color(120,120,120);
	BASIC.L[5].on=0;
	REGION.M[1].C=new Color(230,230,230);

    }


    public int getLimit() {
	return((int)(Math.pow(2,LIMIT.val)));
    }
    public int getWidthLimit() {
	return((int)(Math.pow(2,WIDTH.val)));
    }
    public int getHeightLimit() {
	return((int)(Math.pow(2,HEIGHT.val)));
    }


    public void renderLimits(Graphics2D g) {
	int opt=getOption();
	if(opt<8) renderBasic(g);
	if(opt>=8) renderBlock(g);
    }


    public void renderBasic(Graphics2D g) {
	g.drawString("length",x+20,y+282);
	LIMIT.render2(g,new Color(50,50,255),Color.white,Color.white);
    }

    public void renderBlock(Graphics2D g) {
	g.drawString("width",x+20,y+282);
	WIDTH.render2(g,new Color(50,50,255),Color.white,Color.white);
	g.drawString("height",x+130,y+282);
	HEIGHT.render2(g,new Color(50,50,255),Color.white,Color.white);
    }

    public int getOption() {
	return(CHOICE.mode);
    }


    public void render(Graphics2D g) {
	 if(SCALE.mode==0) {
	   REGION.render(g,x,y+115,100);
	   LINE.render(g,x+105,y+130,100);
	   HEX.render(g, x+105,y,100);	 
           BASIC.render(g,x,y,100);
	 }
	 CHOICE.render(g,x+212,y,95);
	 STYLE.render(g,x+212,y+190,95);
	 SCALE.render(g,x+212,y+260,95);
	 renderLimits(g);
	 BW.render(g,Color.white);
	 g.drawString("b&w",(int)(BW.x+10),(int)(BW.y+14));	
    }


    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
        int test=HEX.process(J.X,C);
	if(test==20)  DOC.hexInfo();
        test=LINE.process(J.X,C);
	if(test==20)  DOC.lineInfo();
        test=BASIC.process(J.X,C);
    	if(test==20)  DOC.basicInfo();
        test=REGION.process(J.X,C);	
        if(test==20)  DOC.regionInfo();
	test=CHOICE.switchMode(J.X);
  	if(test==20) DOC.AGP_info();
	test=STYLE.switchMode(J.X);
	if(test==20) DOC.style_info();
	test=SCALE.switchMode(J.X);
	if(test==20) DOC.scale_info();

        int test2=getOption();
        if(test2<8) LIMIT.modify(J.X);
        if(test2>=8) {
	WIDTH.modify(J.X);
	HEIGHT.modify(J.X);
	}
	if(BW.inside(J.X)==1) blackAndWhite();
    }

    public void processKey(KeyEvent e) {}

}

