import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlTiling {
    Manager M;
    ControlPanel COLORS,ACTION,MULTI,POWER;
    ControlPanelColor MARKER;	 
    TileCoordsDisplay VCD;
    TilingClipControl TCC;  
    Pinwheel PW;
    SelectInteger[] INT=new SelectInteger[4];
    int x,y;
    Documentation DOC;

    public ControlTiling(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation();
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};


	 //toggle display of objects

	 //toggle display of objects
	 String[] TileShowString={"X lines", "frame","diamonds","pinwheel","necklace","display"};
         Color[]  TileShowColor={new Color(100,100,100,100),new Color(0,30,150),new Color(220,0,250),new Color(200,0,100,100),new Color(255,0,255)};
	 int[] TileShowState={0,1,0,0,0};
         MARKER=new ControlPanelColor(C1,TileShowString,TileShowState,5,TileShowColor);





	 //object colors
	 String[] ColorString={"edge","bg","kite","tracer","colors"};
	 Color[] COL={Color.white,Color.black,new Color(0,0,255),new Color(200,0,100,100)};
	 int[] ColorState={0,0,0,0};
         COLORS=new ControlPanel(C1,ColorString,ColorState,4,COL);

	 //power of map
	 String[] PowerString={"1","2","power"};
	 int[] PowerState={0,1};
         POWER=new ControlPanel(C1,PowerString,PowerState,2);
	 POWER.mode=1;


	 //button 2 selector
	 String[] ActionState={"plot","recolor orbit","erase orbit","recolor tile","tile coords","button 2"};
	 int[] ButtonState={1,0,0,0,0,0};
         ACTION=new ControlPanel(C1,ActionState,ButtonState,5,0);

	 //tile coords display
         VCD=new TileCoordsDisplay(x,y+263); 
	 //orbit tracer

	 //orbit type selector
	 String[] IterationString={"whole orbit","strip","1st return","#","diamonds","plot type"};
	 int[] IterationState={0,0,0,1,0};
         MULTI=new ControlPanel(C1,IterationString,IterationState,5);
	 MULTI.mode=3;	      
         INT[0]=new SelectInteger(x+135,y+65,30,13,1,1,20,1);  //orbit length
	 TCC=new TilingClipControl(x,y+185); 
         PW=new Pinwheel(x+190,y);


    }

    public void render(Graphics2D g) {
         ACTION.render2(g,x+95,y+100,90); 
         MULTI.render2(g,x+95,y,90);   
         POWER.render(g,x+95,y+200,90);   

	 if(MARKER.L[3].on==1) PW.render(g); 
         if(ACTION.mode==4) VCD.render(g,0);  
         COLORS.render2(g,x,y+100,90); 
         MARKER.render(g,x,y,90);
         INT[0].render(g,Color.red,Color.white,Color.black);  
	 TCC.render(g);
    }

  public void vertexCoordsProcess(MouseEvent e) {
	int stats=VCD.process(e);
	if(stats==1) M.P.repaint();
	if(stats==20) DOC.stats_info();
     }
  public void modifyOrbitType(Point X) {
	int multi=MULTI.switchMode(X);               	
	if(multi==20) DOC.multiInfo();
        INT[0].modify(X);
     }

    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
	int test1=MARKER.process(J.X,C);
	if(test1==20) DOC.markerInfo();
	int test2=COLORS.recolor(J.X,C);
	if(test2==20) DOC.colorInfo();
	int test3=ACTION.switchMode(J.X);
	if(test3==20) DOC.actionInfo();
	int pcc=TCC.processMouse(J.X,DOC);   
	int power=POWER.switchMode(J.X);  
	if(power==20) DOC.power_info();            
	vertexCoordsProcess(e);
	modifyOrbitType(J.X);	 
        PW.stripModify(J.X,DOC,C);
    }

}

