import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlTorus {
    Manager M;
    Documentation DOC;
    int x,y;
    TorusPartitionControl PEC;
    SelectInteger MODE;
    ListenSquare ON;
    ListenSquare[] INFO=new ListenSquare[5];


    public ControlTorus(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation(); 
        PEC=new TorusPartitionControl(x,y,M);

	Color[] C0={new Color(0,200,200),Color.white,Color.white,Color.black,Color.orange};

	 MODE=new SelectInteger(x+10,y+290,37,20,0,0,9,1);
	 INFO[0]=new ListenSquare(x-7,y+301,12,12,Color.white);
	 INFO[1]=new ListenSquare(x+80,y+275,12,12,Color.white);
	 ON=new ListenSquare(x+153,y+270,15,15,Color.white);
	 ON.on=1;
    }


    public void render(Graphics2D g) {
	g.setColor(new Color(0,180,180));
	g.fillRect(x-7,y+270,175,43);
	g.setColor(Color.white);
	g.drawRect(x-7,y+270,175,43);
	ON.render(g,new Color(50,100,255));
	  MODE.render(g,Color.red,Color.white,new Color(0,0,0,0));
	  drawModes(g);
	  PEC.render(g,MODE.val);
    }



    public void drawModes(Graphics2D g) {
	g.setColor(Color.white);
	g.drawString("display mode",x,y+283);
	g.drawString("on",x+135,y+283);
	INFO[0].infoRender(g);
	INFO[1].infoRender(g);
	if(MODE.val==0) g.drawString("0. basic",x+50,y+303);
	if(MODE.val==1) g.drawString("1. general purpose",x+50,y+303);
	if(MODE.val==2) g.drawString("2. master picture thm",x+50,y+303);
	if(MODE.val==3) g.drawString("3. valence-two demo",x+50,y+303);
	if(MODE.val==4) g.drawString("4. embedding demo",x+50,y+303);
	if(MODE.val==5) g.drawString("5. hexagrid theorem 1",x+50,y+303);
	if(MODE.val==6) g.drawString("6. hexagrid theorem 2",x+50,y+303);
	if(MODE.val==7) g.drawString("7. barrier theorem",x+50,y+303);
	if(MODE.val==8) g.drawString("8. master picture II",x+50,y+303);
    }






    public Complex getFiber() {
	Complex z=new Complex();
	return(PEC.TOR.Z);
    }

    public int getProjection() {
	return(PEC.PROJ.mode);
    }




    public int getFiberSelect() {
        int test0=PEC.DISPLAY.L[0].on;
        int test1=PEC.DISPLAY.L[1].on;
	return(test0+2*test1);
    }




    public int getShift() {
	return(PEC.SHIFT.mode);
    }

    public int getSlice() {
	return(PEC.PROJ.mode);
    }

    public Color getColorAbsolute(int t1,int t2,int a) {
	   return(PEC.getColor(t1,t2,a,0));
    }





    public void process(MouseEvent e,Color C,Manager MM) {	
        MouseData J=MouseData.process(e);
	if(J.mode==2) PEC.colorProcess(J.X,MM);
	if(J.mode!=2) PEC.selectorProcess(J.X);
	DOC.M=MM;
          PEC.M=MM;
          PEC.mouseProcess(J.X,MM,MODE.val);
	  MODE.modifyCyclic(J.X);
	  if(ON.inside(J.X)==1) ON.on=1-ON.on;
	  if((MODE.isModified(J.X)==1)&&(ON.on==1)) PEC.resetControls(MODE.val);

	  if(INFO[0].inside(J.X)==1) DOC.polytope_mode_info();
	  if(INFO[1].inside(J.X)==1) {
	      if(MODE.val==0) DOC.polytope_basic_info();
	      if(MODE.val==1) DOC.polytope_general_info();
	      if(MODE.val==2) DOC.polytope_master_info();
	      if(MODE.val==3) DOC.polytope_valence_info();
	      if(MODE.val==4) DOC.polytope_embed_info();
	      if(MODE.val==5) DOC.polytope_hex1_info();
	      if(MODE.val==6) DOC.polytope_hex2_info();
	      if(MODE.val==7) DOC.polytope_barrier_info();
	      if(MODE.val==8) DOC.polytope_master2_info();
	  }
    }

}

