import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentPolytope {
    Manager M;
    public DocumentPolytope(Manager MM) {
	this.M=MM;
    }




    public void info() {

	String S="torus partition: general info";

	S=S+"\n\nThe torus partition window draws slices of a 4 dimensional picture. This area manages the drawing of that picture. The picture is a partition of a pair of convex polytopes into smaller convex polytopes.   Technically, we construct partitions of spaces having the topological form T x [0,1], where T is a 3 dimensional torus.  This is why we call our objects 'torus partitions' even though we are cutting them open and drawing them in Euclidean space. This 4 dimensional partition is explained in detail in my monograph, in connection with the Master Picture Theorem. The Master Picture Theorem demo on this window will also explain the significance of the partition.  However, if you are new to this window, you should first learn about how to operate the controls. This is the general documentation for the control panel.   Here we will briefly explain the two main controls in this window.  You should click on the info boxes attached to the various controls to get more information.";

	S=S+"\n\nThe slice selector: This is the large cyan square with an x in it.  We think of our 4 dimensional picture as being a subset of 4-dimensional space, with coordinates (x,y,z,A).  Here A corresponds to the kite parameter and (x,z,y) correspond to a certain pair of 3d partitions that we construct for the parameter A  The large cyan square lets you select values for (z,A).  When you do this, the resulting slice is drawn in the torus partition window.  The easiest way to select (z,A) is to drag the mouse over the square.  The documentation for the square explains additional options.  You can also select a parameter using the red button at the very top of the slice selector.  This red button grabs a rational parameter from the space selector.";

	S=S+"\n\nThe display switcher.   These arrows allow you to select between 7 modes of operation for the controls. Mode 0 and Mode 1 are, in a sense, the two extremes.  Mode 0 has no controls at all except the slice selector.  You should use this mode first, just getting used to the slice selector and the pictures it causes the Torus Partition Window to draw.  Mode 1 has essentially all of the controls.  Once you have mastered Mode 0, you should enter Mode 1 and learn the other controls.  Modes 2,3,4,5,6 are specialized modes, each designed to illustrate a different theorem in my monograph.   The info button just to the right of the mode switcher explains each mode in detail.  The inbo button at the very bottom left describes the operation of the display switcher.";
    
	M.E.setExplain(S);
    }




    public void slice_info() {

	String S="slice selector";

	S=S+"\n\nThe torus partition window draws slices of a 4 dimensional picture.  We think of our 4 dimensional picture as being a subset of 4-dimensional space, with coordinates (x,y,z,A).  Here A corresponds to the kite parameter and (x,z,y) correspond to a certain pair of 3d partitions that we construct for the parameter A   There are 3 ways to operate the slice selector.";

	S=S+"\n\n1. Draw the mouse button over the square.  This changes the (z,A) coordinates.";

	S=S+"\n\n2. Use the buttons above and to the right of the square. Clicking on these buttons increments either the z or the A coordinate.  The outer buttons cause bigger increments. We display the decimal value of z and A on the sides of the square, so you can quickly learn the effect of each of your clicks.";

	S=S+"\n\n3. You can use red button at the very top of the window to grab a parameter from the shape entry system.  This changes the A parameter but not the z parameter.  This option is not always visible on the controls.";

    
	M.E.setExplain(S);


    }




    public void master_info() {

	String S="master picture theorem demo";

S=S+"\n\nThis display mode illustrates the Master Picture Theorem from the monograph. Parr II of the monograph explains the situation in great detail.  Here we will just try to give a rough feel for the connection.  It turns out that there is a locally linear map from the integer lattice Z2 into our polytopes.  There are really two such maps, a plus map and a minus map.  The local structure of the arithmetic graph at a given point is determined by which polyhedra in our partitions contain the images of the given point under the plus and minus maps.";

	S=S+"\n\nThe precise connection is difficult to say in words, but we can guide the user to an understanding of what is going on by describing an experiment.  The experiment involves looking simultaneously at the Torus Partition Window and the Arithmetic Graph Window.";

	S=S+"\n\nStep 1:  Arrange this Control Panel, the Torus Partition Window, and the Arithmetic Graph Window so that all are visible.";

	S=S+"\n\nStep 2:  Select a rational parameter, say A=13/37.  Press the 'reset' button to make sure that this parameter is recorded.";

	S=S+"\n\nStep 3:  Switch to the arithmetic graph controls and do the 'block plot' option. This will plot a chunk of the arithmetic graph.";

	S=S+"\n\nStep 4:  Switch back to the Torus controls, and turn on the 'hear' option on the 'display' control panel. This causes Billiard King to apply the plus and minus maps to any point you select in the arithetic graph window.";

	S=S+"\n\nStep 5:  Set the '--shift' option to (2+A)(1).  This positions the minus fiber in the correct position for the demo.";

	S=S+"\n\nStep 6:  Select a point on the arithetic graph window (using the middle mouse button.)  Let's say that you select (3,6).";

	S=S+"\n\nStep 7:  Look at the white points now plotted the Torus Partition Window.  You will see one point in the plus fiber and one point in the minus fiber. If you are following the example we have suggested, you will see one point in an orange region and one point in a dark green region.  In this way, you associated a pair of colors to your selected point";

	S=S+"\n\nStep 8:  Look at the colored tic-tac-toe board on top left of the the Torus Partition Window control panel.  Your pair of colors determines two squares in this tic-tac-toe grid.  Note the positions of these squares.";

	S=S+"\n\nStep 9:  Draw segments from the center of the tic-tac-toe board to the centers of the two special squares. You will see the same local type as in the arithmetic graph window. Actally, this should happen automatically if you have all the settings right. In the example we are considering, the orange square is northeast from the center and the dark green square is south.  This matches the picture you see when looking at the point (3,6) in the Arithmetic Graph Window.";

	S=S+"\n\nStep 10:  Repeat with other points and parameters until you see the pattern.";

	S=S+"\n\n There is one additional thing we should mention about this demo.  Sometimes it appears that the points we are talking about lie on the edge of our tile.  Our convention is that such points should be given an infinitesimal push upwards and to the right.   This determines the color for such points.  This convention is explained in detail in the monograph, both in connection with the Master Picture Theorem and in connection with the definition of the arithmetic graph.";

    
	M.E.setExplain(S);
    }




    public void master2_info() {

	String S="master picture theorem demo II";

	S=S+"\n\nThis display mode gives a second illustration of the Master Picture Theorem.  Actually, it is more like a sanity check for the result.  Here is how to operate this demo.";

	S=S+"\n\n1.  Select a slice using the torus slice selector.  For best results, first drag the mouse over the slice selector and then perturb your selection a bit using the buttons above and to the right of the selector.  These fine perturbations help insure that you have not selected a very simple rational.  The demo is boring for very simple rationals.";

	S=S+"\n\n2. Adjust the color selector so that the transparency of the color is neatly 0.  This will cause the two slices on the Torus Partition Window to be displayed dimly.  You want a dim display here because the demo will plot over the display.";

	S=S+"\n\n3. Use the blue arrow keys to specify how many points you would like to plot. The default is 2^10.";

	S=S+"\n\n4. Push the red GO button on the side of the control panel, wait a bit, then look at the Torus Partition Window.";


	S=S+"\n\nBilliard King is sampling a large number of points, tuned so that they actually lie in the selected slice.  For each point, the arithmetic graph is computed dynamically, and then the color of the point is determined by the local structure of the arithmetic graph.  At the same time, the point is mapped into the torus using the map from the Master Picture Theorem.  What we are checking is that the color of the point matches the color of the region, as determined by the Master Picture Theorem.  This test, when performed for a few parameters, gives overwhelming experimental evidence that the Master Picture Theorem is correct.";
    
	M.E.setExplain(S);
    }



    public void embed_info() {


	String S="embedding theorem demo";

S=S+"\n\nThis display mode allows you to verify by hand our claim that the arithmetic graph is embedded. Here is the proof.  If the graph is not embedded, then there is some X that appears in the graph.  Consider the two right vertices of the X.  Referring to the Master Picture Theorem, this can happen in one of 4 ways.";

	S=S+"\n\nThe plus tiling assigns to the top right vertex an edge that slopes down and left while the plus tiling assigns to the top left vertex an edge that slopes up and left.";

	S=S+"\n\nThe plus tiling assigns to the top right vertex an edge that slopes down and left while the minus tiling assigns to the top left vertex an edge that slopes up and left.";

	S=S+"\n\nThe minus tiling assigns to the top right vertex an edge that slopes down and left while the plus tiling assigns to the top left vertex an edge that slopes up and left.";

	S=S+"\n\nThe minus tiling assigns to the top right vertex an edge that slopes down and left while the minus tiling assigns to the top left vertex an edge that slopes up and left.";

	S=S+"\n\nThe arrow keys beneath the slice selector let you cycle between these 4 options. In all cases, we would have overlapping tiles when we normalize as we do in this mode.  Just as in the valence-two demo mode, you can drag the mouse around the slice selector and see that this does not happen.";


	M.E.setExplain(S);
    }


    public void valence_info() {

	String S="valence 2 demo";

S=S+"\n\nThis display mode allows you to verify by hand our claim that all vertices of the arithmetic graph either have valence 0 or valence 2.  Here is the proof.  If some vertex has valence 1, it means that some lattice point from the Master Picture Theorem lands in a tile of color X, with respect to the two tilings, when the minus tiling is shifted as it is in this mode.  This happens iff a tile colored X in the one tiling intersects a tile colored X from the other tiling.  This excludes the grey tiles, which coincide in both tilings.  You can do around, highlighting the same colors in the two 3x3 checkerboards, and see that this does not happen.";

	S=S+"\n\nFor example, on both checkerboards, turn on the bottom left squares.  These activate the red tiles.  Now drag the mouse all over the slice selector.  You will see that the corresponding red tiles never have overlapping interiors.  The tiles do sometimes share endpoints, but this is fine from the point of view of our proof.";

	M.E.setExplain(S);
    }


    public void shift_info() {

	String S="shift selector";

S=S+"\n\nOur polyope partitions give rise to two tilings of an infinite slab in 4 dimensional space.  We call these tilings the plus tiling and the minus tiling.  This is explained in detail in Part II of the monograph.  This window allows you to shift the position of the minus tiling.";


	S=S+"We always draw the plus tiling in exactly its defined location, so that the bottom left corner of the fundamental fiber is (0,0).  However, we draw the fundamental minus fiber so that the bottom left corner is some other value.  The most canonical choice is (1,1), though we give the user several different options, all related to different properties of the partitions.";

	M.E.setExplain(S);
    }



    public void proj_info() {

	String S="projection selector";

S=S+"\n\nThis control panel gives you 3 different modes for drawing the 4D polytopes.  Recall that our coordinates for R4 are (x,y,z,A).";

	S=S+"\n\n0: This mode takes the (z,A) slices of the tiles.  This mode corresponds to our proof of the Embedding Theorem in the monograph.";

	S=S+"\n\n1: This mode slices the tiling by planes containing the vectors (1,0,0,0) and (1,1,1,0).  For the (-) partition, the plane we use contains the origin.  In the (+) case, we translate the (-) plane by the vector (1,1,0,0).  This slice corresponds to our proof Statement 1 of the Hexagrid Theorem in the monograph.";

	S=S+"\n\n2: This mode slices the tiling by the plane x+y=A.  This slice corresponds to our proof of Statement 2 of the Hexagrid Theorem in the monograph";

	M.E.setExplain(S);
    }



    public void display_info() {

	String S="plot controls";

	 S=S+"\n\nThis control panel controls what gets plotted in the Torus Partition Window.  There are 8 options:";

	 S=S+"\n\nplus fiber:  With this option on, Billiard King plots the plus fiber.";

	 S=S+"\n\nminus fiber:  With this option on, Billiard King plots the minus fiber.";

	 S=S+"\n\nplus tiling:  Our partition of the polytope can be extended to fill up an infinite slab in 4-dimensional space by convex integral polytopes.  The slab is R^3 x (0,1).  With this option on, you can draw a the slices of the tiling that correspond to the selected plus fiber.  When you select this option, a 3x3 checkerboard will appear beneath the shape selector.  By left/right clicking on the squares in this checkerboard, you can turn on and off individual pieces of the tiling.  By middle clicking, you change the color of the piece you have selected.";

	 S=S+"\n\nminus tiling: With this option on, you can draw a the slices of the tiling that correspond to the selected minus fiber.   Turning on this option brings up the same kind of checkerboard as in the plus case.";

	 S=S+"\n\nplus frame:  This draws the partition (without the colors) associated to the plus fiber.  Not only do we draw the partition of the fundamental domain, but also the orbit under the lattice.";

	 S=S+"\n\nminus frame: This does the same thing for the minus fiber.";

	 S=S+"\n\nhear: This option causes the Torus Partition Window to hear a click that is made on the arithmetic graph.  When you click on a point on the arithmetic graph, the resulting point is mapped into R3 and moved around according to the lattice attached to our polytope partition.  This feature is used to illustrate the Master Picture Theorem.  To learn more about this, you should select the Master Picture Theorem option on the mode switcher and read the corresponding documentation.";

	 S=S+"\n\ncoords: This option puts a little coordinate axis in the torus window, so you can see where the origin is.  The blue cross extends 1+A in all directions.";

	M.E.setExplain(S);
    }



    public void basic_info() {

	String S="basic mode";
	S=S+"\n\nThis is the basic mode for our controls.  Here you should just drag the mouse over the slice selector and look at the pictures in the Torus Partition Window.  You can also use the buttons on the sides of the slice selector to change the picture.  By dragging the mouse around and looking at the Torus Partition Window, you can get a feel for what our 4-dimensional partition looks like";
	M.E.setExplain(S);
    }


    public void general_info() {

	String S="general purpose mode";

	S=S+"\n\nThis is the general purpose mode for our controls.  Here are the things you can do in this window.";

	S=S+"\n\nSelect a slice from the slice selector.";
	S=S+"\n\nModify the display in the Torus Partition Window by toggling the 8 options in the display control panel.";
	S=S+"\n\nFurther modify the display by clicking on the two sets of 3x3 checkerboards.  A left or right click turns off and on different polytopes in the tiling. A middle click changes the color of the selected polytope.";
	S=S+"\n\nSelect 3 different geometric views of the tiling.  The first view is the one we use most commonly.  The other two views arise in connection with our proof of the Hexagrid Theorem.";
	S=S+"\n\nModify the location of part of the tiling using the shift control panel.";
	S=S+"\n\nYou should read the documentation for each of these functions to learn more details.";
	M.E.setExplain(S);
    }



    public void hex1_info() {
	String S="hexagrid theorem, statement 1 demo";

S=S+"\n\nThis display mode demonstrates the proof we give in the monograph of Statement 1 of the Hexagrid Theorem.  It is not so easy to explain what this mode shows.  We refer the reader to Part III of the monograph.  You operate this mode as you operate the valence-mode and the embedding-mode.  You use the arrow keys to cycle through several pictures and drag the mouse around the slice selector to see the picture for different parameters.";
	M.E.setExplain(S);
    }


    public void hex2_info() {

	String S="hexagrid theorem, statement 2 demo";
	
        S=S+"\n\nThis display mode demonstrates the proof we give in the monograph of Statement 2 of the Hexagrid Theorem.  It is not so easy to explain what this mode shows.  We refer the reader to Part III of the monograph.  You operate this mode as you operate the valence-mode and the embedding-mode. There are two parts to this demonstration.";

	S=S+"\n\nYou use the red arrow keys to cycle through 8 possible pictures.  Each picture shows a colored parallelogram and some projections of tiles from the torus partition.  The parallelograms are the ranges for a certain maps, called Delta+ and Delta- in the monograph.  The main point is that these parallelograms are disjoint from the corresponding tiles.  You can see this by dragging the mouse over the slice selector.";

	S=S+"\n\nThe second part of the demo involves checking that the parallelograms are indeed the ranges of the maps Delta+ and Delta-.  For this part of the demo, you should stop dragging the mouse over the slice selector and graph an odd rational parameter.  You do this by clicking the red button at the top of the screen.  The easiest way to generate a rational is to use the random rational generator on the 'basic mode' of the shape console.  Once you have selected and grabbed your odd/odd rational, you should press the red GO button.  The plot of white points will then appear in the Torus Partition Window.   The thing to see is that the white points are contained in side the displayed parallelogram.";

	S=S+"\n\nThe third part of the demo lets you see the singular set described in Chapter 16.  To see the pictures in this chapter, do the following.";
	S=S+"\n\n1. Set the red arrow key to 0";
	S=S+"\n\n2. Referring to the 3x3 polygon selector on the left, turn on the light green and light blue squares.  These squares are North and West.";
	S=S+"\n\n. 3. Use the blue arrow key to perturb the plane Pi from Chapter 16.  The smaller the number the smaller the perturbation.  Each increase in the number doubles the size of the perturbation.";
	S=S+"\n\n 4. Change the red arrow key number to 1, and repeat the exercise using the right polygon selector.";



	M.E.setExplain(S);
    }


    public void barrier_info() {
	String S="barrier theorem demo";

	S=S+"\n\nThis display mode demonstrates the proof we give in the monograph of the Barrier Theorem.  It is not so easy to explain what this mode shows.  We refer the reader to Part III of the monograph.  This display works somewhat like the display for the hexagrid mode, but is somewhat more involved.  Here is what you should do to operate this mode.";

	S=S+"\n\n1. Set the shape selector to 'advanced'.  Next, choose a reasonable sized rational, say 23/55.  Now, use the grab button on the torus control panel to grab the parameter.";

	S=S+"\n\n2. Referring to the Torus Partition window, try zooming in on the picture to see it close up.";

	S=S+"\n\n3. Back on the torus control window, try clicking the blue arrow keys and watching the picture change.  What is going on is that you are moving the slice that we used in the proof of Statement 1 of the Hexagrid Theorem.  The values of 1 and -1 correspond to the Barrier Theorem, though the other values give you perspective on how the picture changes.  We are moving the slice-plane parallel to itself by constant increments.";

	S=S+"\n\nYou might want to turn on all the tiles in the tiling, in order to get a fuller appreciation for how the blue arrow keys change the picture.  You do this by left/right clicking on the two 3x3 black checkerboards.";

	M.E.setExplain(S);
    }




    public void color_info() {
	String S="color scheme";
	M.E.setExplain(S);
    }


    public void mode_info() {
	String S="mode switch"
;
	S=S+"\n\nThis control panel lets you switch between 7 modes for the controls.  When you click the arrow keys, you see which mode you have currently selected.  If you click the info button just above and to the right of the arrow keys, you can learn about the behavior of the mode you have selected.";

	S=S+"\n\nThe blue box at the top right of the control panel labelled 'on' controls the way the settings are remembered as you cycle through the possible modes.  When the on button is on, any changes you make to the settings are erased when you move to a new setting.  This is a good option to use when you are first beginning, because each mode will then appear to you as it did at first.  When the on button is odd, the changes you make are remembered.  This option is more useful once you gain experience, and want to compare what is happening in one mode with what is happening in another.";

	S=S+"\n\nAs Some of the displayed control buttons will not work with all the modes.  We limit what you can change on some of the demo modes in order to more tightly control the demo.";


	M.E.setExplain(S);
    }


}


