import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ArithmeticGraphOffset {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[7];
    ListenSquare INFO;
    ListenSquare[] PARITY=new ListenSquare[2];
    ListenSquare HEAR;
    int x,y;
    int parity;

    public ArithmeticGraphOffset(int x,int y) {

	 I[0]=new SelectIntegerKeyboard(x+2, y+2 ,35,13,0,9999);  //numerator
	 I[1]=new SelectIntegerKeyboard(x+2 ,y+19,35,13,1,9999);  //denominator

 	 I[2]=new SelectIntegerKeyboard(x+45,y+2, 35,13,0,9999);  //numerator
	 I[3]=new SelectIntegerKeyboard(x+45,y+19,35,13,1,9999);  //denominator

 	 I[4]=new SelectIntegerKeyboard(x+2,y+52,35,13,0,9999);  //numerator
	 I[5]=new SelectIntegerKeyboard(x+2,y+69,35,13,1,9999);  //denominator

	 PARITY[0]=new ListenSquare(x+60,y+47,15,15,Color.white);
	 PARITY[0].on=1;

	 PARITY[1]=new ListenSquare(x+60,y+67,15,15,Color.white);
	 PARITY[1].on=0;
	 parity=0;

	 HEAR=new ListenSquare(x+60,y+97,15,15,Color.white);

	 INFO=new ListenSquare(x+73,y-15,12,12,Color.black);
	 this.x=x;
	 this.y=y;

    }

    public void setZero() {
	I[0].val=0;
	I[1].val=1;
	I[2].val=0;
	I[3].val=1;
    }

    public void render(Graphics2D g) {
	g.setColor(new Color(0,120,160));
	g.fillRect(x,y-15,85,100);
	g.setColor(Color.white);
	g.drawRect(x,y-15,85,100);
        for(int i=0;i<6;++i)
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);

	g.setColor(Color.white);
	g.drawString("(mA)offset(n)",x+4,y-2);
	g.drawString("strip shift",x+4,y+46);
	g.drawLine(x+4,y+17,x+33,y+17);
	g.drawLine(x+48,y+17,x+74,y+17);
	g.drawLine(x+5,y+67,x+34,y+67);
	INFO.infoRender(g);
	PARITY[0].render(g,new Color(200,0,255));
	PARITY[1].render(g,new Color(200,0,255));
    }

    public double getOffset(double A) {
	return(1.0*A*I[0].val/I[1].val+1.0*I[2].val/I[3].val);
    }


    public double getStripShift() {
	return(1.0*I[4].val/I[5].val);
    }


    public void switchParity(Point X) {
	if(PARITY[0].inside(X)==1) {
	    parity=0;
	    PARITY[0].on=1;
	    PARITY[1].on=0;
	}
	if(PARITY[1].inside(X)==1) {
	    parity=1;
	    PARITY[1].on=1;
	    PARITY[0].on=0;
	}
    }



    public int processMouse(Point X,Documentation DOC) {
	for(int i=0;i<6;++i) {
	    I[i].on=0;
	    if(I[i].inside(X)==1) I[i].on=1;
	}
	if(INFO.inside(X)==1) DOC.offset_info();
	switchParity(X);
	return(0);

    }


    public void processKey(KeyEvent e) {
	if(I[0].on==1) I[0].modifySign(e);
	if(I[1].on==1) I[1].modify(e);
	if(I[2].on==1) I[2].modifySign(e);
	if(I[3].on==1) I[3].modify(e);
	if(I[4].on==1) I[4].modify(e);
	if(I[5].on==1) I[5].modify(e);
    }

}





