import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TorusPartitionControl2 {
    Manager M;
    ControlPanel STYLE,DISPLAY,COLOR,WINDOW;
    Documentation DOC;
    ListenSquare GRAB;
    ListenSquare[] INFO=new ListenSquare[10];
    int[] PROJECT=new int[2];
    ListenSquare[] ON=new ListenSquare[3];
    TorusSliceSelector TOR;
    int X,Y;
    SelectInteger SLICE;
    ListenSquare TRANS;

    public TorusPartitionControl2(int X,int Y,Manager MM) {
	this.X=X;
	this.Y=Y;
	this.M=MM;

	setPanels();

	SLICE=new SelectInteger(X+100,Y+220,26,15,0,0,1000,1);  //z slicer

	 //grab the parameter
	 GRAB=new ListenSquare(X-4,Y+188,26,24,Color.white);
	 GRAB.on=1;

	 INFO[0]=new ListenSquare(X-7,Y-7,12,12,Color.white);
	 INFO[1]=new ListenSquare(X+26,Y+256,12,12,Color.white);

	 TOR=new TorusSliceSelector(X+25,Y+12,200);
	 TOR.Z=new Complex(1.0/20.0,1.0/3.0);
	 DOC=new Documentation();

	 PROJECT[0]=0;
	 PROJECT[1]=1;
    }

    public void setPanels() {


	Color[] C0={new Color(0,200,200),Color.white,Color.white,Color.black,Color.red};

	 DOC=new Documentation();

	 //style control  
	 String[] S2={"color","black","colors"};
	 int[] state2={0,1};
	 STYLE=new ControlPanel(C0,S2,state2,2);
	 STYLE.mode=1;

	 //window
	 String[] S1={"none","blue","red","window"};
	 int[] state1={1,0,0};
	 WINDOW=new ControlPanel(C0,S1,state1,3);

	 //display 
	 String[] S4={"+ fiber","-- fiber","display"};
	 int[] state4={1,0};
	 DISPLAY=new ControlPanel(C0,S4,state4,2);


	 String[] ArithGraphColorString={"","","","","","","","","","","","","","","",""};
	 Color[] COL2={new Color(255,220,0),new Color(50,100,255),new Color(0,220,0),new Color(255,0,255),new Color(255,150,0),new Color(0,0,255),new Color(0,180,0),new Color(200,0,200),new Color(220,0,0),new Color(0,150,0),new Color(160,0,160),new Color(170,0,0),new Color(0,100,0),new Color(80,0,80),new Color(80,0,0),new Color(100,0,200),new Color(200,0,100)};
	 int[] ArithGraphColorState={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
         COLOR=new ControlPanel(C0,ArithGraphColorString,ArithGraphColorState,15,COL2);


    }







    public void render(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);

      INFO[0].infoRender(g);
      g.setColor(Color.white);

      GRAB.render(g,new Color(0,200,200));
      DISPLAY.render(g,X+245,Y+260,64);
      STYLE.render(g,X+176,Y+260,64);
      COLOR.render2(g,X+245,Y-3,30);
      WINDOW.render(g,X-4,Y+245,70);

      g.setColor(Color.white);
      g.drawString("grab",X-1,Y+197);
      g.drawString("A",X-1,Y+211);

      SLICE.render(g,Color.red,Color.white,Color.white);

       TOR.render(g);
    }


    public static Color getColor(int v1,int v2,int mode) {
	if(mode==1) return(getColorBlack(v1,v2));
        return(getColorXY(v1,v2));
    }

    public static Color getColorXY(int v1,int v2) {
	      Color COL=Color.black;
              if((v1== 1)&&(v2== 1)) COL=new Color(255,80,0);
              if((v1==-1)&&(v2==-1)) COL=new Color(190,0,0);
              if((v1==-1)&&(v2== 1)) COL=new Color(160,0,140);
              if((v1== 1)&&(v2==-1)) COL=new Color(255,50,255);

	      if((v1== 0)&&(v2== 1)) COL=new Color(0,200,0);
              if((v1== 0)&&(v2==-1)) COL=new Color(0,100,0);
	      if((v1==-1)&&(v2== 0)) COL=new Color(50,100,255);
	      if((v1== 1)&&(v2== 0)) COL=new Color(0,0,220);
              if((v1== 0)&&(v2== 0)) COL=new Color(140,140,140);
	      return(COL);
    }




    public static Color getColorBlack(int v1,int v2) {
	if((v1+v2)%2==0) return(new Color(20,20,20));
	return(Color.black);
    }


 public void hearGraph(double A,double t) {
	TOR.Z.y=M.C.SES.getParameter();
	double s=t/2;
        TOR.Z.x=s-Math.floor(s);
	TOR.setFinal();
 }




    public void grabShape() {
	TOR.Z.y=M.C.SES.getParameter();
	int q=M.C.SES.getDenominator();;
	SLICE.max=q-1;
	SLICE.val=(q-1)/2;
	TOR.Z.x=0.5*(2*SLICE.val+1)/q;
	TOR.setFinal();
    }



    public void sliceShape() {
	int q=M.C.SES.getDenominator();
	SLICE.max=q-1;
	TOR.Z.x=0.5*(2*SLICE.val+1)/q;
	TOR.setFinal();
    }




       public void mouseProcess(Point X,Manager M) {
	   DOC.M=M;

           int style=STYLE.switchMode(X);  
           if(style==20) DOC.polytope_color_info();

	   int display= DISPLAY.switchMode(X);
           if(display==20) DOC.polytope_display_info();

	   COLOR.recolor(X,M.C.CS.C);
           WINDOW.switchMode(X);

	   if(INFO[0].inside(X)==1) DOC.polytope_info();
	   if(INFO[1].inside(X)==1) DOC.polytope_tiling_info();

           int tor=TOR.process(X);
	   if(GRAB.inside(X)==1) grabShape();

	   SLICE.modify(X);
	   if(SLICE.isModified(X)==1) sliceShape();

       }

}


