#! /usr/local/bin/wish  -f



canvas .plot -width 600 -height 600 -bg white
pack .plot
canvas .post -width 600 -height 20 -bg red
pack .post

bind .post <Any-Button> post

set a1 -2000.0
set phi [expr (1 + sqrt(5))/2]
set a2 [expr -2000.0/($phi*$phi*$phi)-1/(2*$phi*$phi)]

set b1 2000.0
set b2 [expr 2000.0/($phi*$phi*$phi)-1/(2*$phi*$phi)]

set a3 [expr $a1+2000]
set b3 [expr $b1+2000]


.plot create rectangle 0 0 600 600 -fill white
source graph
source graph2
.plot raise X
.plot create line 0 -2 0 2 -fill black  -tag X
.plot create line -2 0 2 0 -fill black  -tag X

.plot itemconfigure X -fill black
.plot scale X 0 0 2 -2
.plot move X 300 500

.plot itemconfigure Y -fill #aaa
.plot scale Y 0 0 2 -2
.plot move Y 300 500





proc post {} {
.plot postscript -pageheight 300 \
-height 600 -width 600 \
-file "temp.ps"
}

######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
.plot scale Y $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
.plot scale Y $ACOORD $BCOORD $sc $sc
}
######################################
