import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PinwheelMap {
    double[][] h=new double[5][3];
    Complex[] v=new Complex[10];
    double A;

    public PinwheelMap(double AA) {
	this.A=AA;

	v[1]=new Complex(0,4);
	v[2]=new Complex(-2,2);
	v[3]=new Complex(-2-2*A,0);
	v[0]=new Complex(-2,-2);

	h[1][0]=-1;
	h[1][1]=+1;
	h[1][2]=+3;

	h[2][0]=  -2/(1+A);
	h[2][1]= 2*A/(1+A);
	h[2][2]= 2*A/(1+A);

	h[3][0]=  -2/(1+A);
	h[3][1]=-2*A/(1+A);
	h[3][2]= 2*A/(1+A);

	h[0][0]=-1;
	h[0][1]=-1;
	h[0][2]=+3;

	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		h[i][j]=.25*h[i][j];
	    }
	}
    }


    /**This is the basics of the pinwheel map*/

    public double evaluate(int j,Complex z) {
	Complex V=new Complex(v[j]);
	double d=h[j][0]*z.x+h[j][1]*z.y+h[j][2];
	return(d);
    }

    public int getDepth(int j,Complex z) {
	double d=evaluate(j,z);
	int n=-(int)(Math.floor(d));
	return(n);
    }

    public double getStripPosition(int j,Complex z) {
	double d=evaluate(j,z);
	return(d-Math.floor(d));
    }

    public Complex doMap(int j,Complex z) {
	int d=getDepth(j,z);
	Complex V=new Complex(d*v[j].x,d*v[j].y);
	Complex w=Complex.plus(V,z);
	return(w);
    }

    public Complex doReturn(Complex zz) {
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
	    z=doMap(j%4,z);
	}
	int test=(int)(101-z.y);
	if(test%4==0) return(new Complex(z.x,1));
	if(test%4==2) return(new Complex(z.x,-1));
	return(new Complex(0,0));
    }







    /**This computes all the integer parts of the basic octagon*/

    public int[] mapSpectrum(Complex zz) {
	int[] n=new int[10];
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
	    n[j]=getDepth(j%4,z);
	    z=doMap(j%4,z);
	}
	return(n);
    }

    public double[] positionSpectrum(Complex zz) {
	double[] n=new double[10];
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
            z=doMap(j%4,z);
	    n[j]=getStripPosition(j%4,z);
	}
	return(n);
    }

    public int[] doReturnIntegral(Complex zz) {
	int[] n=mapSpectrum(zz);
	int[] s=new int[3];
	s[0]=-n[7]-n[3];
	s[1]=-n[2]-n[3]-n[4]-n[6]-n[7]-n[8];
        int parity=(s[0]+s[1]+4)%2;
	s[2]=(int)(zz.y);
	s[2]=1;
	if(zz.y<0) s[2]=-1;
	if(parity==1) s[2]=-s[2];
	return(s);
    }



    public int findSector(Complex z) {
	double d1=evaluate(1,z);
	double d2=evaluate(2,z);
	double d3=evaluate(3,z);
	double d4=evaluate(0,z);
	if((d4<1)&&(d1<0)) return(1);
	if((d2<0)&&(d1>0)) return(2);
	if((d2>0)&&(d3<0)) return(3);
	if((d4<0)&&(d3>0)) return(4);
	if((d4>0)&&(d1>1)) return(5);
	if((d2>1)&&(d1<1)) return(6);
	if((d2<1)&&(d3>1)) return(7);
	if((d4>1)&&(d3<1)) return(8);
	return(0);
    }


    public int numberStrip(Complex z) {
	double d1=evaluate(1,z);
	double d2=evaluate(2,z);
	double d3=evaluate(3,z);
	double d4=evaluate(0,z);
	int test=0;
	if((d1>0)&&(d1<1)) ++test;
	if((d2>0)&&(d2<1)) ++test;
	if((d3>0)&&(d3<1)) ++test;
	if((d4>0)&&(d4<1)) ++test;
	if(test>1) return(1);
	return(0);
    }





    public Complex[] makeLine0(double d,Complex z) {
	Complex[] w=new Complex[2];
	w[0]=new Complex(z.x+d*v[0].x,z.y+d*v[0].y);
	w[1]=Complex.plus(w[0],new Complex(1,-1));
	return(w);
    }

    public Complex[] makeLine1(double d,Complex z) {
	Complex[] w=new Complex[2];
	w[0]=new Complex(z.x+d*v[1].x,z.y+d*v[1].y);
	w[1]=Complex.plus(w[0],new Complex(1,1));
	return(w);
    }

    public Complex[] makeLine2(double d,Complex z) {
	Complex[] w=new Complex[2];
	w[0]=new Complex(z.x+d*v[2].x,z.y+d*v[2].y);
	w[1]=Complex.plus(w[0],new Complex(A,1));
	return(w);
    }

    public Complex[] makeLine3(double d,Complex z) {
	Complex[] w=new Complex[2];
	w[0]=new Complex(z.x+d*v[3].x,z.y+d*v[3].y);
	w[1]=Complex.plus(w[0],new Complex(A,-1));
	return(w);
    }


    public Complex getVertex(Complex[] z1,Complex[] z2) {
	Vector V1=new Vector(z1[0]);
	Vector V2=new Vector(z1[1]);
	Vector V3=new Vector(z2[0]);
	Vector V4=new Vector(z2[1]);
	Vector V5=V1.cross(V1,V2);
	Vector V6=V1.cross(V3,V4);
	Vector V7=V1.cross(V5,V6);
	Complex z=V7.toComplex();
	return(z);
    }


    public PolyWedge rhomb1(double d1,double d2,double d3,double d4,Complex z) {
	Complex[] w1=makeLine1(d1,z);
	Complex[] w2=makeLine0(d2,z);
	Complex[] w3=makeLine1(d3,z);
	Complex[] w4=makeLine0(d4,z);
	PolyWedge P=new PolyWedge();
	P.count=4;
	P.z[0]=getVertex(w1,w2);
	P.z[1]=getVertex(w2,w3);
	P.z[2]=getVertex(w3,w4);
	P.z[3]=getVertex(w4,w1);
	return(P);
    }


    public PolyWedge rhomb2(double d1,double d2,double d3,double d4,Complex z) {
	Complex[] w1=makeLine2(d1,z);
	Complex[] w2=makeLine3(d2,z);
	Complex[] w3=makeLine2(d3,z);
	Complex[] w4=makeLine3(d4,z);
	PolyWedge P=new PolyWedge();
	P.count=4;
	P.z[0]=getVertex(w1,w2);
	P.z[1]=getVertex(w2,w3);
	P.z[2]=getVertex(w3,w4);
	P.z[3]=getVertex(w4,w1);
	return(P);
    }



    public  PolyWedge nextPoly(PolyWedge P) {
	Complex w=P.getCenter();
	int sector = findSector(w);
	Complex z=v[sector];
	PolyWedge PP=new PolyWedge();
	PP.count=P.count;

	for(int i=0;i<P.count;++i) {
	    Complex Z=new Complex(P.z[i]);
	    Z=Complex.plus(Z,z);
	    PP.z[i]=new Complex(Z);
	}
	return(PP);
    }






    /*the inverse maps*/


    public Complex doMapInverse0(Complex z) {
	int d=getDepth(3,z);
	Complex V=new Complex(d*v[0].x,d*v[0].y);
	Complex w=Complex.plus(z,V);
	return(w);
    }


    public Complex doMapInverse1(Complex z) {
	int d=getDepth(0,z);
	Complex V=new Complex(d*v[1].x,d*v[1].y);
	Complex w=Complex.minus(z,V);
	return(w);
    }


    public Complex doMapInverse2(Complex z) {
	int d=getDepth(1,z);
	Complex V=new Complex(d*v[2].x,d*v[2].y);
	Complex w=Complex.plus(z,V);
	return(w);
    }

    public Complex doMapInverse3(Complex z) {
	int d=getDepth(2,z);
	Complex V=new Complex(d*v[3].x,d*v[3].y);
	Complex w=Complex.plus(z,V);
	return(w);
    }


    public Complex doMapInverse4(Complex z) {
	int d=getDepth(3,z);
	Complex V=new Complex(d*v[0].x,d*v[0].y);
	Complex w=Complex.plus(z,V);
	return(w);
    }

    public Complex doMapInverse(int j,Complex z) {
	int jj=j%4;
	Complex w=new Complex();
	if(jj==0) w=doMapInverse0(z);
	if(jj==1) w=doMapInverse1(z);
	if(jj==2) w=doMapInverse2(z);
	if(jj==3) w=doMapInverse3(z);
	return(w);
    }





}

