import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntryQuadratic {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[15];
    SelectInteger APPROX;
    ListenSquare SAVE;
    int x,y;	
    ListenSquare[] L=new ListenSquare[3];


    public ShapeEntryQuadratic(int x,int y) {

	 I[0]=new SelectIntegerKeyboard(x+3,y+73,   75,13,0,99999999);  //xcoord numerator
	 I[1]=new SelectIntegerKeyboard(x+3,y+93,75,13,1,99999999);  //xcoord denominator
 	 I[2]=new SelectIntegerKeyboard(x+92,y+73,27,13,1,999);  //xcoord numerator
	 I[3]=new SelectIntegerKeyboard(x+92,y+93,27,13,1,999);  //xcoord denominator
	 I[4]=new SelectIntegerKeyboard(x+130,y+83,27,13,5,999);  //radical
	 this.x=x;
	 this.y=y;

	 I[10]=new SelectIntegerKeyboard(x+3,y+3,   48,13,1,9999999);  //x rational numerator
	 I[11]=new SelectIntegerKeyboard(x+3,y+21,48,13,3,9999999);  //y rational denominator

	 APPROX=new SelectInteger(x+65,y+5,36,18,0,1,10,1);
	 SAVE=new ListenSquare(x+156,y+19,14,14,Color.white);
	 SAVE.on=0;

	 L[0]=new ListenSquare(x+3,y+47,45,17,Color.white);
	 L[0].on=0;
	 L[1]=new ListenSquare(x+53,y+47,45,17,Color.white);
	 L[1].on=0;
	 L[2]=new ListenSquare(x+103,y+47,45,17,Color.white);
	 L[2].on=1;
    }


    public void render(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,10));
	  g.setColor(new Color(160,0,160));  
	  g.fillRect(x,y+70,175,38);
	  g.setColor(Color.white);
	  g.drawRect(x,y+70,175,38);
          for(int i=0;i<=4;++i)
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
          g.setFont(new Font("Helvetica",Font.PLAIN,10));
	  g.setColor(Color.white);
	  g.drawLine(x,y+89,x+74,y+89);  
          g.drawLine(x+98,y+89,x+118,y+89);
	  g.translate(-3,2);
	  g.drawLine(x+130,y+78,x+150,y+78);
	  g.drawLine(x+130,y+78,x+128,y+92);
	  g.drawLine(x+128,y+92,x+125,y+83); 
          g.translate(3,-2);
	  g.drawString("+",x+84,y+91);
	  drawFractionsBasic(g);
	  APPROX.render(g,new Color(200,0,200),Color.white,Color.white);
	  SAVE.on=1;
	  SAVE.render(g,new Color(200,0,200));
	  g.setColor(Color.white);
	  g.drawString("send",x+124,y+30);

	  for(int i=0;i<3;++i)
	      L[i].render(g,new Color(200,0,200));
	  g.drawString("odd",(int)(L[0].x+5),(int)(L[0].y+13));
	  g.drawString("even",(int)(L[1].x+5),(int)(L[1].y+13));
	  g.drawString("both",(int)(L[2].x+5),(int)(L[2].y+13));
    }


	public void drawFractionsBasic(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,10));

	  //main entry
	  g.setColor(new Color(160,0,160));  
	  g.fillRect(x,y,55,37);
	  g.setColor(Color.white);
	  g.drawRect(x,y,55,37);

          for(int i=10;i<=11;++i) {
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
	  }

	}


    public void getApprox() {

	double t=getQuadratic();
	double tol=Math.pow(.1,APPROX.val);

	int[] a=MathRational.approximate(t,tol);

	int a0=a[0];
	int a1=a[1];

	int test=(a[0]*a[1])%2;

	if((test==0)&&(L[0].on==1)) {  
	    int[] b=MathRational.oppositeType(a0,a1);
	    a0=b[0];
	    a1=b[1];
	}

	if((test==1)&&(L[1].on==1)) {
	    int[] b=MathRational.oppositeType(a0,a1);
	    a0=b[0];
	    a1=b[1];
	}



	I[10].val=a0;
	I[11].val=a1;




    }





    public void processMouse(MouseEvent e) {
	MouseData J=MouseData.process(e);
	APPROX.modify(J.X);
	  for(int i=0;i<=4;++i) {
	    I[i].on=0;
	    if(I[i].inside(J.X)==1) I[i].on=1;
	  }
	  getApprox();
	  setApproxType(J.X);
    }



    public void processKey(KeyEvent e) {
	if(I[0].on==1) I[0].modifySign(e);
	if(I[1].on==1) I[1].modifySign(e);
	if(I[2].on==1) I[2].modifySign(e);
	if(I[3].on==1) I[3].modify(e);
	if(I[4].on==1) I[4].modify(e);
	if(Math.abs(I[2].val)>999) I[2].val=0;
    }


    public double getParameter() {
	double t=1.0*I[10].val/I[11].val;
	return(t);
    }


    public double getQuadratic() {
	if(I[1].val==0) return(1.0/3.0);
	if(I[3].val==0) return(1.0/3.0);
	double r1=1.0*I[0].val/I[1].val;
	double r2=1.0*I[2].val/I[3].val;
	double x=r1+r2*Math.sqrt(I[4].val);
	x=x-Math.floor(x);
	if(x==0)  return(1.0/3.0);
	return(x);
    }

    public void setApproxType(Point X) {
	int test=-1;
	for(int i=0;i<3;++i) {
	    if(L[i].inside(X)==1) test=i;
	}
	if(test!=-1) {
	    for(int i=0;i<3;++i) L[i].on=0;
	    L[test].on=1;
	}




    }


}





