import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntryRational {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[2];
    SelectIntegerKeyboard[] J=new SelectIntegerKeyboard[2];
    SelectIntegerKeyboard[] K=new SelectIntegerKeyboard[3];
    SelectIntegerKeyboard[] MEM=new SelectIntegerKeyboard[2];
    SelectInteger KK;
    ListenSquare SWAP;
    ListenSquare REDUCE,RANDOM;
    ListenSquare[] GRAB=new ListenSquare[2];
    ListenSquare[] SEND=new ListenSquare[2];
    ListenSquare[] INFO=new ListenSquare[10];
    ListenSquare[] ODD=new ListenSquare[5];
    SelectInteger INFOSELECT;
    int X,Y;



    public ShapeEntryRational(int x,int y) {
	 X=x;
	 Y=y;
	 I[0]=new SelectIntegerKeyboard(x+3,y+3,   48,13,1,9999999);  //xcoord numerator
	 I[1]=new SelectIntegerKeyboard(x+3,y+21,48,13,3,9999999);  //ycoord denominator

	 J[0]=new SelectIntegerKeyboard(x+123,y+3,   48,13,1,9999999);  //xcoord memory
	 J[1]=new SelectIntegerKeyboard(x+123,y+21,48,13,5,9999999);  //ycoord memory

	 K[0]=new SelectIntegerKeyboard(x,y+102, 30,12,1,999);  //modular x
	 K[1]=new SelectIntegerKeyboard(x,y+114, 30,13,2,999);  //modular n
	 KK=new SelectInteger(x+33,y+106,34,17,0,0,100,1); //modular n	  
         ODD[4]=new ListenSquare(x,y+102,100,25,Color.white);  //modular limit

	 MEM[0]=new SelectIntegerKeyboard(x+123,y+104,   48,13,1,9999999);  //xcoord memory
	 MEM[1]=new SelectIntegerKeyboard(x+123,y+122,48,13,5,9999999);  //ycoord memory
	 GRAB[0]=new ListenSquare(x+120,y+136,27,15,Color.white);
	 SEND[0]=new ListenSquare(x+147,y+136,28,15,Color.white);
	 GRAB[0].on=1;
	 SEND[0].on=1;

	 SWAP=new ListenSquare(x+37,y+133,30,15,Color.white);
	 SWAP.on=1;
	 REDUCE=new ListenSquare(x+63,y,50,15,Color.white);
	 REDUCE.on=1;
	 RANDOM=new ListenSquare(x+63,y+22,50,15,Color.white);
	 RANDOM.on=1;
	
	 INFO[1]=new ListenSquare(x,y+169,12,12,Color.white);
	 ODD[0]=new ListenSquare(x,    y+40,55,28,Color.white);
	 ODD[1]=new ListenSquare(x, y+70,55,28,Color.white);
	 ODD[2]=new ListenSquare(x+120,y+40,55,28,Color.white);
	 ODD[3]=new ListenSquare(x+120,y+70,55,28,Color.white);
	 for(int i=0;i<5;++i) ODD[i].on=1;

	 INFOSELECT=new SelectInteger(x+20,y+161,34,17,0,0,8,1);
    }

    public double getParameter() {
	double t=1.0/3.0;
	if(I[1].val>0) {
	  t=1.0*I[0].val/I[1].val;
	}
	return(t-Math.floor(t));
    }

    public double getMemoryParameter() {
	double t=1.0*J[0].val/J[1].val;
	return(t-Math.floor(t));

    }



    public void render(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	int test=1;
	if(I[0].val<=0) test=0;
	if(I[1].val<=0) test=0;
	if(I[0].val>=I[1].val) test=0;

        drawFractions(g);  
        drawButtons(g);
        if(test==1) drawCompare(g);
	INFOSELECT.render(g,new Color(255,100,255),Color.white,new Color(0,0,0,0));
	infoRender(g);

    }


    public void drawButtons(Graphics2D g) {
	  SWAP.render(g,new Color(150,0,150));
	  REDUCE.render(g,new Color(150,0,150));
	  RANDOM.render(g,new Color(150,0,150));
	
	  g.drawString("reduce",X+70,Y+11);
	  g.drawString("random",X+70,Y+33);
	  for(int i=0;i<4;++i) ODD[i].render(g,new Color(160,0,80));
	  INFO[1].infoRender(g);
	  GRAB[0].render(g,new Color(120,0,180));
	  SEND[0].render(g,new Color(120,0,180));
          g.drawString("swap",X+40,Y+144);
	  g.drawString("grab",X+124,Y+147);
	  g.drawString("send",X+150,Y+147);

    }



	public void drawFractions(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,10));

	  //main entry
	  g.setColor(new Color(210,60,160));  
	  g.fillRect(X,Y,55,37);
	  g.setColor(Color.white);
	  g.drawRect(X,Y,55,37);

	  //swapping rational
	  g.setColor(new Color(160,0,160));  
	  g.fillRect(X+120,Y,55,37);
	  g.setColor(Color.white);
	  g.drawRect(X+120,Y,55,37);

	  //memory rational
	  g.setColor(new Color(100,0,160));  
	  g.fillRect(X+120,Y+103,55,38);
	  g.setColor(Color.white);
	  g.drawRect(X+120,Y+103,55,38);


          for(int i=0;i<=1;++i) {
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
	    J[i].render(g,new Color(200,0,200),Color.blue,Color.yellow,Color.black);
	    MEM[i].render(g,new Color(150,0,200),Color.blue,Color.yellow,Color.black);
	  }

	  //modular limit console
          ODD[4].render(g,new Color(200,80,0));
          for(int i=0;i<=1;++i) {
	      K[i].render(g,new Color(200,80,0),Color.white,Color.yellow,Color.white);
	  }
	  KK.render(g,new Color(150,40,0),Color.white,Color.white);
	}






    public int getDiophantine(int pp,int qq,int mpp,int mqq) {
	double r1=1.0*pp/qq;
	double r2=1.0*mpp/mqq;
	    double t=qq*qq*Math.abs(r1-r2);   
	    t=1.0/t;
	    int kappa=(int)(Math.floor(2*t));
	    return(kappa);
    }


	  public void drawCompare(Graphics2D g) {

	    //which one is bigger
	    double r1=1.0*I[0].val/I[1].val;
	    double r2=1.0*J[0].val/J[1].val; 
            g.setFont(new Font("Helvetica",Font.PLAIN,14));
	    if(r1==r2) g.drawString("=",X+82,Y+60);
	    if(r1<r2) g.drawString("<",X+82,Y+60);
	    if(r1>r2) g.drawString(">",X+82,Y+60);

	    //farey split
            g.setFont(new Font("Helvetica",Font.PLAIN,11));
	    if(good()==1) {
              int p=I[0].val;
	      int q=I[1].val;

	      int[] a=MathRational.RMINUS(p,q);
	      Integer a0=new Integer(a[0]);
	      Integer a1=new Integer(a[1]);
	      g.drawLine(X+5,Y+54,X+48,Y+54);  
              g.drawString(a0.toString(),X+5,Y+52);
	      g.drawString(a1.toString(),X+5,Y+66);

	      int[] b=MathRational.RPLUS(p,q);
	      a0=new Integer(b[0]);
	      a1=new Integer(b[1]);
	      g.drawLine(X+5,Y+84,X+48,Y+84);
              g.drawString(a0.toString(),X+5,Y+82);
	      g.drawString(a1.toString(),X+5,Y+96);


             if((p+q)%2==0) {

               //inferior predecessor
	      int[] c=MathRational.inferiorPredecessor(p,q);
              a0=new Integer(c[0]);
	      a1=new Integer(c[1]);
	      g.drawLine(X+123,Y+54,X+166,Y+54);
              g.drawString(a0.toString(),X+125,Y+52);
	      g.drawString(a1.toString(),X+125,Y+66);


	       //superior predecessor
	      if((p+q)%2==0) {
	         int[] d=MathRational.superiorPredecessor(p,q);
                a0=new Integer(d[0]);
	        a1=new Integer(d[1]);
	        g.drawLine(X+123,Y+85,X+171,Y+85);
                g.drawString(a0.toString(),X+125,Y+83);
	        g.drawString(a1.toString(),X+125,Y+97);
	      }
	     }

	    }


	  }


    public double good() {
	if(I[0].val==0) return(0);
	if(I[1].val==0) return(0);
	if(I[0].val>=I[1].val) return(0);
	int s=MathRational.GCD(I[0].val,I[1].val);
	if(s!=1) return(0);
	return(1);
    }



    public void getRandom() {
	double d1=Math.random();
	double d2=Math.random();
	d2=d2*400;
	d1=d1*d2;

	int p=(int)(d1);
	int q=(int)(d2);
	if(p<=0) {p=1;q=2;}
	if(p==q) p=q-1;
	I[0].val=p;
	I[1].val=q;
	reduce();
    }


    public String cleanDouble(double t) {
	Double T=new Double(t);
        String v1=T.toString();
	if(Math.abs(t)<.0000000001) v1="0";
	try {
	    v1=v1.substring(0,8);
	}
	catch(Exception e) {} 
	return(v1);
    }




    public void swap() {
      int p=I[0].val;
      int q=I[1].val;
      I[0].val=J[0].val;
      I[1].val=J[1].val;
      J[0].val=p;
      J[1].val=q;
    }

    public void reduce() {
	if(I[0].val*I[1].val>0) {
           int s=MathRational.GCD(I[0].val,I[1].val);
           I[0].val=I[0].val/s;
           I[1].val=I[1].val/s;
	}
    }


    public void generateNew(int test) {

	if(good()==1) {
	  int[] z={I[0].val,I[1].val};
       
	  int[] a1=MathRational.RPLUS(z[0],z[1]);
	  int[] b1=MathRational.RMINUS(z[0],z[1]);
	  int[] c=MathRational.superiorPredecessor(z[0],z[1]);

	if(test==0) {
	    J[0].val=b1[0];
	    J[1].val=b1[1];
	}


	if(test==1) {
	    J[0].val=a1[0];
	    J[1].val=a1[1];
	}

	if(test==2) {
	    J[0].val=a1[0]-b1[0];
	    J[1].val=a1[1]-b1[1];
	    if(J[0].val<0) J[0].val=-J[0].val;
	    if(J[1].val<0) J[1].val=-J[1].val;
	}

	if(test==3) {
            J[0].val=c[0];
	    J[1].val=c[1];
	}
	}


    }


    public int computeSign() {	
        double d1=1.0*I[0].val/I[1].val;
	double d2=1.0*J[0].val/J[1].val;
	if(I[0].val<J[0].val) {
	  if(d1<d2) return(0);
	  return(1);
	}
	  if(d1<d2) return(1);
	  return(0);
    }


    public double computeDiophantine() {

        double d1=1.0*I[0].val/I[1].val;
	double d2=1.0*J[0].val/J[1].val;
	double d3=Math.abs(d1-d2)*I[1].val*I[1].val;
	double d4=Math.abs(d1-d2)*J[1].val*J[1].val;
	d3=Math.min(d3,d4);
	return(1.0/d3);
    }


    public void infoRender(Graphics2D g) {
	String S="";
	int val=INFOSELECT.val;
	if(val==0) S="main parameter (A)";
	if(val==1) S="parameter A-";
	if(val==2) S="parameter A+";
	if(val==3) S="modular generator";
	if(val==4) S="memory parameter";
	if(val==5) S="superior predecessor";
	if(val==6) S="inferior predecessor";
	if(val==7) S="swap parameter";

        g.setStroke(new BasicStroke((float)(3)));
	g.setColor(new Color(255,100,255));
	if(val==0) g.drawLine(X+60,Y+40,X+87,Y+70);
	if(val==1) g.drawLine(X+60,Y+55,X+87,Y+70);
	if(val==2) g.drawLine(X+60,Y+85,X+87,Y+70);
	if(val==3) g.drawLine(X+80,Y+95,X+87,Y+70);
	if(val==4) g.drawLine(X+110,Y+95,X+87,Y+70);
	if(val==5) g.drawLine(X+113,Y+85,X+87,Y+70);
	if(val==6) g.drawLine(X+113,Y+55,X+87,Y+70);
	if(val==7) g.drawLine(X+113,Y+40,X+87,Y+70);
        g.setStroke(new BasicStroke((float)(1)));
	g.fillOval(X+84,Y+67,6,6);


	g.setColor(Color.white);
	g.drawString(S,X+65,Y+173);
    }





    public void sendModular() {
	int a=I[0].val;
	int b=I[1].val;
	int p=K[0].val;
	int q=K[1].val;
	int dio=KK.val;
	int n=-dio-2;
	int test=0;
	double test2=0;
	int[] u={a,b};
	while((n<dio+2)&&(test==0)) {
	   u=MathRational.computeModular(a,b,p,q,n);
	   if(u[0]<0) u[0]=-u[0];
	   if(u[1]<0) u[1]=-u[1];
	   test2=(1.0*a/b)-(1.0*u[0]/u[1]);
	   test2=1.0/test2;
	   test2=2*test2/(b*b);
	   test2=Math.abs(test2);
	   test2=Math.floor(test2);
	   if(test2==dio) test=1;
	   ++n;
	}

	J[0].val=u[0];
	J[1].val=u[1];
    }



    public void doMemory(Point X) {
	if(SEND[0].inside(X)==1) {
	    I[0].val=MEM[0].val;
	    I[1].val=MEM[1].val;
	}
	if(GRAB[0].inside(X)==1) {
	    MEM[0].val=I[0].val;
	    MEM[1].val=I[1].val;
	}
    }


  public int processMouse(MouseEvent e) {
	MouseData J=MouseData.process(e);

       for(int i=0;i<=1;++i) {
	  I[i].on=0;
	  if(I[i].inside(J.X)==1) I[i].on=1;
       }
       if(REDUCE.inside(J.X)==1) reduce();
       if(RANDOM.inside(J.X)==1) getRandom();

       doMemory(J.X);

       for(int i=0;i<=1;++i) {
	  K[i].on=0;
	  if(K[i].inside(J.X)==1) K[i].on=1;
       }
       KK.modify(J.X);
       if(KK.isModified(J.X)==1) sendModular();
       if(ODD[4].inside(J.X)==1) sendModular();

       if(SWAP.inside(J.X)==1) swap();

       int test=-1;
       for(int i=0;i<4;++i) {
	   if(ODD[i].inside(J.X)==1) test=i;
       }
       if(test!=-1) generateNew(test);
       if(INFO[1].inside(J.X)==1) {
           return(101);
       }

       INFOSELECT.modifyCyclic(J.X);
       return(0);
  }







    public void processKey(KeyEvent e) {
	if(I[0].on==1) I[0].modifySign(e);
	if(I[1].on==1) I[1].modifySign(e);
	if(K[0].on==1) K[0].modifySign(e);
	if(K[1].on==1) K[1].modifySign(e);
    }


}




