import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntrySystem {
    int X,Y;
    ControlPanel SHAPE;
    ShapeEntryRational SER;
    ShapeEntryQuadratic SEQ;
    ShapeEntryBasic SEB;
    Documentation DOC;
    double A;

    public ShapeEntrySystem(int x,int y) {
	X=x;
	Y=y;
	A=1.0/3.0;

	//control panel
        Color[] C0={new Color(220,0,220),Color.white,Color.white,Color.black,Color.blue};
	String[] ShapeString={"basic","quadratic","monograph","shape mode"};
	int[] ShapeState={1,0,0,0};
        SHAPE=new ControlPanel(C0,ShapeString,ShapeState,3);
	SHAPE.mode=0;
	DOC=new Documentation();
	SER=new ShapeEntryRational(x,y+85);
	SEQ=new ShapeEntryQuadratic(x,y+85);
	SEB=new ShapeEntryBasic(x,y+85);
    }


    public void render(Graphics2D g) {
	int h=266;
	if(SHAPE.mode==0) h=122;
	if(SHAPE.mode==1) h=170;
	if(SHAPE.mode==2) h=266;
	g.setColor(new Color(50,0,50));
	g.fillRect(X,Y,175,h);
	g.setColor(Color.white);
	g.drawRect(X,Y,175,h);
	SHAPE.render(g,X,Y,90);
	if(SHAPE.mode==0) SEB.render(g);
	if(SHAPE.mode==1) SEQ.render(g);
	if(SHAPE.mode==2) SER.render(g);
	drawShape(g);
    }

    public double getParameter() {
	double t=1.0/3.0;
	if(SHAPE.mode==2) t=SER.getParameter();
	if(SHAPE.mode==1) t=SEQ.getParameter();
	if(SHAPE.mode==0) t=SEB.getParameter();
	return(t);
    }


    public void drawShape(Graphics2D g) {
	float r=(float)(0.5);
	if(r>1) r=1;
	if(SHAPE.mode==2) r=(float)(SER.getParameter());
	if(SHAPE.mode==1) r=(float)(SEQ.getParameter());
	if(SHAPE.mode==0) r=(float)(SEB.getParameter());
	GeneralPath gp=new GeneralPath();
	AffineTransform AT1=AffineTransform.getScaleInstance(60,60);
	AffineTransform AT2=AffineTransform.getTranslateInstance(X+88,Y+330);


	gp.moveTo(-1,0);
	gp.lineTo(0,1);
	gp.lineTo(1,0);
	gp.lineTo(0,-1);
	gp.closePath();
	gp.transform(AT1);
	gp.transform(AT2);
	g.setColor(new Color(30,0,30));
	g.fill(gp);	
        g.setColor(new Color(150,0,150));
	g.draw(gp);

	gp.reset();
	gp.moveTo(-1,0);
	gp.lineTo(0,1);
	gp.lineTo(r,0);
	gp.lineTo(0,-1);
	gp.closePath();
	g.setColor(Color.blue);
	gp.transform(AT1);
	gp.transform(AT2);
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }


    public void doSend1() {
	SEB.I[0].val=SEQ.I[10].val;
	SEB.I[1].val=SEQ.I[11].val;
	SER.I[0].val=SEQ.I[10].val;
	SER.I[1].val=SEQ.I[11].val;
    }


    public int process(MouseEvent e) {
	MouseData J=MouseData.process(e,1);
	Point P=J.X;
	int shape=SHAPE.switchMode(P);
	if(shape==20) return(shape);
	int info=0;
	if(SHAPE.mode==2) shape=SER.processMouse(e);   //important: set shape var here
	if(SHAPE.mode==1) SEQ.processMouse(e);
	if(SHAPE.mode==0) SEB.processMouse(e);

	if(SHAPE.mode==1) {
	    if(SEQ.SAVE.inside(P)==1) doSend1();
	}

	if(shape==101) return(shape);
	return(0);
    }

    public void processKey(KeyEvent e) {
	if(SHAPE.mode==2) SER.processKey(e);
	if(SHAPE.mode==1) SEQ.processKey(e);
	if(SHAPE.mode==0) SEB.processKey(e);
    }


    public int getNumerator() {
	int p=1;
	if(SHAPE.mode==2) p=SER.I[0].val;
	if(SHAPE.mode==1) p=SEQ.I[10].val;
	if(SHAPE.mode==0) p=SEB.I[0].val;
	return(p);
    }



    public int getDenominator() {
	int q=3;
	if(SHAPE.mode==2) q=SER.I[1].val;
	if(SHAPE.mode==1) q=SEQ.I[11].val;
	if(SHAPE.mode==0) q=SEB.I[1].val;
	return(q);
    }







}





