import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;






public class TilingCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener, Runnable {
    Manager M;
    GeneralPath[] G=new GeneralPath[3];
    ComputeTile TC;
    String[] STAT=new String[5];
    Documentation DOC;

    Complex SOURCE=new Complex(0,0);
    Color[] TILECOLOR=new Color[200000];
    PolyWedge[] TILE=new PolyWedge[200000];
    int[] ORBITINDEX=new int[200000];   
    int[] ORBITPOSITION=new int[200000];
    ListenSquare STATS;

    int orbit=0;
    int tile=0;
    int count=1;
    int halt=0;
    int block=0; 
    Point JX;

    PolyWedge QUAD,WEDGE;
    PolyVector VECTOR;
    ListenSquare[] L=new ListenSquare[10];
    int MEM;


    public TilingCanvas addManager(Manager M) {
	TilingCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public TilingCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 TC=new ComputeTile();
	 setScales(200,20);
	 QUAD=QUAD.setQuad(1.0/3.0);
	 L[6]=new ListenSquare(0,0,12,12,Color.white);
	 STATS=new ListenSquare(0,0,0,0,Color.white);
	 STAT[0]="";
	 STAT[1]="";
	 STAT[2]="";
	 STAT[3]="";
	 DOC=new Documentation();
     }






    //paint method

   public void paint(Graphics g2) {

         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

         drawSetup(g);
	 drawZones(g);
         drawTiles(g);  
         drawSource(g,new Color(180,180,180),SOURCE,0.001);
	 drawMarkings(g);
	 drawStats(g);
         g.setColor(Color.white);
         g.drawRect(0,0,getWidth()-1,getHeight()-1);
	 try{
     	 if(M.C.EXPORT.mode>0) saveTiles();
	 }
	 catch(Exception e) {}
   }


      public void drawMarkings(Graphics2D g) {
      	 try{
	     Output OUT=new Output("Output/tilemark");	   
           TilingMarkings.drawStrips(g,M);
	   if(M.C.CON_T.MARKER.L[0].on==1) TilingMarkings.drawX(g,M,OUT);
	   if(M.C.CON_T.ACTION.mode==4) TilingMarkings.drawVertexPointer(g,M);
           if(M.C.CON_T.MARKER.L[1].on==1) TilingMarkings.drawFrame(g,M);
           if(M.C.CON_T.MARKER.L[2].on==1) TilingMarkings.drawDiamonds(g,M,OUT);
	   if(M.C.CON_T.MARKER.L[4].on==1) TilingMarkings.drawNecklace(g,M,OUT);
      	 }	 
         catch(Exception e) {}
      }


    public void drawZones(Graphics2D g) {
	try{ 
	    Output OUT=new Output("Output/tiling");
             if(M.C.CON_T.PW.ZMARKER.L[0].on==1) TilingMarkings.drawZone1(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[1].on==1) TilingMarkings.drawZone2(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[2].on==1) TilingMarkings.drawZone3(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[3].on==1) TilingMarkings.drawZone4(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[4].on==1) TilingMarkings.drawZone4sharp(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[5].on==1) TilingMarkings.drawZone5(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[6].on==1) TilingMarkings.drawZone6flat(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[7].on==1) TilingMarkings.drawZone6(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[8].on==1) TilingMarkings.drawZone7(g,M,0,OUT); 
	     if(M.C.CON_T.PW.ZMARKER.L[9].on==1) TilingMarkings.drawZone8(g,M,0,OUT); 

	     if(M.C.CON_T.PW.ZMARKER2.L[0].on==1) TilingMarkings.drawZone1(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[1].on==1) TilingMarkings.drawZone2(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[2].on==1) TilingMarkings.drawZone3(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[3].on==1) TilingMarkings.drawZone4(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[4].on==1) TilingMarkings.drawZone4sharp(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[5].on==1) TilingMarkings.drawZone5(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[6].on==1) TilingMarkings.drawZone6flat(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[7].on==1) TilingMarkings.drawZone6(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[8].on==1) TilingMarkings.drawZone7(g,M,1,OUT); 
	     if(M.C.CON_T.PW.ZMARKER2.L[9].on==1) TilingMarkings.drawZone8(g,M,1,OUT); 

             if(M.C.CON_T.PW.ZMARKER3.L[0].on==1) TilingMarkings.drawZone4sharp(g,M,2,OUT); 
             if(M.C.CON_T.PW.ZMARKER3.L[1].on==1) TilingMarkings.drawZone6flat(g,M,2,OUT); 

	} 

	catch(Exception e) {} 
    }




    public void drawStats(Graphics g) {
	STATS.x=0;
	STATS.y=getHeight()-20;
	STATS.w=getWidth();
	STATS.h=20;
	STATS.on=1;
	g.setFont(new  Font("Helvetica",Font.PLAIN,11));
	STATS.render(g,new Color(0,0,100));
	g.drawString(STAT[0],5,(int)(STATS.y+11));
	g.drawString(STAT[1],90,(int)(STATS.y+11));
	g.drawString(STAT[2],200,(int)(STATS.y+11));
	g.drawString(STAT[3],500,(int)(STATS.y+11));
    }




    public void drawSetup(Graphics2D g) {
	g.setColor(new Color(0,30,50));
	try{
          g.setColor(M.C.CON_T.COLORS.L[1].C);
	}
	catch(Exception e){}
     g.fillRect(0,0,getWidth(),getHeight());
     G[0]=QUAD.toGeneralPath();
     G[0]=transform(G[0]);
     g.setColor(new Color(0,0,50));
     try{
       g.setColor(M.C.CON_T.COLORS.L[2].C);
     }
     catch(Exception e) {}
     g.fill(G[0]);
     g.setColor(Color.white);
     g.draw(G[0]);  
   
    }




    public void setCoord() {
	     Double Sx=new Double(SOURCE.x);
	     Double Sy=new Double(SOURCE.y);
	     double d=Math.floor((SOURCE.x+1)/4);
	     Integer II=new Integer((int)(d));
	     STAT[2]="coord "+Sx.toString()+"   "+Sy.toString();
    }





    public void drawTiles(Graphics2D g) {
	for(int i=0;i<tile;++i) {
	    try{
	       GeneralPath X=TILE[i].toGeneralPath();
	       X=transform(X);
               g.setColor(TILECOLOR[i]);
               g.fill(X); 
               g.setColor(M.C.CON_T.COLORS.L[0].C);
               g.draw(X); 
	    }
	    catch(Exception e) {}
	}
    }




    public void saveTiles() {
	Output writer=new Output("Output/tiling");
	GeneralPath Y=QUAD.toGeneralPath();
        writer.polyWrite(Y,M.C.CON_T.COLORS.L[2].C);

	for(int i=0;i<tile;++i) {
	    GeneralPath X=TILE[i].toGeneralPath();
            writer.polyWrite(X,TILECOLOR[i]);
	}
    }





    public void displayVertices(int N) {
	WEDGE=TILE[N];
	M.C.CON_T.VCD.W=TILE[N];
	M.C.repaint();
    }

    //done with drawing stuf






    //computing the next orbit


    public void nextOrbit(PolyWedge PW) {

	PinwheelMap RM=new PinwheelMap(M.C.SES.getParameter());
	int k1=M.C.CON_T.TCC.INT[0].val;
	int k2=M.C.CON_T.TCC.INT[1].val;
	k1=(int)(Math.pow(2,k1));
	k2=(int)(Math.pow(2,k2));
	Complex z=PW.getCenter();
	  int multi=M.C.CON_T.MULTI.mode;
	  if(multi==0) nextOrbitWhole(PW,PW.orbit,k1,k2);
	  if(multi==1) nextOrbitHalfStrip(PW,PW.orbit,k1);
	  if(multi==2) nextOrbitReturn(PW);
	  if(multi==3) nextOrbitWhole(PW,M.C.CON_T.INT[0].val,k1,k2);  
          if(multi==4) nextOrbitWhole(PW,1,k1,k2);
	  ++orbit;
    }


    public int determinePlot(int k1,int k2) {
        int test=WEDGE.isWithinRange(k1,k2);
	return(test);
    }

    public void nextOrbitWhole(PolyWedge PW,int k,int k1,int k2) {
	Complex z1=PW.getCenter();
	Complex z2=new Complex(z1);
	  WEDGE=new PolyWedge(PW);
	  int i=0;
	  int test=0;

	  int s=2-M.C.CON_T.POWER.mode;

          double max=Math.pow(2,M.C.CON_T.TCC.INT[2].val);
	  while((test==0)&&(i<s*k)&&(i<max)) {
	      z2=WEDGE.getCenter();
	      if(determinePlot(k1,k2)==1) {
		   TILE[tile]=WEDGE;
                   TILECOLOR[tile]=M.C.CS.C;   
		   ORBITPOSITION[tile]=i;
                   ORBITINDEX[tile]=orbit;   
                   ++tile;
	       }
               WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       if(s==1) WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       ++i;
	       test=PolyWedge.doTheyIntersect(PW,WEDGE);
	  }

	     Integer II=new Integer(i);
	     STAT[0]="orbit "+II.toString();

	     Integer MAX=new Integer(PW.radius);
	     STAT[1]="excursion "+MAX.toString();
	     setCoord();
    }



    public void nextOrbitHalfStrip(PolyWedge PW,int k,int k1) {
	Complex z1=PW.getCenter();
	Complex z2=new Complex(z1);
	  WEDGE=new PolyWedge(PW);
	  int i=0;
	  int test=0;  
          int s=2-M.C.CON_T.POWER.mode;
	  double max=Math.pow(2,M.C.CON_T.TCC.INT[2].val);
	  while((test==0)&&(i<s*k)&&(i<max)) {
	      z2=WEDGE.getCenter();
	      if((z2.x>0)&&(determinePlot(k1,1)==1)) {
		   TILE[tile]=WEDGE;
                   TILECOLOR[tile]=M.C.CS.C;   
		   ORBITPOSITION[tile]=i;
                   ORBITINDEX[tile]=orbit;   
                   ++tile;
	       }
               WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
               if(s==1) WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       ++i;
	       test=PolyWedge.doTheyIntersect(PW,WEDGE);
	  }

	     Integer II=new Integer(i);
	     STAT[0]="orbit "+II.toString();

	     Integer MAX=new Integer(PW.radius);
	     STAT[1]="excursion "+MAX.toString();
	     setCoord();
    }





    public void nextOrbitReturn(PolyWedge PW) {
	int first=0;
	int second=0;
	int test=0; 
	int count=0;
	Complex[] z=new Complex[6];
 
        WEDGE=new PolyWedge(PW);

	while((count<PW.orbit+6)&&(second==0)) {

           test=WEDGE.hitsStrip();

	   if((count>2)&&(first==1)) {
		if(test==1) {
                    z[1]=WEDGE.getCenter();
                    second=1;
		}
	    }

	    if(first==0) {
		if(test==1) {
                    first=1;
		    z[0]=WEDGE.getCenter();
		}
	    }

            TILE[tile]=WEDGE;
            TILECOLOR[tile]=M.C.CS.C;   
	    ORBITPOSITION[tile]=count;
            ORBITINDEX[tile]=orbit;  
	    PolyWedge QUAD0=new PolyWedge(QUAD); 
            WEDGE=ComputeTile.nextPoly(WEDGE,QUAD0);
	    WEDGE=ComputeTile.nextPoly(WEDGE,QUAD0);
	    ++tile;
	    ++count;
	}
    }

    //done with orbit computing stuff











    //tile changing options -- plotting, recoloring, erasing




    public void action() {

	if(M.C.CON_T.ACTION.mode==0) {
	    TC=new ComputeTile(SOURCE,M,0);
	    new Thread(TC).start();
	}

        if(M.C.CON_T.ACTION.mode>0) modifyTiles();
    }

    public void run() {}


    public void modifyTiles() {
            int MODE=M.C.CON_T.ACTION.mode;
	    halt=1;
	    int count=tile-1;
	    MEM=-1;
	    GeneralPath T=new GeneralPath();
	    while((count>=0)&&(halt==1)) {
		try {
	            T=TILE[count].toGeneralPath();
	            if(T.contains(SOURCE.x,SOURCE.y)==true) {
		       MEM=count;
		       halt=0;
		    }
		}
		catch(Exception e) {}
	        --count; 
	    }

	    halt=0;
	    if(MEM!=-1) {

		System.out.println("test ");
		System.out.println(MEM+" "+ORBITINDEX[MEM]);



	       if(MODE==1) recolor(MEM,M.C.CS.C); //recolor whole orbit
	       if(MODE==3) TILECOLOR[MEM]=M.C.CS.C;   //recolor individual tile
	       if(MODE==4) displayVertices(MEM);
	    }

	    if((MODE==2)&&(MEM!=-1)) eraseOrbit(MEM);
	    repaint();
	    M.C.repaint();
    }



    public void recolor(int MEM,Color C) {
	for(int i=0;i<tile;++i) {
	    if(ORBITINDEX[i]==ORBITINDEX[MEM]) {TILECOLOR[i]=C;}
	}
    }



    public void eraseOrbit(int N) {
	    int[] stretch=findRange(N);
	    int range=stretch[1]-stretch[0]+1;
	    for(int i=stretch[0];i<tile-range;++i) {
		TILE[i]=new PolyWedge(TILE[i+range]);
	        ORBITINDEX[i]=ORBITINDEX[i+range];	
		int r=TILECOLOR[i+range].getRed();
		int g=TILECOLOR[i+range].getGreen();
		int b=TILECOLOR[i+range].getBlue();
		TILECOLOR[i]=new Color(r,g,b);
	    }
	    tile=tile-range;
    }



    public int[] findRange(int N) {
	int orb=ORBITINDEX[N];
	int max=0;
	int min=10000000;
	for(int i=0;i<tile;++i) {
	    if((ORBITINDEX[i]==orb)&&(max<i)) max=i;
	    if((ORBITINDEX[i]==orb)&&(min>i)) min=i;
	}
	int[] str={min,max};
	return(str);
    }
  







    //mouse buttons and keyboards



    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
     }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
	try{
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	    JX=J.X;
	}
	catch(Exception ee) {}
    }

    public void mouseDragged(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {

        DOC.M=this.M;
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	Point X=J.X;
	int but=J.mode; 
	doMouseClick(X,but);
    }

    public void doMouseClick(Point X,int mode) {
	if(M.C.EXPORT.mode==1) saveTiles();
        if(L[6].inside(X)==1) DOC.pictureCanvasInfo();
        if(mode==1) scaleUp(X,-1);
        if(mode==3) scaleUp(X,+1);
	if(mode==2) {
            Complex temp=unTransform(X);
	    PolyVector PP=new PolyVector(QUAD);
            if(PP.inside(new Vector(temp))==0) {
	      SOURCE=temp;
	      setCoord();
	      action();
	    }
	}
    }



    public void keyTyped(KeyEvent e) {

	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(JX,test);
	repaint();
    }


    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

