import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TilingMarkings {
    public TilingMarkings() {
    }

    public static void drawX(Graphics2D g,Manager M,Output OUT) {
	GeneralPath H=new GeneralPath();  
        Color COL=M.C.CON_T.MARKER.M[0].C;
	g.setColor(COL);
	for(int i=-100;i<100;++i) {
	  H.reset();
	  H.moveTo(-1000,1+2*i);
	  H.lineTo(1000,1+2*i);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);
	}
    }


    public static void drawNecklace(Graphics2D g,Manager M,Output OUT) {
	GeneralPath H=new GeneralPath();  
        Color COL=M.C.CON_T.MARKER.M[4].C;
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	int test=(p+q)%2;
	int n=(p+q)*(p+q)/2;
	if(test==1) n=(p+q)*(p+q)*2;
	g.setColor(COL);

	H.moveTo(-n,0);
	H.lineTo(n,0);
        if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	H=M.P.transform(H);
	g.draw(H);

    }









    public static void drawFrame(Graphics2D g,Manager M) {
	GeneralPath H=new GeneralPath();

	float dx=(float)(Math.pow(2,M.C.CON_T.TCC.INT[0].val));
	float dy=(float)(Math.pow(2,M.C.CON_T.TCC.INT[1].val));

	float a=(float)(1000.0);

	Color COL=M.C.CON_T.MARKER.M[1].C;
        g.setColor(COL);

	//top
	H.reset();
	H.moveTo(dx+a,dy);
	H.lineTo(dx+a,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,dy);
	H=M.P.transform(H);
	g.fill(H);

	//bottom
	H.reset();
	H.moveTo(dx+a,-dy);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(-dx-a,dy-a);
	H.lineTo(-dx-a,-dy);
	H=M.P.transform(H);
	g.fill(H);

	//right
	H.reset();
	H.moveTo(dx,dy+a);
	H.lineTo(dx+a,dy+a);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);

	//left
	H.reset();
	H.moveTo(-dx,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,-dy-a);
	H.lineTo(-dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);


	g.setColor(M.C.CON_T.COLORS.L[0].C);
	H.reset();
	H.moveTo(dx,dy);
	H.lineTo(-dx,dy);
	H.lineTo(-dx,-dy);
	H.lineTo(dx,-dy);
	H.closePath();
	H=M.P.transform(H);
	g.draw(H);
    }




    public static void drawVertexPointer(Graphics2D g,Manager M) {
	Complex z1=M.P.WEDGE.getCenter();
	Complex z2=M.P.WEDGE.z[M.C.CON_T.VCD.I2.val];
	float x1=(float)(z1.x);
	float y1=(float)(z1.y);
	float x2=(float)(z2.x);
	float y2=(float)(z2.y);
	GeneralPath H=new GeneralPath();
	H.moveTo(x1,y1);
	H.lineTo(x2,y2);
	H=M.P.transform(H);
	g.setColor(M.C.CON_T.COLORS.L[0].C);
	g.setStroke(new BasicStroke(2));
	g.draw(H);
	g.setStroke(new BasicStroke(1));
    }





    public static void drawDiamonds(Graphics2D g,Manager M,Output OUT) {
	g.setStroke(new BasicStroke((float)(1.5)));
	GeneralPath H0=new GeneralPath();

	H0.moveTo(-1,0);
	H0.lineTo(1,2);
	H0.lineTo(3,0);
	H0.lineTo(1,-2);
	H0.closePath();

	double LIM=Math.pow(2,M.C.CON_T.TCC.INT[0].val-2);
	GeneralPath H=new GeneralPath();
	Color COL=M.C.CON_T.MARKER.M[2].C;
        g.setColor(COL);
        H=new GeneralPath(H0);
	AffineTransform A1=AffineTransform.getTranslateInstance(4,0);
	for(int i=0;i<=LIM;++i) {
	    if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	    GeneralPath H1=M.P.transform(H);
            g.draw(H1);    
            H.transform(A1);
	}
	g.setStroke(new BasicStroke(1));

    }





    public static void drawStrips(Graphics2D g,Manager M) {
	PinwheelLayering SL=M.C.CON_T.PW.SL;
	for(int i=0;i<4;++i) if(M.C.CON_T.PW.STRIPS.L[SL.n[i]].on==1) drawStrip(SL.n[i],g,M);
    }


    public static void drawStrip(int i,Graphics2D g,Manager M) {

	if(i==0) drawStrip1(g,M);
	if(i==1) drawStrip2(g,M);
	if(i==2) drawStrip3(g,M);
	if(i==3) drawStrip4(g,M);
    }



    public static void drawStrip4(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.PW.STRIPS.M[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;


	//first strip

	a1=0;
	a2=1;
	a3=3;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }


    public static void drawStrip1(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.PW.STRIPS.M[0].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//second strip

	a1=0;
	a2=3;
	a3=1;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }


    public static void drawStrip3(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.PW.STRIPS.M[2].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//third strip

	a1=2;
	a2=3;
	a3=0;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }





    public static void drawStrip2(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.PW.STRIPS.M[1].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//4th strip

	a1=2;
	a2=1;
	a3=0;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);	

        H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }


    public static Color zoneColor(int j,int option,Manager M) {
	Color COL=M.C.CON_T.PW.ZMARKER.M[j-1].C;
	if(option==1)  COL=M.C.CON_T.PW.ZMARKER2.M[j-1].C;
	if(option==2)  COL=M.C.CON_T.PW.ZMARKER3.M[j-1].C;

        return(COL);
    }










    public static void drawZone1(Graphics2D g,Manager M,int option,Output OUT) {
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(0,4);

	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)(1);
	p1[1]=(float)(-2);

	p2[0]=(float)(2*0-(NUM1*(-1)-NUM2*(0)));
	p2[1]=(float)(2*(-1)-(NUM1*(0)-NUM2*1));

	p3[0]=(float)(NUM1*0-NUM2*(-1));
	p3[1]=(float)(NUM1*(-1)-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();  
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(zoneColor(1,option,M));
	g.fill(H0);
	g.setColor(new Color(100,100,100));
	g.draw(H0);
    }




    public static void drawZone2(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(-2,2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)(0);
	p1[1]=(float)(-1);

	p2[0]=(float)(1);
	p2[1]=(float)(-2);

	p3[0]=(float)(2*0-(NUM1*(-1)-NUM2*(0)));
	p3[1]=(float)(2*(-1)-(NUM1*(0)-NUM2*1));

	p4[0]=(float)(NUM1*A-NUM2*0);
	p4[1]=(float)(NUM1*(0)-NUM2*(-1));


	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath(); 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(zoneColor(2,option,M));

	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }


    public static void drawZone3(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=M.C.SES.getParameter();
	AffineTransform offset=AffineTransform.getTranslateInstance(-2-2*A,0);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	//sector R3

	p1[0]=(float)(2*A);
	p1[1]=(float)(1);

        w=Vector.findCross2(z[2],z[3],z[2].reflect(z[1]),z[2].reflect(z[0]));
	w=new Complex(2*A*A/(A-1),(1+A)/(1-A));

	p2[0]=(float)(w.x);
	p2[1]=(float)(w.y);

	p3[0]=(float)(NUM1*(0)-NUM2*A);
	p3[1]=(float)(NUM1*1-NUM2*(0));

	p4[0]=(float)(NUM1*A-NUM2*0);
	p4[1]=(float)(NUM1*(0)-NUM2*(-1));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath(); 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(zoneColor(3,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();
    }


    public static void drawZone4(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(-2,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();


        w2=Vector.findCross2(z[2],z[3],z[3].reflect(z[0]),z[3].reflect(z[1]));
	w2=new Complex(2*A/(A-1),(A-3)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(0)-(NUM1*0-NUM2*(-1)));
	p2[1]=(float)(2*1-(NUM1*(-1)-NUM2*(0)));

	p3[0]=(float)(NUM1*(0)-NUM2*A);
	p3[1]=(float)(NUM1*1-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath(); 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);  
        g.setColor(zoneColor(4,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }


    public static void drawZone5(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(0,-4);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();



	w=new Complex(2*A/(A-1),(3*A-1)/(A-1));
	w2=new Complex(2*A/(A-1),(A-3)/(A-1));

	p1[0]=(float)(-A);
	p1[1]=(float)(2);

	p2[0]=(float)(w.x);
	p2[1]=(float)(w.y);

	p3[0]=(float)(NUM1*(-1)-NUM2*(0));
	p3[1]=(float)(NUM1*(0)-NUM2*1);

	p5[0]=(float)(w2.x);
	p5[1]=(float)(w2.y);

	p4[0]=(float)(2*(0)-(NUM1*0-NUM2*(-1)));
	p4[1]=(float)(2*1-(NUM1*(-1)-NUM2*(0)));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.lineTo(p5[0],p5[1]);
	H0.closePath();	 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);  
        g.setColor(zoneColor(6,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }




    public static void drawZone6(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();


	w2=new Complex(2/(A-1),(A+1)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(-1)-(NUM1*A-NUM2*0));
	p2[1]=(float)(2*(0)-(NUM1*(0)-NUM2*(-1)));

	p3[0]=(float)(NUM1*(-1)-NUM2*(0));
	p3[1]=(float)(NUM1*(0)-NUM2*1);

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();	 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);   
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        g.setColor(zoneColor(8,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }



public static void drawZone7(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=M.C.SES.getParameter();
	AffineTransform offset=AffineTransform.getTranslateInstance(2+2*A,0);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	w2=new Complex(2/(A-1),(A+1)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(-1)-(0));
	p2[1]=(float)(2*(0)-1);

	p3[0]=(float)(2*(-1)-(NUM1*(0)-NUM2*A));
	p3[1]=(float)(2*(0)-(NUM1*1-NUM2*(0)));

	p4[0]=(float)(2*(-1)-(NUM1*A-NUM2*0));
	p4[1]=(float)(2*(0)-(NUM1*(0)-NUM2*(-1)));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath(); 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0); 
        g.setColor(zoneColor(9,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }




public static void drawZone8(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2,2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=M.C.SES.getParameter();
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)((-1));
	p1[1]=(float)((0));

	p2[0]=(float)(-2);
	p2[1]=(float)(-1);

	p3[0]=(float)(2*(-1)-(NUM1*(0)-NUM2*A));
	p3[1]=(float)(2*(0)-(NUM1*1-NUM2*(0)));

	p4[0]=(float)(NUM1*0-NUM2*(-1));
	p4[1]=(float)(NUM1*(-1)-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath();	 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);  
        g.setColor(zoneColor(10,option,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }



public static void drawZone4sharp(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=M.C.SES.getParameter();
	AffineTransform offset=AffineTransform.getTranslateInstance(-2*A,-2);
	AffineTransform offset2=AffineTransform.getTranslateInstance(-2*A-2,0);

	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();


	p1[0]=(float)(A);
	p1[1]=(float)(0);

	p2[0]=(float)(2*A);
	p2[1]=(float)(1);

	w=new Complex(2*A*A/(A-1),(A+1)/(1-A));

	p3[0]=(float)(w.x);
	p3[1]=(float)(w.y);


	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath(); 
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
        if(option==2) H0.transform(offset2);
	H0=M.P.transform(H0);  
        if(option<2)  g.setColor(zoneColor(5,option,M));
        if(option==2) g.setColor(zoneColor(1,2,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }





public static void drawZone6flat(Graphics2D g,Manager M,int option,Output OUT) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	double A=M.C.SES.getParameter();
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2*A,-2);
	AffineTransform offset2=AffineTransform.getTranslateInstance(0,-4);

	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)((0));
	p1[1]=(float)(1);

	p2[0]=(float)(-A);
	p2[1]=(float)(2);

        w=new Complex(2*A/(A-1),(3*A-1)/(A-1));

	p3[0]=(float)(w.x);
	p3[1]=(float)(w.y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();	   
        if(M.C.EXPORT.mode!=0) OUT.polyWrite(H0,Color.white,Color.black);
        if(option==1) H0.transform(offset);
        if(option==2) H0.transform(offset2);

	H0=M.P.transform(H0);

        if(option<2)  g.setColor(zoneColor(7,option,M));
        if(option==2) g.setColor(zoneColor(2,2,M));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();

    }


































}
