import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TorusPartition extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    double A;
    double offset;
    Complex SOURCE;
    Point JX;
    Complex[] POINT=new Complex[1000000];
    Color[] POINTCOLOR=new Color[1000000];
    GeneralPath[] PATH=new GeneralPath[1000000];
    Color[] PATHCOLOR=new Color[1000000];
    PolyWedge[] POLY=new PolyWedge[50];
    Color[] POLYCOLOR=new Color[50];
    ListenSquare INFO;
    int polycount;
    int point;
    int path;
    Documentation DOC;
    double current;
    TorusPolytopes PL;
    Output OUT;
    Complex[] WINDOW=new Complex[2];
    TorusPartitionMarkings TPM;


    public TorusPartition() {
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);

	 setScales(200,40);
         SOURCE=new Complex(0,110);
	 point=0;
	 path=0;
	 A=1.0/3.0;
	 offset=1.0/10.0;
	 polycount=0;
	 DOC=new Documentation();
	 INFO=new ListenSquare(0,0,12,12,Color.white);
	 PL=new TorusPolytopes();
	 OUT=new Output("Output/tiling");
	 WINDOW[0]=new Complex(0,0);
	 WINDOW[1]=new Complex(1,1);	
         TPM=new TorusPartitionMarkings();
       
    }

    public TorusPartition addManager(Manager M) {
	TorusPartition XX=this;
	XX.M=M;
	return(XX);
    }




    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      g.fillRect(0,0,this.getWidth(),this.getHeight());
      OUT=new Output("Output/tiling");


      try {    
          getParameter(); 
	  drawAuxilliary(g);
	  drawPolygons(g,OUT);    
	   if(M.C.CON_P.PEC.DISPLAY.L[7].on==1) TPM.drawCoords(g,M);
           if(M.C.CON_P.MODE.val==5) TPM.drawCoordsSpecial(g,M);  
           if(M.C.CON_P.MODE.val==6) TPM.drawHexProof(g,M,OUT);  
           if(M.C.CON_P.PEC.DISPLAY.L[6].on==1) TPM.drawLatticeImage(g,M);
      }

      catch(Exception e) {}  
      drawPath(g);
      drawPlot(g); 
      try {drawLegend(g);}
      catch(Exception e) {}  
    }


    public void drawLegend(Graphics2D g) {
         Color COL=Color.white;
	 for(int i=0;i<3;++i) {
	     for(int j=0;j<3;++j) {
		 COL=M.C.CON_P.PEC.PLUS[i][j].C;
		 g.setColor(COL);
		 g.fillRect(30*i,30*j,30,30);
		 g.setColor(Color.white);
                 g.drawRect(30*i,30*j,30,30);

	     }
	 }

	 try{
	   if(M.C.CON_P.PEC.DISPLAY.L[6].on==1) {
	     int[] map = M.C.CON_P.PEC.LOCAL;
	     g.setColor(Color.white); 
             g.setStroke(new BasicStroke(3));
	     g.drawLine(45,45,45+30*map[0],45-30*map[1]);
	     g.drawLine(45,45,45+30*map[2],45-30*map[3]);  
             g.setStroke(new BasicStroke(1));
	   }
	 }
	 catch(Exception e) {}


    }






    public void drawAuxilliary(Graphics2D g) {
	  if(M.C.CON_P.PEC.DISPLAY.L[2].on==1) drawPolytopeTiling(g,0,OUT); 
	  if(M.C.CON_P.PEC.DISPLAY.L[3].on==1) drawPolytopeTiling(g,1,OUT);
	  int mode=M.C.CON_P.PEC.PROJ.mode;
	  if(mode==0) {	
	      Color COL=Color.white;
	      if(M.C.CON_P.PEC.DISPLAY.L[4].on==1) TPM.drawFramePlus(g,M,COL);
	      if(M.C.CON_P.PEC.DISPLAY.L[5].on==1) TPM.drawFrameMinus(g,M,COL);
	  }
    }


    public void getParameter() {
       Complex z=M.C.CON_P.getFiber();
       A=z.y;
       offset=2*z.x;
    }


    //this drawing corresponds to the 3 possible geom modes in the torus window

    public GeneralPath slice1(Polytope P) {

	GeneralPath gp=new GeneralPath();
        int mode=M.C.CON_P.PEC.PROJ.mode;
	double perturb=M.C.CON_P.PEC.IS[5].val;
	perturb=Math.pow(.5,12-perturb);

	if(mode==0) gp=P.slice0(.5*offset,A);
	if(mode==1) gp=P.slice1(1,A);
	if(mode==2) gp=P.slice2(A+perturb,A);

	int mode2=0;
	if(M.C.CON_P.MODE.val==7) mode2=1;

	//this option is for the Barrier Theorem
	if((mode==1)&&(mode2==1)) {
	    int q=M.C.SES.getDenominator();
	  int slicer=M.C.CON_P.PEC.IS[3].val;   //should be 1 or -1 for barrier theorem
                   double s=1.0/q;
	  s=s*slicer;
                   gp=P.slice1(1+s,A);
	}

	return(gp);
    }



    public GeneralPath slice2(Polytope P) {
	GeneralPath gp=new GeneralPath();
                   int mode=M.C.CON_P.PEC.PROJ.mode;
	double perturb=M.C.CON_P.PEC.IS[5].val;
	perturb=Math.pow(.5,12-perturb);
	if(mode==0) gp=P.slice0(.5*offset,A);
	if(mode==1) gp=P.slice1(0,A);	
                   if(mode==2) gp=P.slice2(A+perturb,A);
	int mode2=0;
	if(M.C.CON_P.MODE.val==7) mode2=1;

	//this option is for the barrier theorem

	if((mode==1)&&(mode2==1)) {
	  int q=M.C.SES.getDenominator();
          int slicer=M.C.CON_P.PEC.IS[3].val;    // should be 1 or -1 for barrier theorem
          double s=1.0/q;
          s=s*slicer;
          gp=P.slice1(1+s,A);
          gp=P.slice1(s,A);
	}

	return(gp);
    }

    public Color makeTransparent(Color C,int a) {
	int r=C.getRed();
	int g=C.getGreen();
	int b=C.getBlue();
	Color D=new Color(r,g,b,a);
	return(D);
    }


    public void drawPolygons(Graphics2D g,Output OUT) {
	    int test=M.C.CON_P.getFiberSelect();
	    if(test==1)  drawPoly(g,0,OUT);
	    if(test==2)  drawPoly(g,1,OUT);
	    if(test==3) {
		drawPoly(g,0,OUT);
		drawPoly(g,1,OUT);
	    }
	}



    public void drawPoly(Graphics2D g,int choice,Output OUT) {
      GeneralPath gp=new GeneralPath();
      AffineTransform AA=new AffineTransform();
      int mode=0;

      Color C=M.C.CS.C;
      int a=C.getAlpha();


      Color COL=Color.blue;

      if(choice==0) {
	for(int i=0;i<14;++i) {   
                      int t1=PL.P[i].type[1];
	   int t2=PL.P[i].type[2];
	   gp=slice1(PL.P[i]);  
                    COL=M.C.CON_P.PEC.PLUS[1+t1][1-t2].C;
                     if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,COL,Color.black);	
	   gp=transform(gp);
	   COL=M.C.CON_P.PEC.PLUS[1+t1][1-t2].C;
	   COL=makeTransparent(COL,a);
	   g.setColor(COL);

                     g.fill(gp);  
	   g.setColor(new Color(255,255,255));
	   g.draw(gp);
	}
      }


      if(choice==1) {
	  int mode2=M.C.CON_P.getShift();
	  if(mode2==3) AA=AffineTransform.getTranslateInstance(2+A,1);
	  if(mode2==1) AA=AffineTransform.getTranslateInstance(1,1);
	  if(mode2==2) AA=AffineTransform.getTranslateInstance(-1,-1);
	  if(mode2==0) AA=AffineTransform.getTranslateInstance(0,0);

	for(int i=14;i<28;++i) {  
           int t1=PL.P[i].type[1];
	   int t2=PL.P[i].type[2];  
           COL=M.C.CON_P.PEC.MINUS[1+t1][1-t2].C;   
                    COL=makeTransparent(COL,a);
	   gp=slice2(PL.P[i]);
	   gp.transform(AA);  
           if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,COL,Color.black);	
	   gp=transform(gp);
	   g.setColor(COL);
           g.fill(gp);  
	   g.setColor(new Color(255,255,255));
	   g.draw(gp);
	}
      }
    }





    public void drawPolytopeTiling(Graphics2D g,int SIGN,Output OUT) {
      GeneralPath gp=new GeneralPath();
      AffineTransform AA=new AffineTransform();
      Polytope P=new Polytope();    
      TorusPolytopes PL=new TorusPolytopes();
      int alpha=M.C.CS.C.getAlpha();

    if(SIGN==0) {
	int b=0;
	if(M.C.CON_P.PEC.PROJ.mode==1) b=1;
	if(M.C.CON_P.PEC.PROJ.mode==3) b=1;
      for(int j1=-3;j1<=3;++j1) {
	  for(int j2=-3;j2<=3;++j2) {
	    for(int j3=0;j3<=b;++j3) {
	     for(int i=0;i<14;++i) {   
               P=new Polytope(PL.P[i]);
               int t1=PL.P[i].type[1];
	       int t2=PL.P[i].type[2];
	       if(M.C.CON_P.PEC.PLUS[1+t1][1-t2].on==1) {
	           P=Polytope.gamma(j1,j2,j3,P);
	           gp=slice1(P);
		   Color CC=M.C.CON_P.PEC.PLUS[1+t1][1-t2].C;
                   if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,CC,Color.black);	
	           gp=transform(gp);
		   g.setColor(CC);
                   g.fill(gp);  
	           g.setColor(new Color(255,255,255,200));
	           g.draw(gp);
		 }
	     }
	    }
	  }
      }
    }


    // minus fibers can be shifted
    int shift=M.C.CON_P.getShift();
    int proj=M.C.CON_P.getProjection();

    if(proj==0) {
       if(shift==3) AA=AffineTransform.getTranslateInstance(2+A,1);
       if(shift==1) AA=AffineTransform.getTranslateInstance(1,1);
       if(shift==2) AA=AffineTransform.getTranslateInstance(-1,-1);
       if(shift==0) AA=AffineTransform.getTranslateInstance(0,0);
    }


    if(SIGN==1) {	
        int b=0;
	if(M.C.CON_P.PEC.PROJ.mode==1) b=1;
	if(M.C.CON_P.PEC.PROJ.mode==3) b=1;
      for(int j1=-3;j1<=3;++j1) {
	  for(int j2=-3;j2<=3;++j2) {
	    for(int j3=0;j3<=b;++j3) {
	     for(int i=14;i<28;++i) {   
               P=new Polytope(PL.P[i]);  
               int t1=PL.P[i].type[1];
	       int t2=PL.P[i].type[2];
	       if(M.C.CON_P.PEC.MINUS[1+t1][1-t2].on==1) {
	           P=Polytope.gamma(j1,j2,j3,P);
	           gp=slice2(P);
		   Color CC=M.C.CON_P.PEC.MINUS[1+t1][1-t2].C;
	           gp.transform(AA);  
                   if(M.C.EXPORT.mode!=0) OUT.polyWrite(gp,CC,Color.black);	
	           gp=transform(gp);
		   g.setColor(CC);
                   g.fill(gp);  
	           g.setColor(new Color(255,255,255,200));
	           g.draw(gp);
		 }
	     }
	    }
	  }
      }
    }
    }


    public void setWindow(Point X) {
      Complex z=unTransform(X);
    }


    /*********auxilliary plotting ****/
    public void addPoint(Complex z,Color C) {
	POINT[point]=new Complex(z);
	POINTCOLOR[point]=C;
	++point;
    }

    public void addPath(GeneralPath gp,Color C) {
	PATH[path]=new GeneralPath(gp);
	PATHCOLOR[path]=C;
	++path;
    }

    public void drawPath(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();

       	for(int j=-1;j<=1;++j) {
	    for(int k=-1;k<=1;++k) {
		AffineTransform AT=AffineTransform.getTranslateInstance(j*(1+A)+k*(1-A),k*(1+A));

	        for(int i=0;i<path;++i) {
	          gp=new GeneralPath(PATH[i]);
                  gp.transform(AT); 
                  gp=transform(gp);
		  g.setColor(PATHCOLOR[i]);
		  g.fill(gp);
		  g.draw(gp);
		}
	    }
	}
    }

    public void drawPlot(Graphics2D g) {
	double d=.002;
	GeneralPath gp=new GeneralPath();
	Complex z=new Complex();

	for(int i=0;i<point;++i) {
	    gp.reset();
	    z=new Complex(POINT[i]);
	    g.setColor(POINTCOLOR[i]);
	    gp.moveTo((float)(z.x-d),(float)(z.y-d));
	    gp.lineTo((float)(z.x-d),(float)(z.y+d));
	    gp.lineTo((float)(z.x+d),(float)(z.y+d));
	    gp.lineTo((float)(z.x+d),(float)(z.y-d));
	    gp.closePath();
	    gp=transform(gp);
	    g.draw(gp);
	    g.fill(gp);
	}
    }
    /********end auxilliary plotting**************/




    public void mouseMoved(MouseEvent e) {
	try{	
            MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	    JX=J.X; }
	catch(Exception ee) {}
    }
    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e,M.C.MOUSE.mode); 
        if(J.mode==2) doMouseClick(J.X,J.mode);
    }

    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}


   public void mouseClicked(MouseEvent e) {
       MouseData J=MouseData.process(e,M.C.MOUSE.mode);
       doMouseClick(J.X,J.mode);
   }



       public void doMouseClick(Point X,int mode) {
	   DOC.M=this.M;
	   if(INFO.inside(X)==0) {
	     if(mode==2)  setWindow(X);
             if(mode==1)  scaleUp(X,0);
             if(mode==3)  scaleUp(X,1);
	   }
	   if(INFO.inside(X)==1) DOC.polytope_info();
	   repaint();
       }

    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();

	int test=0;
	if(ch=='b') test=1;
	if(ch=='n') test=2;
	if(ch=='m') test=3;
	if(test>0) doMouseClick(JX,test);
    }


}


