import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TorusPartitionControl {
    Manager M;
    ControlPanel SCALE,DISPLAY,SHIFT,PROJ;

    ControlPanel DISPLAY1;


    Documentation DOC;
    ListenSquare GRAB;
    ListenSquare[] INFO=new ListenSquare[10];
    int[] PROJECT=new int[2];

    ListenSquare[] ON=new ListenSquare[3];
    TorusSliceSelector TOR;
    int X,Y;

    ListenSquare[][] PLUS=new ListenSquare[3][3];
    ListenSquare[][] MINUS=new ListenSquare[3][3];
    SelectInteger[] IS=new SelectInteger[10];
    ListenSquare TRANS;
    int[] LOCAL=new int[4];

    public TorusPartitionControl(int X,int Y,Manager MM) {
	this.X=X;
	this.Y=Y;
	this.M=MM;

	setPanels();
	setTileControls();

	IS[0]=new SelectInteger(X+125,Y+215,36,18,0,0,8,1);  //hex2
	IS[1]=new SelectInteger(X+125,Y+220,36,18,0,0,4,1);  //immerse
	IS[2]=new SelectInteger(X+125,Y+220,36,18,0,0,2,1);  //embed
                  IS[3]=new SelectInteger(X+125,Y+245,36,18,0,-10,10,1); //barrier
                  IS[4]=new SelectInteger(X+5,Y+220,36,18,10,5,18,1); //sanity check
	IS[5]=new SelectInteger(X+125,Y+245,36,18,0,0,10,1);  //hex2

	 //grab the parameter
	GRAB=new ListenSquare(X+68,Y-7,30,15,Color.white);
	 GRAB.on=1;

	 INFO[0]=new ListenSquare(X+102,Y-7,12,12,Color.white);
	 INFO[1]=new ListenSquare(X+301,Y-7,12,12,Color.white);

	 TOR=new TorusSliceSelector(X-7,Y+8,200);
	 TOR.Z=new Complex(1.0/20.0,1.0/3.0);
	 DOC=new Documentation();  

	 //for barrier

	 PROJECT[0]=0;
	 PROJECT[1]=1;
    }



     public void setTileControls() {

	     //minus selector
	 for(int i=0;i<3;++i) {
	     for(int j=0;j<3;++j) {
		 PLUS[i][j]=new ListenSquare(X+15*i,217+Y+15*j,15,15,Color.white);
		 PLUS[i][j].C=TorusColors.getColorXY(i-1,1-j,255);
	     }
	 }

	     //plus selector
	 for(int i=0;i<3;++i) {
	     for(int j=0;j<3;++j) {
		 MINUS[i][j]=new ListenSquare(63+X+15*i,217+Y+15*j,15,15,Color.white);	 
                 MINUS[i][j].C=TorusColors.getColorXY(i-1,1-j,255);
	     }
	 }

     }

    public void setPanels() {


	Color[] C0={new Color(0,200,200),Color.white,Color.white,Color.black,Color.red};

	 DOC=new Documentation();

	 //display 
	 String[] S4={"+ fiber","-- fiber","+ tiling","-- tiling","+ frame","-- frame","hear","coords","display"};
	 int[] state4={1,1,0,0,0,0,0,0};
	 DISPLAY=new ControlPanel(C0,S4,state4,8);

	 //shift
	 String[] S5={"(0)(0)","(1)(1)","(-1)(-1)","(2+A)(1)","-- shift"};
	 int[] state5={0,0,0,1};
	 SHIFT=new ControlPanel(C0,S5,state5,4);
	 SHIFT.mode=3;

	 //projection
	 String[] S7={"0","1","2","geom"};
	 int[] state7={1,0,0};
	 PROJ=new ControlPanel(C0,S7,state7,3);
	 PROJ.mode=0;

    }



    public void resetBasics() {
       for(int i=0;i<8;++i) DISPLAY.L[i].on=0;  
       for(int i=0;i<4;++i) SHIFT.L[i].on=0;
       PROJ.forceMode(0);
        for(int i=0;i<3;++i) {
	  for(int j=0;j<3;++j) {
	      PLUS[i][j].on=0;
	      MINUS[i][j].on=0;
	  }
	}
    }

    public void resetControls(int mode) {
	resetBasics();
	if(mode==0) resetControls0();
	if(mode==1) resetControls1();
	if(mode==2) resetControls2();
	if(mode==3) resetControls3();
	if(mode==4) resetControls4();
	if(mode==5) resetControls5();
	if(mode==6) resetControls6();
	if(mode==7) resetControls7();
	if(mode==8) resetControls8();
    }



    public void resetControls0() {
      DISPLAY.L[0].on=1;
      DISPLAY.L[1].on=1;  
      SHIFT.mode=3; 


    }


    public void resetControls1() {
      DISPLAY.L[0].on=1;
      DISPLAY.L[1].on=1;
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      SHIFT.L[3].on=1;
      SHIFT.mode=3;

    }



    public void resetControls2() {
	PROJ.L[0].on=1;
      DISPLAY.L[0].on=1;
      DISPLAY.L[1].on=1;
      DISPLAY.L[6].on=1;
      SHIFT.L[3].on=1;
      SHIFT.mode=3;
    }


    public void resetControls3() {
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      SHIFT.L[3].on=1;
      SHIFT.mode=3;
    }

    public void resetControls4() {
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      SHIFT.mode=2;
      SHIFT.L[2].on=1;
    }

    public void resetControls5() {
	
      PROJ.forceMode(1);
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      DISPLAY.L[7].on=1;
      SHIFT.mode=0;
      SHIFT.L[0].on=1;
    }


    public void resetControls6() {
	
	PROJ.forceMode(2);
	PROJ.L[2].on=1;
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      DISPLAY.L[7].on=1;
      SHIFT.mode=0;
      SHIFT.L[0].on=1;
    }


    public void resetControls7() {
	
	PROJ.forceMode(1);
      DISPLAY.L[2].on=1;
      DISPLAY.L[3].on=1;
      DISPLAY.L[7].on=1;
      SHIFT.mode=0;
      SHIFT.L[0].on=1;
    }

    public void resetControls8() {
	PROJ.forceMode(0);
        DISPLAY.L[0].on=1;
        DISPLAY.L[1].on=1;
        SHIFT.mode=3;
        SHIFT.L[3].on=1;
    }










    public void render(Graphics gfx,int mode) {
	if(mode==0) render0(gfx);
	if(mode==1) render1(gfx); 
	if(mode==2) render2(gfx); 
	if(mode==3) render3(gfx);  
	if(mode==4) render4(gfx);   
	if(mode==5) render5(gfx);    
	if(mode==6) render6(gfx);     
	if(mode==7) render7(gfx);     
	if(mode==8) render8(gfx); 
        INFO[0].infoRender(gfx); 
        INFO[1].infoRender(gfx); 
        Graphics2D g=(Graphics2D) gfx;
	TOR.render(g); 
        GRAB.render(g,Color.red);
    }




    public void render0(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      INFO[0].infoRender(g);
    }





    public void render1(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      renderControls(g);
      drawSquares(g);  
       GRAB.render(g,Color.red);
       g.setColor(Color.white);
       g.drawString("grab",X+72,Y+5);  
    }


    public void render2(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      renderControls(g);

    }



    public void render3(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      renderControls(g);
    }


    public void render4(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);  
      IS[1].render(g,Color.red,Color.white,Color.white);
      renderControls(g);
    }



    public void render5(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      IS[2].render(g,Color.red,Color.white,Color.white);
      renderControls(g);
    }


    public void render6(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.black);
      IS[0].render(g,Color.red,Color.white,Color.white);
      IS[5].render(g,new Color(50,100,255),Color.white,Color.white);
      renderControls(g);
      g.setColor(new Color(0,0,0,100));

    }

    public void render7(Graphics gfx) {
	render5(gfx);
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      IS[3].render(g,new Color(50,100,255),Color.white,Color.white);
    }


    public void render8(Graphics gfx) {


      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);  
       renderControls(g);
       IS[4].render2(g,Color.blue,Color.white,Color.white); 
    }

    public void renderControls(Graphics2D g) {
      PROJ.render(g,X+265,Y+245,45);
      SHIFT.render(g,X+195,Y+230,65);
      DISPLAY.render(g,X+212,Y,60);
      drawSquares(g);
    }







   public void drawSquares(Graphics2D g) {

   if(DISPLAY.L[2].on==1) {
     for(int i=0;i<3;++i) {
	  for(int j=0;j<3;++j) {
	      PLUS[i][j].render2(g,PLUS[i][j].C);
	  }
     }
    }

   if(DISPLAY.L[3].on==1) {
     for(int i=0;i<3;++i) {
	  for(int j=0;j<3;++j) {
	      MINUS[i][j].render2(g,MINUS[i][j].C);
	  }
     }
    }


   }






    public static Color getColor(int v1,int v2,int trans,int mode) {
	if(mode==1) return(TorusColors.getColorX(v1,v2,trans));
	if(mode==2) return(TorusColors.getColorY(v1,v2,trans));	
        return(TorusColors.getColorXY(v1,v2,trans));
    }

    public static Color getColorPrint(int v1,int v2) {
        return(TorusColors.getColorPrint(v1,v2));
    }




    public void hearGraph(double A,double t,int[] mm,int[] mp,Manager M) {
	grabShape(M);
	double s=t/2;
        TOR.Z.x=s-Math.floor(s);
	LOCAL[0]=mm[0];
	LOCAL[1]=mm[1];
	LOCAL[2]=mp[0];
	LOCAL[3]=mp[1];
	TOR.setFinal();
 }



    public void embeddingDemo() {

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		PLUS[i][j].on=0;
		MINUS[i][j].on=0;
	    }
	}

	 if(IS[1].val==0) {
	     PLUS[2][0].on=1;
	     MINUS[2][2].on=1;
	 }
	 if(IS[1].val==1) {
	     PLUS[2][2].on=1;
	     MINUS[2][0].on=1;
	 }
	 if(IS[1].val==2) {
	     PLUS[2][0].on=1;
	     PLUS[2][2].on=1;
	 }
	 if(IS[1].val==3) {
	     MINUS[2][2].on=1;
	     MINUS[2][0].on=1;
	 }
    }



    public void hex1Demo() {

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		PLUS[i][j].on=0;
		MINUS[i][j].on=0;
	    }
	}

	 if(IS[2].val==0) {
	     PLUS[0][2].on=1;
	     PLUS[1][2].on=1;
	     PLUS[2][2].on=1;
	     PLUS[0][1].on=1;
	 }
	 if(IS[2].val==1) {
	     MINUS[0][2].on=1;
	     MINUS[1][2].on=1;
	     MINUS[2][2].on=1;
	     MINUS[0][1].on=1;
	 }
    }





    public void hex2Demo() {

	  for(int i=0;i<3;++i) {
	      for(int j=0;j<3;++j) {
	 	 PLUS[i][j].on=0;
	 	 MINUS[i][j].on=0;
	      }
 	 }


	 if(IS[0].val==0) {
	     PLUS[1][0].on=1;
	 }

	 if(IS[0].val==1) {
	     MINUS[1][0].on=1;
	 }

	 if(IS[0].val==2) {
	     PLUS[0][2].on=1;
	 }

	 if(IS[0].val==3) {
	     MINUS[0][2].on=1;
	 }


	 if(IS[0].val==4) {
	     PLUS[0][1].on=1;
	 }

	 if(IS[0].val==5) {
	     MINUS[0][1].on=1;
	 }

	 if(IS[0].val==6) {
	     PLUS[0][0].on=1;
	 }

	 if(IS[0].val==7) {
	     MINUS[0][0].on=1;
	 }


    }















     public void selectProjection(Point X) {
	int proj= PROJ.switchMode(X);
        if(proj==20) DOC.polytope_proj_info();
     }


    public void grabShape(Manager M) {
	TOR.Z.y=M.C.SES.getParameter();
	TOR.setFinal();
    }


    public void colorProcess(Point X,Manager M) {

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(PLUS[i][j].inside(X)==1) PLUS[i][j].C=M.C.CS.C;
		if(MINUS[i][j].inside(X)==1) MINUS[i][j].C=M.C.CS.C;
	    }
	}
    }

    public void selectorProcess(Point X) {
        for(int i=0;i<3;++i) {
	  for(int j=0;j<3;++j) {
	      if(PLUS[i][j].inside(X)==1) PLUS[i][j].on=1-PLUS[i][j].on;
	      if(MINUS[i][j].inside(X)==1) MINUS[i][j].on=1-MINUS[i][j].on;
	  }
	}
    }


    public void mouseProcess(Point X,Manager M,int mode) {
	   DOC.M=M;  
           if(GRAB.inside(X)==1) grabShape(M);
           int tor=TOR.process(X);
	   if(mode==1) mouseProcess1(X,M);
	   if(mode==4) mouseProcess4(X,M);
	   if(mode==5) mouseProcess5(X,M);
	   if(mode==6) mouseProcess6(X,M);
	   if(mode==7) mouseProcess7(X,M);
	   if(mode==8) mouseProcess8(X,M);
	   if(INFO[1].inside(X)==1) DOC.polytope_info();
	   if(INFO[0].inside(X)==1) DOC.polytope_slice_info();
       }

    public void mouseProcess1(Point X,Manager M) {
           int display= DISPLAY.toggle(X);
	   if(display==20) DOC.polytope_display_info();
	   int shift=SHIFT.switchMode(X);
           if(shift==20) DOC.polytope_shift_info(); 
           int proj=PROJ.switchMode(X);
           if(proj==20) DOC.polytope_proj_info();
    }

    public void mouseProcess4(Point X,Manager M) {
	IS[1].modifyCyclic(X);  
	if(IS[1].isModified(X)==1) embeddingDemo();
    }

    public void mouseProcess5(Point X,Manager M) {
	IS[2].modifyCyclic(X);
	if(IS[2].isModified(X)==1) hex1Demo();  	
                   int proj=PROJ.dummy(X);
	if(proj==20) DOC.polytope_slice_info();
    }

    public void mouseProcess6(Point X,Manager M) {
	IS[0].modifyCyclic(X);
	IS[5].modify(X);
	if(IS[0].isModified(X)==1) hex2Demo();  
                   int display= DISPLAY.toggle(X);
	if(display==20) DOC.polytope_display_info(); 
                   int shift=SHIFT.switchMode(X);
                  if(shift==20) DOC.polytope_shift_info(); 
	int proj=PROJ.dummy(X);
	if(proj==20) DOC.polytope_slice_info();

    }

    public void mouseProcess7(Point X,Manager M) {
	IS[2].modifyCyclic(X);
	if(IS[2].isModified(X)==1) hex1Demo();  
	 IS[3].modify(X);
    }

    public void mouseProcess8(Point X,Manager M) {
	 IS[4].modify(X);
    }

}


