import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TorusPartitionMarkings {
    public TorusPartitionMarkings() {}

    public void drawFramePlus(Graphics2D g,Manager M,Color COL) {
	double A= M.PE.A;
      float x=(float)(1+A);
      AffineTransform AT=new AffineTransform();
      GeneralPath gp=new GeneralPath();	
       for(int i=-2;i<=2;++i) {
	for(int j=-2;j<=2;++j) {
	  AT=AffineTransform.getTranslateInstance(i*(1+A)+j*(1-A),j*(1+A));
	  gp.moveTo(0,0);
	  gp.lineTo(0,x);
	  gp.lineTo(x,x);
	  gp.lineTo(x,0);
	  gp.closePath();
	  gp.transform(AT);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(1,0);
	  gp.lineTo(1,x);
	  gp.closePath();
	  gp.transform(AT);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(x-1,0);
	  gp.lineTo(x-1,x);
	  gp.closePath();
	  gp.transform(AT);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(0,1);
	  gp.lineTo(x,1);
	  gp.closePath();
	  gp.transform(AT);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(0,x-1);
	  gp.lineTo(x,x-1);
	  gp.closePath();
	  gp.transform(AT);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);


	}
       }
  }



    public void drawFrameMinus(Graphics2D g,Manager M,Color COL) {

      AffineTransform AA=new AffineTransform();
	double A= M.PE.A;
      int shift=M.C.CON_P.PEC.SHIFT.mode;
          if(shift==0) AA=AffineTransform.getTranslateInstance(2+A,1);
	  if(shift==1) AA=AffineTransform.getTranslateInstance(1,1);
	  if(shift==2) AA=AffineTransform.getTranslateInstance(-1,-1);
	  if(shift==3) AA=AffineTransform.getTranslateInstance(0,0);


      float x=(float)(1+A);
      AffineTransform AT=new AffineTransform();
      GeneralPath gp=new GeneralPath();	
       for(int i=-2;i<=2;++i) {
	for(int j=-2;j<=2;++j) {
	  AT=AffineTransform.getTranslateInstance(i*(1+A)+j*(1-A),j*(1+A));
	  gp.moveTo(0,0);
	  gp.lineTo(0,x);
	  gp.lineTo(x,x);
	  gp.lineTo(x,0);
	  gp.closePath();
	  gp.transform(AT);
	  gp.transform(AA);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(1,0);
	  gp.lineTo(1,x);
	  gp.closePath();
	  gp.transform(AT);  
          gp.transform(AA);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(x-1,0);
	  gp.lineTo(x-1,x);
	  gp.closePath();
	  gp.transform(AT);  
          gp.transform(AA);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(0,1);
	  gp.lineTo(x,1);
	  gp.closePath();
	  gp.transform(AT);  
          gp.transform(AA);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);

          gp.moveTo(0,x-1);
	  gp.lineTo(x,x-1);
	  gp.closePath();
	  gp.transform(AT);  
          gp.transform(AA);
	  gp=M.PE.transform(gp); 
          g.setColor(COL);
          g.draw(gp);



	}
       }
  }



    public void drawCoords(Graphics2D g,Manager M) {
	double A= M.PE.A;
        float a=(float)(A);
        GeneralPath gp=new GeneralPath();
	
	g.setColor(new Color(255,0,255));

	  gp.moveTo(0,-1-a);
	  gp.lineTo(0,1+a);
	  gp=M.PE.transform(gp);
          g.draw(gp); 
	  g.fill(gp);
	  gp.reset();

	  gp.moveTo(-1-a,0);
	  gp.lineTo(1+a,0);
          gp=M.PE.transform(gp);
          g.draw(gp);  
          g.fill(gp);
	  gp.reset();
    }






    public void drawCoordsSpecial(Graphics2D g,Manager M) {
	double A= M.PE.A;
        float a=(float)(A);
        GeneralPath gp=new GeneralPath();
	
	g.setColor(new Color(50,80,240));
	int choice=M.C.CON_P.PEC.IS[2].val;
	  gp.moveTo(0,-1-a);
	  gp.lineTo(0,1+a);
	  gp.moveTo(a,-1-a);
	  gp.lineTo(a,1+a);
	  gp.moveTo(1-a,-1-a);
	  gp.lineTo(1-a,1+a);
	  gp.moveTo(1,-1-a);
	  gp.lineTo(1,1+a);
	  gp.moveTo(1+a,-1-a);
	  gp.lineTo(1+a,1+a);

	  gp=M.PE.transform(gp);
          g.draw(gp); 
	  g.fill(gp);
	  gp.reset();

	  gp.moveTo(-1-a,0);
	  gp.lineTo(1+a,0);
	  gp.moveTo(-1-a,a);
	  gp.lineTo(1+a,a);
	  gp.moveTo(-1-a,1-a);
	  gp.lineTo(1+a,1-a);
	  gp.moveTo(-1-a,1);
	  gp.lineTo(1+a,1);
	  gp.moveTo(-1-a,1+a);
	  gp.lineTo(1+a,1+a);  

          gp=M.PE.transform(gp);
          g.draw(gp);  
          g.fill(gp);
	  gp.reset();





	g.setColor(new Color(255,255,255,100));

	  gp.moveTo(0,0);
	  gp.lineTo(0,1);
	  gp.closePath();
          g.setStroke(new BasicStroke(3));
	  gp=M.PE.transform(gp);
          g.draw(gp); 
	  g.fill(gp);
	  gp.reset();


	  gp.moveTo(a,0);
	  gp.lineTo(0,0);
	  gp.closePath();  
          gp=M.PE.transform(gp);
          g.draw(gp);  
          g.fill(gp);
          g.setStroke(new BasicStroke(1));

          int[] pp=M.C.getParameter();
	  int p=pp[0];
	  int q=pp[1];

	  for(int i=0;i<q+p;++i) {
	      gp.reset();
              gp.moveTo(a,i*a/q);
              gp.moveTo(0,i*a/q);
              gp.closePath();  
              gp=M.PE.transform(gp);
              g.draw(gp);  
              g.fill(gp);
	  }


    }








    public void drawGrid(Graphics2D g,Manager M) {
	GeneralPath gp=new GeneralPath();
	AffineTransform AT=new AffineTransform();	
        double A= M.PE.A;
	for(int i=-13;i<=13;++i) {
	    for(int j=-13;j<=13;++j) {
		AT=AffineTransform.getTranslateInstance(-.5*A+i*(1+A)+j*(1-A),j*(1+A)+.5*A);
	        float AA=(float)(A);
	        gp.moveTo(0,0);
	        gp.lineTo(1+AA,0);
	        gp.lineTo(2,1+AA);
	        gp.lineTo(1-AA,1+AA);
	        gp.closePath();
	        g.setColor(new Color(0,0,0));
		if((i+j)%2==0) g.setColor(new Color(30,30,30));
		gp.transform(AT);  
	        gp=M.PE.transform(gp);
	        g.fill(gp);
		gp.reset();
	    }
	}

    }


    public void drawHexProof(Graphics2D g,Manager M,Output OUT) {

      GeneralPath gp=new GeneralPath();
      int val=M.C.CON_P.PEC.IS[0].val;
      double A=M.PE.A;

      int i=0;
      int j=0;

      if((val==0)||(val==1)) {i=0;j=1;}
      if((val==2)||(val==3)) {i=-1;j=-1;}
      if((val==4)||(val==5)) {i=-1;j=0;}
      if((val==6)||(val==7)) {i=-1;j=1;}

      Color COL=Color.white; 
      COL=M.C.CON_P.getColorAbsolute(i,j,180);
      if(val%2==0)  gp=HexagridDemo.hexParallelogramPlus(i,j,A);
      if(val%2==1)  gp=HexagridDemo.hexParallelogramMinus(i,j,A);
      Color CC=new Color(200,200,200);
      if(M.C.EXPORT.mode==1) OUT.lineWrite(gp,Color.black);

      gp=M.PE.transform(gp);
      g.setColor(COL);
      g.fill(gp);
      g.draw(gp);

      if(val%2==0)  gp=HexagridDemo.hexRectanglePlus1(i,j,A);
      if(val%2==1)  gp=HexagridDemo.hexRectangleMinus1(i,j,A);  
      gp=M.PE.transform(gp);
      g.draw(gp);

      if(val%2==0)  gp=HexagridDemo.hexRectanglePlus2(i,j,A);
      if(val%2==1)  gp=HexagridDemo.hexRectangleMinus2(i,j,A);  
      gp=M.PE.transform(gp);
      g.draw(gp);

    }



    public void drawLatticeImage(Graphics2D g,Manager M) {
	int mode=M.C.CON_P.getSlice();
	if(mode==0) drawLatticeImage0(g,M);
	if(mode==2) drawLatticeImage2(g,M);
    }


    public Complex getPointSlice(int i,int j,Manager M) {
	double A=M.PE.A;
	double current=M.PE.current;
	Complex z=new Complex();
	z=TorusMap.phiPlus(A,current);
	double u1=j*(1-A)+i*(1+A);
	double u2=j*(1+A);
	Complex w=z.plus(new Complex(u1,u2));
	return(w);
    }



    public void drawLatticeImage0(Graphics2D g,Manager M) {
	double d=.01;
	GeneralPath gp=new GeneralPath();
	Complex z=new Complex();
	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {	
		z=getPointSlice(i,j,M);
		makePoint(g,z,.01,Color.white,M);
	    }
	}
    }



    public void drawLatticeImage3(Graphics2D g,Manager M) {
	Complex z=getFloorPlus(M);
	makePoint(g,z,.02,new Color(255,200,0),M);
	z=getFloorMinus(M);
	makePoint(g,z,.02,new Color(80,140,255),M);
    }





    public void drawLatticeImage2(Graphics2D g,Manager M) {
	Complex z=getHexPlus(M);
	makePoint(g,z,.02,new Color(255,200,0),M);
	z=getHexMinus(M);
	makePoint(g,z,.02,new Color(80,140,255),M);
    }



    public void makePoint(Graphics2D g,Complex z,double d,Color C,Manager M) {
        GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(z.x-d),(float)(z.y-d));
	gp.lineTo((float)(z.x-d),(float)(z.y+d));
	gp.lineTo((float)(z.x+d),(float)(z.y+d));
	gp.lineTo((float)(z.x+d),(float)(z.y-d));
	gp.closePath();
	gp=M.PE.transform(gp);	
        g.setColor(C);
        g.fill(gp);
        g.draw(gp);
    }




    public Complex getHexPlus(Manager M) {
	double A=M.PE.A;
	Complex SOURCE=M.R.SOURCE;
	double m=SOURCE.x;
	double n=SOURCE.y;
	double x=2*A-m*(1+2*A)+2*A*n+A*Math.floor(A*m);
	double y=m*A-Math.floor(m*A);
	return(new Complex(x,y));
    }


    public Complex getHexMinus(Manager M) {
	double A=M.PE.A;
	Complex SOURCE=M.R.SOURCE;
	double m=SOURCE.x;
	double n=SOURCE.y;	
        double x=A-m*(1+2*A)+2*A*n+A*Math.floor(A*m);
	double y=m*A-Math.floor(m*A);
	return(new Complex(x,y));
    }




    public Complex getFloorPlus(Manager M) {
	double A=M.PE.A;
	Complex SOURCE=M.R.SOURCE;
	double m=SOURCE.x;
	double n=SOURCE.y;
	double[] d=TorusMap.phiPlus3D(A,m,n);
	double x=d[0];
	double y=(d[1]+d[2])/2.0;
	return(new Complex(x,y));
    }


    public Complex getFloorMinus(Manager M) {
	double A=M.PE.A;
	Complex SOURCE=M.R.SOURCE;
	double m=SOURCE.x;
	double n=SOURCE.y;
	double[] d=TorusMap.phiMinus3D(A,m,n);
	double x=d[0];
	double y=(d[1]+d[2])/2.0;
	return(new Complex(x,y));
    }










}