import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class stores the polytopes for our master picture*/

public class TorusPolytopes {
    Polytope[] P=new Polytope[40];
    Polytope[] Q=new Polytope[8];
    Polytope[] S=new Polytope[8];

    public TorusPolytopes() {
	setPolytopes();
    }

    public void printAll() {
	Output OUT=new Output("temp");
	for(int i=0;i<24;++i) {
	    P[i].print(OUT);
	}
    }


    public void setPolytopes() {

	//magenta
	P[0]=new Polytope();
	P[0].count=8;
	P[0].V[0]=new Vector4(0,0,0,0);
	P[0].V[1]=new Vector4(0,1,0,0);
	P[0].V[2]=new Vector4(0,1,0,1);
	P[0].V[3]=new Vector4(0,2,0,1);
	P[0].V[4]=new Vector4(0,2,1,1);
	P[0].V[5]=new Vector4(1,1,0,1);
	P[0].V[6]=new Vector4(1,1,1,1);
	P[0].V[7]=new Vector4(1,2,1,1);
	P[0].type[0]=0;
	P[0].type[1]=-1;
	P[0].type[2]=1;

	//orange
	P[1]=new Polytope();
	P[1].count=9;
	P[1].V[0]=new Vector4(0,0,0,0);
	P[1].V[1]=new Vector4(0,0,0,1);
	P[1].V[2]=new Vector4(0,0,1,0);
	P[1].V[3]=new Vector4(0,1,0,1);
	P[1].V[4]=new Vector4(0,1,1,1);
	P[1].V[5]=new Vector4(1,0,0,1);
	P[1].V[6]=new Vector4(1,0,1,0);
	P[1].V[7]=new Vector4(1,0,1,1);
	P[1].V[8]=new Vector4(1,1,1,1);
	P[1].type[0]=0;
	P[1].type[1]=1;
	P[1].type[2]=1;


	//dark red
	P[2]=new Polytope();
	P[2].count=6;
	P[2].V[0]=new Vector4(0,1,0,0);
	P[2].V[1]=new Vector4(0,1,1,0);
	P[2].V[2]=new Vector4(1,1,1,0);
	P[2].V[3]=new Vector4(1,1,1,1);
	P[2].V[4]=new Vector4(1,2,1,1);
	P[2].V[5]=new Vector4(2,1,1,1);
	P[2].type[0]=0;
	P[2].type[1]=-1;
	P[2].type[2]=-1;

	//light green 1
	P[3]=new Polytope();
	P[3].count=8;
	P[3].V[0]=new Vector4(0,1,0,0);
	P[3].V[1]=new Vector4(0,2,0,1);
	P[3].V[2]=new Vector4(1,0,0,0);
	P[3].V[3]=new Vector4(1,1,0,0);
	P[3].V[4]=new Vector4(1,1,0,1);
	P[3].V[5]=new Vector4(1,1,1,0);
	P[3].V[6]=new Vector4(1,2,0,1);
	P[3].V[7]=new Vector4(1,2,1,1);
	P[3].type[0]=0;
	P[3].type[1]=0;
	P[3].type[2]=1;


	//light green 2
	P[4]=new Polytope();
	P[4].count=8;
	P[4].V[0]=new Vector4(0,0,0,0);
 	P[4].V[1]=new Vector4(0,0,1,0);
	P[4].V[2]=new Vector4(0,1,0,1);
	P[4].V[3]=new Vector4(0,1,1,0);
	P[4].V[4]=new Vector4(0,1,1,1);
	P[4].V[5]=new Vector4(0,2,1,1);
	P[4].V[6]=new Vector4(1,0,1,0);
	P[4].V[7]=new Vector4(1,1,1,1);
	P[4].type[0]=0;
	P[4].type[1]=0;
	P[4].type[2]=1;



	//light green 3
	P[5]=new Polytope();
	P[5].count=5;
	P[5].V[0]=new Vector4(0,0,0,0);
	P[5].V[1]=new Vector4(0,1,0,1);
	P[5].V[2]=new Vector4(1,0,0,1);
	P[5].V[3]=new Vector4(1,1,0,1);
	P[5].V[4]=new Vector4(1,1,1,1);
	P[5].type[0]=0;
	P[5].type[1]=0;
	P[5].type[2]=1;


	//light green 4
	P[6]=new Polytope();
	P[6].count=5;
	P[6].V[0]=new Vector4(0,0,0,1);
	P[6].V[1]=new Vector4(0,0,1,0);	
        P[6].V[2]=new Vector4(0,0,1,1);
	P[6].V[3]=new Vector4(0,1,1,1);
	P[6].V[4]=new Vector4(1,0,1,1);
	P[6].type[0]=0;
	P[6].type[1]=0;
	P[6].type[2]=1;


	//light blue 1
	P[7]=new Polytope();
	P[7].count=6;
	P[7].V[0]=new Vector4(0,0,0,0);
	P[7].V[1]=new Vector4(0,1,0,0);
	P[7].V[2]=new Vector4(0,1,1,0);
	P[7].V[3]=new Vector4(0,2,1,1);
	P[7].V[4]=new Vector4(1,1,1,1);
	P[7].V[5]=new Vector4(1,2,1,1);
	P[7].type[0]=0;
	P[7].type[1]=-1;
	P[7].type[2]=0;


	//light blue 2
	P[8]=new Polytope();
	P[8].count=5;
	P[8].V[0]=new Vector4(1,1,0,0);
	P[8].V[1]=new Vector4(1,2,0,1);
	P[8].V[2]=new Vector4(2,1,0,1);
	P[8].V[3]=new Vector4(2,2,0,1);
	P[8].V[4]=new Vector4(2,2,1,1);
	P[8].type[0]=0;
	P[8].type[1]=-1;
	P[8].type[2]=0;


	//light blue 3
	P[9]=new Polytope();
	P[9].count=5;
	P[9].V[0]=new Vector4(0,1,0,0);
	P[9].V[1]=new Vector4(1,1,0,1);
	P[9].V[2]=new Vector4(1,1,1,1);
	P[9].V[3]=new Vector4(1,2,1,1);
	P[9].V[4]=new Vector4(2,1,1,1);
	P[9].type[0]=0;
	P[9].type[1]=-1;
	P[9].type[2]=0;


	//dark blue 1
	P[10]=new Polytope();
	P[10].count=7;
	P[10].V[0]=new Vector4(1,0,0,0);
	P[10].V[1]=new Vector4(1,1,0,0);
	P[10].V[2]=new Vector4(1,1,0,1);
	P[10].V[3]=new Vector4(1,1,1,0);
	P[10].V[4]=new Vector4(2,0,0,1);
	P[10].V[5]=new Vector4(2,1,0,1);
	P[10].V[6]=new Vector4(2,1,1,1);
	P[10].type[0]=0;
	P[10].type[1]=1;
	P[10].type[2]=0;



	//dark blue 2
	P[11]=new Polytope();
	P[11].count=5;
	P[11].V[0]=new Vector4(1,0,0,1);
	P[11].V[1]=new Vector4(1,0,1,0);
	P[11].V[2]=new Vector4(1,0,1,1);
	P[11].V[3]=new Vector4(1,1,1,1);
	P[11].V[4]=new Vector4(2,0,1,1);
	P[11].type[0]=0;
	P[11].type[1]=1;
	P[11].type[2]=0;



	//grey
	P[12]=new Polytope();
	P[12].count=12;
	P[12].V[0]=new Vector4(0,0,0,0);
	P[12].V[1]=new Vector4(0,1,0,0);
	P[12].V[2]=new Vector4(0,1,1,0);
	P[12].V[3]=new Vector4(1,0,0,0);
	P[12].V[4]=new Vector4(1,0,0,1);
	P[12].V[5]=new Vector4(1,0,1,0);
	P[12].V[6]=new Vector4(1,1,0,1);
	P[12].V[7]=new Vector4(1,1,1,0);
	P[12].V[8]=new Vector4(1,1,1,1);
	P[12].V[9]=new Vector4(2,0,0,1);
	P[12].V[10]=new Vector4(2,0,1,1);
	P[12].V[11]=new Vector4(2,1,1,1);
	P[12].type[0]=0;
	P[12].type[1]=0;
	P[12].type[2]=0;


	//grey
	P[13]=new Polytope();
	P[13].count=8;
	P[13].V[0]=new Vector4(1,1,0,0);
	P[13].V[1]=new Vector4(1,1,0,1);
	P[13].V[2]=new Vector4(1,1,1,0);
	P[13].V[3]=new Vector4(1,2,0,1);
	P[13].V[4]=new Vector4(1,2,1,1);
	P[13].V[5]=new Vector4(2,1,0,1);
	P[13].V[6]=new Vector4(2,1,1,1);	
        P[13].V[7]=new Vector4(2,2,1,1);
	P[13].type[0]=0;
	P[13].type[1]=0;
	P[13].type[2]=0;


	for(int i=14;i<28;++i) {
	    P[i]=Polytope.reflect(P[i-14]);
	}






	/*The Q polyhedra are used in the proof of the
          Hexagrid Statement 1.*/



	Q[0]=new Polytope();
	Q[0].count=8;
	Q[0].V[0]=new Vector4(0,0,0,0);
	Q[0].V[1]=new Vector4(0,0,0,1);
	Q[0].V[2]=new Vector4(0,1,1,0);
	Q[0].V[3]=new Vector4(0,2,2,1);
	Q[0].V[4]=new Vector4(2,0,0,0);
	Q[0].V[5]=new Vector4(2,0,0,1);
	Q[0].V[6]=new Vector4(2,1,1,0);
	Q[0].V[7]=new Vector4(2,2,2,1);
	Q[0].type[0]=1;
	Q[0].type[1]=-1;
	Q[0].type[2]=-1;


	Q[1]=new Polytope();
	Q[1].count=6;
	Q[1].V[0]=new Vector4(0,0,0,0);
	Q[1].V[1]=new Vector4(0,0,0,1);
	Q[1].V[2]=new Vector4(0,1,1,1);
	Q[1].V[3]=new Vector4(2,0,0,0);
	Q[1].V[4]=new Vector4(2,0,0,1);
	Q[1].V[5]=new Vector4(2,1,1,1);
	Q[1].type[0]=1;
	Q[1].type[1]=-1;
	Q[1].type[2]=0;



	Q[2]=new Polytope();
	Q[2].count=8;
	Q[2]=new Polytope();
	Q[2].count=8;
	Q[2].V[0]=new Vector4(0,0,0,0);
	Q[2].V[1]=new Vector4(0,0,0,1);
	Q[2].V[2]=new Vector4(0,1,1,0);
	Q[2].V[3]=new Vector4(0,1,1,1);
	Q[2].V[4]=new Vector4(2,0,0,0);
	Q[2].V[5]=new Vector4(2,0,0,1);
	Q[2].V[6]=new Vector4(2,1,1,0);
	Q[2].V[7]=new Vector4(2,1,1,1);
	Q[2].type[0]=1;
	Q[2].type[1]=0;
	Q[2].type[2]=-1;

	Q[3]=new Polytope();
	Q[3].count=6;
	Q[3].V[0]=new Vector4(0,0,0,0);
	Q[3].V[1]=new Vector4(0,0,0,1);
	Q[3].V[2]=new Vector4(0,1,1,0);
	Q[3].V[3]=new Vector4(2,0,0,0);
	Q[3].V[4]=new Vector4(2,0,0,1);
	Q[3].V[5]=new Vector4(2,1,1,0);
	Q[3].type[0]=1;
	Q[3].type[1]=1;
	Q[3].type[2]=-1;


	for(int i=4;i<8;++i) {
             Q[i]=Polytope.shift(new Vector4(1,1,0,0),Q[i-4]);
	     Q[i].type[0]=0;
	}









	/* These polytopes are used for the proof of Statement 2
           of the hexagrid theorem. THey are described in
           the last chapter of Part III of the book. */


	//on top

	S[0]=new Polytope();
	S[0].count=4;
	S[0].V[0]=new Vector4(0,0,1,0);  
	S[0].V[1]=new Vector4(0,0,0,0);    
	S[0].V[2]=new Vector4(0,1,1,1);
	S[0].V[3]=new Vector4(2,-1,1,1);
	S[0].type[1]=0;
	S[0].type[2]=1;

	//on bottom

	S[1]=new Polytope();
	S[1].count=5;
	S[1].V[0]=new Vector4(0,0,0,0);  
	S[1].V[1]=new Vector4(0,1,0,1);    
	S[1].V[2]=new Vector4(0,1,1,1);
	S[1].V[3]=new Vector4(2,-1,0,1);
	S[1].V[4]=new Vector4(2,-1,1,1);    
	S[1].type[1]=0;
	S[1].type[2]=1;


	//on top

	S[2]=new Polytope();
	S[2].count=6;
	S[2].V[0]=new Vector4( -1,1,0,0);  
	S[2].V[1]=new Vector4(-1,1,1,0);    
	S[2].V[2]=new Vector4( 0,0,0,0);
	S[2].V[3]=new Vector4( 0,0,1,0);
	S[2].V[4]=new Vector4(0,1,1,1);
	S[2].V[5]=new Vector4(2,-1,1,1);    
	S[2].type[1]=-1;
	S[2].type[2]=-1;

	//on bottom

	S[3]=new Polytope();
	S[3].count=6;
	S[3].V[0]=new Vector4( -1,1,0,0);  
	S[3].V[1]=new Vector4(0,0,0,0);    
	S[3].V[2]=new Vector4(1,0,0,1);
	S[3].V[3]=new Vector4(1,0,1,1);
	S[3].V[4]=new Vector4(2,-1,0,1);
	S[3].V[5]=new Vector4(2,-1,1,1);    
	S[3].type[1]=-1;
	S[3].type[2]=-1;

	//on top

	S[4]=new Polytope();
	S[4].count=6;
	S[4].V[0]=new Vector4(-1,1,0,0);  
	S[4].V[1]=new Vector4(-1,1,1,0);    
	S[4].V[2]=new Vector4( 0,0,0,0);
	S[4].V[3]=new Vector4( 0,0,1,0);
	S[4].V[4]=new Vector4(-2,3,1,1);
	S[4].V[5]=new Vector4(2,-1,1,1);    
	S[4].type[1]=-1;
	S[4].type[2]=0;

	//on bottom

	S[5]=new Polytope();
	S[5].count=6;
	S[5].V[0]=new Vector4( -1,1,0,0);  
	S[5].V[1]=new Vector4(0,0,0,0);    
	S[5].V[2]=new Vector4(-1,2,0,1);
	S[5].V[3]=new Vector4(-1,2,1,1);
	S[5].V[4]=new Vector4(2,-1,0,1);
	S[5].V[5]=new Vector4(2,-1,1,1);    
	S[5].type[1]=-1;
	S[5].type[2]=0;



	//on top

	S[6]=new Polytope();
	S[6].count=6;
	S[6].V[0]=new Vector4( -1,1,0,0);  
	S[6].V[1]=new Vector4(-1,1,1,0);    
	S[6].V[2]=new Vector4( 0,0,0,0);
	S[6].V[3]=new Vector4( 0,0,1,0);
	S[6].V[4]=new Vector4(-4,5,1,1);
	S[6].V[5]=new Vector4(-2,-1,1,1);    
	S[6].type[1]=-1;
	S[6].type[2]=1;


	//on bottom

	S[7]=new Polytope();
	S[7].count=6;
	S[7].V[0]=new Vector4( -1,1,0,0);  
	S[7].V[1]=new Vector4(0,0,0,0);    
	S[7].V[2]=new Vector4(-3,4,0,1);
	S[7].V[3]=new Vector4(-3,4,1,1);
	S[7].V[4]=new Vector4(2,-1,0,1);
	S[7].V[5]=new Vector4(2,-1,1,1);    
	S[7].type[1]=-1;
	S[7].type[2]=1;

    }


    public Polytope getStrip(int t1,int t2,int parity) {
	for(int i=0;i<8;++i) {
	    if((i%2==parity)&&(t1==S[i].type[1])&&(t2==S[i].type[2])) return(S[i]);
	}
	return(null);
    }



}



