import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

import java.awt.geom.*;
import java.math.*;



public class ArithmeticGraph extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    AffineTransform[] A=new AffineTransform[5];
    Complex SOURCE;
    PenrosePartitionCanvas RT;
    ComputeArithmeticGraph AGC;
    PenroseComputeGraph PC;
    Documentation DOC;
    Output OUT; 

    Point JX;
    ListenSquare[] ACTION=new ListenSquare[6];
    Complex MOVE;

    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[3];
    ListenSquare[] L=new ListenSquare[3];  
    SelectInteger[] IS=new SelectInteger[3];

    Color[] COLOR=new Color[1000];
    GeneralPath[] GP=new GeneralPath[1000];
    GeneralPath SHADOW,GPMARKER;

    int SELECT=-1;
    int type=3;
    int count=0;
    ListenSquare INFO;

    public ArithmeticGraph addManager(Manager M) {
	ArithmeticGraph XX=this;
	XX.M=M;
	return(XX);
    }



    public ArithmeticGraph() {
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
	RT=new PenrosePartitionCanvas();
	DOC=new Documentation();

        SOURCE=new Complex(0,0);

	L[0]=new ListenSquare(0,0,80,18,Color.white); L[0].on=1;
	INFO=new ListenSquare(0,0,12,12,Color.black);

	setScales();
	makePointConsole();
	makeMotionConsole();
    }





    public void setScales() {
	 A[0]=AffineTransform.getTranslateInstance(230,330);
         A[1]=AffineTransform.getScaleInstance(10,-10); 
    }



    public void makePointConsole() {
	 I[0]=new SelectIntegerKeyboard(15,2,40,14,0,10000);    //Xcoord
	 I[1]=new SelectIntegerKeyboard(115,2,40,14,0,10000);    //Ycoord
	 IS[0]=new SelectInteger(60,2,30,14,0,-10000,10000,1);    //Xcoord backup
	 IS[1]=new SelectInteger(160,2,30,14,0,-10000,10000,1);    //Ycoord backup
    }

    public void makeMotionConsole() {

	 ACTION[0]=new ListenSquare(230,2,13,13,Color.white);
	 ACTION[0].on=1;

	 ACTION[1]=new ListenSquare(300,2,13,13,Color.white);
	 ACTION[1].on=1;


	 ACTION[2]=new ListenSquare(370,2,13,13,Color.white);
	 ACTION[2].on=1;




	 SHADOW=new GeneralPath();
    }





    public void paint(Graphics gfx) {
      OUT=new Output("Output/graph_markings");
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      //background
      g.setColor(Color.black);
      try {g.setColor(M.C.CON_G.BASIC.M[4].C);} catch(Exception e) {}
      g.fillRect(0,0,this.getWidth(),this.getHeight());

      //auxilliary markings
      try {drawMarkings(g);}
      catch(Exception e) {}
      
      int mode=0;
      try {if((M.C.GLOBAL.mode==2)) mode=1;}
      catch(Exception e) {}
      if(mode==0) drawPath(g); 
      if(mode==1) drawPathEnhanced(g);

      drawControls(g);
      drawSource(g);  
      INFO.infoRender(g);
    }




    /**drawing routines */


    /**These are all the auxilliary markings.*/

      public void drawMarkings(Graphics2D g) {

          if(M.C.CON_G.BASIC.L[0].on==1) ArithmeticGraphMarkings.drawAxesGraph(g,M,OUT);
	  if(M.C.CON_G.BASIC.L[1].on==1) ArithmeticGraphMarkings.drawGridGraph(g,M,OUT);
          if(M.C.CON_G.BASIC.L[2].on==1) ArithmeticGraphMarkings.drawHalfplaneGraph(g,M,OUT);
	  if(M.C.CON_G.BASIC.L[3].on==1) ArithmeticGraphMarkings.drawHalflineGraph(g,M,OUT);
	  if(M.C.CON_G.BASIC.L[5].on==1) ArithmeticGraphMarkings.drawMagicPoints(g,M);
	  if(M.C.EXPORT.mode==1) OUT.tclBgSet(M.C.CON_G.BASIC.M[4].C);
      }






    /**this is the general routine*/

    public void drawPath(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	  g.setColor(COLOR[i]);
          g.setStroke(new BasicStroke((float)(3)));
	  gp=new GeneralPath(GP[i]);
          gp=transform(gp);
	  g.setColor(COLOR[i]);
	  g.draw(gp);
	}
        g.setStroke(new BasicStroke(1));
    }




    /**this works with the penrose kite*/

    public void drawPathEnhanced(Graphics2D g) {

	GeneralPath gp=new GeneralPath();

	for(int i=0;i<count;++i) {
	  g.setColor(new Color(50,120,255));
	  gp=new GeneralPath(GP[i]);
          gp=transform(gp);
	  g.draw(gp);
	}

	int mode=0;
	try {
	    mode=M.C.CON_X.SEQS.mode;
	}
	catch(Exception e) {}

	if(mode==1) {
	    AffineTransform AF=AffineTransform.getScaleInstance(Math.sqrt(5)+2,Math.sqrt(5)+2);
	for(int i=0;i<count;++i) {
	  g.setColor(Color.red);
	  gp=new GeneralPath(GP[i]);
	  gp.transform(AF);
          gp=transform(gp);
	  g.draw(gp);
	}

	if(GPMARKER!=null) gp=new GeneralPath(GPMARKER);
	GeneralPath gp2=new GeneralPath(gp);
          gp.transform(AF);
          gp=transform(gp);
	  gp2=transform(gp2);
	  g.setColor(Color.green);
	  g.draw(gp);
          g.draw(gp2);
	}

	gp=new GeneralPath(SHADOW);
	g.setColor(Color.white);
        gp=transform(gp);
	g.draw(gp);
    }


    public void drawControls(Graphics2D g) {
	L[0].w=getWidth()-1;
	L[0].render(g,Color.blue);
        for(int i=0;i<2;++i)  I[i].render(g,new Color(200,0,200),Color.black,Color.yellow,Color.white);
	for(int i=0;i<2;++i) IS[i].render(g,new Color(200,0,200),Color.white,new Color(0,0,0,0));
	g.setColor(Color.white);  
        g.setFont(new Font("Helvetica",Font.PLAIN,10));	
	g.setColor(Color.white);


	ACTION[0].render(g,new Color(200,0,200));	
        g.drawString("inflate",250,13);
	ACTION[1].render(g,new Color(200,0,200));	
        g.drawString("delete",320,13);

    }


  public void drawSource(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	float x=(float)(SOURCE.x);
	float y=(float)(SOURCE.y);
	gp.moveTo((float)(x-.5),(float)(y-.5));
	gp.lineTo((float)(x-.5),(float)(y+.5));
	gp.lineTo((float)(x+.5),(float)(y+.5));
	gp.lineTo((float)(x+.5),(float)(y-.5));
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.yellow);
	g.draw(gp);
  }


    /**output to TCL file*/

    public void savePath() {
	Output temp=new Output("Output/graph");
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	    gp=new GeneralPath(GP[i]);
	    temp.lineWrite(gp,COLOR[i]);
	}
    }



    /**scaling routines */

    public GeneralPath transform(GeneralPath H) {
	GeneralPath HH=new GeneralPath(H);
	HH.transform(A[1]);   //scale
	HH.transform(A[0]);   //translate
	return(HH);
    }

    public Complex unTransform(Point X) {
	double ux=A[0].getTranslateX();
       double uy=A[0].getTranslateY();
       double tx=X.x;
       double ty=X.y;
       double sx=A[1].getScaleX();
       double sy=A[1].getScaleY();
       ux=(ux-tx)+tx;
       uy=(uy-ty)+ty;
       tx=tx-ux;
       ty=ty-uy;
       tx=tx/sx;
       ty=ty/sy;
       return(new Complex(tx,ty));
    }

    public void scaleUp(Point X,int k) {
	double scale=Math.pow(2,.25);
	double ss=scale;
	if(k==1) ss=1/scale;
	double sx=A[1].getScaleX();
	double sy=A[1].getScaleY();
	double tx=X.x;
	double ty=X.y;
	double ux0=A[0].getTranslateX();
	double uy=A[0].getTranslateY();
	double ux1=ss*(ux0-tx)+tx;
	uy=ss*(uy-ty)+ty;
	sx=sx*ss;
        sy=sy*ss;
	A[1]=AffineTransform.getScaleInstance(sx,sy);
	A[0]=AffineTransform.getTranslateInstance(ux1,uy);
    }

    /**done with scaling routines */


    public void selectPoint(Point X) {

	//integer valued selection
        MOVE=unTransform(X);
	MOVE.x=1*Math.floor(MOVE.x+.5);
	MOVE.y=1*Math.floor(MOVE.y+.5);


	int test=-1;
	for(int i=0;i<count;++i) {
	    if(GP[i].intersects(MOVE.x-2,MOVE.y-2,4,4)==true) test=i;
	}	

	  I[0].val=(int)(MOVE.x);
	  I[1].val=(int)(MOVE.y);
	  IS[0].val=(int)(MOVE.x);
	  IS[1].val=(int)(MOVE.y);
	  SOURCE=new Complex(MOVE);
	  if(test!=-1) SELECT=test;
	  doType();
    }



    /**communicate with polygon exchange window*/

    public void doType() {
	  type=M.RT.classify(I[0].val,I[1].val);
	  M.RT.X=I[0].val;
          M.RT.Y=I[1].val;
    }


    /*add new path to list: invoked by the arithmetic graph computer*/

    public void nextPathLast(GeneralPath X) {
       GP[count]=new GeneralPath(X);
       COLOR[count]=M.C.CS.C;
       ++count;
    }


    /**invoked by penrose computer during shadowing routine*/

    public void setMarker(GeneralPath X) {
	GPMARKER=new GeneralPath(X);
    }


    /*deleting, dilating  stuff*/

    public void alterGraph(Point X) {

	//dilate
	if(ACTION[0].inside(X)==1) {
            AffineTransform TRANS=AffineTransform.getScaleInstance(Math.sqrt(5)+2,Math.sqrt(5)+2);
	    try{GP[SELECT].transform(TRANS);}
	    catch(Exception e){}
	}

	//delete
	if(ACTION[1].inside(X)==1) {
	    try{GP[SELECT].reset();}
	    catch(Exception e){}
	}
    }




    /******************do the computation! ********************/

    public void iterate() {
    	   AGC=new ComputeArithmeticGraph(M.P.QUAD.z[2].x,SOURCE,M);
           new Thread(AGC).start();
    }
    /**********************************************************/



    /**mouse events */
   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}


   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       DOC.M=this.M;
       MouseData J=MouseData.process(e,M.C.MOUSE.mode);
       doMouseClick(J.X,J.mode);
   }

   public void mouseMoved(MouseEvent e) {
       try {MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	   JX=J.X; }
       catch (Exception ee) {}
   }


   public void doMouseClick(Point X,int mode) {
       int test=L[0].inside(X);

       //click inside top rim
       if(test==1) {
          if(INFO.inside(X)==1) DOC.arithmeticGraphInfo();
          for(int i=0;i<2;++i) IS[i].modify(X);
          I[0].val=IS[0].val;
          I[1].val=IS[1].val;  
          doType();	
          SOURCE=new Complex(I[0].val,I[1].val);

          for(int i=0;i<2;++i) {
	  I[i].on=0;
	  if(I[i].inside(X)==1) I[i].on=1;
	  }
          alterGraph(X);
       }


       //click outside top rim
       if(test==0) {
         if(mode==1)  scaleUp(X,0);
         if(mode==3)  scaleUp(X,1);
         if((M.C.EXPORT.mode==0)&&(mode==2))  selectPoint(X);
         if((M.C.EXPORT.mode==1)&&(mode==2))  savePath();
       }

       repaint();
       M.C.repaint();
       M.RT.repaint();
       M.RC.repaint();
   }


/**done with mouse events*/




/**key events */

    public void keyTyped(KeyEvent e) {

	for(int i=0;i<2;++i) {
	    if(I[i].on==1) I[i].modifySign(e);
	    IS[i].val=I[i].val;
	}
        repaint();

	SOURCE=new Complex(I[0].val,I[1].val);
	char ch=e.getKeyChar();
	int test=0;
	if(ch=='b') test=1;
	if(ch=='n') test=2;
	if(ch=='m') test=3;
	if(test>0) doMouseClick(JX,test);

	if(ch=='h') forceForward();
	if(ch=='j') forceBackward();
    }
 
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

    public void forceForward() {
	M.C.CON_G.AGC.AGP.mode=0;
	M.R.iterate();
    }

    public void forceBackward() {
	M.C.CON_G.AGC.AGP.mode=1;
 	M.R.iterate();
    }

/**done with key events */


}
