import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeArithmeticGraph implements Runnable {
    Manager M;
    Quad QUAD;  
    Complex SOURCE;
    int halt;
    int export;
    Output writer;
    double A;
    int[] LIST=new int[1000000];

    public ComputeArithmeticGraph() {
    }

    public ComputeArithmeticGraph(double a,Complex z,Manager MM) {
	this.A=a;
	this.SOURCE=new Complex(z.x,z.y);
	this.M=MM;
    }


    public void run() {
	int a2=M.C.CON_G.AGC.AGP.mode;
	  if(a2<=1)  orbitPlot();         //orbit regular
     	  if(a2==2)  blockPlot();         //block plot
    }

    public void sendMessage(int c) {
           if((c>0)&&(c%100==0)) {
	      Integer COUNT=new Integer(c);
	      M.C.PROGRESS=COUNT.toString();
	      M.C.repaint();
	   }
    }

    public void sendMessage2(int c) {
	      Integer COUNT=new Integer(c);
	      M.C.PROGRESS=COUNT.toString();
	      M.C.repaint();
    }




    public double toDouble(int x,int y,double AA) {

	double aa=M.C.CON_G.AGC.getOffset();
       	return(2*AA*x+2*y+aa+.00000001);
    }


    public Complex toComplex(ArithmeticPoint P,double AA) {
	double d=toDouble(P.m,P.n,AA);
	Complex z=new Complex(d,P.y);
	return(z);
    }

    public ArithmeticPoint firstReturnDirected(ArithmeticPoint P,double AA,int direction) {
	if(direction==0) return(firstReturn(P,AA));
	return(firstReturnBackwards(P,AA));
    }


    public ArithmeticPoint firstReturn(ArithmeticPoint P,double AA) {
	PinwheelMap RM=new PinwheelMap(AA);
        int[] ret=new int[3];
	Complex z=toComplex(P,AA);
	ret=RM.doReturnIntegral(z);
	ArithmeticPoint Q=new ArithmeticPoint();
	Q.m=ret[0]+P.m;
	Q.n=ret[1]+P.n;
	Q.y=ret[2];
	return(Q);
    }


    public ArithmeticPoint firstReturnBackwards(ArithmeticPoint P,double AA) {
	PinwheelMap RM=new PinwheelMap(AA);
        int[] ret=new int[3];
	ArithmeticPoint PP=new ArithmeticPoint(P);
	PP.y=-P.y;
	Complex z=toComplex(PP,AA);
	ret=RM.doReturnIntegral(z);
	ArithmeticPoint Q=new ArithmeticPoint();
	Q.m=ret[0]+P.m;
	Q.n=ret[1]+P.n;
       	Q.y=-ret[2];
	return(Q);
    }



    /***********plotting routines**********/



    public void orbitPlot() {
	/*initialize point*/
	int direction=M.C.CON_G.AGC.AGP.mode;
	ArithmeticPoint P=new ArithmeticPoint(SOURCE);
	int parity=(P.m+P.n+100000)%2;
	P.y=-1.0;
	if(parity==1)	P.y=1.0;

	ArithmeticPoint P1=new ArithmeticPoint(P);
	ArithmeticPoint P2=new ArithmeticPoint(P);

	double LIM=Math.pow(2,M.C.CON_G.AGC.INT[0].val);
	halt=1;
        GeneralPath gp=new GeneralPath();
	int count=0;

       	while((halt==1)&&(count<LIM)) {
	    P2=firstReturnDirected(P1,A,direction);
            gp.moveTo(P1.m,P1.n);
	    gp.lineTo(P2.m,P2.n);
	    P1=new ArithmeticPoint(P2);
	    if(P2.testSame(P2,P)==1) halt=0;
	    sendMessage(count);
	    ++count;
	}

	halt=0;
	M.R.nextPathLast(gp);
	M.R.repaint();
    }


    public void blockPlot() {	
	int i2=(int)(SOURCE.x);	
	int j2=(int)(SOURCE.y);
	M.RT.plot_count=0;
	int type=0;
	int LIM1=(int)(Math.pow(2,M.C.CON_G.AGC.INT[1].val));
	int LIM2=-LIM1;
	int DEP=(int)(Math.pow(2,M.C.CON_G.AGC.INT[0].val));
	ArithmeticGraphLocal L;
	double A=Math.sqrt(5.0)-2.0;

	halt=1;
	int count=0;
	GeneralPath gp=new GeneralPath();
	int fail=0;
	for(int i=LIM2;i<=LIM1;++i) {
	    for(int j=-DEP;j<=DEP;++j) {
		int i3=i+i2;
		int j3=j+j2-(int)(A*i);
		if(A*i3+j3>0) {
	          L=doLocal(i3,j3,A);
                  gp.append(L.gp,false);
		}
	    }

             Integer JJ=new Integer(i);
	     M.C.PROGRESS=JJ.toString();
	     M.C.repaint();
	}

	halt=0;
	M.R.nextPathLast(gp);
	M.R.repaint();   
	M.RT.repaint();
    }



    public ArithmeticGraphLocal doLocal(int i,int j,double AA) {
	ArithmeticGraphLocal L=new ArithmeticGraphLocal();
	L.gp=new GeneralPath();
	ArithmeticPoint P1=new ArithmeticPoint();
	P1.m=i;
	P1.n=j;
	ArithmeticPoint P2=new ArithmeticPoint();
	Complex test=toComplex(P1,AA);

	L.x[0]=-2;
	L.x[1]=-2;
	L.x[2]=-2;
	L.x[3]=-2;

	int parity=(i+j+1000000)%2;
	if(test.x>0) {
	    P1.y=-1;
	    if(parity==1) P1.y=1;
            P2=firstReturnDirected(P1,AA,0);
	    L.gp.moveTo(P1.m,P1.n);
	    L.gp.lineTo(P2.m,P2.n);
	    L.x[0]=P2.m-P1.m;
	    L.x[1]=P2.n-P1.n;

            P2=firstReturnDirected(P1,AA,1);
	    L.gp.moveTo(P1.m,P1.n);
	    L.gp.lineTo(P2.m,P2.n);
            L.x[2]=P2.m-P1.m;
	    L.x[3]=P2.n-P1.n;
	}
	return(L);
    }



    public int checkList(int q) {
	for(int i=1;i<=LIST[0];++i) {
	    if(q==LIST[i]) return(1);
	}
	return(0);
    }

    public class ArithmeticPoint {
	int m,n;
	double y;
	public ArithmeticPoint() {}
	public ArithmeticPoint(ArithmeticPoint P) {
	    m=P.m;
	    n=P.n;
	    y=P.y;
	}
	public ArithmeticPoint(Complex z) {
	    m=(int)(z.x);
	    n=(int)(z.y);
	    y=1.0;
	}
	public int testSame(ArithmeticPoint P,ArithmeticPoint Q) {
	    if(P.m!=Q.m) return(0);
	    if(P.n!=Q.n) return(0);
	    if(Math.abs(P.y-Q.y)>.000001) return(0);
	    return(1);
	}

	public int testSameStart(ArithmeticPoint P,ArithmeticPoint Q) {
	    if(P.m!=Q.m) return(0);
	    if(P.n!=Q.n) return(0);
	    return(1);
	}



	public void print() {
	    System.out.println(m+" "+n+" "+y);
	}
    }



}

