import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

import java.awt.geom.*;
import java.math.*;


public class ComputeTile implements Runnable {
    int halt;
    int block;
    Quad QUAD;
    double A;
    PolyVector VECTOR;
    Complex SOURCE;
    Manager M;
    int MODE;


    public ComputeTile() {}

    public ComputeTile(Quad Q,Complex z,Manager MM,int mode) {
	this.QUAD=Q;
	this.SOURCE=z;
	this.M=MM;
	this.MODE=mode;
    }


    public void run() {
	makeTile();
    }






  public void makeTile() {

      PinwheelMap RM=new PinwheelMap(Math.sqrt(5.0)-2.0);
       Complex z=goodStart(SOURCE);
	
       int sector=RM.findSector(z);
       Complex z1=RM.doMap(sector%4,z);

       double[][] d=new double[4][2];
       for(int i=0;i<4;++i) {
	   d[i][0]=1;   //min
	   d[i][1]=-1;  //max
       }

        PolyWedge WEDGE=new PolyWedge(); 
        halt=1;
	int test=0;
	int count=0;
	double dist=0;  
	int orbit=0;
	int max=0;
        VECTOR=PolyVector.bigSquare(SOURCE);

	int choice=0;
	int big=0;

	while((halt==1)&&(test==0)) {
	    choice=(sector+count)%4;
            double temp=RM.getStripPosition(choice,z);
            orbit=orbit+(int)(Math.abs(RM.getDepth(choice,z)));
	    if(orbit>999999999) big=1;
	    z=RM.doMap(choice,z);
	    if((choice==1)&&(max<z.x)) max=(int)(z.x);


	    if(d[choice][0]>temp) d[choice][0]=temp;
	    if(d[choice][1]<temp) d[choice][1]=temp;

            if((count>0)&&(count%100000==0)) {
		Integer COUNT=new Integer(count);
		M.C.PROGRESS=COUNT.toString();
		M.C.repaint();
	    }

	    ++count;
	    dist=Complex.dist(z1,z);
	    if((count>6)&&(dist<.00001)) test=1;
	}

	for(int i=0;i<4;++i) {
	    d[i][0]=-d[i][0];
	    d[i][1]=1-d[i][1];
	}

	PolyWedge WEDGE1=RM.rhomb1(d[1][0],d[0][0],d[1][1],d[0][1],SOURCE);
	PolyWedge WEDGE2=RM.rhomb2(d[2][0],d[3][0],d[2][1],d[3][1],SOURCE);
	WEDGE=WEDGE1.polyChop(WEDGE1,WEDGE2);

        halt=0;
	M.C.repaint();
       	WEDGE.radius=max;
	WEDGE.orbit=orbit-1;
	if(big==1) orbit=0;


        double time2=System.currentTimeMillis();
	M.P.nextOrbit(WEDGE);  
        M.C.repaint();
	M.P.repaint();	
    }








    public void firstReturn(double x,int k) {

        halt=1;
	int test=0;
	int choice=0;
	double y;

	Complex z=new Complex(x,k);
	while((halt==1)&&(test==0)) {
	    z=nextComplex(z,QUAD);
	    y=Math.abs(z.y);
	    if(y*y<.01) test=1;
	}
	System.out.println(z);
    }



  public static int findGoodVertex(Complex w,Quad Q) {
	int index=0;
	for(int i=1;i<4;++i) {
	    int test=Complex.isPositivelyOriented(w,Q.z[index],Q.z[i]);
	    if(test==1) {
		index=i;
	    }
	}
	return(index);
    }

    public static PolyWedge nextPoly(PolyWedge P,Quad Q) {
	int k=findGoodVertex(P.getCenter(),Q);
	PolyWedge PP=new PolyWedge();
	for(int i=0;i<P.count;++i) {
	    Complex Z=new Complex(Q.z[k]);
	    Z=Complex.plus(Z,Z);
	    Z=Complex.minus(Z,P.z[i]);
	    PP.z[i]=new Complex(Z);
	}
	PP.count=P.count;
	PP.history=k;
	return(PP);
    }

    public static Complex nextComplex(Complex z,Quad Q) {
	int k=findGoodVertex(z,Q);
	Complex Z=new Complex(Q.z[k]);
	Z=Complex.plus(Z,Z);
	Z=Complex.minus(Z,z);
	return(Z);
    }


    public Complex goodStart(Complex z) {
	Complex w=new Complex(z);
	for(int i=0;i<100;++i) {
	    if((w.x>0)&&(Math.abs(w.y)<w.x+1)) return(w);
	         w=nextComplex(w,QUAD);
	         w=nextComplex(w,QUAD);
	}
	return(z);
    }












    /**diamond fill routines*/



  public PolyWedge singleCore() {

       SOURCE.y=0;
       PinwheelMap RM=new PinwheelMap(Math.sqrt(5.0)-2.0);
       Complex z=new Complex(SOURCE);
       int sector=1;

       double[][] d=new double[4][2];
       for(int i=0;i<4;++i) {
	   d[i][0]=1;   //min
	   d[i][1]=-1;  //max
       }

        PolyWedge WEDGE=new PolyWedge(); 
        halt=1;
	int test=0;
	int count=0;
	double dist=0;  
	int orbit=0;
	int max=0;
        VECTOR=PolyVector.bigSquare(SOURCE);

	int choice=0;
	int big=0;

	for(count=0;count<9;++count) {
	    choice=(sector+count)%4;
            double temp=RM.getStripPosition(choice,z);
	    z=RM.doMap(choice,z);
	    if(d[choice][0]>temp) d[choice][0]=temp;
	    if(d[choice][1]<temp) d[choice][1]=temp;
	}

	for(int i=0;i<4;++i) {
	    d[i][0]=-d[i][0];
	    d[i][1]=1-d[i][1];
	}

	PolyWedge WEDGE1=RM.rhomb1(d[1][0],d[0][0],d[1][1],d[0][1],SOURCE);
	PolyWedge WEDGE2=RM.rhomb2(d[2][0],d[3][0],d[2][1],d[3][1],SOURCE);
	WEDGE=WEDGE1.polyChop(WEDGE1,WEDGE2);
	return(WEDGE);
  }

    public double extractMaxX(PolyWedge WEDGE) {
	double max=0;
	for(int i=0;i<WEDGE.count;++i) {
	    if(max<WEDGE.z[i].x) max=WEDGE.z[i].x;
	}
	return(max);
    }


	public static double dec(double x) {
	    return(x-Math.floor(x+.5));
	}

}









