import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class ControlCanvas extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ControlPanel GLOBAL,EXPORT,MODULE,MOUSE;
    ControlTiling   CON_T;
    ControlGraph    CON_G;
    ControlPenrose  CON_X;
    ControlSanityCheck CON_S;
    ControlPanel PROOF;

    ListenSquare[] MM=new ListenSquare[5];
  
    SelectColor CS;
    ListenSquare GO,HALT,RESET;
    int halt;
    String PROGRESS="";
    Documentation DOC;

    //runnable modules
    ComputeArithmeticGraph CAG;
    ComputeSanityCheck CSAN;
    PenroseComputeProof PCP;

    public ControlCanvas addManager(Manager M) {
	ControlCanvas Q=this;
	Q.M=M;
	return(Q);
    }

     public ControlCanvas() {
	 addMouseListener(this);
  	 addMouseMotionListener(this);
 	 addKeyListener(this);
	 DOC=new Documentation();
	 CON_T=new ControlTiling(110,10);
	 CON_G=new ControlGraph(110,10);
	 CON_X=new ControlPenrose(110,10);
	 CON_S=new ControlSanityCheck(227,205);

	 setControlPanels();
	 setStartStop();
	 CS=new SelectColor(M,3,328,400,65);

	 //runnable modules
	 CAG=new ComputeArithmeticGraph(); 
	 CSAN=new ComputeSanityCheck(); 
	 PCP=new PenroseComputeProof();
     }

    public void setStartStop() { 
         GO=  new ListenSquare(3,220,40,30,Color.white);
	 HALT=new ListenSquare(3,255,80,30,Color.white);
         RESET=  new ListenSquare(3,290,60,30,Color.white);
	 GO.on=1;	 
         HALT.on=1;
	 halt=0;
	 RESET.on=1;
    }

    public void setControlPanels() {	 
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(160,0,160),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(0,160,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C3={new Color(200,0,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C4={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

	 //go button control
	 String[] GoString={"arith graph","Penrose pfs","sanity checks","go"};
	 int[] GoState={1,0,0};
         MODULE=new ControlPanel(C3,GoString,GoState,3);
	 MODULE.mode=0;

	 //Penrose proof routines
	 String[] ProofString={"dyn polys","shadowing","coherence","endpoints","partition","return map","Proofs"};
	 int[] ProofState={1,0,0,0,0,0};
	 PROOF=new ControlPanel(C0,ProofString,ProofState,6);
	 PROOF.turnOff();

	 //mouse emulator
	 String[] MouseString={"not needed","button 1 (B)","button 2 (N)", "button 3 (M)", "3b mouse"};
	 int[] MouseState={1,0,0,0};
         MOUSE=new ControlPanel(C3,MouseString,MouseState,4);


	 //global
	 String[] GlobalString={"tiling", "arith graph", "torus","controls"};
	 int[] GlobalState={1,0,0};
         GLOBAL=new ControlPanel(C3,GlobalString,GlobalState,3);

	 //export
	 String[] ExportString={"no","yes","export"};
	 int[] ExportState={1,0};
         EXPORT=new ControlPanel(C3,ExportString,ExportState,2);

    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(GLOBAL.mode==0) CON_T.render(g);
      if(GLOBAL.mode==1) CON_G.render(g);
      if(GLOBAL.mode==2) CON_X.render(g);
      if(MODULE.mode==2) CON_S.render(g);  
      if(MODULE.mode==1) PROOF.render(g,317,212,87); 
      MOUSE.render(g,317,3,87); 
      GLOBAL.render(g,3,3,95);
      EXPORT.render(g,3,75,95);  
      MODULE.render(g,3,128,95);
      drawGoButton(g);
      CS.render(g); 
      haltDraw(g);
   }


    //info about the parameter

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,50,50));
	g.fillRect(103,3,210,320);
	g.setColor(Color.white);
	g.drawRect(103,3,210,320);
    }

  public void haltDraw(Graphics2D g) {
      int test=0;
      if(CAG.halt==1) test=1;
      if(CSAN.halt==1) test=1;
      if(PCP.halt==1) test=1;
      try{if(M.P.TC.halt==1) test=1;} catch(Exception e) {}

      if(test==1) {
	    halt=1;
	    g.setColor(Color.white);
	    HALT.render(g,new Color(220,0,0));
            g.setFont(new Font("Helvetica",Font.PLAIN,12));
	    g.drawString("halt",(int)(HALT.x+3),(int)(HALT.y+11));
            g.setFont(new Font("Helvetica",Font.PLAIN,10));
	    g.drawString(PROGRESS,(int)(HALT.x+3),(int)(HALT.y+23));
      }
  }

    public void drawGoButton(Graphics2D g) {
	 g.setFont(new Font("Helvetica",Font.PLAIN,20));
	GO.render(g,new Color(200,0,0));
	RESET.render(g,new Color(200,0,0));
	g.setColor(Color.white);	 
	g.drawString("go",(int)(GO.x+6),(int)(GO.y+20));
	g.drawString("reset",(int)(RESET.x+6),(int)(RESET.y+20));
    }


     public void resetStuff() {
       	    M.P.tile=0;
            M.R.count=0;
            M.RT.plot_count=0; 
            M.RT.point=0; 
	    M.RT.repaint();
     }

    /*These routines depend on the value of the go button*/

    public void doAction(Point X,int mode) {

        //arithmetic grapher
	if(MODULE.mode==0) {
           if(GO.inside(X)==1) { 
		CAG=new ComputeArithmeticGraph(Math.sqrt(5.0)-2.0,M.R.SOURCE,M);
		new Thread(CAG).start();
	   }
	}

	//rigorous proof modes


	if(MODULE.mode==1) { 
            int proof=PROOF.switchMode(X);
	    if(proof==20) DOC.proof_info();
            if(GO.inside(X)==1) {
	        PCP=new PenroseComputeProof(M);
                 new Thread(PCP).start();
	    }
	}

	//sanity checks
	if(MODULE.mode==2) { 
	  
            if(GO.inside(X)==1) {
		CSAN=new ComputeSanityCheck(Math.sqrt(5.0)-2.0,M);
            new Thread(CSAN).start();
	    }
	}
    }

      //halt computations

       public void haltComputations() {
	    try {M.P.TC.halt=0;} catch(Exception ee) {}
	    CAG.halt=0;  
	    CSAN.halt=0;
	    PCP.halt=0;
       }



    //mouse button action


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e,MOUSE.mode);
	DOC.M=this.M;

	int test=GLOBAL.switchMode(J.X);
	if(test==20) DOC.display_info();


	test=EXPORT.switchMode(J.X);
	if(test==20) DOC.export_info();

	if(GLOBAL.mode==0) CON_T.process(e,CS.C,M);
	if(GLOBAL.mode==1) CON_G.process(e,CS.C,M);
	if(GLOBAL.mode==2) CON_X.process(e,CS.C,M);
	if(MODULE.mode==2) CON_S.process(e,CS.C,M);	

	int module=MODULE.switchMode(J.X);                  //action change
	if(module==20) DOC.go_info();
	doAction(J.X,J.mode);
	if(RESET.inside(J.X)==1) resetStuff(); 
	if(HALT.inside(J.X)==1) haltComputations();         //halt computations
	CS.process(e,DOC); 
	test=MOUSE.switchMode(J.X);
	if(test==20) DOC.mouse_info();

	repaint();
	M.P.repaint();
	M.R.repaint();
	M.RT.repaint();	
        M.RC.repaint();
    }


    public void mousePressed(MouseEvent e) {
    }

   public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {
	    CON_G.processKey(e);
   	    repaint();
	}
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

