import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlPenrose {
    Manager M;
    Documentation DOC;
    ControlPanel SEQS,PCOLORS,PMARKER;  
    PenroseSequenceHolder SH;
    ListenSquare GO;
    SelectInteger[] INT=new SelectInteger[3]; 
    PenroseComputeGraph PCG;
    int x,y;

    public ControlPenrose(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation(); 
        Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

         INT[0]=new SelectInteger(x+100,y+215,28,15,10,1,20,1);  //number of iterates for gene
	 INT[1]=new SelectInteger(x+100,y+233,28,15,5,5,7,1);  //gene length


	 //genes for penrose kite
	 String[] GeneString={"shadow off","shadow on","genes"};
	 int[] GeneState={1,0,0};
	 SEQS=new ControlPanel(C1,GeneString,GeneState,2,0);

	 GO=new ListenSquare(x+97,y+260,100,20,Color.white);
	 GO.on=1;

	 //gene colors
	 String[] PenroseColorString={"gene","shadow","gene image","polys","poly edges","core","pointer","polyX colors"};
	 Color[] COL3={Color.blue,Color.red,new Color(50,100,255),Color.black,Color.white,new Color(0,0,0,100),Color.black};
	 int[] PenroseColorState={0,0,0,0,0,0,0};
         PCOLORS=new ControlPanel(C1,PenroseColorString,PenroseColorState,7,COL3);


	 //toggle display of objects - Penrose kite
	 String[] PenroseShowString={"core","dyn polys","exchange","monochrome","cross","polyX show"};
	 int[] PenroseShowState={0,0,0,0,0};
         PMARKER=new ControlPanel(C1,PenroseShowString,PenroseShowState,5);


         Color[] CC={new Color(50,80,255),Color.white,new Color(0,0,0,0)};	 
         SH=new PenroseSequenceHolder(M,x+100,34,CC,null);	 


    }


    public void compute(Point X,Color C,Manager M) {
           PCG=new PenroseComputeGraph(M.P.QUAD.z[2].x,M.R.SOURCE,M);
           new Thread(PCG).start();
    }


   
    public void compute2(Point X,Color C,Manager M) {
          PCG=new PenroseComputeGraph(Math.sqrt(5)-2,M.R.SOURCE,M);
          new Thread(PCG).start();
    }




    public void render(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,11));
        PMARKER.render(g,x,y,90); 
        SEQS.render2(g,x,y+230,90); 
	PCOLORS.render(g,x,y+100,90);
	SH.render(g,PCOLORS.L[0].C,PCOLORS.L[1].C,SEQS.mode,INT[1].val);
	INT[0].render(g,Color.blue,Color.white,Color.white);
	INT[1].render(g,Color.blue,Color.white,Color.white);
	g.drawString("gene#",x+155,y+245);
	GO.render(g,new Color(0,140,140));
	g.setColor(Color.white);
	g.drawString("get genes",x+110,y+274);
    }


    public void penroseModify(Point X,Color C,Manager MM) {	 
        DOC.M=MM;
	int test4=PCOLORS.recolor(X,C);
	if(test4==20) DOC.penroseColorInfo();
	int test3=PMARKER.toggle(X);
	if(test3==20) DOC.pmarkerInfo();

        int seqs=SEQS.switchMode(X);
        if(seqs==20) DOC.seq_info();
    	INT[0].modify(X);
	INT[1].modify(X);
	if(GO.inside(X)==1) compute(X,C,MM);

        int dyn=SH.process(X,C,INT[1].val);
	if(dyn==20) DOC.seq_info();
	if(dyn==2) compute2(X,C,MM);






    }


    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
	penroseModify(J.X,C,MM);
    }
}

