import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentControlPanel {
    Manager M;
    public DocumentControlPanel(Manager MM) {
	this.M=MM;
    }



    public void display_info() {
	String S="There are 3 main windows in which you draw pictures. Each window is controlled by a different set of buttons.  This window lets you select which set of controls to use.  Here are the options.";

	S=S+"\n\ntiling: these are controls associated to the tiling window.  This window is the dynamical plane, in which the outer billiards system takes place.  Here you can draw parts of an infinite tiling associated to the dynamics.";
	S=S+"\n\narith graph: these are the controls associated to the arithmetic graph.  The arithmetic graph, described in my paper, gives the arithmetic view of the return map to the basic strip.  You can learn more about this window by selecting this option and then clicking on the information buttons for these controls.";
	S=S+"\n\ntorus: these are the controls for the torus partition window. This is 2-dimensional polygon exchange map that controls the structure of the arithmeetic graph.  Again, you can learn more about this window by selecting this option and clicking on the info buttons associated to these controls.";
	M.E.setExplain(S);
    }


    public void go_info() {
	String S="This control panel lets you choose between  3 different functions for the 'go' button.  Whatever option you choose, you then activate the program by pushing the 'go' button.  If the calculation is long (and sometimes when it is short) there will appear a 'halt' button while the calculation is running.  You can halt the calculation by pushing the halt button.  Depending on which option you select, different control panels will pop up to the left of this one. Here are the 5 options:";

	S=S+"\n\narithmetic graph: This option lets you plot the arithmetic graph of the dynamics.  You should read the documentation in the arithmetic graph window to see that this means.";

	S=S+"\n\npenrose pfs: When this  option is on, you can perform the rigorous proofs that do into my proof that outer billiards on the Penrose kite really has an unbounded orbit.  To understand what the computations are, you should read the documentation for the control panel that pops up when you activate this option.";

	S=S+"\n\nsanity checks: Billiard King performs various calculations that serve as sanity checks for our various claims in the paper.  Clicking on this option brings up an auxilliary control panel that manages these sanity checks.";
	M.E.setExplain(S);
	M.E.repaint();
    }


  public void export_info() {

      String S=new String();
	S=S+"This control panel lets you save pictures.  When you set the option to 'yes' and then click on one of the picture windows, Billiard King writes the result to a tcl file and stores it in the Output subdirectory.  If you then run the tcl programs in this subdirectory, you can save the pictures to postscript.  This is a rather awkward procedure, and mainly I have it here so that I can illustrate my papers.  Java does have its own postscript generating capabilities, but it is rather complicated.\n\n ";  

	M.E.setExplain(S);
	M.E.repaint();
  }



  public void mouse_info() {

      String S=new String();
      S=S+"Billiard King is designed to work best with a 3 button mouse. Generally speaking\n   1. clicking button 1 scales up the picture\n   2. clicking button 2 selects a new point in the window.\n   3. clicking button 3 scales down the picture.\nOn the control panel, all mouse clicks have the same effect.\n\n";

      S=S+"If you have a 3-button mouse, just keep this control panel set on 'not needed'.  Otherwise, you can click on the other settings to force Billiard King to re-interpret the a mouse click as desired.  You can also uses the keys B,N,M to simulate a 3 button mouse.";


	M.E.setExplain(S);
	M.E.repaint();
  }




	public void sanityInfo() {

	    String S="This control panel lets you perform several calculations that serve as sanity checks for the results I prove in my papers. The first of these calculations is 'behind the scenes' in the sense that there is no demonstrable result of the calculation.  The computer simply runs the calculation and then halts.  In principle, the user could trace through the code and verify that the given calculation is done.   However, these calculations are present mainly for my benefit, and not for the benefit of a user.  By performing these calculations, I am not trying to prove something, but only trying to reassure myself that various conclusions I have drawn are correct.  At any given time, the programs in this window are in flux, and not really meant as a formal part of the program.  I use them to develop the program.";

	S=S+"\n\npinwheel: This option lets you test the truth of the Pinwheel Lemma, from my papers.  The Pinwheel Lemma states that the first return map for outer billiards on kites is the product of 8 simpler maps, which I call strip maps. When you select this option, you then see 3 integer selectors appear below.  If the first integer selector says 256, it means that you are sampling the parameters 1/256,...,255/256 in the kite parameter interval (0,1).  If the second integer selector says 1024, it means that you are sampling 1024 points per unit.  If the third integer says 8, it means that you are sampling points from the sets (0,8) times {-1,1}. the total number of tests you make is the product of the 3 numbers. You can change these numbers, and their new meanings will be similar.";

	S=S+"\n\npenrose torus: This routine serves as a sanity check for the arithmetic graph lemma in my paper on the Penrose kite.  The Master Picture Theorem in my monograph is the generalization of the Arithmetic Graph Lemma in the paper.  To use this option, you should set all possible options on the control panel to 'Penrose'.  First, you should set the shape type to penrose, so that the Penrose Kite Partition window comes alive.  Second, you should set the color type to 'monochrome' on the control panel for the Penrose Kite Partition window.  When you select this option, a little magenta tic-tac-toe board appears.  Using mouse buttons 1 and 3, you can select any `local type' you like.  Here, a 'local type' is the 1-neighborhood of a vertex in the arithmetic graph.  When you run this option, Billiard King searches through the Penrose Kite arithmetic graph for all lattice points where the local picture of the graph matches the selected local type.  Billiard King then maps these special lattice points into the torus, and plots them in the Penrose Kite Partition window.  In this way, you can check that the partition, given by the Arithmetic Graph Lemma and drawn in the Penrose Kite Partition window, is correct.";

	M.E.setExplain(S);
	M.E.repaint();
    }



    public void resetInfo() {
	String S="This control panel allows you to reset the plots that appear on the tiling window and also to implement changes to the quadrilateral you have selected.";
	S=S+"\n\nThe 'shape/tiles' button resets the tiling you compute on the main window, and simultaneously implements and changes you have made to the quadrilateral on which the tiling is based.  This is a very important button. You need to use this button whenever you want to select a new shape.";
	S=S+"\n\nThe 'tracer' button erases all the orbit tracers you might have created using the 'Orbit Tracer' window.";
	S=S+"\n\nThe 'arith graph' button erases any plots you make on the arithmetic graph window.";
	S=S+"\n\nThe 'all' button is a hard reset.  All your plots get reset.  You should use this button when you are in doubt that the changes you want to make have been implemented.";
 M.E.setExplain(S);
    }



    public void colorSelectorInfo() {
        String S="This is the color selector.  Many other parts of Billiard King plot pictures, and you can select the color of the plot using this interface.  You can click and drag the mouse in the three big bars to the left in order to change the red, green, and blue components of the color. You can also click or drag on the bottom bar in order to change the transparency level of the color.  It is best to experiment around to see how this works.  When you have altered the color selector the new color will appear in the vertical bar.";
        S=S+"\n\nThere is also a preset list of 8 colors running across the top right hand side of the color selector.  You can select these colors just by clicking on the squares.  You can also change the list of preset colors by clicking on the bottom row of squares.";
        M.E.setExplain(S);
        M.E.repaint();
    }






}


