import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentGraph {
    Manager M;
    public DocumentGraph(Manager MM) {
	this.M=MM;
    }


    public void AGP_info() {

	String S="This panel controls what you plot in the Arithmetic Graph window. If you don't know what the arithmetic graph is, you can read the documentation for the Arithmetic Graph Window.  In brief, the arithmetic graph is a 2-dimensional plot which encodes the dynamics of the fundamental return map for the outer billiards map.";

S=S+"\n\nNow I'll suppose you know what the arithmetic graph is. Once you have set the option you like, just push 'go' and see what happens. Note: many grid points in the Arithmetic Graph window are not in the arithmetic graph: they have trivial orbits. For these points, nothing will happen if you press 'go' ";

	S=S+"\n\nforward: The forward option plots the forward orbit of the selected point in the Arithmetic Graph window. You control the number of iterates (always a power of 2 with our interface) using the upper arrow key above this panel"; 

	S=S+"\n\nbackward: The backward option plots the backward orbit of the selected point in the Arithmetic Graph window. You control the number of iterates as in the forward case."; 

	S=S+"\n\nblock: The block option lets you plot all the orbits within a certain rectangle.  The two arrow keys above this panel control the size of this rectangle.  The rectangle is centered on the point in the window you have selected.  If you select nothing, then the default is (0,0).";

	M.E.setExplain(S);

	M.E.repaint();
    }


    public void agparameter_info() {
	String S="These arrow keys control how much of the arithmetic graph you plot.";
	S=S+"\n\nFor the 'forward' and 'backward' plot, the top arrow key controls the number of iterates.  The bottom key has no effect.";
	S=S+"\n\nFor the 'block' plot, the top arrow key controls the height of the plot and the bottom arrow key controls the width.";

	M.E.setExplain(S);
	M.E.repaint();
    }



    public void pmarkerInfo() {
	String S="This control panel toggles the display of some auxilliary objects.";


S=S+"\n\ncore: In the documentation for the Arithmetic Graph window we explain that the map from the Arithmetic Graph window to the Polygon Exchange window controls the local structure of the arithmetic graph.  When you plot the arithmetic graph (using the 'go' button in the upper right corner, with the plot type set to 'block') you will see a lot of 5-gons and 7-gons.  The core shows a union of 24 sub-polygons on the Polygon Exchange window.  These sub-polygons have the property that a point on the arithmetic graph maps into one of these sub-polygons if and only if it lies on a 5-gon or 7-gon.";

S=S+"\n\ndyn polys: In general, each finite strand of the arithmetic graph is classified by some sub-polygon of the ones shown in the Polygon Exchange window. This button lets you see all the polygons corresponding to the strangs of length 5.  Here is how to see all these polygons:  set the 'inflation' panel option to 'new'. Set the 'plot type' option to 'forward'.   Set the upper number below the 'clear' button to 1024.  Select the point (0,0) on the Arithmetic Graph window.  Now Press 'go'.  When you are done you should click both the 'core' option and the 'dyn polys' option and you will see a finer partition of the Polygon Exchange window corresponding to these length 5 strands.";

S=S+"\n\nshadow points: These are certain points along the Arithmetic Graph that are used as a technical part of the proof in my paper.   See the remark in section 4.4, in connection with checking the coherence of the inflation structure.  If you plot the forwards orbit of (0,0) on the Arithmetic Graph window, then inflate this orbit, you will see that the shadow points follow the kinks of the inflated polygon.";

S=S+"\n\nexchange: We have explained elsewhere how the arithmetic graph is associated to the Polygon exchange window.  This feature illustrates another facet of this connection.  Each point in the arithmetic graph corresponds to a point in the torus.  The operation of moving one edge along the arithmetic graph in either direction corresponds to the operation of translating the corresponding polygon by one vector or another.  Thus, each point in the arithmetic graph really corresponds to a triple of polygons: the original one and its two translates.  With this feature turned on, you can see the translates drawn over the tiling.";

S=S+"\n\nmonochrome: When this feature is on, all the polygons on the Polygon Exchange window are drawn the same color.  This feature is useful when you are studying the inflation structure discussed in my paper.";

S=S+"\n\ncross: This button toggles the pointer on the polygon exchange window between a square pointer and a cross pointer.";

	M.E.setExplain(S);
	M.E.repaint();
    }

    public void basicInfo() {
	String S="";

	S=S+"This window controls the basic settings on the arithmetic graph.";

	S=S+"\n\ncoordinate axes.";
	S=S+"\n\nthe Z+Z integer lattice.";
	S=S+"\n\nthe baseplane: this is the lower halfplane bounded by the baseline.";
	S=S+"\n\nthe baseline: this is the line of slope -A through the origin.  Here A is the kite parameter.";
	S=S+"\n\nbackground color.";
	S=S+"\n\nmagic points: These points are discussed in my paper.  They are certain points of near-agreement between the arithmetic graph and its dilated image.";



	M.E.setExplain(S);
	M.E.repaint();
    }


    public void arithmeticGraphInfo() {



	String S="This window plots the arithmetic graph. The arithmetic graph is the central object in my paper.  Here we describe the basic ideas behind this object.";

	S=S+"\n\nIn general, a kite has a single parameter A in (0,1). The parameter for the Penrose kite is A=sqrt(5)-2.  This is the only value consider.  We define the map T, from Z+Z into R times {-1} by the rule ";


	S=S+"\n\n(T(a,b),1) and (T(a,b),-1) \n\nwhere T(a,b)=2aA+2b+,mA+n";

	S=S+"\n\nHere mA+n, the offset value. For the penrose kite, our offset value is (1-A)/2.";


S=S+"\n\nWe apply the outer billiards map a number of times until our point returns to a point on R, and this point necessarily  corresponds to some T(a0,b0).   We also apply the inverse map a number of times to arrive at a point T(a1,b1).   We connect (a,b) to both (a0,b0) and (a1,b1).  This gives us a small part of the arithmetic graph.  Doing this for all points in the grid gives us the whole arithmetic graph.  The 'block plot' option on the Arithmetic Graph Control Panel makes this plot.";

	S=S+"\n\nAlternatively, we can trace out an orbit by starting with (a,b), then moving to (a1,b1), then moving to a new point (a2,b2) connected to (a1,b1), and so on.  This would give us a kind of 2D plot of the return map.  We could also connect (a,b) to (a0,b0), etc., working our way backwards.  This would give us a kind of 2D plot of the backwards return map.  The 'forwards' and 'backwards' options on the Arithmetic Graph Control Panel let you make this kind of plot, once you have selected (a,b).";

	S=S+"\n\nYou can interact with the Arithmetic Graph window in several ways.  First of all, you can click on grid points, as we already mentioned.  You select points using the middle mouse button. You can scale the window using the left and right mouse buttons. You can resize the window by dragging on the lower left corner.  You can move the selected point using the arrow keys in the upper left corner.  You can also enter a point numerically using the keyboard.";

	S=S+"\n\nThe most interesting thing about the arithmetic graph (for the Penrose kite) is that it is quasi-invariant inder a dilation about the origin by phi^3.  Once you have plotted an orbit you can click on that orbit to select it.  If you then press 'inflate', you will see the orbit dilated by phi^3.  You can then observe, by perhaps doing additional plots, that the dilated orbit is closely shadowed by the original arithmetic graph.";


	S=S+"\n\nMore concretely, here is a great demo. Select the point (0,0) and then plot the backwards orbit.  Now click again on (0,0) to select the orbit.  Now press the 'inflate' button.  Now change colors and replot the backwards orbit of (0,0).  You can do the same thing with the forwards orbit, but the backwards orbit looks cooler.  My paper deals with the forwards orbit.";

	S=S+"\n\nThe entire arithmetic graph behaves a lot like a self-similar tiling.  Here is a nice demo of that phenomenon.  Again select the Penrose kite.  First, plot the orbit of (0,0) as before (but don't inflate it.)  Now plot the orbit of the point (12,-3).  The orbit will be a finite polygon.  You can now click on this orbit and drag it over to the orbit of (0,0) and see that it 'fits' into it.  You can use the little grid of 9 squares to fine tune the dragging.  You can use the 'rotate' button to turn the orbit upside down.";

	S=S+"\n\nAnother structure-revealing exercise is to go along and plot all the orbits of the grid points nearest to the purple halfplane.  If you move out to the right from (0,0) to the points (4,-1), (8,-2), (12,-3), (17,-4) etc., you will see a growing family of periodic orbits arranged in the pattern of a large scale Cantor set.  Try it out.";

	M.E.setExplain(S);
	M.E.repaint();
    }


}


