import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentPenrose {
    Manager M;
    public DocumentPenrose(Manager MM) {
	this.M=MM;
    }



    public void main_info() {

	String S="";
	S=S+"This window explores the relationship between the arithmetic graph and the polygon exchange map associated to the Penrose kite. Before using this window, you should probably first read the documentation for the Polygon Exchange window and the Arithmetic Graph window.In brief, there is a certain map from the lattice Z2 to the torus T2.  The local type of the arithmetic graph at a given vertex is determined by which polygon in T2 contains it.";

	S=S+"\n\nHere are instructions for using this window:";
	S=S+"\n\n1. Select the 'Penrose kite' shape on the 'shape type' control panel.";
	S=S+"\n\n2. Select the 'get genes' option on the 'genes' control panel.";
	S=S+"\n\n3. Push the 'go' button.";
	S=S+"\n\n4. Now you will see a number of little squares pop up on this window. If you click on these squares you can see a gene that is indexed by this square.  A gene is a length 5 strand in the component of the arithmetic graph that contains (0,0).  The gene is drawn in red beside the boxes and its core, the central strand of length 2, is drawn in white.";
	S=S+"\n\n5. Now select the 'shadow on' option on the 'genes' control panel.";
	S=S+"\n\n6. Again click on one of the little squares.  This time Billiard King will compute the longer strand of the arithmetic graph that shadoes the inflated core of the gene.";
	S=S+"\n\n7. Turn on the 'monochrome' option on the 'polyXshow' control panel.  You access this option by clicking on the 'penrose' option on the 'display' panel.  The 'monochrome' option all the polygons on the Polygon Exchange Window the same color, making it easier to view the auxilliary polgyons.";
	S=S+"\n\n8. When you click on a little square (with the 'shadow on' option selected) Billiard King plots 3 auxilliary polygons in the polygon exchange window.  The first polygon is the one that classifies the gene.  In other words, a point in Z2 maps into this polygon if and only if it is the center of a strand that is a copy of this gene.  The second polygon classifies the longer strand that shadows the inflated gene core.  The third polygon is the image of the first one under a certain special similarity.  The fact that the third polygon is always contained in the second polygon constitutes a proof that the inflation structure discussed in my paper exists.";
	S=S+"\n\n9. If you look on the Arithmetic Graph window just after you press one of the little squares, you can see the shadowing strand drawn in white, on top of a blue copy of the arithmetic graph.  You can also see a dilated version of the arithmetic graph in red. In this way you can locate the genes and their shadows right on the picture.";
	M.E.setExplain(S);
	M.E.repaint();
    }




    public void local_info() {

	String S="To understand these 23 squares you should first read the documentation for the Arithmetic Graph window and the documentation for the Polygon Exchange window.\n\n These 23 squares correspond with the 23 tiles in the Polygon Exchange window.  They also enumerate (somewhat redundantly) all the local pictures you see in the arithmetic graph.";

	S=S+"\n\nWhen you click on a point of the arithmetic graph, one of these 23 squares is highlighted, according to the local type of the the vertex you have selected.";

	S=S+"\n\nThese 23 squares have no active function.  They are just part of the display."; 

	M.E.setExplain(S);
	M.E.repaint();
    }




    public void gene_info() {

	String S="This window allows you to specify the lengths of genes.";

	S=S+"\n\nOur convention in the paper is that a gene is a length 5 strand contained in the component of the arithmetic graph that contains (0,0). You should read the documentation for the Arithmetic Graph Window if this statement doesn't make sense.  There are 75 gene types.";

S=S+"\n\nYou can see these gene types using the following procedure. set the 'inflation' panel option to 'new'. Set the 'plot type' option to 'forward'.   Set the upper number below the 'clear' button to 1024.  Select the point (0,0) on the Arithmetic Graph window.  Now Press 'go'. You will see a row of boxes appear along the bottom left of this window. When you click on one of these boxes, you see the gene types displayed.";

	S=S+"\n\nIf you click on the '6' or the '7' button you redefine a gene to be a strand of length 6 or 7 rather than a strand of length 5.  You can then get the list of the longer genes, using the same procedure as above.  There are 75 length 5 gene types, and 89 length 6 gene types, and 96 length 7 gene types.";

	S=S+"\n\nBilliard King simply plots the forward orbit of the point (0,0) and records the genes as they appear.  It turns out that 1024 iterations suffices to see everyting.  If you plot longer portions of the orbit, you see no new gene types.  This is a reflection of the fact that the arithmetic graph is quasi-self-similar.";

	M.E.setExplain(S);
	M.E.repaint();
    }







  public void penroseColorInfo() {

	String S="This control panel lets you change the colors of various objects in connection with the Penrose kite.";

	S=S+"\n\n'gene': The genes are the length 5 strands on the component of the arithmetic graph that contains (0,0).  Each gene is classified by a sub-polygon on the Polygon Exchange window.  That is, a point in the Arithmetic Graph maps into the classifying polygon if and only if it has this geometric type. We call this polygon the gene classifier. This button controls the colors of the polygons on the Polygon Exchange window corresponding to these genes.";


	S=S+"\n\n'shadow':  The operation of dilation on the Arithmetic Graph window is intertwined with a certain system of contractions on the Polygon Exchange window.  This is explained in the Shadow Lemma in section 3.3 of my paper. Each gene has associated to it one of these contractions, and this contraction maps the gene classifier into the core shadow classifier.  The color of this image is controlled by this button.  The fact that the gene classifier always maps inside the core shadow classifier is the technical device we use to show that the arithmetic graph really does have its quasi-self-similarity structure.";


	S=S+"\n\n'gene image':  The operation of dilation on the Arithmetic Graph window is intertwined with a certain system of contractions on the Polygon Exchange window.  This is explained in the Shadow Lemma in section 3.3 of my paper. Each gene has associated to it one of these contractions, and this contraction maps the gene classifier into the core shadow classifier.  The color of this image is controlled by this button.  The fact that the gene classifier always maps inside the core shadow classifier is the technical device we use to show that the arithmetic graph really does have its quasi-self-similarity structure.";

	S=S+"\n\n'polys': This button controls the color used to draw the main polygons in the Polygon Exchange window, when the 'monochrome' option on the 'show' panel is turned on.";

	S=S+"\n\n'poly edges': This button controls the color of the edges of the polygons in the Polygon Exchange window.";

	S=S+"\n\n'core': This button controls the color of the core polygons.  You can read about these polygons in the documentation for the 'display' panel.";

	S=S+"\n\n'pointer': when you click on the Arithmetic Graph window, using the middle mouse button, you select the nearest grid point.  Correspondingly, a point appears in the Polygon Exchange window.  This button controls the color of that point.";

	M.E.setExplain(S);
	    M.E.repaint();
    }






    public void seq_info() {

	String S="This panel lets you to see the shadowing phenomenon described in my paper. To use this window propertly you should set the shape type to 'Penrose kite'.  In brief, the arithmetic graph, when dilated by phi^3 about the origin, is closely shadowed by itself.  In other words, it is quasi-self-similar.";

	S=S+"\n\nIn my paper I only establish this shadowing property for the orbit of (0,0).  This is sufficient to prove that outer billiards on the Penrose kite has an unbounded orbit.  I establish the shadowing property by considering all the length 5 strands on this orbit.  These length 5 strands are called genes.";

	S=S+"\n\nIf you select the 'shadow off' button, and then push the 'Go' button, you can compute all the genes contained in the strand through the point you have selected on the Arithmetic Graph window.  You should select the point (0,0) for the best results, and in particular for the results obtained in my paper. After you push 'Go', you will see a number of small squares appear at the bottom of the Polygon Exchange Window.  Each of these squares 'contains' a different gene. When you click on one of these squares, you can see the gene displayed visually in several ways.";

	S=S+"\n\nIf you set this panel mode to 'shadow on' and then again click on the little squares, you will then see the longer strands of the arithmetic graph that shadow the inflated gene cores.  A gene core is the central two segments of a gene.  Assuming that you have retrieved the list of 75 gene types, you will see a row of boxes across the bottom left of the this window.  If you click on one of these boxes with the shadow on mode on, you will see the strands that shadow the inflated gene cores by clicking on the boxes.  In the language of the paper, this mode allows you to survey the inflation generator discussed in Chapter 3.";

	S=S+"\n\nThe shadowing option has a subtle dependence on the position of the pointer in the arithmetic graph.  The simplest thing to do is simply not to touch the arithmetic graph window in between the time you compute the genes and the time you use the shadowing.  The case of interest to us is when the pointer in the arithmetic graph window is set to (0,0).  You can read the pointer value at the upper left corner of the arithmetic graph window.";

	S=S+"\n\nWe have set up Billiard King so that you can 'redefine' a gene to be a strand of length L for L=6,7,8  You can do this using the 'gene length' key.  For these values, the 'get genes' computation still works:  You can find all the genes of length L.  However, the shadow on option does not work for L>5.  In the paper we only care about the shadowing for the case L=5, though the other cases are essentially the same.";

	M.E.setExplain(S);
	M.E.repaint();
    }


    public void proof_info() {


	String S="This module performs the rigorous computations from my paper.  There are 6 computations. After you select the computation would would like to see, you press the 'go' button to run the computation. These computations produce no visual effect in Billiard King.  However, they are part of the rigorous proof presented in my paper.  Some of these computations run quite slowly.  After you start a computation, a 'halt' button will appear (after a bit) and you can press this button to stop the computation.  When the computation ends the halt button goes away.  Here is a description of the computations.";

	S=S+"\n\ndyn polys:  This implements the calculation described in section 7.7 of my paper.  Recall that there are 75 genes and each one has a corresponding polygon which is its gene classifier.  This calculation rigorously verifies that we have correctly written down the vertices for each of the gene classifiers.";

	S=S+"\n\nshadowing: This implements the calculation described in section 7.8 of my paper. Recall that each gene core, when dilated, is shadowed by a longer strand of the arithmetic graph. The key to proving this is to check that each gene classifier is mapped into the corresponding core shadow classifier using the relevant contraction map.  This calculation verifies that this happens in each of the 75 cases.";

	S=S+"\n\ncoherence.  This implements the calculation described in section 7.9 of my paper.  To each gene on the arithmetic graph we assign a longer strand that shadows the dilation of the gene core.  If two genes overlap, then the shadowing strands should also overlap.  This is what we call 'coherence'. We check this for the first 1024 overlapping genes on the forward orbit of (0,0) and this suffices.";

	S=S+"\n\nendpoints.  This routine checks that the endpoints of the dilated core shadow are within 3 units of the dilated core.  This is one of the criteria we set in the paper for an inflation structure.";

	S=S+"\n\npartition: This implements the main calculation for the proof of the Arithmetic Graph lemma in the paper. See the last section of Chapter 7.  In brief, we construct a 4 dimensional polytope exchange map, on a 4-torus, that compactifies the dynamical action of the outer billiards return map. We then have a certain map from our Polygon Exchange window into this 4 dimensional torus and we need to check that the 4D polytope exchange is coherently defined on the image of each polygon in our 2D polygon exchange.";

	S=S+"\n\nreturn map: This is a floating point calculation, sampling 1 million points in the interval (0,10) x (+-1), which checks that our factorization of the return map into strip maps coincides with the straightforward definition.  This calculation is not formally part of our proof, but rather is a knd of sanity check for something that one can do by hand.";

	S=S+"\n\nThe reader might be interested in seeing the code that implements these computations.  The proof subroutines aer all activated from the class ProofComputer.  The actual proof subroutines are contained in the files PenroseProofRoutines1 and PenroseProofRoutines2.  These classes in turn use the date contained in the files PenroseProofData1, PenroseProofData2, and PenroseProofData3.";

	M.E.setExplain(S);

	M.E.repaint();
    }





}


