import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentTiling {
    Manager M;
    public DocumentTiling(Manager MM) {
	this.M=MM;
    }


  public void pictureCanvasInfo() {
	String S="This is the tiling window. ";

	S=S+"\n\n The tiling window displays a certain tiling associated to the Penrose kite. In general, an outer billiards system is based on a convex shape S.  Starting with a point x0 outside of S, we let x1 be the point such that the line segment x0x1 is tangent to S at the midpoint, and S lies to the right of this line segment.  By this we mean that a person walking from x0 to x1 would encounter S on the right. There are certain points x0 for which this construction does not work, but it does work in the complement of a countable set of lines.  The iteration x0-->x1--x2... is then defined for almost all points in the complement of S.  This is the outer billiards system.";

	S=S+"\n\nIn general, every periodic orbit is contained in a convex tile consisting of periodic orbits having the same combinatorial structure.  In the case of a rational outer billiard system, there is a locally finite tiling of the complement of S, with the following property: If you click on a typical point in the tiling window, Billiard King computes the tile containing that point and draws its orbit.  You can either plot the single tile, or else its entire orbit. There are a few other options as well.";
	S=S+"\n\nThe color of the tiles is determined by the color selector, one of the other windows of Billiard King.  If you modify the color on the color selector then the tiles are drawn in a different color.  In this way, you can see some of the dynamical properties of the tiling.  \n\nOnce you have drawn an orbit you can modify its appearance in several ways.  For instance, you can recolor the entire orbit, or recolor an individual tile within the orbit.  Also, you can erase the orbit.  These actions are always done with the middle mouse button (button 2).  You use the control panel to select which action button 2 has.";
	S=S+"\n\nYou can also use the control panel to change the bounding box.  The  X and  Y fields allow you to do this.  Finally, you can scale the picture in the tiling window using the left and right mouse buttons.  There are a variety of other ways you can interact with the tiling, and the documentation for the control panel explains this.";
	S=S+"\n\nYou can use some of the mouse keys to navigate the window. The buttons 'b' and 'm' scale the window and the bottons 'h' and 'j' translate the window to the left and the right.";

	M.E.setExplain(S);
	M.E.repaint();
    }




    public void multiInfo() {
	String S="This control panel lets you decide how much of the orbit you want to plot. No matter what you decide, Billiard King computes the full orbit of any point you select.  What Billiard King actually computes is the maximal convex polygon of orbits all having the same combinatorial type as the point you have selected.  There are then three things you can do with this polygon and its orbit:";

	S=S+"\n\nwhole orbit: You can plot the whole orbit.  Even with this option,  Billiard King will only plot the portion of the whole orbit inside the window frame.  The size of this window frame is controlled by the X and Y buttons on the 'plot range' panel.  If you really want the whole orbit, you can set these numbers to be huge. We have made a lot of safeguards against plotting the whole orbit because we don't know in advance how big it will be.  A huge orbit will cause Billiard King to get hung up.  So, you should use the 'whole orbit' option with caution.   A nice option is to set the Y number very small, so that you are just plotting in a thin strip around the X axis.  With practice, you can learn to deduce the structure of the whole orbit from the picture in a thin strip.";

	S=S+"\n\nstrip: This option is equivalent to setting the Y coordinate equal to 1.  It only plots tiles that land in a thin neighborhood of the X-axis.";

	S=S+"\n\n#: With this option you can select a number between 1 and 9 using the arrow keys.  Then you will plot this number of tiles from the beginning part of the orbit.";

	M.E.setExplain(S);
	M.E.repaint();
    }


    public void actionInfo() {
	String S="This control panel controls the action of button 2 on the main tiling window.  We will explain the different options one at a time.";

	S=S+"\n\nplot: This is the normal mode.  When you are using this option, and you click on the main window, you cause Billiard King to compute the orbit of one of the tiles in the tiling associated to the outer billiards system. If you don't know that this means, you should read the documentation for the main window.";

	S=S+"\n\nrecolor orbit: When this option is activated, you can recolor an orbit on the main window according to the current color on the color selector.";

	S=S+"\n\nerase orbit: This is self-explanatory.";

	S=S+"\n\nrecolor tile: This option is like the option for recoloring orbits, except that here you recolor individual tiles.";

	M.E.setExplain(S);

    }

    public void clipInfo() {

	String S="This control panel lets you change various geometric features of the Main Window.";

	S=S+"\n\nThe 'X' and 'Y' buttons control the size of the frame around the tiling.  One reason to make these numbers small is to avoid unnecessary plotting which slows the display.  For a particular orbit,  Billiard King only plots the tiles which intersect the unframed part of the window, though it computes all the tiles in the orbit.";

S=S+"\n\nThe interaction between the frame size and the Orbit Tracer window is not perfect. If your orbit goes outsize the frame, and then you trace the orbit, Billiard King will connect consecutively plotted tiles, even if they are not consecutive iterates under the map.  If you want to see the orbit correctly traced, you need to make the frame large enough to accomodate the whole orbit.";

M.E.setExplain(S);
    }


    public void markerInfo() {

	String S="This control panel toggles the display of some auxilliary objects:";

	S=S+"\n\nX lines: This option displays the set of evenly spaced horizontal lines that is invariant under the outer billiards map.  The X axis is also drawn, even though the X axis is not part of the family of horizintal lines we have in mind.";

S=S+"\n\nframe: This simply draws a frame around the tiling.  You can change the size of the frame using the 'X' and 'Y' fields on the 'plot range' control panel.  You can recolor the frame using the 'frame' button on the 'colors' control panel.";

	S=S+"\n\nstrip: It turns out that we can factor the first return map into a product of 8 maps, which we call strip maps.  The data for each strip map is a pair (S,V), where S is a strip and V is a vector that points from one boundary line of S to the other.  Given a point not in S, we can add a suitable integer multiple of V until the resulting point lies in the strip. This is the strip map.   In other words, the point p is mapped to q=p+nV, where n is chosen such that q lies in S.";

	S=S+"If you consider the first return map for points of the form (x,1) and (x,-1), where x is a large positive number, you can probably get a sense of how the factorization works.  The amazing thing is that the same factorization works for all x>0.  In order to prove this, we make a careful study of how the strips interact with the regions we call 'zones'.  If you click on the documentation for the 'zone' window, you can read about the zones.";



	M.E.setExplain(S);
	M.E.repaint();
    }


    public void colorInfo() {
	String S="This control panel lets you change the colors of various objects on the tiling window. You should first select a color using the color selector at the bottom of the control panel.  Once you have selected a color you like, you can click on one of the buttons in this window.  Some of the options refer to already existing objects, such as the background color, and other options refer to objects that will appear when you plot them.";

	M.E.setExplain(S);
	    M.E.repaint();
    }





}


