import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class IntegerPolyWedge {
    int[][] z=new int[7][4];
    int count;


    public IntegerPolyWedge() {}

    public IntegerPolyWedge(PolyWedge X) {
	for(int i=0;i<X.count;++i) {
	    int[] q1=recognizeGolden(X.z[i].x,200);
	    int[] q2=recognizeGolden(X.z[i].y,200);
	    this.z[i][0]=q1[0];
	    this.z[i][1]=q1[1];
	    this.z[i][2]=q2[0];
	    this.z[i][3]=q2[1];
	}
	this.count=X.count;
    }


    public PolyWedge toPolyWedge() {
	double PHI=(1.0+Math.sqrt(5.0))/2.0;
	PolyWedge X=new PolyWedge();
        X.count=count;
	for(int i=0;i<count;++i) {
	    X.z[i]=new Complex();
	    X.z[i].x=z[i][0]+z[i][1]*PHI;
	    X.z[i].y=z[i][2]+z[i][3]*PHI;
	    X.z[i].x=X.z[i].x/2;
	    X.z[i].y=X.z[i].y/2;
	}
	return(X);
    }



    public IntegerPolyWedge swap() {
	IntegerPolyWedge X=new IntegerPolyWedge();
	X.count=count;
	for(int i=0;i<count;++i) {
	    X.z[i][0]=z[i][2];
	    X.z[i][1]=z[i][3];
	    X.z[i][2]=z[i][0];
	    X.z[i][3]=z[i][1];
	}
	return(X);
    }



    public static int[] recognizeGolden(double d,int depth) {
	double phi=(1+Math.sqrt(5))/2;
	double min=1000.0;
	double test=0;
	int ii=0;
	int jj=0;

	for(int j=-depth;j<=depth;++j) {
	    int lim1=(int)(Math.floor(2*d-2-j*phi));
	    int lim2=(int)(Math.floor(2*d+2-j*phi))+1;
	    for(int i=lim1;i<lim2;++i) {
		test=Math.abs(i/2.0+j*phi/2.0-d);
		if(min>test) {ii=i;jj=j;min=test;}
	    }
	}
	int[] ans={ii,jj};
	if(min<.000000001) return(ans);
	ans[0]=9999999;
	ans[1]=9999999;
	return(ans);
    }




    public void print() {
	for(int i=0;i<count;++i) {
	    System.out.println(z[i][0]+" "+z[i][1]+"   "+z[i][2]+" "+z[i][3]);
	}
    }


}

