import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PenroseComputeGraph implements Runnable {
    Manager M;
    Quad QUAD;  
    Complex SOURCE;
    double PHI=(1.0+Math.sqrt(5.0))/2.0;
    int halt;
    PenroseGeneList GL;
    int[] gene=new int[20];
    int[] CONVERT={0,1,2,3,4,5,6,5,6,7,8,9,10,9,10,11,12,11,12,13,14,15,15,15};
    PenrosePartition PX;
    int export;
    Output writer;
    double A;

    public PenroseComputeGraph() {
    }

    public PenroseComputeGraph(double a,Complex z,Manager MM) {
	this.A=a;
	this.SOURCE=new Complex(z.x,z.y);
	this.M=MM;
	PX=new PenrosePartition();
    }




    public void run() {
	int a3=M.C.CON_X.SEQS.mode;
	if(a3==0)  orbitPlotSequence();   
	if(a3==1)  orbitPlotShadow();     
    }



  public Complex transformPoint(Complex z) {
	Complex temp2=new Complex();
	temp2.x= 2-6*z.x+2*z.y;
	temp2.y=-1+4*z.x;
	return(temp2);
    }




    /*requires certain congruence properties - which we have*/
   public int[][] affineChange(int[][] X) {
      int[][] Y=new int[2][2];
      Y[1][0]=X[1][0];
      Y[1][1]=X[1][1];

      double d0=.25*X[0][1]+.25;
      double d1=.5*X[0][0]+.75*X[0][1]-.25;
      Y[0][0]=(int)(d0);
      Y[0][1]=(int)(d1);
      return(Y);
   }


   public double[][] affineChange(double[][] X) {
      double[][] Y=new double[2][2];
      Y[1][0]=X[1][0];
      Y[1][1]=X[1][1];
      Y[0][0]=.25*X[0][1]+.25;
      Y[0][1]= .5*X[0][0]+.75*X[0][1]-.25;
      return(Y);
   }



    public int[][] loadStart() {
	double[][] X=new double[2][2];
	Complex temp2=transformPoint(SOURCE);
	X[0][0]=temp2.x;
	X[0][1]=temp2.y;
	double[][] YY=new double[2][2];
	YY=affineChange(X);
        int[][] Y=new int[2][2];
	Y[0][0]=(int)(YY[0][0]);
	Y[0][1]=(int)(YY[0][1]);
	Y[1][0]=(int)(YY[1][0]);
	Y[1][1]=(int)(YY[1][1]);
	return(Y);
    }


    public int[][] doMove(int k) {
	int[][] vec=new int[2][2];
	if(k==0)  { vec[0][0]= 0;vec[0][1]=-0;vec[1][0]=-0;vec[1][1]= 0;}
	if(k==1)  { vec[0][0]= 0;vec[0][1]= 1;vec[1][0]= 1;vec[1][1]= 1;}
	if(k==2)  { vec[0][0]= 0;vec[0][1]=-1;vec[1][0]=-1;vec[1][1]=-1;}
	if(k==3)  { vec[0][0]= 1;vec[0][1]= 1;vec[1][0]=-1;vec[1][1]= 1;}
	if(k==4)  { vec[0][0]=-1;vec[0][1]=-1;vec[1][0]= 1;vec[1][1]=-1;}
	if(k==5)  { vec[0][0]=-1;vec[0][1]= 1;vec[1][0]= 0;vec[1][1]=-1;}
	if(k==6)  { vec[0][0]= 1;vec[0][1]=-1;vec[1][0]= 0;vec[1][1]= 1;}
	if(k==7)  { vec[0][0]= 0;vec[0][1]= 1;vec[1][0]=-1;vec[1][1]=-1;}
	if(k==8)  { vec[0][0]= 0;vec[0][1]=-1;vec[1][0]= 1;vec[1][1]= 1;}
	if(k==9)  { vec[0][0]=-1;vec[0][1]= 0;vec[1][0]= 1;vec[1][1]= 1;}
	if(k==10) { vec[0][0]= 1;vec[0][1]= 0;vec[1][0]=-1;vec[1][1]=-1;}
	if(k==11) { vec[0][0]=-1;vec[0][1]= 0;vec[1][0]= 0;vec[1][1]=-1;}
	if(k==12) { vec[0][0]= 1;vec[0][1]= 0;vec[1][0]= 0;vec[1][1]= 1;}
	if(k==13) { vec[0][0]= 0;vec[0][1]= 1;vec[1][0]=-1;vec[1][1]= 0;}
	if(k==14) { vec[0][0]= 0;vec[0][1]=-1;vec[1][0]= 1;vec[1][1]= 0;}
	if(k==15) { vec[0][0]= 0;vec[0][1]= 1;vec[1][0]= 0;vec[1][1]=-1;}
	return(vec);
    }


    public void orbitPlotAuto() {

	double LIM=Math.pow(2,12);
	halt=1;
        GeneralPath gp=new GeneralPath();
	gp.moveTo(0,0);
	int count=0;
	int init=0;

	int[][] Y=loadStart();
	int[] Y0=new int[2];
	int[] Y1=new int[2];
	int[] Y2=new int[2];
	Y0[0]=Y[0][0];
	Y0[1]=Y[0][1];
	int type=0;
	int[][] move=new int[2][2];

	int choice=0;

	while((halt==1)&&(count<LIM)) {

	    if(init==1) {
	        type=CONVERT[M.RT.classify(Y1[0],Y1[1])];
		move=doMove(type);

	        Y2[0]=Y1[0]+move[0][0];
		Y2[1]=Y1[1]+move[0][1];
		if((Y2[0]==Y0[0])&&(Y2[1]==Y0[1])) {

                  Y2[0]=Y1[0]+move[1][0];
		  Y2[1]=Y1[1]+move[1][1];
		}
		Y0[0]=Y1[0];
		Y0[1]=Y1[1];
		Y1[0]=Y2[0];
		Y1[1]=Y2[1];
	    }

	    if(init==0) {
		type=CONVERT[M.RT.classify(Y0[0],Y0[1])];
		move=doMove(type);
		Y1[0]=Y0[0]+move[choice][0];
		Y1[1]=Y0[1]+move[choice][1];
		init=1;
	    }
            gp.moveTo((float)(Y0[0]),(float)(Y0[1]));
	    gp.lineTo((float)(Y1[0]),(float)(Y1[1]));
	    double test=Math.abs(Y1[0]-Y[0][0])+Math.abs(Y1[1]-Y[0][1]);
	    if(test<.1) halt=0;

	    ++count;
	}
	halt=0;
	M.R.nextPathLast(gp);
	M.R.repaint();
    }














    public void orbitPlotSequence() {

	double LIM=Math.pow(2,M.C.CON_X.INT[0].val);
	GL=new PenroseGeneList();
	GL.girth=M.C.CON_X.INT[1].val;
	int half=(GL.girth-1)/2;


	halt=1;
        GeneralPath gp=new GeneralPath();
	int count=0;
	int init=0;

	int[][] Y=loadStart();
	int[] Y0=new int[2];
	int[] Y1=new int[2];
	int[] Y2=new int[2];
	Y0[0]=Y[0][0];
	Y0[1]=Y[0][1];
	int type=0;
	int[][] move=new int[2][2];

	int enhanced=0;

	int[][] spot=new int[10][2];
	for(int i=0;i<GL.girth;++i) gene[i]=0;
	int clock_mode=0;
	int clock_count=0;
	int count2=0;

	PenrosePartition PX=new PenrosePartition();


	while((halt==1)&&(count<LIM)) {

	    if(init==1) {
		enhanced=M.RT.classify(Y1[0],Y1[1]);
	        type=CONVERT[enhanced];
	        move=doMove(type);

	        Y2[0]=Y1[0]+move[0][0];
		Y2[1]=Y1[1]+move[0][1];

		if((Y2[0]==Y0[0])&&(Y2[1]==Y0[1])) {
                  Y2[0]=Y1[0]+move[1][0];
		  Y2[1]=Y1[1]+move[1][1];
		}

		int test1=Y2[0]-Y1[0];
		int test2=Y2[1]-Y1[1];
		int sign=1;
		if(enhanced%2==1) sign=assignDirections(enhanced,test1,test2);
		if(enhanced%2==0) sign=assignDirections(enhanced-1,-test1,-test2);
		enhanced=enhanced*sign;

		Y0[0]=Y1[0];
		Y0[1]=Y1[1];
		Y1[0]=Y2[0];
		Y1[1]=Y2[1];



		for(int k=0;k<GL.girth-1;++k) {
                      gene[k]=gene[k+1];
		      spot[k][0]=spot[k+1][0];
		      spot[k][1]=spot[k+1][1];
		}
			      
		gene[GL.girth-1]=enhanced;
		spot[GL.girth-1][0]=Y1[0];
		spot[GL.girth-1][1]=Y1[1];


		if((gene[0]!=0)&&(gene[half]>0)) {
                           int did=GL.augmentList(gene);
			   if(did==-1) {
			       ++count2;
			   }
		}
	    }

	    if(init==0) {
		type=CONVERT[M.RT.classify(Y0[0],Y0[1])];
		move=doMove(type);
		Y1[0]=Y0[0]+move[0][0];
		Y1[1]=Y0[1]+move[0][1];
		init=1;
	    }

            gp.moveTo((float)(Y0[0]),(float)(Y0[1]));
	    gp.lineTo((float)(Y1[0]),(float)(Y1[1]));   

	    ++count;

            double test=Math.abs(Y1[0]-Y[0][0])+Math.abs(Y1[1]-Y[0][1]);
	    if(test<.1) clock_mode=1;
	    if(clock_mode==1) ++clock_count;
	    if(clock_count>GL.girth+1) halt=0;

	}
	halt=0;
	M.C.CON_X.SH.list=GL.list;
	M.C.CON_X.SH.total=GL.count;
	M.C.CON_X.SH.process(new Point(),Color.black,GL.girth);
	M.C.repaint();
	M.R.nextPathLast(gp);
	M.R.repaint();
    }




    public void orbitPlotShadow() {
	    orbitPlotShadow(M.C.CON_X.SH.current);
    }


    public void orbitPlotShadow(int current) {
	int[][] X=getSequenceLocation(current);
	int[][] h1=M.RT.generateShadow(X[0][0],X[0][1],1);
	int[][] h3=M.RT.generateShadow(X[2][0],X[2][1],1);
	PenroseShadowData U=makeConnection(h1,X,h3);
	for(int i=0;i<3;++i) {
	   U.POS[i][0]=X[i][0];
	   U.POS[i][1]=X[i][1];
	}

	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(X[1][0]-.25),(float)(X[1][1]-.25));
	gp.lineTo((float)(X[1][0]+.25),(float)(X[1][1]-.25));
	gp.lineTo((float)(X[1][0]+.25),(float)(X[1][1]+.25));
	gp.lineTo((float)(X[1][0]-.25),(float)(X[1][1]+.25));
	gp.closePath();
	M.R.setMarker(gp);

	M.C.CON_X.SH.shadow=U;
	M.C.repaint();
	M.R.repaint();
	M.RT.repaint();
    }





    public int[][] getSequenceLocation(int current) {
	int[][] A=new int[3][2];
	if(current==-1) {
	    A[0][0]=0;
	    A[0][1]=0;
	    A[1][0]=0;
	    A[1][1]=0;
	    A[2][0]=0;
	    A[2][1]=0;
	    return(A);
	}

	GL=new PenroseGeneList();
	GL.girth=M.C.CON_X.INT[1].val;      
	int[] goal=new int[100];
	if(current>=0)	goal=M.C.CON_X.SH.list[current];
	double LIM=Math.pow(2,M.C.CON_X.INT[0].val);

	halt=1;
	int count=0;
	int init=0;
	int enhanced=0;

	int[][] Y=loadStart();
	int[] xx=new int[GL.girth+1];
	int[] yy=new int[GL.girth+1];

	int[] Y0=new int[2];
	int[] Y1=new int[2];
	int[] Y2=new int[2];
	Y0[0]=Y[0][0];
	Y0[1]=Y[0][1];
	int type=0;
	int[][] move=new int[2][2];

	for(int i=0;i<GL.girth;++i) gene[i]=0;

	while((halt==1)&&(count<LIM)) {

	    if(init==1) {
		enhanced=M.RT.classify(Y1[0],Y1[1]);
	        type=CONVERT[enhanced];
	        move=doMove(type);

	        Y2[0]=Y1[0]+move[0][0];
		Y2[1]=Y1[1]+move[0][1];

		if((Y2[0]==Y0[0])&&(Y2[1]==Y0[1])) {
                  Y2[0]=Y1[0]+move[1][0];
		  Y2[1]=Y1[1]+move[1][1];
		}

		int test1=Y2[0]-Y1[0];
		int test2=Y2[1]-Y1[1];

		int sign=1;
		if(enhanced%2==1) sign=assignDirections(enhanced,test1,test2);
		if(enhanced%2==0) sign=assignDirections(enhanced-1,-test1,-test2);
		enhanced=enhanced*sign;

		Y0[0]=Y1[0];
		Y0[1]=Y1[1];
		Y1[0]=Y2[0];
		Y1[1]=Y2[1];

		for(int k=0;k<GL.girth-1;++k) gene[k]=gene[k+1];
		gene[GL.girth-1]=enhanced;

	        if(GL.match(gene,goal,GL.girth)==1) {
		    int t1=(GL.girth-1)/2;
		    int t2=t1+1;  
                    int t3=t1+2;

	            A[0][0]=xx[t1];
	            A[0][1]=yy[t1];
	            A[1][0]=xx[t2];
	            A[1][1]=yy[t2];
	            A[2][0]=xx[t3];
	            A[2][1]=yy[t3];
                    halt=0;
		}


                for(int k=0;k<GL.girth;++k) xx[k]=xx[k+1];
	        xx[GL.girth]=Y2[0];
		for(int k=0;k<GL.girth;++k)	yy[k]=yy[k+1];
		yy[GL.girth]=Y2[1];


	    }  

	    if(init==0) {
		type=CONVERT[M.RT.classify(Y0[0],Y0[1])];
		move=doMove(type);
		Y1[0]=Y0[0]+move[0][0];
		Y1[1]=Y0[1]+move[0][1];
		init=1;
	    }

	    ++count;
	}
	return(A);
    }


    public int assignDirections(int en,int t1,int t2) {
	if((en== 1)&&(t1==+1)&&(t2==+1)) return(1);
	if((en== 3)&&(t1==-1)&&(t2==+1)) return(1);
	if((en== 5)&&(t1==-1)&&(t2==+1)) return(1);
	if((en== 7)&&(t1==-1)&&(t2==+1)) return(1);
	if((en== 9)&&(t1==+0)&&(t2==+1)) return(1);
	if((en==11)&&(t1==+1)&&(t2==+1)) return(1);
	if((en==13)&&(t1==+1)&&(t2==+1)) return(1);
	if((en==15)&&(t1==+0)&&(t2==-1)) return(1);
	if((en==17)&&(t1==+0)&&(t2==-1)) return(1);
	if((en==19)&&(t1==+0)&&(t2==+1)) return(1);
	if((en==21)&&(t1==+0)&&(t2==+1)) return(1);
	if((en==22)&&(t1==+0)&&(t2==+1)) return(1);
	if((en==23)&&(t1==+0)&&(t2==+1)) return(1);
	return(-1);

    }


    public int[] magicPoint(PenroseProofData PD,int x,int y,int target) {
	double PHI=(1+Math.sqrt(5))/2;
	double PHI3=PHI*PHI*PHI;
	int[] a=new int[2];
	a[0]=0;
	a[1]=0;
	int x1=(int)(PHI3*x);
	int y1=(int)(PHI3*y);
	for(int i=-5;i<=5;++i) {
	    for(int j=-5;j<=5;++j) {
		int x2=x1+i;
		int y2=y1+j;
		IntegerComplex z=IntegerComplex.psi(x2,y2);
		int test=IntegerComplex.isLatticeOpenContained(z,PD.Y[target]);
		if(test==1) {
		    a[0]=x2;
		    a[1]=y2;
		}
	    }
	}
	return(a);
    }




    public PenroseShadowData makeConnection(int i0,int j0,int i1,int j1,int i2,int j2,int sign) {	

	GeneralPath Z=new GeneralPath();

        PenroseShadowData X=new PenroseShadowData();
	X.POS[3][0]=i0;
	X.POS[3][1]=j0;
	X.POS[5][0]=i2;
	X.POS[5][1]=j2;

	int[] seq=new int[220];
	int count=0;
	int init=0;
	int enhanced=0;

	int[][] Y=new int[2][2];
        Y[0][0]=i0;
        Y[0][1]=j0;
        Y[1][0]=0;
        Y[1][1]=0;

	int[] Y0=new int[2];
	int[] Y1=new int[2];
	int[] Y2=new int[2];
	Y0[0]=Y[0][0];
	Y0[1]=Y[0][1];
	int type=0;
	int[][] move=new int[2][2];
	int match=0;

        while((count<200)&&(match<2)) {

	    if(init==1) {

	        type=CONVERT[M.RT.classify(Y1[0],Y1[1])];
		enhanced=M.RT.classify(Y1[0],Y1[1]);
	        move=doMove(type);


	        Y2[0]=Y1[0]+move[0][0];
		Y2[1]=Y1[1]+move[0][1];	
                if((Y2[0]==Y0[0])&&(Y2[1]==Y0[1])) {
                  Y2[0]=Y1[0]+move[1][0];
		  Y2[1]=Y1[1]+move[1][1];
		}


	        Z.moveTo(Y1[0],Y1[1]);
	        Z.lineTo(Y2[0],Y2[1]);

	        int test1=Y2[0]-Y1[0];
		int test2=Y2[1]-Y1[1];
		int sg=1;
		if(enhanced%2==1) sg=assignDirections(enhanced,test1,test2);
		if(enhanced%2==0) sg=assignDirections(enhanced-1,-test1,-test2);
		enhanced=enhanced*sg;	
                seq[count]=enhanced;

		Y0[0]=Y1[0];
		Y0[1]=Y1[1];
		Y1[0]=Y2[0];
		Y1[1]=Y2[1];
		if(match==1) ++match;
	    }

	    if(init==0) {
		type=CONVERT[M.RT.classify(Y0[0],Y0[1])];
		enhanced=M.RT.classify(Y0[0],Y0[1]);
		move=doMove(type);
		Y1[0]=Y0[0]+move[sign][0];
		Y1[1]=Y0[1]+move[sign][1];

                Z.moveTo(Y0[0],Y0[1]);
	        Z.lineTo(Y1[0],Y1[1]);



                int test1=Y1[0]-Y0[0];
		int test2=Y1[1]-Y0[1];
		int sg=1;
		if(enhanced%2==1) sg=assignDirections(enhanced,test1,test2);
		if(enhanced%2==0) sg=assignDirections(enhanced-1,-test1,-test2);
		enhanced=enhanced*sg;	
                seq[count]=enhanced;
		init=1;
	    }

	    double d=Math.abs(Y2[0]-i2)+Math.abs(Y2[1]-j2);
	    if(d<.1) match=1;

	    if(M.RT.testInflate(Y2[0],Y2[1],i1,j1,1)==1) {
		X.POS[4][0]=Y2[0];
		X.POS[4][1]=Y2[1];
		X.middle=count+1;
	    }
	    ++count;
	}

	M.R.SHADOW=Z;

	if(count>180) {
	    X.seq=null;
	    return(X);
	}
	X.seq=new int[count];
	for(int i=0;i<count;++i) X.seq[i]=seq[i];
	return(X);

    }




    public PenroseShadowData makeConnection(int[][] h1,int[][] xx,int[][] h3) {
	PenroseShadowData X=new PenroseShadowData();
	int[] seq=new int[1000];
	for(int sign=0;sign<=1;++sign) {
	   for(int i=0;i<h1.length;++i) {
	    for(int j=0;j<h3.length;++j) {
		X=makeConnection(h1[i][0],h1[i][1],xx[1][0],xx[1][1],h3[j][0],h3[j][1],sign);
		if(X.seq!=null) return(X);
	    }
	   }
	}
	return(X);
    }



}

