import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PenrosePartition {
    double PHI=(1+Math.sqrt(5))/2;
    double PHI4=PHI*PHI*PHI*PHI;
    double PHI3=PHI*PHI*PHI;
    GeneralPath[] POLYGP=new GeneralPath[35];
    GeneralPath[] BABYGP=new GeneralPath[35];
    IntegerPolyWedge[] IPOLY=new IntegerPolyWedge[35];
    PolyWedge[] POLY=new PolyWedge[35];
    PolyWedge[] BABY=new PolyWedge[35];
    IntegerPolyWedge[] IBABY=new IntegerPolyWedge[35];
    Complex[][] MAP=new Complex[3][35];
    Complex[][] TRACE=new Complex[3][35];


    public PenrosePartition() {
	setBabies();
	setZones();
	setMap();
	setTrace();
    }

    public Complex shrink(Complex z) {
	Complex lambda=new Complex(-1.0/PHI3,0);
	Complex z0=new Complex(.5/PHI3,.5/(PHI*PHI));
	Complex z1=Complex.minus(z,z0);
	z1=Complex.times(lambda,z1);
	z1=Complex.plus(z0,z1);
	return(z1);
    }


    public PolyWedge shrink(PolyWedge X) {
	PolyWedge Y=new PolyWedge();
	Y.count=X.count;
	for(int i=0;i<Y.count;++i) Y.z[i]=shrink(X.z[i]);
	return(Y);
    }


   public PolyWedge reflect(PolyWedge X) {
	PolyWedge Y=new PolyWedge();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) {
	    Y.z[i]=new Complex(-X.z[i].x,-X.z[i].y);
	}
	return(Y);
    }



     public void setBabies() {

	double[] XP=new double[18];
	for(int i=0;i<=14;++i) XP[i]=Math.pow(PHI,-i);

	for(int i=1;i<=25;++i) {
                BABYGP[i]=new GeneralPath();
		BABY[i]=new PolyWedge();
		BABY[i].count=0;
	}

IBABY[1]=new IntegerPolyWedge();
IBABY[1].count=6;
IBABY[1].z[0][0]=5;IBABY[1].z[0][1]=-3;IBABY[1].z[0][2]=-6;IBABY[1].z[0][3]=4;
IBABY[1].z[1][0]=-8;IBABY[1].z[1][1]=5;IBABY[1].z[1][2]=10;IBABY[1].z[1][3]=-6;
IBABY[1].z[2][0]=13;IBABY[1].z[2][1]=-8;IBABY[1].z[2][2]=0;IBABY[1].z[2][3]=0;
IBABY[1].z[3][0]=5;IBABY[1].z[3][1]=-3;IBABY[1].z[3][2]=0;IBABY[1].z[3][3]=0;
IBABY[1].z[4][0]=-3;IBABY[1].z[4][1]=2;IBABY[1].z[4][2]=10;IBABY[1].z[4][3]=-6;
IBABY[1].z[5][0]=18;IBABY[1].z[5][1]=-11;IBABY[1].z[5][2]=-6;IBABY[1].z[5][3]=4;

IBABY[2]=new IntegerPolyWedge();
IBABY[2].count=6;
IBABY[2].z[0][0]=-5;IBABY[2].z[0][1]=3;IBABY[2].z[0][2]=6;IBABY[2].z[0][3]=-4;
IBABY[2].z[1][0]=8;IBABY[2].z[1][1]=-5;IBABY[2].z[1][2]=-10;IBABY[2].z[1][3]=6;
IBABY[2].z[2][0]=-13;IBABY[2].z[2][1]=8;IBABY[2].z[2][2]=0;IBABY[2].z[2][3]=0;
IBABY[2].z[3][0]=-5;IBABY[2].z[3][1]=3;IBABY[2].z[3][2]=0;IBABY[2].z[3][3]=0;
IBABY[2].z[4][0]=3;IBABY[2].z[4][1]=-2;IBABY[2].z[4][2]=-10;IBABY[2].z[4][3]=6;
IBABY[2].z[5][0]=-18;IBABY[2].z[5][1]=11;IBABY[2].z[5][2]=6;IBABY[2].z[5][3]=-4;

IBABY[3]=new IntegerPolyWedge();
IBABY[3].count=6;
IBABY[3].z[0][0]=5;IBABY[3].z[0][1]=-3;IBABY[3].z[0][2]=-12;IBABY[3].z[0][3]=8;
IBABY[3].z[1][0]=-8;IBABY[3].z[1][1]=5;IBABY[3].z[1][2]=4;IBABY[3].z[1][3]=-2;
IBABY[3].z[2][0]=13;IBABY[3].z[2][1]=-8;IBABY[3].z[2][2]=-6;IBABY[3].z[2][3]=4;
IBABY[3].z[3][0]=5;IBABY[3].z[3][1]=-3;IBABY[3].z[3][2]=-6;IBABY[3].z[3][3]=4;
IBABY[3].z[4][0]=-3;IBABY[3].z[4][1]=2;IBABY[3].z[4][2]=4;IBABY[3].z[4][3]=-2;
IBABY[3].z[5][0]=18;IBABY[3].z[5][1]=-11;IBABY[3].z[5][2]=-12;IBABY[3].z[5][3]=8;

IBABY[4]=new IntegerPolyWedge();
IBABY[4].count=6;
IBABY[4].z[0][0]=-5;IBABY[4].z[0][1]=3;IBABY[4].z[0][2]=12;IBABY[4].z[0][3]=-8;
IBABY[4].z[1][0]=8;IBABY[4].z[1][1]=-5;IBABY[4].z[1][2]=-4;IBABY[4].z[1][3]=2;
IBABY[4].z[2][0]=-13;IBABY[4].z[2][1]=8;IBABY[4].z[2][2]=6;IBABY[4].z[2][3]=-4;
IBABY[4].z[3][0]=-5;IBABY[4].z[3][1]=3;IBABY[4].z[3][2]=6;IBABY[4].z[3][3]=-4;
IBABY[4].z[4][0]=3;IBABY[4].z[4][1]=-2;IBABY[4].z[4][2]=-4;IBABY[4].z[4][3]=2;
IBABY[4].z[5][0]=-18;IBABY[4].z[5][1]=11;IBABY[4].z[5][2]=12;IBABY[4].z[5][3]=-8;

IBABY[5]=new IntegerPolyWedge();
IBABY[5].count=6;
IBABY[5].z[0][0]=-5;IBABY[5].z[0][1]=3;IBABY[5].z[0][2]=-6;IBABY[5].z[0][3]=4;
IBABY[5].z[1][0]=-18;IBABY[5].z[1][1]=11;IBABY[5].z[1][2]=10;IBABY[5].z[1][3]=-6;
IBABY[5].z[2][0]=3;IBABY[5].z[2][1]=-2;IBABY[5].z[2][2]=0;IBABY[5].z[2][3]=0;
IBABY[5].z[3][0]=-5;IBABY[5].z[3][1]=3;IBABY[5].z[3][2]=0;IBABY[5].z[3][3]=0;
IBABY[5].z[4][0]=-13;IBABY[5].z[4][1]=8;IBABY[5].z[4][2]=10;IBABY[5].z[4][3]=-6;
IBABY[5].z[5][0]=8;IBABY[5].z[5][1]=-5;IBABY[5].z[5][2]=-6;IBABY[5].z[5][3]=4;

IBABY[6]=new IntegerPolyWedge();
IBABY[6].count=6;
IBABY[6].z[0][0]=5;IBABY[6].z[0][1]=-3;IBABY[6].z[0][2]=6;IBABY[6].z[0][3]=-4;
IBABY[6].z[1][0]=18;IBABY[6].z[1][1]=-11;IBABY[6].z[1][2]=-10;IBABY[6].z[1][3]=6;
IBABY[6].z[2][0]=-3;IBABY[6].z[2][1]=2;IBABY[6].z[2][2]=0;IBABY[6].z[2][3]=0;
IBABY[6].z[3][0]=5;IBABY[6].z[3][1]=-3;IBABY[6].z[3][2]=0;IBABY[6].z[3][3]=0;
IBABY[6].z[4][0]=13;IBABY[6].z[4][1]=-8;IBABY[6].z[4][2]=-10;IBABY[6].z[4][3]=6;
IBABY[6].z[5][0]=-8;IBABY[6].z[5][1]=5;IBABY[6].z[5][2]=6;IBABY[6].z[5][3]=-4;

IBABY[7]=new IntegerPolyWedge();
IBABY[7].count=6;
IBABY[7].z[0][0]=11;IBABY[7].z[0][1]=-7;IBABY[7].z[0][2]=-14;IBABY[7].z[0][3]=8;
IBABY[7].z[1][0]=-2;IBABY[7].z[1][1]=1;IBABY[7].z[1][2]=2;IBABY[7].z[1][3]=-2;
IBABY[7].z[2][0]=19;IBABY[7].z[2][1]=-12;IBABY[7].z[2][2]=-8;IBABY[7].z[2][3]=4;
IBABY[7].z[3][0]=11;IBABY[7].z[3][1]=-7;IBABY[7].z[3][2]=-8;IBABY[7].z[3][3]=4;
IBABY[7].z[4][0]=3;IBABY[7].z[4][1]=-2;IBABY[7].z[4][2]=2;IBABY[7].z[4][3]=-2;
IBABY[7].z[5][0]=24;IBABY[7].z[5][1]=-15;IBABY[7].z[5][2]=-14;IBABY[7].z[5][3]=8;

IBABY[8]=new IntegerPolyWedge();
IBABY[8].count=6;
IBABY[8].z[0][0]=-11;IBABY[8].z[0][1]=7;IBABY[8].z[0][2]=14;IBABY[8].z[0][3]=-8;
IBABY[8].z[1][0]=2;IBABY[8].z[1][1]=-1;IBABY[8].z[1][2]=-2;IBABY[8].z[1][3]=2;
IBABY[8].z[2][0]=-19;IBABY[8].z[2][1]=12;IBABY[8].z[2][2]=8;IBABY[8].z[2][3]=-4;
IBABY[8].z[3][0]=-11;IBABY[8].z[3][1]=7;IBABY[8].z[3][2]=8;IBABY[8].z[3][3]=-4;
IBABY[8].z[4][0]=-3;IBABY[8].z[4][1]=2;IBABY[8].z[4][2]=-2;IBABY[8].z[4][3]=2;
IBABY[8].z[5][0]=-24;IBABY[8].z[5][1]=15;IBABY[8].z[5][2]=14;IBABY[8].z[5][3]=-8;

IBABY[9]=new IntegerPolyWedge();
IBABY[9].count=6;
IBABY[9].z[0][0]=-11;IBABY[9].z[0][1]=7;IBABY[9].z[0][2]=0;IBABY[9].z[0][3]=0;
IBABY[9].z[1][0]=2;IBABY[9].z[1][1]=-1;IBABY[9].z[1][2]=0;IBABY[9].z[1][3]=0;
IBABY[9].z[2][0]=-19;IBABY[9].z[2][1]=12;IBABY[9].z[2][2]=16;IBABY[9].z[2][3]=-10;
IBABY[9].z[3][0]=-11;IBABY[9].z[3][1]=7;IBABY[9].z[3][2]=6;IBABY[9].z[3][3]=-4;
IBABY[9].z[4][0]=-3;IBABY[9].z[4][1]=2;IBABY[9].z[4][2]=6;IBABY[9].z[4][3]=-4;
IBABY[9].z[5][0]=-24;IBABY[9].z[5][1]=15;IBABY[9].z[5][2]=16;IBABY[9].z[5][3]=-10;

IBABY[10]=new IntegerPolyWedge();
IBABY[10].count=6;
IBABY[10].z[0][0]=11;IBABY[10].z[0][1]=-7;IBABY[10].z[0][2]=0;IBABY[10].z[0][3]=0;
IBABY[10].z[1][0]=-2;IBABY[10].z[1][1]=1;IBABY[10].z[1][2]=0;IBABY[10].z[1][3]=0;
IBABY[10].z[2][0]=19;IBABY[10].z[2][1]=-12;IBABY[10].z[2][2]=-16;IBABY[10].z[2][3]=10;
IBABY[10].z[3][0]=11;IBABY[10].z[3][1]=-7;IBABY[10].z[3][2]=-6;IBABY[10].z[3][3]=4;
IBABY[10].z[4][0]=3;IBABY[10].z[4][1]=-2;IBABY[10].z[4][2]=-6;IBABY[10].z[4][3]=4;
IBABY[10].z[5][0]=24;IBABY[10].z[5][1]=-15;IBABY[10].z[5][2]=-16;IBABY[10].z[5][3]=10;

IBABY[11]=new IntegerPolyWedge();
IBABY[11].count=6;
IBABY[11].z[0][0]=9;IBABY[11].z[0][1]=-5;IBABY[11].z[0][2]=-12;IBABY[11].z[0][3]=8;
IBABY[11].z[1][0]=-4;IBABY[11].z[1][1]=3;IBABY[11].z[1][2]=4;IBABY[11].z[1][3]=-2;
IBABY[11].z[2][0]=17;IBABY[11].z[2][1]=-10;IBABY[11].z[2][2]=-6;IBABY[11].z[2][3]=4;
IBABY[11].z[3][0]=9;IBABY[11].z[3][1]=-5;IBABY[11].z[3][2]=-6;IBABY[11].z[3][3]=4;
IBABY[11].z[4][0]=1;IBABY[11].z[4][1]=0;IBABY[11].z[4][2]=4;IBABY[11].z[4][3]=-2;
IBABY[11].z[5][0]=22;IBABY[11].z[5][1]=-13;IBABY[11].z[5][2]=-12;IBABY[11].z[5][3]=8;

IBABY[12]=new IntegerPolyWedge();
IBABY[12].count=6;
IBABY[12].z[0][0]=-9;IBABY[12].z[0][1]=5;IBABY[12].z[0][2]=12;IBABY[12].z[0][3]=-8;
IBABY[12].z[1][0]=4;IBABY[12].z[1][1]=-3;IBABY[12].z[1][2]=-4;IBABY[12].z[1][3]=2;
IBABY[12].z[2][0]=-17;IBABY[12].z[2][1]=10;IBABY[12].z[2][2]=6;IBABY[12].z[2][3]=-4;
IBABY[12].z[3][0]=-9;IBABY[12].z[3][1]=5;IBABY[12].z[3][2]=6;IBABY[12].z[3][3]=-4;
IBABY[12].z[4][0]=-1;IBABY[12].z[4][1]=0;IBABY[12].z[4][2]=-4;IBABY[12].z[4][3]=2;
IBABY[12].z[5][0]=-22;IBABY[12].z[5][1]=13;IBABY[12].z[5][2]=12;IBABY[12].z[5][3]=-8;

IBABY[13]=new IntegerPolyWedge();
IBABY[13].count=6;
IBABY[13].z[0][0]=-9;IBABY[13].z[0][1]=5;IBABY[13].z[0][2]=-2;IBABY[13].z[0][3]=0;
IBABY[13].z[1][0]=4;IBABY[13].z[1][1]=-3;IBABY[13].z[1][2]=-2;IBABY[13].z[1][3]=0;
IBABY[13].z[2][0]=-17;IBABY[13].z[2][1]=10;IBABY[13].z[2][2]=14;IBABY[13].z[2][3]=-10;
IBABY[13].z[3][0]=-9;IBABY[13].z[3][1]=5;IBABY[13].z[3][2]=4;IBABY[13].z[3][3]=-4;
IBABY[13].z[4][0]=-1;IBABY[13].z[4][1]=0;IBABY[13].z[4][2]=4;IBABY[13].z[4][3]=-4;
IBABY[13].z[5][0]=-22;IBABY[13].z[5][1]=13;IBABY[13].z[5][2]=14;IBABY[13].z[5][3]=-10;

IBABY[14]=new IntegerPolyWedge();
IBABY[14].count=6;
IBABY[14].z[0][0]=9;IBABY[14].z[0][1]=-5;IBABY[14].z[0][2]=2;IBABY[14].z[0][3]=0;
IBABY[14].z[1][0]=-4;IBABY[14].z[1][1]=3;IBABY[14].z[1][2]=2;IBABY[14].z[1][3]=0;
IBABY[14].z[2][0]=17;IBABY[14].z[2][1]=-10;IBABY[14].z[2][2]=-14;IBABY[14].z[2][3]=10;
IBABY[14].z[3][0]=9;IBABY[14].z[3][1]=-5;IBABY[14].z[3][2]=-4;IBABY[14].z[3][3]=4;
IBABY[14].z[4][0]=1;IBABY[14].z[4][1]=0;IBABY[14].z[4][2]=-4;IBABY[14].z[4][3]=4;
IBABY[14].z[5][0]=22;IBABY[14].z[5][1]=-13;IBABY[14].z[5][2]=-14;IBABY[14].z[5][3]=10;

IBABY[15]=new IntegerPolyWedge();
IBABY[15].count=4;
IBABY[15].z[0][0]=5;IBABY[15].z[0][1]=-3;IBABY[15].z[0][2]=0;IBABY[15].z[0][3]=0;
IBABY[15].z[1][0]=10;IBABY[15].z[1][1]=-6;IBABY[15].z[1][2]=-6;IBABY[15].z[1][3]=4;
IBABY[15].z[2][0]=-11;IBABY[15].z[2][1]=7;IBABY[15].z[2][2]=10;IBABY[15].z[2][3]=-6;
IBABY[15].z[3][0]=10;IBABY[15].z[3][1]=-6;IBABY[15].z[3][2]=0;IBABY[15].z[3][3]=0;

IBABY[16]=new IntegerPolyWedge();
IBABY[16].count=4;
IBABY[16].z[0][0]=-5;IBABY[16].z[0][1]=3;IBABY[16].z[0][2]=0;IBABY[16].z[0][3]=0;
IBABY[16].z[1][0]=-10;IBABY[16].z[1][1]=6;IBABY[16].z[1][2]=6;IBABY[16].z[1][3]=-4;
IBABY[16].z[2][0]=11;IBABY[16].z[2][1]=-7;IBABY[16].z[2][2]=-10;IBABY[16].z[2][3]=6;
IBABY[16].z[3][0]=-10;IBABY[16].z[3][1]=6;IBABY[16].z[3][2]=0;IBABY[16].z[3][3]=0;

IBABY[17]=new IntegerPolyWedge();
IBABY[17].count=4;
IBABY[17].z[0][0]=-5;IBABY[17].z[0][1]=3;IBABY[17].z[0][2]=2;IBABY[17].z[0][3]=-2;
IBABY[17].z[1][0]=16;IBABY[17].z[1][1]=-10;IBABY[17].z[1][2]=-8;IBABY[17].z[1][3]=4;
IBABY[17].z[2][0]=11;IBABY[17].z[2][1]=-7;IBABY[17].z[2][2]=-8;IBABY[17].z[2][3]=4;
IBABY[17].z[3][0]=16;IBABY[17].z[3][1]=-10;IBABY[17].z[3][2]=-14;IBABY[17].z[3][3]=8;

IBABY[18]=new IntegerPolyWedge();
IBABY[18].count=4;
IBABY[18].z[0][0]=5;IBABY[18].z[0][1]=-3;IBABY[18].z[0][2]=-2;IBABY[18].z[0][3]=2;
IBABY[18].z[1][0]=-16;IBABY[18].z[1][1]=10;IBABY[18].z[1][2]=8;IBABY[18].z[1][3]=-4;
IBABY[18].z[2][0]=-11;IBABY[18].z[2][1]=7;IBABY[18].z[2][2]=8;IBABY[18].z[2][3]=-4;
IBABY[18].z[3][0]=-16;IBABY[18].z[3][1]=10;IBABY[18].z[3][2]=14;IBABY[18].z[3][3]=-8;

IBABY[19]=new IntegerPolyWedge();
IBABY[19].count=4;
IBABY[19].z[0][0]=-15;IBABY[19].z[0][1]=9;IBABY[19].z[0][2]=8;IBABY[19].z[0][3]=-6;
IBABY[19].z[1][0]=6;IBABY[19].z[1][1]=-4;IBABY[19].z[1][2]=-2;IBABY[19].z[1][3]=0;
IBABY[19].z[2][0]=1;IBABY[19].z[2][1]=-1;IBABY[19].z[2][2]=-2;IBABY[19].z[2][3]=0;
IBABY[19].z[3][0]=6;IBABY[19].z[3][1]=-4;IBABY[19].z[3][2]=-8;IBABY[19].z[3][3]=4;

IBABY[20]=new IntegerPolyWedge();
IBABY[20].count=4;
IBABY[20].z[0][0]=15;IBABY[20].z[0][1]=-9;IBABY[20].z[0][2]=-8;IBABY[20].z[0][3]=6;
IBABY[20].z[1][0]=-6;IBABY[20].z[1][1]=4;IBABY[20].z[1][2]=2;IBABY[20].z[1][3]=0;
IBABY[20].z[2][0]=-1;IBABY[20].z[2][1]=1;IBABY[20].z[2][2]=2;IBABY[20].z[2][3]=0;
IBABY[20].z[3][0]=-6;IBABY[20].z[3][1]=4;IBABY[20].z[3][2]=8;IBABY[20].z[3][3]=-4;

IBABY[21]=new IntegerPolyWedge();
IBABY[21].count=4;
IBABY[21].z[0][0]=-4;IBABY[21].z[0][1]=2;IBABY[21].z[0][2]=-2;IBABY[21].z[0][3]=0;
IBABY[21].z[1][0]=1;IBABY[21].z[1][1]=-1;IBABY[21].z[1][2]=-2;IBABY[21].z[1][3]=0;
IBABY[21].z[2][0]=-4;IBABY[21].z[2][1]=2;IBABY[21].z[2][2]=4;IBABY[21].z[2][3]=-4;
IBABY[21].z[3][0]=17;IBABY[21].z[3][1]=-11;IBABY[21].z[3][2]=-12;IBABY[21].z[3][3]=6;

IBABY[22]=new IntegerPolyWedge();
IBABY[22].count=4;
IBABY[22].z[0][0]=4;IBABY[22].z[0][1]=-2;IBABY[22].z[0][2]=2;IBABY[22].z[0][3]=0;
IBABY[22].z[1][0]=-1;IBABY[22].z[1][1]=1;IBABY[22].z[1][2]=2;IBABY[22].z[1][3]=0;
IBABY[22].z[2][0]=4;IBABY[22].z[2][1]=-2;IBABY[22].z[2][2]=-4;IBABY[22].z[2][3]=4;
IBABY[22].z[3][0]=-17;IBABY[22].z[3][1]=11;IBABY[22].z[3][2]=12;IBABY[22].z[3][3]=-6;

IBABY[23]=new IntegerPolyWedge();
IBABY[23].count=4;
IBABY[23].z[0][0]=-12;IBABY[23].z[0][1]=8;IBABY[23].z[0][2]=8;IBABY[23].z[0][3]=-4;
IBABY[23].z[1][0]=-7;IBABY[23].z[1][1]=5;IBABY[23].z[1][2]=8;IBABY[23].z[1][3]=-4;
IBABY[23].z[2][0]=-12;IBABY[23].z[2][1]=8;IBABY[23].z[2][2]=14;IBABY[23].z[2][3]=-8;
IBABY[23].z[3][0]=9;IBABY[23].z[3][1]=-5;IBABY[23].z[3][2]=-2;IBABY[23].z[3][3]=2;

IBABY[24]=new IntegerPolyWedge();
IBABY[24].count=4;
IBABY[24].z[0][0]=12;IBABY[24].z[0][1]=-8;IBABY[24].z[0][2]=-8;IBABY[24].z[0][3]=4;
IBABY[24].z[1][0]=7;IBABY[24].z[1][1]=-5;IBABY[24].z[1][2]=-8;IBABY[24].z[1][3]=4;
IBABY[24].z[2][0]=12;IBABY[24].z[2][1]=-8;IBABY[24].z[2][2]=-14;IBABY[24].z[2][3]=8;
IBABY[24].z[3][0]=-9;IBABY[24].z[3][1]=5;IBABY[24].z[3][2]=2;IBABY[24].z[3][3]=-2;

for(int i=1;i<=24;++i) BABY[i]=IBABY[i].toPolyWedge();
	for(int i=1;i<=24;++i) BABYGP[i]=BABY[i].toGeneralPath();


    }

    public void setZones() {

	double[] XP=new double[18];
	for(int i=0;i<=14;++i) XP[i]=Math.pow(PHI,-i);

	for(int i=1;i<=31;++i) {
                POLYGP[i]=new GeneralPath();
		POLY[i]=new PolyWedge();
		POLY[i].count=0;
	}


IPOLY[1]=new IntegerPolyWedge();
IPOLY[1].count=3;
IPOLY[1].z[0][0]=5;IPOLY[1].z[0][1]=-3;IPOLY[1].z[0][2]=0;IPOLY[1].z[0][3]=0;
IPOLY[1].z[1][0]=10;IPOLY[1].z[1][1]=-6;IPOLY[1].z[1][2]=-6;IPOLY[1].z[1][3]=4;
IPOLY[1].z[2][0]=2;IPOLY[1].z[2][1]=-1;IPOLY[1].z[2][2]=0;IPOLY[1].z[2][3]=0;

IPOLY[2]=new IntegerPolyWedge();
IPOLY[2].count=3;
IPOLY[2].z[0][0]=-5;IPOLY[2].z[0][1]=3;IPOLY[2].z[0][2]=0;IPOLY[2].z[0][3]=0;
IPOLY[2].z[1][0]=-10;IPOLY[2].z[1][1]=6;IPOLY[2].z[1][2]=6;IPOLY[2].z[1][3]=-4;
IPOLY[2].z[2][0]=-2;IPOLY[2].z[2][1]=1;IPOLY[2].z[2][2]=0;IPOLY[2].z[2][3]=0;

IPOLY[3]=new IntegerPolyWedge();
IPOLY[3].count=4;
IPOLY[3].z[0][0]=0;IPOLY[3].z[0][1]=0;IPOLY[3].z[0][2]=0;IPOLY[3].z[0][3]=0;
IPOLY[3].z[1][0]=5;IPOLY[3].z[1][1]=-3;IPOLY[3].z[1][2]=0;IPOLY[3].z[1][3]=0;
IPOLY[3].z[2][0]=10;IPOLY[3].z[2][1]=-6;IPOLY[3].z[2][2]=-6;IPOLY[3].z[2][3]=4;
IPOLY[3].z[3][0]=5;IPOLY[3].z[3][1]=-3;IPOLY[3].z[3][2]=-6;IPOLY[3].z[3][3]=4;

IPOLY[4]=new IntegerPolyWedge();
IPOLY[4].count=4;
IPOLY[4].z[0][0]=0;IPOLY[4].z[0][1]=0;IPOLY[4].z[0][2]=0;IPOLY[4].z[0][3]=0;
IPOLY[4].z[1][0]=-5;IPOLY[4].z[1][1]=3;IPOLY[4].z[1][2]=0;IPOLY[4].z[1][3]=0;
IPOLY[4].z[2][0]=-10;IPOLY[4].z[2][1]=6;IPOLY[4].z[2][2]=6;IPOLY[4].z[2][3]=-4;
IPOLY[4].z[3][0]=-5;IPOLY[4].z[3][1]=3;IPOLY[4].z[3][2]=6;IPOLY[4].z[3][3]=-4;

IPOLY[5]=new IntegerPolyWedge();
IPOLY[5].count=3;
IPOLY[5].z[0][0]=0;IPOLY[5].z[0][1]=0;IPOLY[5].z[0][2]=0;IPOLY[5].z[0][3]=0;
IPOLY[5].z[1][0]=13;IPOLY[5].z[1][1]=-8;IPOLY[5].z[1][2]=-6;IPOLY[5].z[1][3]=4;
IPOLY[5].z[2][0]=5;IPOLY[5].z[2][1]=-3;IPOLY[5].z[2][2]=-6;IPOLY[5].z[2][3]=4;

IPOLY[6]=new IntegerPolyWedge();
IPOLY[6].count=3;
IPOLY[6].z[0][0]=0;IPOLY[6].z[0][1]=0;IPOLY[6].z[0][2]=0;IPOLY[6].z[0][3]=0;
IPOLY[6].z[1][0]=-13;IPOLY[6].z[1][1]=8;IPOLY[6].z[1][2]=6;IPOLY[6].z[1][3]=-4;
IPOLY[6].z[2][0]=-5;IPOLY[6].z[2][1]=3;IPOLY[6].z[2][2]=6;IPOLY[6].z[2][3]=-4;

IPOLY[7]=new IntegerPolyWedge();
IPOLY[7].count=4;
IPOLY[7].z[0][0]=9;IPOLY[7].z[0][1]=-5;IPOLY[7].z[0][2]=-4;IPOLY[7].z[0][3]=4;
IPOLY[7].z[1][0]=4;IPOLY[7].z[1][1]=-2;IPOLY[7].z[1][2]=2;IPOLY[7].z[1][3]=0;
IPOLY[7].z[2][0]=1;IPOLY[7].z[2][1]=0;IPOLY[7].z[2][2]=2;IPOLY[7].z[2][3]=0;
IPOLY[7].z[3][0]=14;IPOLY[7].z[3][1]=-8;IPOLY[7].z[3][2]=-4;IPOLY[7].z[3][3]=4;

IPOLY[8]=new IntegerPolyWedge();
IPOLY[8].count=4;
IPOLY[8].z[0][0]=-9;IPOLY[8].z[0][1]=5;IPOLY[8].z[0][2]=4;IPOLY[8].z[0][3]=-4;
IPOLY[8].z[1][0]=-4;IPOLY[8].z[1][1]=2;IPOLY[8].z[1][2]=-2;IPOLY[8].z[1][3]=0;
IPOLY[8].z[2][0]=-1;IPOLY[8].z[2][1]=0;IPOLY[8].z[2][2]=-2;IPOLY[8].z[2][3]=0;
IPOLY[8].z[3][0]=-14;IPOLY[8].z[3][1]=8;IPOLY[8].z[3][2]=4;IPOLY[8].z[3][3]=-4;

IPOLY[9]=new IntegerPolyWedge();
IPOLY[9].count=5;
IPOLY[9].z[0][0]=3;IPOLY[9].z[0][1]=-2;IPOLY[9].z[0][2]=-4;IPOLY[9].z[0][3]=2;
IPOLY[9].z[1][0]=-5;IPOLY[9].z[1][1]=3;IPOLY[9].z[1][2]=2;IPOLY[9].z[1][3]=-2;
IPOLY[9].z[2][0]=3;IPOLY[9].z[2][1]=-2;IPOLY[9].z[2][2]=-2;IPOLY[9].z[2][3]=0;
IPOLY[9].z[3][0]=-2;IPOLY[9].z[3][1]=1;IPOLY[9].z[3][2]=-2;IPOLY[9].z[3][3]=0;
IPOLY[9].z[4][0]=6;IPOLY[9].z[4][1]=-4;IPOLY[9].z[4][2]=-8;IPOLY[9].z[4][3]=4;

IPOLY[10]=new IntegerPolyWedge();
IPOLY[10].count=5;
IPOLY[10].z[0][0]=-3;IPOLY[10].z[0][1]=2;IPOLY[10].z[0][2]=4;IPOLY[10].z[0][3]=-2;
IPOLY[10].z[1][0]=5;IPOLY[10].z[1][1]=-3;IPOLY[10].z[1][2]=-2;IPOLY[10].z[1][3]=2;
IPOLY[10].z[2][0]=-3;IPOLY[10].z[2][1]=2;IPOLY[10].z[2][2]=2;IPOLY[10].z[2][3]=0;
IPOLY[10].z[3][0]=2;IPOLY[10].z[3][1]=-1;IPOLY[10].z[3][2]=2;IPOLY[10].z[3][3]=0;
IPOLY[10].z[4][0]=-6;IPOLY[10].z[4][1]=4;IPOLY[10].z[4][2]=8;IPOLY[10].z[4][3]=-4;

IPOLY[11]=new IntegerPolyWedge();
IPOLY[11].count=3;
IPOLY[11].z[0][0]=0;IPOLY[11].z[0][1]=0;IPOLY[11].z[0][2]=0;IPOLY[11].z[0][3]=0;
IPOLY[11].z[1][0]=5;IPOLY[11].z[1][1]=-3;IPOLY[11].z[1][2]=-4;IPOLY[11].z[1][3]=2;
IPOLY[11].z[2][0]=-3;IPOLY[11].z[2][1]=2;IPOLY[11].z[2][2]=0;IPOLY[11].z[2][3]=0;

IPOLY[12]=new IntegerPolyWedge();
IPOLY[12].count=3;
IPOLY[12].z[0][0]=0;IPOLY[12].z[0][1]=0;IPOLY[12].z[0][2]=0;IPOLY[12].z[0][3]=0;
IPOLY[12].z[1][0]=-5;IPOLY[12].z[1][1]=3;IPOLY[12].z[1][2]=4;IPOLY[12].z[1][3]=-2;
IPOLY[12].z[2][0]=3;IPOLY[12].z[2][1]=-2;IPOLY[12].z[2][2]=0;IPOLY[12].z[2][3]=0;

IPOLY[13]=new IntegerPolyWedge();
IPOLY[13].count=3;
IPOLY[13].z[0][0]=10;IPOLY[13].z[0][1]=-6;IPOLY[13].z[0][2]=-6;IPOLY[13].z[0][3]=4;
IPOLY[13].z[1][0]=5;IPOLY[13].z[1][1]=-3;IPOLY[13].z[1][2]=-6;IPOLY[13].z[1][3]=4;
IPOLY[13].z[2][0]=-3;IPOLY[13].z[2][1]=2;IPOLY[13].z[2][2]=4;IPOLY[13].z[2][3]=-2;

IPOLY[14]=new IntegerPolyWedge();
IPOLY[14].count=3;
IPOLY[14].z[0][0]=-10;IPOLY[14].z[0][1]=6;IPOLY[14].z[0][2]=6;IPOLY[14].z[0][3]=-4;
IPOLY[14].z[1][0]=-5;IPOLY[14].z[1][1]=3;IPOLY[14].z[1][2]=6;IPOLY[14].z[1][3]=-4;
IPOLY[14].z[2][0]=3;IPOLY[14].z[2][1]=-2;IPOLY[14].z[2][2]=-4;IPOLY[14].z[2][3]=2;

IPOLY[15]=new IntegerPolyWedge();
IPOLY[15].count=4;
IPOLY[15].z[0][0]=13;IPOLY[15].z[0][1]=-8;IPOLY[15].z[0][2]=-6;IPOLY[15].z[0][3]=4;
IPOLY[15].z[1][0]=5;IPOLY[15].z[1][1]=-3;IPOLY[15].z[1][2]=-6;IPOLY[15].z[1][3]=4;
IPOLY[15].z[2][0]=-3;IPOLY[15].z[2][1]=2;IPOLY[15].z[2][2]=4;IPOLY[15].z[2][3]=-2;
IPOLY[15].z[3][0]=5;IPOLY[15].z[3][1]=-3;IPOLY[15].z[3][2]=-2;IPOLY[15].z[3][3]=2;

IPOLY[16]=new IntegerPolyWedge();
IPOLY[16].count=4;
IPOLY[16].z[0][0]=-13;IPOLY[16].z[0][1]=8;IPOLY[16].z[0][2]=6;IPOLY[16].z[0][3]=-4;
IPOLY[16].z[1][0]=-5;IPOLY[16].z[1][1]=3;IPOLY[16].z[1][2]=6;IPOLY[16].z[1][3]=-4;
IPOLY[16].z[2][0]=3;IPOLY[16].z[2][1]=-2;IPOLY[16].z[2][2]=-4;IPOLY[16].z[2][3]=2;
IPOLY[16].z[3][0]=-5;IPOLY[16].z[3][1]=3;IPOLY[16].z[3][2]=2;IPOLY[16].z[3][3]=-2;

IPOLY[17]=new IntegerPolyWedge();
IPOLY[17].count=3;
IPOLY[17].z[0][0]=12;IPOLY[17].z[0][1]=-8;IPOLY[17].z[0][2]=-8;IPOLY[17].z[0][3]=4;
IPOLY[17].z[1][0]=7;IPOLY[17].z[1][1]=-5;IPOLY[17].z[1][2]=-8;IPOLY[17].z[1][3]=4;
IPOLY[17].z[2][0]=4;IPOLY[17].z[2][1]=-3;IPOLY[17].z[2][2]=-4;IPOLY[17].z[2][3]=2;

IPOLY[18]=new IntegerPolyWedge();
IPOLY[18].count=3;
IPOLY[18].z[0][0]=-12;IPOLY[18].z[0][1]=8;IPOLY[18].z[0][2]=8;IPOLY[18].z[0][3]=-4;
IPOLY[18].z[1][0]=-7;IPOLY[18].z[1][1]=5;IPOLY[18].z[1][2]=8;IPOLY[18].z[1][3]=-4;
IPOLY[18].z[2][0]=-4;IPOLY[18].z[2][1]=3;IPOLY[18].z[2][2]=4;IPOLY[18].z[2][3]=-2;

IPOLY[19]=new IntegerPolyWedge();
IPOLY[19].count=3;
IPOLY[19].z[0][0]=-4;IPOLY[19].z[0][1]=2;IPOLY[19].z[0][2]=-2;IPOLY[19].z[0][3]=0;
IPOLY[19].z[1][0]=1;IPOLY[19].z[1][1]=-1;IPOLY[19].z[1][2]=-2;IPOLY[19].z[1][3]=0;
IPOLY[19].z[2][0]=4;IPOLY[19].z[2][1]=-3;IPOLY[19].z[2][2]=-6;IPOLY[19].z[2][3]=2;

IPOLY[20]=new IntegerPolyWedge();
IPOLY[20].count=3;
IPOLY[20].z[0][0]=4;IPOLY[20].z[0][1]=-2;IPOLY[20].z[0][2]=2;IPOLY[20].z[0][3]=0;
IPOLY[20].z[1][0]=-1;IPOLY[20].z[1][1]=1;IPOLY[20].z[1][2]=2;IPOLY[20].z[1][3]=0;
IPOLY[20].z[2][0]=-4;IPOLY[20].z[2][1]=3;IPOLY[20].z[2][2]=6;IPOLY[20].z[2][3]=-2;

IPOLY[21]=new IntegerPolyWedge();
IPOLY[21].count=3;
IPOLY[21].z[0][0]=1;IPOLY[21].z[0][1]=-1;IPOLY[21].z[0][2]=0;IPOLY[21].z[0][3]=0;
IPOLY[21].z[1][0]=6;IPOLY[21].z[1][1]=-4;IPOLY[21].z[1][2]=-6;IPOLY[21].z[1][3]=4;
IPOLY[21].z[2][0]=-2;IPOLY[21].z[2][1]=1;IPOLY[21].z[2][2]=0;IPOLY[21].z[2][3]=0;

IPOLY[22]=new IntegerPolyWedge();
IPOLY[22].count=3;
IPOLY[22].z[0][0]=-1;IPOLY[22].z[0][1]=1;IPOLY[22].z[0][2]=0;IPOLY[22].z[0][3]=0;
IPOLY[22].z[1][0]=-6;IPOLY[22].z[1][1]=4;IPOLY[22].z[1][2]=6;IPOLY[22].z[1][3]=-4;
IPOLY[22].z[2][0]=2;IPOLY[22].z[2][1]=-1;IPOLY[22].z[2][2]=0;IPOLY[22].z[2][3]=0;

IPOLY[23]=new IntegerPolyWedge();
IPOLY[23].count=4;
IPOLY[23].z[0][0]=6;IPOLY[23].z[0][1]=-3;IPOLY[23].z[0][2]=-2;IPOLY[23].z[0][3]=2;
IPOLY[23].z[1][0]=-2;IPOLY[23].z[1][1]=2;IPOLY[23].z[1][2]=2;IPOLY[23].z[1][3]=0;
IPOLY[23].z[2][0]=-4;IPOLY[23].z[2][1]=3;IPOLY[23].z[2][2]=4;IPOLY[23].z[2][3]=-2;
IPOLY[23].z[3][0]=4;IPOLY[23].z[3][1]=-2;IPOLY[23].z[3][2]=0;IPOLY[23].z[3][3]=0;

IPOLY[24]=new IntegerPolyWedge();
IPOLY[24].count=6;
IPOLY[24].z[0][0]=1;IPOLY[24].z[0][1]=-1;IPOLY[24].z[0][2]=0;IPOLY[24].z[0][3]=0;
IPOLY[24].z[1][0]=-2;IPOLY[24].z[1][1]=1;IPOLY[24].z[1][2]=0;IPOLY[24].z[1][3]=0;
IPOLY[24].z[2][0]=3;IPOLY[24].z[2][1]=-2;IPOLY[24].z[2][2]=-4;IPOLY[24].z[2][3]=2;
IPOLY[24].z[3][0]=1;IPOLY[24].z[3][1]=-1;IPOLY[24].z[3][2]=-2;IPOLY[24].z[3][3]=0;
IPOLY[24].z[4][0]=-1;IPOLY[24].z[4][1]=0;IPOLY[24].z[4][2]=-2;IPOLY[24].z[4][3]=0;
IPOLY[24].z[5][0]=4;IPOLY[24].z[5][1]=-3;IPOLY[24].z[5][2]=-4;IPOLY[24].z[5][3]=2;

IPOLY[25]=new IntegerPolyWedge();
IPOLY[25].count=6;
IPOLY[25].z[0][0]=-1;IPOLY[25].z[0][1]=1;IPOLY[25].z[0][2]=0;IPOLY[25].z[0][3]=0;
IPOLY[25].z[1][0]=2;IPOLY[25].z[1][1]=-1;IPOLY[25].z[1][2]=0;IPOLY[25].z[1][3]=0;
IPOLY[25].z[2][0]=-3;IPOLY[25].z[2][1]=2;IPOLY[25].z[2][2]=4;IPOLY[25].z[2][3]=-2;
IPOLY[25].z[3][0]=-1;IPOLY[25].z[3][1]=1;IPOLY[25].z[3][2]=2;IPOLY[25].z[3][3]=0;
IPOLY[25].z[4][0]=1;IPOLY[25].z[4][1]=0;IPOLY[25].z[4][2]=2;IPOLY[25].z[4][3]=0;
IPOLY[25].z[5][0]=-4;IPOLY[25].z[5][1]=3;IPOLY[25].z[5][2]=4;IPOLY[25].z[5][3]=-2;


IPOLY[26]=new IntegerPolyWedge();
IPOLY[26].count=3;
IPOLY[26].z[0][0]=0;IPOLY[26].z[0][1]=0;IPOLY[26].z[0][2]=0;IPOLY[26].z[0][3]=0;
IPOLY[26].z[1][0]=5;IPOLY[26].z[1][1]=-3;IPOLY[26].z[1][2]=-4;IPOLY[26].z[1][3]=2;
IPOLY[26].z[2][0]=0;IPOLY[26].z[2][1]=0;IPOLY[26].z[2][2]=-2;IPOLY[26].z[2][3]=0;

IPOLY[27]=new IntegerPolyWedge();
IPOLY[27].count=3;
IPOLY[27].z[0][0]=0;IPOLY[27].z[0][1]=0;IPOLY[27].z[0][2]=0;IPOLY[27].z[0][3]=0;
IPOLY[27].z[1][0]=0;IPOLY[27].z[1][1]=0;IPOLY[27].z[1][2]=-2;IPOLY[27].z[1][3]=0;
IPOLY[27].z[2][0]=-5;IPOLY[27].z[2][1]=3;IPOLY[27].z[2][2]=2;IPOLY[27].z[2][3]=-2;



for(int i=1;i<=27;++i)
POLY[i]=IPOLY[i].toPolyWedge();

	for(int i=1;i<=27;++i) POLYGP[i]=POLY[i].toGeneralPath();

	POLYGP[30].moveTo(-(float)(-10),-(float)(-.5));
	POLYGP[30].lineTo(-(float)(+10),-(float)(-.5));
	POLYGP[30].lineTo(-(float)(+10),-(float)(-1));
	POLYGP[30].lineTo(-(float)(-10),-(float)(-1));
	POLYGP[30].closePath();

	POLYGP[30].moveTo(-(float)(-10),-(float)(.505));
	POLYGP[30].lineTo(-(float)(+10),-(float)(.505));
	POLYGP[30].lineTo(-(float)(+10),-(float)(1));
	POLYGP[30].lineTo(-(float)(-10),-(float)(1));
	POLYGP[30].closePath();

	POLYGP[31].moveTo((float)(-.5),(float)(-10));
	POLYGP[31].lineTo((float)(-.5),(float)(+10));
	POLYGP[31].lineTo((float)(-1),(float)(+10));
	POLYGP[31].lineTo((float)(-1),(float)(-10));
	POLYGP[31].closePath();

	POLYGP[31].moveTo(-(float)(-.501),-(float)(-10));
	POLYGP[31].lineTo(-(float)(-.501),-(float)(+10));
	POLYGP[31].lineTo(-(float)(-1),-(float)(+10));
	POLYGP[31].lineTo(-(float)(-1),-(float)(-10));
	POLYGP[31].closePath();
    }


    public void setMap() {
	for(int i=0;i<=23;++i) MAP[1][i]=new Complex();
	for(int i=0;i<=23;++i) MAP[2][i]=new Complex();

	double PHI2=PHI*PHI;
	double PHI3=PHI*PHI*PHI;
	double PHI4=PHI2*PHI2;


	MAP[2][1]=new Complex(1/PHI,0);                
	MAP[1][1]=new Complex(1/PHI4+1/PHI,1/PHI3);

	MAP[2][3]=new Complex(1/PHI+1/PHI4,1/PHI3);      
	MAP[1][3]=new Complex(1/PHI-1/PHI4,-1/PHI3);

	MAP[1][5]=new Complex(1/PHI-1/PHI4,-1/PHI3);     
	MAP[2][5]=new Complex(-1/PHI,0);

	MAP[1][7]=MAP[1][5];
	MAP[2][7]=MAP[2][5];

	MAP[1][9]=new Complex(1/PHI,0);                
	MAP[2][9]=new Complex(-1/PHI4-1/PHI,-1/PHI3);

	MAP[2][11]=new Complex(-1/PHI4,-1/PHI3);           
	MAP[1][11]=new Complex(1/PHI+1/PHI4,1/PHI3);

	MAP[2][13]=MAP[2][11];
	MAP[1][13]=MAP[1][11];

	MAP[2][15]=new Complex(-1/PHI4,-1/PHI3);         
	MAP[1][15]=new Complex(-1/PHI,0);

	MAP[2][17]=MAP[2][15];
	MAP[1][17]=MAP[1][15];

	MAP[1][19]=new Complex(1/PHI,0);          
	MAP[2][19]=new Complex(-1/PHI4,-1/PHI3);

	MAP[1][21]=new Complex(1/PHI,0);       
	MAP[2][21]=new Complex(-1/PHI,0);

	MAP[1][23]=new Complex(1/PHI,0);     
	MAP[2][23]=new Complex(-1/PHI,0);

	for(int i=1;i<=21;i=i+2) {
	    MAP[1][i+1]=new Complex(-MAP[1][i].x,-MAP[1][i].y);
	    MAP[2][i+1]=new Complex(-MAP[2][i].x,-MAP[2][i].y);
	}
    }



    public void setTrace() {
	for(int i=0;i<=23;++i) TRACE[1][i]=new Complex();
	for(int i=0;i<=23;++i) TRACE[2][i]=new Complex();


	TRACE[2][1]=new Complex(0,1);                
	TRACE[1][1]=new Complex(1,1);

	TRACE[2][3]=new Complex(1,1);
	TRACE[1][3]=new Complex(-1,1);

	TRACE[1][5]=new Complex(-1,1);
	TRACE[2][5]=new Complex(0,-1);

	TRACE[1][7]=new Complex(-1,1);
	TRACE[2][7]=new Complex(0,-1);

	TRACE[1][9]=new Complex(0,1);
	TRACE[2][9]=new Complex(-1,-1);

	TRACE[2][11]=new Complex(-1,0);
	TRACE[1][11]=new Complex(1,1);

	TRACE[2][13]=new Complex(-1,0);
	TRACE[1][13]=new Complex(1,1);

	TRACE[2][15]=new Complex(-1,0);
	TRACE[1][15]=new Complex(0,-1);

	TRACE[2][17]=new Complex(-1,0);
	TRACE[1][17]=new Complex(0,-1);

	TRACE[1][19]=new Complex(0,1);
	TRACE[2][19]=new Complex(-1,0);

	TRACE[1][21]=new Complex(0,1);
	TRACE[2][21]=new Complex(0,-1);
	TRACE[2][22]=new Complex(0,1);              //21 and 22 and 23
	TRACE[1][22]=new Complex(0,-1);
	TRACE[1][23]=new Complex(0,1);              //21 and 22 and 23
	TRACE[2][23]=new Complex(0,-1);

	for(int i=1;i<=19;i=i+2) {
	    TRACE[1][i+1]=new Complex(-TRACE[1][i].x,-TRACE[1][i].y);
	    TRACE[2][i+1]=new Complex(-TRACE[2][i].x,-TRACE[2][i].y);
	}
    }

}


