import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;





public class PenrosePartitionCanvas extends Canvas implements MouseListener,MouseMotionListener{
    Manager M;
    double PHI=(1+Math.sqrt(5))/2;
    double PHI3=PHI*PHI*PHI;
    AffineTransform[] A=new AffineTransform[10];
    AffineTransform[][] AA=new AffineTransform[17][17];
    Point P1,P2;
    int X,Y;
    Color[] COL=new Color[30];
    SelectInteger[] IS=new SelectInteger[10];
    int count=0;
    int plot_count=0;
    PenrosePartition PX;
    ListenSquare INFO;
    Complex[] POINT=new Complex[100000];
    Color[] POINTCOLOR=new Color[100000];
    int point;




    public PenrosePartitionCanvas() {
	PX=new PenrosePartition();
        addMouseListener(this);
	addMouseMotionListener(this);
	P1=new Point(0,0);
	P2=new Point(0,0);
	IS[0]=new SelectInteger(5,30,30,15,1,1,5,1);	
	setColors();	
	INFO=new ListenSquare(0,0,12,12,Color.black);
	point=0;
	X=0;
	Y=0;
    }



    public PenrosePartitionCanvas addManager(Manager M) {

	PenrosePartitionCanvas XX=this;
	XX.M=M;
	return(XX);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

        setScales();  
        setColors();
        penrosePlot(g);
	drawPlot(g);
   }

   public void penrosePlot(Graphics2D g) {
      g.setColor(Color.black);
      g.fillRect(0,0,getWidth(),getHeight());
      g.setColor(Color.white);
      g.drawRect(0,0,getWidth()-1,getHeight()-1);

      drawZones(g);
   
      try{if(M.C.CON_X.PMARKER.L[0].on==1) drawCore(g);}
      catch(Exception e) {}
      drawDynamics(g);
      drawInstance(g); 
      try{if(M.C.CON_X.PMARKER.L[2].on==1) displayArrows(g);}  
      catch(Exception e){}
      drawFrame(g);   
      INFO.infoRender(g);
   }

    public void displayArrows(Graphics2D g) {
	Complex z=M.R.SOURCE;
	int x=(int)(z.x);
	int y=(int)(z.y);
	int k=classify(x,y);
	Complex z1=PX.MAP[1][k];
	Complex z2=PX.MAP[2][k];
        drawTile(g,k,z1,new Color(0,0,0,100));
        drawTile(g,k,z2,new Color(0,0,0,100));
    }






    public void drawPlot(Graphics2D g) {
	PolyWedge P=new PolyWedge();
	double d=.0002;
	for(int i=0;i<point;++i) {
	    P.count=4;
	    P.z[0]=new Complex(POINT[i].x-d,POINT[i].y-d);
	    P.z[1]=new Complex(POINT[i].x-d,POINT[i].y+d);
	    P.z[2]=new Complex(POINT[i].x+d,POINT[i].y+d);
	    P.z[3]=new Complex(POINT[i].x+d,POINT[i].y-d);
	    drawPolyQuick(g,P,POINTCOLOR[i]);
	}
    }





    public GeneralPath transform(GeneralPath X) {
	GeneralPath Y=new GeneralPath(X);
	Y.transform(A[1]);
	Y.transform(A[0]);
	return(Y);
    }


    public void setColors() {

	COL[0]=Color.green;

	   COL[1]=new Color(0,80,150);
	   COL[2]=new Color(0,110,200);
	   COL[3]=new Color(0,0,255);
	   COL[4]=new Color(50,80,255);

	   COL[5]=new Color(100,0,0);
	   COL[6]=new Color(130,0,0);
	   COL[7]=new Color(180,0,0);
	   COL[8]=new Color(220,00,0);
	   COL[9]=new Color(255,40,0);
	   COL[10]=new Color(255,80,0);


	   COL[11]=new Color(0,100,0);
	   COL[12]=new Color(0,150,0);
	   COL[13]=new Color(0,200,0);
	   COL[14]=new Color(0,255,0);

	   COL[15]=new Color(100,0,200);
	   COL[16]=new Color(150,0,250);
	   COL[17]=new Color(200,0,200);
	   COL[18]=new Color(250,0,250);
	   COL[19]=new Color(250,50,200);
           COL[20]=new Color(255,100,255);
	   COL[21]=new Color(0,150,150);
	   COL[22]=new Color(0,200,200);
	   COL[23]=new Color(0,255,255);
	   COL[24]=new Color(0,0,100);
	   COL[25]=new Color(0,0,100);
	   COL[26]=new Color(0,0,100);
	   COL[27]=new Color(0,0,100);

	try {
	    if(M.C.CON_X.PMARKER.L[3].on==1) {
                 for(int i=0;i<=27;++i) COL[i]=M.C.CON_X.PCOLORS.L[3].C;
	    }
	}
	catch(Exception e) {}

    }




    public void setScales() {
        int w=getWidth();
        int h=getHeight();

        double sc1=1;
        double sc2=1;

        A[0]=AffineTransform.getTranslateInstance(w/2,h/2);
        A[1]=AffineTransform.getScaleInstance(sc2*w,-sc1*h);
        A[5]=AffineTransform.getTranslateInstance(-P1.x+P2.x,-P1.y+P2.y);

        for(int i=-5;i<=5;++i) {
            for(int j=-5;j<=5;++j) {
                AA[5+i][5+j]=AffineTransform.getTranslateInstance(j,i);
            }
        }
    }

    public PolyWedge reflect(PolyWedge X) {
	PolyWedge Y=new PolyWedge();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) {
	    Y.z[i]=new Complex(-X.z[i].x,-X.z[i].y);
	}
	return(Y);
    }


    public void drawPoly(Graphics2D g,PolyWedge P,Complex zz,Color C) {
	GeneralPath gp=P.toGeneralPath();
	Complex z=new Complex(zz.x,zz.y);
	z.x=z.x+.5;
	z.y=z.y+.5;
        AffineTransform TR=AffineTransform.getTranslateInstance(z.x,z.y);
        gp.transform(TR);

	  for(int i=2;i<=8;++i) {
	      for(int j=2;j<=8;++j) {
		  GeneralPath gp2=new GeneralPath(gp);
		  gp2.transform(AA[i][j]);
	          gp2=transform(gp2);
                  gp2.transform(A[5]);
	          g.setColor(C);
	          g.fill(gp2);
                  g.setColor(Color.white);
		  try{g.setColor(M.C.CON_X.PCOLORS.L[4].C);}
		  catch(Exception e){}
	          g.draw(gp2);
	      }
	  }
    }




    public void savePoly(Output writer,PolyWedge P,Color C) {
	GeneralPath gp=P.toGeneralPath();
        AffineTransform TR=AffineTransform.getTranslateInstance(.5,.5);
        gp.transform(TR);

	  for(int i=2;i<=8;++i) {
	      for(int j=2;j<=8;++j) {
		  GeneralPath gp2=new GeneralPath(gp);
		  gp2.transform(AA[i][j]);
	          gp2=transform(gp2);
                  gp2.transform(A[5]);
		  writer.polyWrite(gp2,C);
	      }
	  }
    }



    public void drawPolyQuick(Graphics2D g,PolyWedge P,Color C) {
	GeneralPath gp=P.toGeneralPath();
        AffineTransform TR=AffineTransform.getTranslateInstance(.5,.5);
        gp.transform(TR);

	  for(int i=4;i<=6;++i) {
	      for(int j=4;j<=6;++j) {
		  GeneralPath gp2=new GeneralPath(gp);
		  gp2.transform(AA[i][j]);
	          gp2=transform(gp2);
                  gp2.transform(A[5]);
	          g.setColor(C);
	          g.fill(gp2);
	          g.draw(gp2);
	      }
	  }
    }












  public void drawTile(Graphics2D g,int k,Complex z,Color C) {
     drawPoly(g,PX.POLY[k],z,C);
  }


    public void drawZones(Graphics2D g) {
	for(int i=1;i<=27;++i) {
	    drawTile(g,i,new Complex(),COL[i]);
	}
    }


    public void saveZones() {	
        Output writer=new Output("Output/polygon");
	for(int i=1;i<=27;++i) {
	    savePoly(writer,PX.POLY[i],COL[i]);
	}
    }





    public void drawCore(Graphics2D g) {
	for(int i=1;i<=24;++i) {
	    drawPoly(g,PX.BABY[i],new Complex(),M.C.CON_X.PCOLORS.L[5].C);
	}
    }

    public int sign(int x) {
	if(x<0) return(-1);
	return(1);
    }

    public int abs(int x) {
	return(x*sign(x));
    }

    public int[] forwardPart(int[] seq,int k,int focus) {
	int[] s=new int[k];
	for(int i=focus;i<k;++i) s[i-focus]=seq[i];
	return(s);
    }


    public int[] backwardPart(int[] seq,int k,int focus) {
	int[] s=new int[k];
	for(int i=0;i<=focus;++i) s[i]=-seq[focus-i];
	return(s);
    }


    public PolyWedge sequencePullback(int[] seq,int k,int focus) {
	int[] seq1=forwardPart(seq,k,focus);
	int[] seq2=backwardPart(seq,k,focus);
	PolyWedge P1=sequencePullback(seq1,k-focus);
	PolyWedge P2=sequencePullback(seq2,focus+1);
	PolyWedge P=P1.polyChop(P1,P2);
	return(P);
    }



    public PolyWedge sequencePullback(int[] seq,int k) {

	PolyWedge P=new PolyWedge(PX.POLY[abs(seq[k-1])]);
	for(int i=k-2;i>=0;--i) {
	   P=dynamicPullback(seq[i],P);
	}
	return(P);
    }


    public PolyWedge sequencePullbackDebug(int[] seq,int k,int focus) {
	return(new PolyWedge());
    }


    public PolyWedge dynamicPullback(int k,PolyWedge P) {
	int kk=(3-sign(k))/2;  // 1 goes to 1 and -1 goes to 2
	return(dynamicPullback(kk,abs(k),P));
    }



    public PolyWedge dynamicPullback(int kk,int k,PolyWedge P) {

	Complex[][] Z=new Complex[5][5];
	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {
		Z[i+2][j+2]=new Complex(i,j);
	    }
	}

	int test=0;
	int hits=0;
	PolyWedge POLY1=PX.POLY[k];
	PolyWedge POLY3=new PolyWedge();
	PolyWedge POLY4=new PolyWedge();
            for(int i=0;i<=4;++i) {
		for(int j=0;j<=4;++j) {
		    Complex w=Complex.minus(Z[i][j],PX.MAP[kk][k]);
		    PolyWedge POLY2=P.translate(w);
		    test=PolyWedge.doTheyIntersect(POLY1,POLY2);

		    if(test==1) {
			hits=1;
			POLY3=POLY1.polyChop(POLY1,POLY2);
		    }

		}
	    }
	    if(hits==0) return(null);
	    return(POLY3);
    }


    public void drawDynamics(Graphics2D g) {
	drawDynamicsSingle(g);
	if(M.C.CON_X.PMARKER.L[1].on==1) drawDynamicsAll(g);
    }




    public PolyWedge getFirstPolygon(int cu) {
	int a=M.C.CON_X.SH.length;
	int b=(int)((a-1)/2);
         int[] list=M.C.CON_X.SH.list[cu];
	 return(sequencePullback(list,a,b));
    }


    public PolyWedge getSecondPolygon() {
	int len=M.C.CON_X.SH.shadow.seq.length;
	if(len==0) return(null);
	int middle=M.C.CON_X.SH.shadow.middle;
	Color COL=Color.green;
	return(sequencePullback(M.C.CON_X.SH.shadow.seq,len,middle));
    }


    public PolyWedge getThirdPolygon(PolyWedge XX) {
	int len=M.C.CON_X.SH.shadow.seq.length;
	if(len==0) return(null);
	int len2=M.C.CON_X.SH.length;
	int[] POS=new int[2];
	POS=M.C.CON_X.SH.shadow.POS[4];         //middle of 3,4,5
	Complex z1=mapTorus(POS[0],POS[1]);
	Complex z2=getSpecialPosition(XX,z1.x,z1.y);
	PolyWedge X=PX.shrink(XX);
	X=X.translate(z2);
	return(X);
    }




    public void drawDynamicsSingle(Graphics2D g) {
	int current=M.C.CON_X.SH.current;
	Color[] C=new Color[3];
	for(int i=0;i<3;++i)	C[i]=M.C.CON_X.PCOLORS.L[i].C;
	int test=1;
	if(M.C.CON_X.SH.length!=5) test=0;
	try{
	if(test*M.C.CON_X.SEQS.mode==1) {
	  PolyWedge X1=getFirstPolygon(current);
	  if(X1!=null)   drawPoly(g,X1,new Complex(),C[0]);
	  PolyWedge X2=getSecondPolygon();
	  if(X2!=null)   drawPoly(g,X2,new Complex(),C[1]);
	  PolyWedge X3=getThirdPolygon(X1);
	  if(X3!=null)   drawPoly(g,X3,new Complex(),C[2]);
	}}
	catch(Exception e) {
	    System.out.println("polygons not plotted ");
	}
    }


    public void drawDynamicsAll(Graphics2D g) {
	int girth=M.C.CON_X.SH.length;
	int half=(girth-1)/2;

	PolyWedge X=new PolyWedge();

	for(int i=0;i<M.C.CON_X.SH.total;++i) {
	    try{ 
                int type=M.C.CON_X.SH.list[i][half];
		Color CC=M.C.CON_X.PCOLORS.L[0].C;
	        X=sequencePullback(M.C.CON_X.SH.list[i],girth,half);
	        drawPoly(g,X,new Complex(),CC);
	    }
	    catch(Exception e) {
		System.out.println("not drawn");
	    }


	}
    }



  public void drawFrame(Graphics2D g) {

          GeneralPath x=new GeneralPath(PX.POLYGP[30]);
          x.transform(A[1]);
          x.transform(A[0]);
          g.setColor(Color.black);
          g.fill(x);
          x=new GeneralPath(PX.POLYGP[31]);
          x.transform(A[1]);
          x.transform(A[0]);
          g.fill(x);

    }



    public int classify(int xx,int yy) {
	Complex z=mapTorus(xx,yy);

	if(z==null) return(0);
	double x1=z.x;
	double x2=z.y;
	int[] a={0,1,-1};

	for(int j=0;j<=2;++j) {
	    for(int k=0;k<=2;++k) {
	      for(int i=1;i<=23;++i) {
	         if(PX.POLYGP[i].contains(x1+a[k],x2+a[j])==true) {
		     return(i);
		 }
	      }
	    }
	}
	return(0);
    }




    public void drawInstance(Graphics2D g) {   

	Complex z=mapTorus(X,Y);
	double x1=z.y;
	double x2=z.x;

        if(x2<-.5) x2=x2+1;
	if(x2>.5) x2=x2-1;
	if(x1<-.5) x1=x1+1;
	if(x1>.5) x1=x1-1;
	drawCross(g,x2,x1,.005);
    }


    /**choice=1 is the stronger requirement*/

    public int[][] generateShadow(int x0,int y0,int choice) {
	int x1=(int)(x0*PHI3);
	int y1=(int)(y0*PHI3);
	int[][] h=new int[10][2];
	int qq=0;
	for(int i=x1-3;i<=x1+3;++i) {
	    for(int j=y1-3;j<=y1+3;++j) {
		if(testInflate(i,j,x0,y0,choice)==1) {
		    h[qq][0]=i;
		    h[qq][1]=j;
                    ++qq;
		}
	    }
	}

	int[][] hh=new int[qq][2];
	for(int i=0;i<qq;++i) {
	    hh[i][0]=h[i][0];
	    hh[i][1]=h[i][1];
	}
	return(hh);
    }


    public int testInflate(int x,int y,int x0,int y0,int choice) {
	int n0=nearestLineInflate(x0,y0);
	int n=nearestLine(x,y);
	if(n!=n0) return(0);
	double dx=Math.abs(x0*PHI3-x);
	if(dx>2) return(0);
	double dy=Math.abs(y0*PHI3-y);
	if(dy>2) return(0);
	if(choice==1) {
	  if(classify(x,y)==0) return(0);
	}
	return(1);
    }



    public void drawDilation(Graphics2D g,double x1,double x2,PolyWedge XX) {
	Complex z=getSpecialPosition(XX,x1,x2);
	PolyWedge X=PX.shrink(XX);
	if(z!=null) {
              drawPoly(g,X,z,new Color(255,0,0,80));
	}
    }



    public Complex getSpecialPosition(PolyWedge XX,double x1,double x2) {
	PolyWedge X=PX.shrink(XX);

	GeneralPath gp0=X.toGeneralPath();
	GeneralPath gp1=new GeneralPath();
	for(int i=-7;i<7;++i) {
	    for(int j=-7;j<7;++j) {
		Complex z=new Complex(dec(i/(PHI*PHI3)+j/PHI),dec(i/PHI3));
	      AffineTransform A=AffineTransform.getTranslateInstance(z.x,z.y);
	      gp1=new GeneralPath(gp0);
	      gp1.transform(A);
	      if(polyContains(gp1,new Complex(x1,x2))==1) {
                return(z);
	      }
	    }
	}
       	return(null);
    }



    public int polyContains(GeneralPath gp,Complex z) {
	Complex z1=new Complex(0,1);
	Complex z2=new Complex(1,0);
	Complex w=new Complex();
	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {
		double x1=z.x+i*z1.x+j*z2.x;
		double y1=z.y+i*z1.y+j*z2.y;
		if(gp.contains(x1,y1)==true) return(1);
	    }
	}
	return(0);
    }


   public void drawCross(Graphics2D g,double x1,double x2,double size) {
       PolyWedge P=new PolyWedge();
       P.count=4;
       P.z[0]=new Complex(x1-size,x2-3*size);
       P.z[1]=new Complex(x1+size,x2-3*size);
       P.z[2]=new Complex(x1+size,x2+3*size);
       P.z[3]=new Complex(x1-size,x2+3*size);

       if(M.C.CON_X.PMARKER.L[4].on==1) {
	   P.count=8;
	   P.z[0]=new Complex(x1,x2);
	   P.z[1]=new Complex(x1-size,x2);
	   P.z[2]=new Complex(x1+size,x2);
	   P.z[3]=new Complex(x1,x2);
           P.z[4]=new Complex(x1,x2-3*size);
           P.z[5]=new Complex(x1,x2);
           P.z[6]=new Complex(x1,x2+3*size);
           P.z[7]=new Complex(x1,x2);
       }


       drawPoly(g,P,new Complex(),M.C.CON_X.PCOLORS.L[6].C);
   }



    /*the torus map*/
  public static double nearestWhole(double x) {
	return(Math.floor(x+.5));
    }

    public double dec(double x) {
	return(x-nearestWhole(x));
    }

    public Complex mapTorus(int x,int y) {
	double q=Math.sqrt(5)-2;
	double d=  2*x*q   +  2*y  +  (1.0-q)/2.0;
	Complex z=new Complex(dec(d*(1+q)/4),dec(d/2));
	return(z);
    }


    public Complex mapTorusCover(int x,int y,int o1,int o2) {
	double q=Math.sqrt(5)-2;
	double d=2*x*q+2*y+(1.0-q)/2.0;
	double d1=Math.pow(2,o1);
	double d2=Math.pow(2,o2);
	Complex z=new Complex(dec(d*(1+q)/d1),dec(d/d2));
	return(z);
    }





    public static  double mapPsi(int i,int j) {
	double PHI=(1+Math.sqrt(5))/2.0;
	double n0=1.0*j/PHI + 1.0*i/(PHI*PHI*PHI*PHI)+.5/(PHI*PHI*PHI);
	return(n0);
    }

   public static  int nearestLine(int i,int j) {
	double PHI=(1+Math.sqrt(5))/2;
	double  s=mapPsi(i,j);
	return((int)(nearestWhole(s)));
    }


   public static  int nearestLineInflate(int i,int j) {
	double PHI=(1+Math.sqrt(5))/2;
        double n0=1.0*j*PHI*PHI*PHI + 1.0*i+.5/(PHI*PHI);	
	return((int)(nearestWhole(n0/PHI)));
    }







    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	if(J.mode!=2) P1=J.X;
    }




   public void mouseReleased(MouseEvent e) {
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
           P1.x=P2.x;
           P1.y=P2.y;
           repaint();
   }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
     public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {

	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	P2=J.X;
	repaint();
    }


    public void mouseClicked(MouseEvent e) {

	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	IS[0].modify(J.X);
	if(INFO.inside(J.X)==1) info();
	if(M.C.EXPORT.mode==1) saveZones();
    }



    public void info() {

	String S="This window displays the polygon exchange (or torus partition) that controls the arithmetic graph for outer billiards on the Penrose kite.  These ideas are explained in my paper, but here I will explain the basic idea.  For this entire discussion, you should set the 'shape type' to 'Penrose kite' on the Tiling Window Control Panel.  The sort of structure we see her persists for other quadratically irrational kites, but we have not yet worked it out.";
	S=S+"\n\nYou can get a nice picture in the Arithmetic Graph window as follows.  On the Arithmetic Graph Control Panel, set the plot type to block, and then press go.  you should see a union of polygons drawn in green, blue, and red (unless you have previously played with this window.)";
S=S+"\n\nIf you now click on one of the vertices of the polygonal arcs in the Arithmetic Graph Window, you will see a point appear in the Polygon Exchange window.  The location of this point classifies the local picture around the point you have clicked in the Arithmetic Graph Window. For instance, click on the point with coordinates (2,4).  You will see a little dot appear in the upper right hand corner of the Polygon Exchange window, inside the green triangle.  You can also look on the Arithmetic Graph Control Panel and see that one of the green squares has been highlighted.   In this way, the Polygon Exchange window is a kind of classifying space for the picture in the Arithmetic Graph window.";
	S=S+"\n\nThe nature of the map from the Arithmetic Graph window to the Polygon Exchange window is explained in my paper, and also somewhat in the documentation for the Arithmetic Graph Control Panel, but you can figure it out by systematically watching the locations of points.  For instance, click on the point (0,0), and then repeatedly use the arrow keys in the upper left hand corner of the window to move the point.";
	S=S+"\n\nYou can see that the picture drawn in the Polygon Exchange window lies on a torus by dragging the mouse over the picture. Try it out. You can also draw this picture in several styles, by changing the settings in the 'partition draw style' panel on the Arithmetic Graph Control Panel."; 
	S=S+"\n\nUsing the Arithmetic Graph Control Panel, you can draw a variety of more sophisticated pictures on the Polygon Exchange Window. (For instance, try pushing the button that says 'core'.)  The documentation for the Arithmetic Graph Control Panel explains these other pictures.";
	M.E.setExplain(S);
	M.E.repaint();
    }


}
