import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class PenroseProofRoutines {
    PenroseProofData PD;
    PenroseProofData2 PD2;
    PenroseProofData3 PD3;
    PenrosePartition PX;

    public PenroseProofRoutines() {
	PD=new PenroseProofData();
	PD2=new PenroseProofData2();
	PD3=new PenroseProofData3();
	PX=new PenrosePartition();
    }


  






    /**This routine generates the gene sequences */

    public PenroseOrbitCoder  getOrbit(int x,int y,int length,int choice) {
	int xx=x;
	int yy=y;
	int type=0;
	int[] old={0,0};
	int map[]={0,0};
	int mapFull[]={0,0,0,0};
	PenroseOrbitCoder X=new PenroseOrbitCoder();

	for(int i=1;i<=length;++i) {
	    type=IntegerComplex.autoClassify(PX,xx,yy);
	    mapFull=PD.map[type];

	    if((choice==0)&&(i==1)) {
		map[0]=mapFull[0];
		map[1]=mapFull[1];
	    }

	    if((choice==1)&&(i==1)) {
		map[0]=mapFull[2];
		map[1]=mapFull[3];
	    }

	    if(i >1) {
		map[0]=mapFull[0];
		map[1]=mapFull[1];
		if((map[0]==-old[0])&&(map[1]==-old[1])) {
		    map[0]=mapFull[2];
		    map[1]=mapFull[3];
		}
	    }

            X.L[i][0]=type;
	    X.L[i][1]=map[0];
	    X.L[i][2]=map[1];
	    xx=xx+map[0];
	    yy=yy+map[1];
	    old[0]=map[0];
	    old[1]=map[1];
	}
	X.L[0][0]=length;
	return(X);
    }




    public PenroseOrbitCoder getOrbit(int x,int y,int length) {
	PenroseOrbitCoder OL=getOrbit(x,y,length,0);
	PenroseOrbitCoder OR=getOrbit(x,y,length,1);
	PenroseOrbitCoder O=new PenroseOrbitCoder();
	O.L=OL.L;
	O.R=OR.L;
	return(O);
    }


    public PenroseOrbitCoder getOrbit(int k) {
	int x=PD.loc[k][0];
	int y=PD.loc[k][1];
	return(getOrbit(x,y,3));
    }


    /*these routines generate the shadowing sequences*/
    public PenroseOrbitCoder  getOrbit(int x,int y,int x1,int y1,int x2,int y2,int choice) {
	int xx=x;
	int yy=y;
	int type=0;
	int[] old={0,0};
	int map[]={0,0};
	int mapFull[]={0,0,0,0};
	PenroseOrbitCoder X=new PenroseOrbitCoder();
	int test=0;
	int count=0;

	while((count<100)&&(test==0)) {
	   ++count;
	    type=IntegerComplex.autoClassify(PX,xx,yy);
	    mapFull=PD.map[type];

	    if((choice==0)&&(count==1)) {
		map[0]=mapFull[0];
		map[1]=mapFull[1];
	    }

	    if((choice==1)&&(count==1)) {
		map[0]=mapFull[2];
		map[1]=mapFull[3];
	    }

	    if(count >1) {
		map[0]=mapFull[0];
		map[1]=mapFull[1];
		if((map[0]==-old[0])&&(map[1]==-old[1])) {
		    map[0]=mapFull[2];
		    map[1]=mapFull[3];
		}
	    }

            X.L[count][0]=type;
	    X.L[count][1]=map[0];
	    X.L[count][2]=map[1];

	    if((xx==x1)&&(yy==y1)) test=1;
	    if((xx==x2)&&(yy==y2)) test=1;

	    xx=xx+map[0];
	    yy=yy+map[1];
	    old[0]=map[0];
	    old[1]=map[1];
	}
	X.L[0][0]=count;
	return(X);
    }



    public PenroseOrbitCoder getOrbit(int x,int y,int x1,int y1,int x2,int y2) {
	PenroseOrbitCoder OL=getOrbit(x,y,x1,y1,x2,y2,0);
	PenroseOrbitCoder OR=getOrbit(x,y,x1,y1,x2,y2,1);
	PenroseOrbitCoder O=new PenroseOrbitCoder();
	O.L=OL.L;
	O.R=OR.L;
	return(O);
    }


    public PenroseOrbitCoder getOrbit2(int k) {

	int x1=PD.loc2[k][0];
	int y1=PD.loc2[k][1];
	int x=PD.loc2[k][2];
	int y=PD.loc2[k][3];
	int x2=PD.loc2[k][4];
	int y2=PD.loc2[k][5];
	return(getOrbit(x,y,x1,y1,x2,y2));
    }

    public IntegerComplex getMap(int x,int y) {
	IntegerComplex z=new IntegerComplex();
	z.x[0]= 10*x-2*y;
	z.x[1]= -6*x+2*y;
	z.x[2]=-6*x;
	z.x[3]= 4*x;
	return(z);
    }






    /**Here we verify that each tile we have associated to a gene is contained in
       the dynamical polygon */

    public int matchClosedOrbit(int k,IntegerComplex z) {
	int type=0;
	int test=0;
	IntegerComplex zz=new IntegerComplex(z.x[0],z.x[1],z.x[2],z.x[3]);
	PenroseOrbitCoder OC=getOrbit(k);
	for(int i=1;i<=3;++i) {
	    type=OC.L[i][0]; 
	    test=IntegerComplex.isLatticeClosedContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.L[i][1],OC.L[i][2]);
	    zz=IntegerComplex.plus(zz,shift);
	}


        zz=new IntegerComplex(z.x[0],z.x[1],z.x[2],z.x[3]);
	for(int i=1;i<=3;++i) {
	    type=OC.R[i][0];
	    test=IntegerComplex.isLatticeClosedContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.R[i][1],OC.R[i][2]);
	    zz=IntegerComplex.plus(zz,shift);  
	}
	return(1);
    }


    public int checkPolygonsClosed(int k) {
	IntegerPolyWedge Y=PD.Y[k];
	for(int i=0;i<Y.count;++i) {
	    IntegerComplex z=new IntegerComplex(Y.z[i][0],Y.z[i][1],Y.z[i][2],Y.z[i][3]);
	    if(matchClosedOrbit(k,z)==0) return(0);
	}	
	return(1);
    }




    /**Here we verify that each tile we have associated to a gene is not a proper subset of
       the dynamical polygon */


    public int matchOpenOrbit(int k,IntegerComplex z) {
	int type=0;
	int test=0;
	IntegerComplex zz=new IntegerComplex(z.x[0],z.x[1],z.x[2],z.x[3]);
	PenroseOrbitCoder OC=getOrbit(k);

	for(int i=1;i<=3;++i) {
	    type=OC.L[i][0]; 
	    test=IntegerComplex.isLatticeOpenContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.L[i][1],OC.L[i][2]);
	    zz=IntegerComplex.plus(zz,shift);
	}


        zz=new IntegerComplex(z.x[0],z.x[1],z.x[2],z.x[3]);
	for(int i=1;i<=3;++i) {
	    type=OC.R[i][0];
	    test=IntegerComplex.isLatticeOpenContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.R[i][1],OC.R[i][2]);
	    zz=IntegerComplex.plus(zz,shift);  
	}
	return(1);
    }


    public int checkPolygonsOpen(int k) {
	IntegerPolyWedge Y=PD.Y[k];
	Y=IntegerComplex.goldenInterpolate(Y);
	for(int i=0;i<Y.count;++i) {
	    IntegerComplex z=new IntegerComplex(Y.z[i][0],Y.z[i][1],Y.z[i][2],Y.z[i][3]);
	    if(matchOpenOrbit(k,z)==0) {
                 return(1);
	    }
	}	
	return(0);
    }








    /*this routine locates the point which actually lies in the polygon*/

    public IntegerComplex canonicalPsi(int k) {
	int[] X=PD.loc[k];
	IntegerComplex z=IntegerComplex.psi(X[0],X[1]);
	IntegerPolyWedge P=PD.Y[k];

	IntegerComplex Z=new IntegerComplex(z);

	for(int i=-1;i<=1;++i) {
	    for(int j=-1;j<=1;++j) {
		Z=IntegerComplex.moveLattice(z,i,j);
		if(IntegerComplex.isOpenContained(Z,P)==1) {
                   return(Z);
		}
	    }
	}
	return(null);
    }


    public IntegerComplex canonicalPsi(int x,int y,int k) {
	IntegerComplex z=IntegerComplex.psi(x,y);
	IntegerPolyWedge P=PD.Y[k];

	IntegerComplex Z=new IntegerComplex(z);

	for(int i=-1;i<=1;++i) {
	    for(int j=-1;j<=1;++j) {
		Z=IntegerComplex.moveLattice(z,i,j);
		if(IntegerComplex.isOpenContained(Z,P)==1) {
                   return(Z);
		}
	    }
	}
	return(null);
    }







    /*This routine computes Psi(shadowing point)*/

   public IntegerComplex psiOfShadow(int k) {
	int[] X=PD.loc2[k];
	IntegerComplex z=IntegerComplex.psi(X[2],X[3]);
	return(z);
   }



    /*this routine finds the special similarity*/

    public int[] getSimilarityTranslate(int k) {
	IntegerComplex z1=canonicalPsi(k);
	z1=IntegerComplex.shrink(z1);
	IntegerComplex z2=psiOfShadow(k);
	IntegerComplex Z1=new IntegerComplex();
	int good=0;
	int[] SH=new int[2];
	SH[0]=99;
	SH[1]=99;

	for(int i=-7;i<=7;++i) {
	    for(int j=-7;j<=7;++j) {
		IntegerComplex s=getMap(i,j);
		Z1=IntegerComplex.plus(s,z1);

		int test=IntegerComplex.agreeLattice(z2,Z1);
		if(test==1) {
		    SH[0]=i;
		    SH[1]=j;	
		    return(SH);
		}
	    }
	}
	return(SH);
    }


    public int checkShadowOrbit(int x,int y,int k) {
	PenroseOrbitCoder OC=getOrbit2(k);
	IntegerPolyWedge P=PD.Y[k];
	int[] a=getSimilarityTranslate(k);
	IntegerComplex s=getMap(a[0],a[1]);
	IntegerComplex z=IntegerComplex.psi(x,y);
        if(checkShadowedItinerary(z,OC)==0) return(0);
	return(1);
    }




    /**this is the final routine for checking the inflation structure*/

    public int verifyInflation(int k) {
	PenroseOrbitCoder OC=getOrbit2(k);
	IntegerPolyWedge P=PD.Y[k];
	int[] a=getSimilarityTranslate(k);
	IntegerComplex s=getMap(a[0],a[1]);
	for(int i=0;i<P.count;++i) {
	    IntegerComplex z=new IntegerComplex(P.z[i][0],P.z[i][1],P.z[i][2],P.z[i][3]);
	    z=IntegerComplex.shrink(z);
	    z=IntegerComplex.plus(z,s);
	    if(checkShadowedItinerary(z,OC)==0) return(0);
	}
	return(1);
    }







    public int checkShadowedItinerary(IntegerComplex z,PenroseOrbitCoder OC) {
	int type=0;
	int test=0;
	IntegerComplex zz=new IntegerComplex(z);
	for(int i=1;i<=OC.L[0][0];++i) {
	    type=OC.L[i][0]; 
	    test=IntegerComplex.isLatticeClosedContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.L[i][1],OC.L[i][2]);
	    zz=IntegerComplex.plus(zz,shift);
	}

        zz=new IntegerComplex(z);
	for(int i=1;i<=OC.R[0][0];++i) {
	    type=OC.R[i][0];
	    test=IntegerComplex.isLatticeClosedContained(zz,PX.IPOLY[type]);
	    if(test==0) return(0);
	    IntegerComplex shift=getMap(OC.R[i][1],OC.R[i][2]);
	    zz=IntegerComplex.plus(zz,shift);  
	}
	return(1);
    }




    /*these routines test the geometric properties of the dynamical
      polygons and the associated genes*/

    public int[] getEndpoint1(int k) {
	int[] a1=new int[2];
	a1[0]=PD.loc[k][0];
	a1[1]=PD.loc[k][1];
	PenroseOrbitCoder OC=getOrbit(k);
	a1[0]=a1[0]+OC.L[1][1];
	a1[1]=a1[1]+OC.L[1][2];
	return(a1);
    }

    public int[] getEndpoint2(int k) {
	int[] a1=new int[2];
	a1[0]=PD.loc[k][0];
	a1[1]=PD.loc[k][1];
	PenroseOrbitCoder OC=getOrbit(k);
	a1[0]=a1[0]+OC.R[1][1];
	a1[1]=a1[1]+OC.R[1][2];
	return(a1);
    }

    /*This is the routine that verifies the coherence*/

    public int verifyCoherence(int k) {
	int[] x=PD3.p[k];
	int fine=IntegerComplex.fineClassify(PD,x[0],x[1]);
	IntegerComplex z1=canonicalPsi(x[0],x[1],fine);
        int[] a=getSimilarityTranslate(fine);
	IntegerComplex s=getMap(a[0],a[1]);
	IntegerComplex z2=IntegerComplex.shrink(z1);
	z2=IntegerComplex.plus(z2,s);
	int[] y=PD2.sp[k];
	IntegerComplex z3=IntegerComplex.psi(y[0],y[1]);
	int test=IntegerComplex.agreeLattice(z2,z3);
	return(test);
    }



    public int testDist(int k,int choice) {
	IntegerComplex p3=new IntegerComplex(2,4,0,0);
	int[] x1=getEndpoint1(k);
	if(choice==2) x1=getEndpoint2(k);
	int[] x2=new int[2];
	int[] x3=new int[2];

	x2[0]=PD.loc2[k][0];
	x2[1]=PD.loc2[k][1];
	x3[0]=PD.loc2[k][4];
	x3[1]=PD.loc2[k][5];

	IntegerComplex X1=new IntegerComplex(2*x1[0],0,2*x1[1],0);
	IntegerComplex X2=new IntegerComplex(2*x2[0],0,2*x2[1],0);
	IntegerComplex X3=new IntegerComplex(2*x3[0],0,2*x3[1],0);

	IntegerComplex Y1=IntegerComplex.twiceTimes(p3,X1);
	Y1=Y1.carefulHalf();

	IntegerComplex d1=IntegerComplex.minus(X2,Y1);
	IntegerComplex d2=IntegerComplex.minus(X3,Y1);

	d1=IntegerComplex.twiceTimes(d1,IntegerComplex.conjugate(d1));
	d2=IntegerComplex.twiceTimes(d2,IntegerComplex.conjugate(d2));

	IntegerComplex bound=new IntegerComplex(36,0,0,0); //represents 18=2*3*3
	d1=IntegerComplex.minus(bound,d1);
	d2=IntegerComplex.minus(bound,d2);
	int[] fin1={d1.x[0],d1.x[1]};
	int[] fin2={d2.x[0],d2.x[1]};


	if(IntegerComplex.sign(fin1)>0) return(1);
	if(IntegerComplex.sign(fin2)>0) return(1);
	return(0);
    }






   public double testDistances1(int k) {
	double PHI=(1+Math.sqrt(5))/2;
	int[] x1=getEndpoint1(k);
	int[] x21=new int[2];
	int[] x22=new int[2];

	x21[0]=PD.loc2[k][0];
	x21[1]=PD.loc2[k][1];
	x22[0]=PD.loc2[k][4];
	x22[1]=PD.loc2[k][5];

	double y11=PHI*PHI*PHI*x1[0];
	double y12=PHI*PHI*PHI*x1[1];

	double d1=2*(y11-x21[0])*(y11-x21[0])+2*(y12-x21[1])*(y12-x21[1]);
	double d2=2*(y11-x22[0])*(y11-x22[0])+2*(y12-x22[1])*(y12-x22[1]);
	double d=Math.min(d1,d2);
	return(d);
    }


    public double testDistances2(int k) {
	double PHI=(1+Math.sqrt(5))/2;
	int[] x1=getEndpoint2(k);
	int[] x21=new int[2];
	int[] x22=new int[2];

	x21[0]=PD.loc2[k][0];
	x21[1]=PD.loc2[k][1];
	x22[0]=PD.loc2[k][4];
	x22[1]=PD.loc2[k][5];

	double y11=PHI*PHI*PHI*x1[0];
	double y12=PHI*PHI*PHI*x1[1];

	double d1=(y11-x21[0])*(y11-x21[0])+(y12-x21[1])*(y12-x21[1]);
	double d2=(y11-x22[0])*(y11-x22[0])+(y12-x22[1])*(y12-x22[1]);
	d1=Math.sqrt(d1);
	d2=Math.sqrt(d2);
	double d=Math.min(d1,d2);
	return(d);
    }


public class PenroseOrbitCoder {
    int[][] L=new int[20][3];
    int[][] R=new int[20][3];

       public PenroseOrbitCoder() {} 


    public void print() {
	System.out.println("left sequence");

	for(int i=1;i<=L[0][0];++i) {
	    System.out.println(L[i][0]+" "+L[i][1]+" "+L[i][2]);
	}
	System.out.println("right sequence");
	for(int i=1;i<=R[0][0];++i) {
	    System.out.println(R[i][0]+" "+R[i][1]+" "+R[i][2]);
	}

	System.out.println("");
    }
}


}
