import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/*These routines verify the definedness property of our
  polygon exchange map.  The routines here mirror the
  routines in the PenroseStripMap class, except that they are done
  using integer arithmetic.*/

public class PenroseProofRoutines2 {
    double PHI=(1+Math.sqrt(5.0))/2.0;
    PenrosePartition PX;



    public PenroseProofRoutines2() {}


    /*Our decimal part routine uses floating point arithmetic
      to guide us in the choice of point, but then we verify
      that the choice of correct.  The integer (a1,a2) represents
      the pair (a1+a2 phi).*/


    public double toDouble(int[] a) {
	return(.5*a[0]+.5*a[1]*PHI);
    }

    public int[] dec8(int[] a) {
	double d=toDouble(a);
	int n=(int)(8*Math.floor(.125*d+.5));
	int[] b={a[0]-2*n,a[1]};
	int test=IntegerComplex.checkSmall8(b);
	if(test==0) System.out.println("fail "+b[0]+" "+b[1]);
	return(b);
    }





    public int[][] dec8(int[][] a) {
	int[][] b=new int[4][2];
	for(int i=0;i<4;++i) b[i]=dec8(a[i]);
	return(b);
    }





    public int getPolyCount(int a1) {
	PenrosePartition PX=new PenrosePartition();
	IntegerPolyWedge P=PX.IPOLY[a1];
	return(P.count);
    }



    public int[][] getVertexPlanar(int a1,int a2,int a3,int a4,int a5) {
	PenrosePartition PX=new PenrosePartition();
	IntegerPolyWedge P=PX.IPOLY[a1];

	int[] z=P.z[a2%P.count];
	int[] x1={z[0],z[1]};
	int[] y1={z[2],z[3]};

	int[] x2={x1[0]+2*a3,x1[1]};
	int[] y2={y1[0]+2*a4,y1[1]};
	int[][] a= new int[4][2];

	int[] c0={2*y2[0]+2,2*y2[1]};
	int[] c1={2*y2[0]-2,2*y2[1]};
	int[] c2={2*x2[0]-2,2*x2[1]+2};
	int[] c3={2*x2[0]+2,2*x2[1]-2};

	a[0]=c0;
	a[1]=c1;
	a[2]=c2;
	a[3]=c3;

	if(a5==1) {
	  a[0]=c1;
	  a[1]=c0;
	  a[2]=c3;
	  a[3]=c2;
	}
	return(a);
    }



    public int[][] getVertex(int a1,int a2,int a3,int a4,int a5) {
	int[][] a=getVertexPlanar(a1,a2,a3,a4,a5);
	a=dec8(a);
	return(a);
    }


    public int[][] goldenInterpolate(int[][] c1,int[][] c2) {
	int[][] d=new int[4][2];
	for(int i=0;i<4;++i) {
	    d[i]=IntegerComplex.goldenInterpolate(c1[i],c2[i]);
	}
	return(d);
    }


    /**This gets a point in the interior of the polygon*/

    public int[][] getTracePoint(int a1,int a3,int a4,int a5) {
	int[][] c1=getVertexPlanar(a1,0,a3,a4,a5);
	int[][] c2=getVertexPlanar(a1,1,a3,a4,a5);
	int[][] c3=getVertexPlanar(a1,2,a3,a4,a5);
	int[][] c4=goldenInterpolate(c1,c2);
	int[][] c5=goldenInterpolate(c4,c3);
	for(int i=0;i<4;++i) c5[i]=dec8(c5[i]);
	return(c5);
    }


    /*generates the test polygons*/

    public int[][][] subdivide(int count,int[][][] a) {
	int[][][] b=new int[count*2][4][2];
	for(int i=0;i<count;++i) {
	    int i1=i;
	    int i2=(i+1)%count;
	    b[2*i+0]=a[i];
	    b[2*i+1]=goldenInterpolate(a[i1],a[i2]);
	}
	return(b);
    }





    public int[][][] getPolygonPlanar(int a1,int a3,int a4,int a5) {	
	int count=getPolyCount(a1);
	int[][][] c=new int[count][4][2];
	for(int i=0;i<count;++i) c[i]=getVertexPlanar(a1,i,a3,a4,a5);
	for(int j=0;j<10;++j) {
	   c=subdivide(count,c);
	   count=count*2;
	}
	return(c);
    }

    public int[][][] toTorus(int count,int[][][] a) {
	int[][][] b=new int[count][4][2];
	for(int i=0;i<count;++i) {
	    b[i]=dec8(a[i]);
	}
	return(b);
    }

    public int[][][] getPolygon(int a1,int a3,int a4,int a5) {
	int count=getPolyCount(a1);
	int[][][] a=getPolygonPlanar(a1,a3,a4,a5);
	int[][][] b=toTorus(1024*count,a);
	return(b);
    }







    /**the linear maps*/

    public int[] dividePhi(int[] a) {
	int[] b={a[1]-a[0],a[0]};
	return(b);
    }

    public int[] timesPhi(int[] a) {
	int[] b={a[1],a[0]+a[1]};
	return(b);
    }


    public int[][] linearMap1(int[][] c) {
	int[][] d=new int[4][2];
	d[0]=c[0];
	d[1]=c[1];
	int[] e=dividePhi(c[1]);
	d[2][0]=-e[0]+c[2][0]+c[3][0];
	d[2][1]=-e[1]+c[2][1]+c[3][1];
	d[3]=e;
	return(d);
    }

    public int[][] linearMap2(int[][] c) {
	int[][] d=new int[4][2];
	d[0]=c[0];
	d[1]=c[1];
	d[2]=c[2];
	int[] e1=dividePhi(c[1]);
	int[] e2=timesPhi(c[2]);
        d[3][0]=-c[0][0]+e1[0]+e2[0];
	d[3][1]=-c[0][1]+e1[1]+e2[1];
	return(d);
    }


  public int[][] linearMap3(int[][] c) {
	int[][] d=new int[4][2];
	int[] e0=timesPhi(c[0]);
	int[] e1=dividePhi(c[0]);
	int[] e2=timesPhi(c[3]);
	int[] e3=dividePhi(c[3]);

	d[0][0]=e0[0]-c[1][0]-c[2][0]+e2[0];
	d[0][1]=e0[1]-c[1][1]-c[2][1]+e2[1];

	d[1][0]=e1[0]-c[2][0]+e2[0];
	d[1][1]=e1[1]-c[2][1]+e2[1];

	d[2][0]=-e1[0]+c[1][0]+2*c[2][0]-e2[0];
	d[2][1]=-e1[1]+c[1][1]+2*c[2][1]-e2[1];

	d[3][0]=-e1[0]+c[1][0]+c[2][0]-e3[0];
	d[3][1]=-e1[1]+c[1][1]+c[2][1]-e3[1];

	return(d);
  }

    public int[][] linearMap4(int[][] c) {
	int[][] d=new int[4][2];
	d[0]=c[0];
	d[1]=c[1];
	int[] e=dividePhi(c[0]);
	d[2]=e;
	d[3]=c[3];
	return(d);
    }



    public int[][] cubeMap1(int sh,int[][] c) {

	int[][] d=linearMap1(c);
	int[][][] g=new int[3][4][2];
	int[][] g0={{8,0},{8,0},{8,-8},{8,8}};
	int[][] g1={{0,0},{0,0},{0,0},{0,0}};
	int[][] g2={{8,0},{8,0},{8,8},{8,-8}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	int[][] e=new int[4][2];
	for(int i=0;i<4;++i) {
	    e[i][0]=d[i][0]+g[sh][i][0];
	    e[i][1]=d[i][1]+g[sh][i][1];
	    e[i]=dec8(e[i]);
	}
	return(e);
    }




    public int[][] cubeMap2(int sh,int[][] c) {

	int[][] d=linearMap2(c);
	int[][][] g=new int[5][4][2];
	int[][] g0={{0,0},{0,0},{0,0},{0,16}};
	int[][] g1={{0,0},{8,0},{0,0},{8,8}};
	int[][] g2={{0,0},{0,0},{0,0},{0,0}};
	int[][] g3={{0,0},{8,0},{0,0},{8,-8}};
	int[][] g4={{0,0},{0,0},{0,0},{0,-16}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	g[3]=g3;
	g[4]=g4;
	int[][] e=new int[4][2];
	for(int i=0;i<4;++i) {
	    e[i][0]=d[i][0]+g[sh][i][0];
	    e[i][1]=d[i][1]+g[sh][i][1];
	    e[i]=dec8(e[i]);
	}
	return(e);
    }


    public int[][] cubeMap3(int sh,int[][] c) {

	int[][] d=linearMap3(c);
	int[][][] g=new int[5][4][2];
	int[][] g0={{0,16},{0,16},{0,-16},{0,-16}};
	int[][] g1={{8,8},{8,8},{0,-8},{0,-8}};
	int[][] g2={{0,0},{0,0},{0,0},{0,0}};
	int[][] g3={{8,-8},{8,-8},{0,8},{0,8}};
	int[][] g4={{0,-16},{0,-16},{0,16},{0,16}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	g[3]=g3;
	g[4]=g4;
	int[][] e=new int[4][2];
	for(int i=0;i<4;++i) {
	    e[i][0]=d[i][0]+g[sh][i][0];
	    e[i][1]=d[i][1]+g[sh][i][1];
	    e[i]=dec8(e[i]);
	}
	return(e);
    }





    public int[][] cubeMap4(int sh,int[][] c) {

	int[][] d=linearMap4(c);
	int[][][] g=new int[3][4][2];
	int[][] g0={{8,0},{0,0},{8,8},{0,0}};
	int[][] g1={{0,0},{0,0},{0,0},{0,0}};
	int[][] g2={{8,0},{0,0},{8,-8},{0,0}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	int[][] e=new int[4][2];
	for(int i=0;i<4;++i) {
	    e[i][0]=d[i][0]+g[sh][i][0];
	    e[i][1]=d[i][1]+g[sh][i][1];
	    e[i]=dec8(e[i]);
	}
	return(e);
    }


    public int[][] cubeMap(int i,int sh, int[][] c) {
	if(i%4==1) return(cubeMap1(sh,c));
	if(i%4==2) return(cubeMap2(sh,c));
	if(i%4==3) return(cubeMap3(sh,c));
	if(i%4==0) return(cubeMap4(sh,c));
	return(null);
    }




    /*1 means yes */

    public int verifyContained(int[] a,int x1,int x2) {
	if((a[0]==2*x1)&&(a[1]==0)) return(1);  //on the boundary
	if((a[0]==2*x2)&&(a[1]==0)) return(1);  //on the boundary
	int[] b1={a[0]-2*x1,a[1]};
	int[] b2={2*x2-a[0],-a[1]};
	int t1=IntegerComplex.sign(b1);
	int t2=IntegerComplex.sign(b2);
	if((t1==1)&&(t2==1)) return(1);
	return(0);
    }

    public int verifyContainedStrict(int[] a,int x1,int x2) {
	int[] b1={a[0]-2*x1,a[1]};
	int[] b2={2*x2-a[0],-a[1]};
	int t1=IntegerComplex.sign(b1);
	int t2=IntegerComplex.sign(b2);
	if((t1==1)&&(t2==1)) return(1);
	return(0);
    }






    /**these routines determine which region of the 4-torus a point is in.
       The point must be in the interior of one of the regions*/


    public int determinerStrict1(int[][] c) {
	int[] a={c[1][0]+2,c[1][1]};
	if(verifyContainedStrict(a,-100,0)==1) return(0);
	if(verifyContainedStrict(a,0,4)==1) return(1);
	if(verifyContainedStrict(a,4,100)==1) return(2);
	return(-1);
    }

    public int determinerStrict2(int[][] c) {
	int[] a={c[1][0]+c[2][0]-4,c[1][1]+c[2][1]+2};
	if(verifyContainedStrict(a,-100,-8)==1) return(0);
	if(verifyContainedStrict(a,-8,-4)==1) return(1);
	if(verifyContainedStrict(a,-4,0)==1) return(2);
	if(verifyContainedStrict(a,0,4)==1) return(3);
	if(verifyContainedStrict(a,4,100)==1) return(4);
	return(-1);
    }


    public int determinerStrict3(int[][] c) {
	int[] a={c[0][0]+c[3][0]-4,c[0][1]+c[3][1]+2};
	if(verifyContainedStrict(a,-100,-8)==1) return(0);
	if(verifyContainedStrict(a,-8,-4)==1) return(1);
	if(verifyContainedStrict(a,-4,0)==1) return(2);
	if(verifyContainedStrict(a,0,4)==1) return(3);
	if(verifyContainedStrict(a,4,100)==1) return(4);
	return(-1);
    }


    public int determinerStrict4(int[][] c) {
	int[] a={c[0][0]+2,c[0][1]};
	if(verifyContainedStrict(a,-100,0)==1) return(0);
	if(verifyContainedStrict(a,0,4)==1) return(1);
	if(verifyContainedStrict(a,4,100)==1) return(2);
	return(-1);
    }

    public int determinerStrict(int i,int[][] c) {
	if(i%4==1) return(determinerStrict1(c));
	if(i%4==2) return(determinerStrict2(c));
	if(i%4==3) return(determinerStrict3(c));
	if(i%4==0) return(determinerStrict4(c));
	return(-1);
    }


    /**these routines allow the point to be on the boundary of the domain
       but the cost is that we need to keep track of an integer that tells
       which domain the point should be in*/


    public int determiner1(int e,int[][] c) {
	int[] a={c[1][0]+2,c[1][1]};
	if((e%2==0)&&(verifyContained(a,-100,0)==1)) return(0);
	if((e%2==1)&&(verifyContained(a,0,4)==1)) return(1);
	if((e%2==0)&&(verifyContained(a,4,100)==1)) return(2);
	return(-1);
    }

    public int determiner2(int e,int[][] c) {
	int[] a={c[1][0]+c[2][0]-4,c[1][1]+c[2][1]+2};
	if((e%2==0)&&(verifyContained(a,-100,-8)==1)) return(0);
	if((e%2==1)&&(verifyContained(a,-8,-4)==1)) return(1);
	if((e%2==0)&&(verifyContained(a,-4,0)==1)) return(2);
	if((e%2==1)&&(verifyContained(a,0,4)==1)) return(3);
	if((e%2==0)&&(verifyContained(a,4,100)==1)) return(4);
	return(-1);
    }


    public int determiner3(int e,int[][] c) {
	int[] a={c[0][0]+c[3][0]-4,c[0][1]+c[3][1]+2};
	if((e%2==0)&&(verifyContained(a,-100,-8)==1)) return(0);
	if((e%2==1)&&(verifyContained(a,-8,-4)==1)) return(1);
	if((e%2==0)&&(verifyContained(a,-4,0)==1)) return(2);
	if((e%2==1)&&(verifyContained(a,0,4)==1)) return(3);
	if((e%2==0)&&(verifyContained(a,4,100)==1)) return(4);
	return(-1);
    }


    public int determiner4(int e,int[][] c) {
	int[] a={c[0][0]+2,c[0][1]};
	if((e%2==0)&&(verifyContained(a,-100,0)==1)) return(0);
	if((e%2==1)&&(verifyContained(a,0,4)==1)) return(1);
	if((e%2==0)&&(verifyContained(a,4,100)==1)) return(2);
	return(-1);
    }


    public int determiner(int i,int e,int[][] c) {
	if(i%4==1) return(determiner1(e,c));
	if(i%4==2) return(determiner2(e,c));
	if(i%4==3) return(determiner3(e,c));
	if(i%4==0) return(determiner4(e,c));
	return(0);
    }



    public int[] getFullCode(int a1,int a3,int a4,int a5) {

    int[] s=new int[10];
    int[][][] c=new int[10][4][2];
    c[0]=getTracePoint(a1,a3,a4,a5);
	for(int i=1;i<=8;++i) {
	    s[i-1]=determinerStrict(i,c[i-1]);
	    c[i]=cubeMap(i,s[i-1],c[i-1]);
	}
	return(s);
    }

    public int[] getCode(int a1,int a3,int a4,int a5) {
	int[] s=getFullCode(a1,a3,a4,a5);
	for(int i=0;i<8;++i) s[i]=s[i]%2;
	return(s);
    }

    public void printCode(int[] s) {
	for(int i=0;i<8;++i) System.out.print(s[i]);
	System.out.println("");
    }



    /**1 means yes */




    public int verifyItinerary(int[] code,int a1,int a2,int a3,int a4,int a5) {

    int[] s=new int[10];
    int[][][] c=new int[10][4][2];
    c[0]=getVertex(a1,a2,a3,a4,a5);

	for(int i=1;i<=8;++i) {
	    s[i-1]=determiner(i,code[i-1],c[i-1]);
	    int test1=code[i-1]%2;
	    int test2=s[i-1]%2;
	    if(test1!=test2) return(0);
	    c[i]=cubeMap(i,s[i-1],c[i-1]);
	}
	return(1);
    }


    public int verifyItinerary(int[] code,int[][] a) {
        int[] s=new int[10];
        int[][][] c=new int[10][4][2];
	c[0]=a;

	for(int i=1;i<=8;++i) {
	    s[i-1]=determiner(i,code[i-1],c[i-1]);
	    int test1=code[i-1]%2;
	    int test2=s[i-1]%2;
	    if(test1!=test2) return(0);
	    c[i]=cubeMap(i,s[i-1],c[i-1]);
	}
	return(1);
    }


    public int verifyItinerary(int a1,int a3,int a4,int a5) {

	int[] code=getCode(a1,a3,a4,a5);
	int[][][] a=getPolygon(a1,a3,a4,a5);
	int count=getPolyCount(a1);

	for(int i=0;i<count;++i) {
	    int test=verifyItinerary(code,a[i]);
	    if(test==0) return(0);
	}
	return(1);
    }






    public int verifyItinerary(int a1) {
	for(int i3=0;i3<4;++i3) {
	    for(int i4=0;i4<4;++i4) {
		for(int i5=0;i5<2;++i5) {
		    int test=verifyItinerary(a1,i3,i4,i5);
                    if(test==0) return(0);
		}
	    }
	}
	return(1);
    }





}

