import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PenroseStripMap {
    double PHI=(1+Math.sqrt(5.0))/2.0;
    double[][] h=new double[10][3];
    double[][] hX=new double[10][3];
    Complex[] v=new Complex[10];
    int maxx;

    public PenroseStripMap() {

	h[1][0]=-1.0/4.0;
	h[1][1]=+1.0/4.0;
	h[1][2]=+3.0/4.0;

	h[2][0]=-PHI/4;
	h[2][1]=+1/(4*PHI*PHI);
	h[2][2]=+1/(4*PHI*PHI);

	h[3][0]=-PHI/4;
	h[3][1]=-1/(4*PHI*PHI);
	h[3][2]=+1/(4*PHI*PHI);

	h[4][0]=-1.0/4.0;
	h[4][1]=-1.0/4.0;
	h[4][2]=+3.0/4.0;


	h[5][0]=+1.0/4.0;
	h[5][1]=-1.0/4.0;
	h[5][2]=+1.0/4.0;

	h[6][0]=+PHI/4;
	h[6][1]=-1/(4*PHI*PHI);
	h[6][2]=1/PHI+3/(4*PHI*PHI);

	h[7][0]=+PHI/4;
	h[7][1]=+1/(4*PHI*PHI);
	h[7][2]=1/PHI+3/(4*PHI*PHI);

	h[8][0]=+1.0/4.0;
	h[8][1]=+1.0/4.0;
	h[8][2]=+1.0/4.0;

	v[1]=new Complex(0,4);
	v[2]=new Complex(-2,2);
	v[3]=new Complex(-4/PHI,0);
	v[4]=new Complex(-2,-2);
	v[5]=new Complex(0,-4);
	v[6]=new Complex(2,-2);
	v[7]=new Complex(4/PHI,0);
	v[8]=new Complex(2,2);

	maxx=0;
    }



    /**Here is the definition of the edge map*/

    public int getJump(int j,Complex z) {
	double[] H=new double[3];
	H[0]=h[j][0];
	H[1]=h[j][1];
	H[2]=h[j][2];
	Complex V=new Complex(v[j]);
	double d=H[0]*z.x+H[1]*z.y+H[2];
	int n=-(int)(Math.floor(d));
	return(n);
    }

    public Complex doMap(int j,Complex z) {
	int d=getJump(j,z);
	Complex V=new Complex(v[j]);
	V.x=d*V.x;
	V.y=d*V.y;
	Complex w=Complex.plus(V,z);
	return(w);
    }

    public int[] mapSpectrum(Complex zz) {
	int[] n=new int[10];
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
	    n[j]=getJump(j,z);
	    z=doMap(j,z);
	}

	n[1]=n[6]-n[2];
	n[2]=n[7]-n[3];
	n[3]=n[8]-n[4];
	return(n);
    }

    public Complex doReturn(Complex zz) {
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
	    z=doMap(j,z);
	}
	int test=(int)(1-z.y);
	if(test%4==0) return(new Complex(z.x,1));
	if(test%4==2) return(new Complex(z.x,-1));
	return(new Complex(0,0));
    }

    public int[] doReturnIntegral(Complex zz) {
	int[] m=mapSpectrum(zz);
	Complex z=doReturn(zz);
	int[] s=new int[3];
	s[0]=2*m[1]-4*m[2]+2*m[3];
	s[1]=4*m[2];
	s[2]=(int)(z.y);
	return(s);
    }



    /*Here is the map to the 4-torus*/

    public double dec(double x) {
	return(x-Math.floor(x+.5));
    }

    public double dec8(double x) {
	double y=8*dec(x/8);
	return(y);
    }

    public double[] bigMap(double x,double y) {
	double[] z=new double[4];
	z[0]=dec8((x+y));
	z[1]=dec8((x-y));
	z[2]=dec8((x+y)/PHI);
	z[3]=dec8((x-y)/PHI);
	return(z);
    }



    /*Here are the 4 dimensional completions of the edge maps*/




    public double[] linearMap1(double[] x) {
	double[] y=new double[4];
	y[0]=x[0];
	y[1]=x[1];
	y[2]=-x[1]/PHI+x[2]+x[3];
	y[3]=x[1]/PHI;



	return(y);
    }

    public double[] linearMap2(double[] x) {
	double[] y=new double[4];
	y[0]=x[0];
	y[1]=x[1];
	y[2]=x[2];
	y[3]=-x[0]+x[1]/PHI+x[2]*PHI;


	return(y);
    }

    public double[] linearMap3(double[] x) {
	double[] y=new double[4];
	y[0]=x[0]*PHI-x[1]-x[2]+x[3]*PHI;
	y[1]=x[0]/PHI-x[2]+x[3]*PHI;
	y[2]=-x[0]/PHI+x[1]+2*x[2]-x[3]*PHI;
	y[3]=-x[0]/PHI+x[1]+x[2]-x[3]/PHI;
	return(y);
    }

    public double[] linearMap4(double[] x) {
	double[] y=new double[4];
	y[0]=x[0];
	y[1]=x[1];
	y[2]=x[0]/PHI;
	y[3]=x[3];
	return(y);
    }

    public int determiner1(double[] x) {
	double d=x[1]+1.0;
	int sh=0;
	if(d<0) sh=0;
	if((d>0)&&(d<4)) sh=1;
	if(d>4) sh=2;
	return(sh);
    }

    public int determiner2(double[] x) {
        double sp=1/(2*PHI*PHI);
	double d=.5*(x[1]+x[2])-sp;	
	int sh=0;
        if(d<-4) sh=0;
	if((d>-4)&&(d<-2)) sh=1;
	if((d>-2)&&(d<0)) sh=2;
	if((d>0)&&(d<2)) sh=3;
	if(d>2) sh=4;



	return(sh);
    }

    public int determiner3(double[] x) {
        double sp=1/(PHI*PHI);
	double d=.5*(x[0]+x[3]-sp);
	int sh=0;
        if(d<-4) sh=0;
	if((d>-4)&&(d<-2)) sh=1;
	if((d>-2)&&(d<0)) sh=2;
	if((d>0)&&(d<2)) sh=3;
	if(d>2) sh=4;
	return(sh);
    }


    public int determiner4(double[] x) {
	double d=x[0]+1.0;	
	int sh=0;
        if(d<0) sh=0;
	if((d>0)&&(d<4)) sh=1;
	if(d>4) sh=2;
	return(sh);
    }




    public int determiner(int q,double[] x) {
	if(q%4==1) return(determiner1(x));
	if(q%4==2) return(determiner2(x));
	if(q%4==3) return(determiner3(x));
	if(q%4==0) return(determiner4(x));
	return(9999999);
    }


    public double[] cubeMap1(double[] x) {
	double[] y=linearMap1(x);
	int sh=determiner1(x);
	int[][][] g=new int[3][4][2];
	int[][] g0={{8,0},{8,0},{8,-8},{8,8}};
	int[][] g1={{0,0},{0,0},{0,0},{0,0}};
	int[][] g2={{8,0},{8,0},{8,8},{8,-8}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	for(int i=0;i<4;++i) y[i]=dec8(y[i]+.5*g[sh][i][0]+.5*PHI*g[sh][i][1]);
	return(y);
    }



    public double[] cubeMap2(double[] x) {
	double[] y=linearMap2(x);
	int sh=determiner2(x);
	int[][][] g=new int[5][4][2];
	int[][] g0={{0,0},{0,0},{0,0},{0,16}};
	int[][] g1={{0,0},{8,0},{0,0},{8,8}};
	int[][] g2={{0,0},{0,0},{0,0},{0,0}};
	int[][] g3={{0,0},{8,0},{0,0},{8,-8}};
	int[][] g4={{0,0},{0,0},{0,0},{0,-16}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	g[3]=g3;
	g[4]=g4;
	for(int i=0;i<4;++i) y[i]=dec8(y[i]+.5*g[sh][i][0]+.5*PHI*g[sh][i][1]);

	return(y);
    }

    public double[] cubeMap3(double[] x) {
	double[] y=linearMap3(x);
	int sh=determiner3(x);
	int[][][] g=new int[5][4][2];
	int[][] g0={{0,16},{0,16},{0,-16},{0,-16}};
	int[][] g1={{8,8},{8,8},{0,-8},{0,-8}};
	int[][] g2={{0,0},{0,0},{0,0},{0,0}};
	int[][] g3={{8,-8},{8,-8},{0,8},{0,8}};
	int[][] g4={{0,-16},{0,-16},{0,16},{0,16}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	g[3]=g3;
	g[4]=g4;
	for(int i=0;i<4;++i) y[i]=dec8(y[i]+.5*g[sh][i][0]+.5*PHI*g[sh][i][1]);

	return(y);

    }

    public double[] cubeMap4(double[] x) {
	double[] y=linearMap4(x);
	int sh=determiner4(x);
	int[][][] g=new int[3][4][2];
	int[][] g0={{8,0},{0,0},{8,8},{0,0}};
	int[][] g1={{0,0},{0,0},{0,0},{0,0}};
	int[][] g2={{8,0},{0,0},{8,-8},{0,0}};
	g[0]=g0;
	g[1]=g1;
	g[2]=g2;
	for(int i=0;i<4;++i) y[i]=dec8(y[i]+.5*g[sh][i][0]+.5*PHI*g[sh][i][1]);
	return(y);
    }





    public double[] cubeMap(int j,double[] x) {
	if(j%4==1) return(cubeMap1(x));
	if(j%4==2) return(cubeMap2(x));
	if(j%4==3) return(cubeMap3(x));
	if(j%4==0) return(cubeMap4(x));
	return(null);
    }


    public double[][] cubeMap(int j,double[][] x,int count) {
	double[][] y=new double[count][4];
	for(int i=0;i<count;++i) y[i]=cubeMap(j,x[i]);
	return(y);
    }


    public double testSize(double[] x ) {
	double test=0;
	for(int i=0;i<4;++i) {
	    test=test+x[i]*x[i];
	}
	test=Math.sqrt(test);
	return(test);
    }


    public int checkMap(int j,Complex p1) {
	Complex p2=doMap(j,p1);
	double[] d1=bigMap(p1.x,p1.y);
	double[] d2=bigMap(p2.x,p2.y); 
	double[] d3=cubeMap(j,d1);
	double[] d4=new double[4];
	for(int i=0;i<4;++i) d4[i]=d2[i]-d3[i];
	double test=testSize(d4);
	if(test<.0000001) return(1);
	return(0);
    }



    /*Here is the calculation for the arithmetic graph lemma*/


    public double[] getVertex(int a1,int a2,int a3,int a4,int a5) {
	PenrosePartition PE=new PenrosePartition();
	PenroseProofRoutines2 PR2=new PenroseProofRoutines2();
	PolyWedge P=PE.POLY[a1];
	P=P.shrinkSlightly(.000000001);
	Complex z1=P.z[a2%P.count];
	double x1=z1.x;
	double y1=PHI*z1.x-z1.y;
	double x2=2*x1+2.0*a3;
	double y2=2*y1+2.0*a4;
	double[] a=new double[4];

	if(a5==0) {
	   a[0]=dec8(y2+1.0);
	   a[1]=dec8(y2-1.0);
	   a[2]=dec8(x2+1.0/PHI);
	   a[3]=dec8(x2-1.0/PHI);
	}
	if(a5==1) {
	   a[0]=dec8(y2-1.0);
	   a[1]=dec8(y2+1.0);
	   a[2]=dec8(x2-1.0/PHI);
	   a[3]=dec8(x2+1.0/PHI);
	}

	return(a);
    }


    public int getItinerary(int a1,int a2,int a3,int a4,int a5) {
	double[][] c=new double[10][4];
	int[] s=new int[9];
	c[0]=getVertex(a1,a2,a3,a4,a5);
	for(int i=1;i<=8;++i) {
	    s[i-1]=determiner(i,c[i-1]);
	    c[i]=cubeMap(i,c[i-1]);
	}
	int code=0;
	for(int i=0;i<=7;++i) {
              s[i]=s[i]%2;
	      code=code+(int)(Math.pow(2,i)*s[i]);
	}
	return(code);
    }




    public int getItinerary(int a1,int a3,int a4,int a5) {
	int fail=1;
    PenrosePartition PE=new PenrosePartition();
    PolyWedge P=PE.POLY[a1];  
    int code=getItinerary(a1,0,a3,a4,a5);
    int code2=0;
    for(int i=0;i<P.count;++i) {
	code2=getItinerary(a1,i,a3,a4,a5);
	if(code2!=code) {
	    fail=0;
	}
    }
    return(fail);
    }



    public int getItinerary(int a1) {
	for(int i3=0;i3<4;++i3) {
	    for(int i4=0;i4<4;++i4) {
		for(int i5=0;i5<2;++i5) {
		    int test=getItinerary(a1,i3,i4,i5);
                    if(test==0) return(0);
		}
	    }
	}
	return(1);
    }







    /**stretchSize routines*/


    public double[][] getPolygon(int a1,int a3,int a4,int a5) {	
        PenrosePartition PE=new PenrosePartition();
	PolyWedge P=PE.POLY[a1];
	double[][] a=new double[P.count][4];
	for(int i=0;i<P.count;++i) {
	    a[i]=getVertex(a1,i,a3,a4,a5);
	}
	return(a);
    }




    public double wrapDist(double[] c1,double[] c2) {
	double[] c=new double[4];
	double try1,try2,try3;
	for(int i=0;i<4;++i) {
	    try1=Math.abs(c1[i]-c2[i]);
	    try2=Math.abs(c1[i]-c2[i]+8);
	    try3=Math.abs(c1[i]-c2[i]-8);
	    c[i]=try1;
	    if(c[i]>try2) c[i]=try2;
	    if(c[i]>try3) c[i]=try3;
	}
	return(testSize(c));
    }


    public double stretch(double[][] c,int count) {
	double str=0;
	for(int i=0;i<count;++i) {
	    int i1=i;
	    int i2=(i+1)%count;
	    double r=wrapDist(c[i1],c[i2]);
	    if(str<r) str=r;
	}
	return(str);
    }



    public void printOut(double[] x) {
	double y;
	for(int i=0;i<4;++i) {
	    y=x[i];
	    if(Math.abs(y)<.000000001) y=0;
            System.out.print(y+" ");
	}
	System.out.println("");
    }


    public double orbitStretch(int a1,int a3,int a4,int a5) {

	double str=0;
        PenrosePartition PE=new PenrosePartition();
	PolyWedge P=PE.POLY[a1];

	double[][] c=getPolygon(a1,a3,a4,a5);
        double test=stretch(c,P.count);


	for(int i=1;i<=8;++i) {
	    c=cubeMap(i,c,P.count);
	    test=stretch(c,P.count);
	    if(str<test) str=test;
	}
	return(str);
    }


    public double orbitStretch(int a1) {
	double str=0;
	for(int i3=0;i3<4;++i3) {
	    for(int i4=0;i4<4;++i4) {
		for(int i5=0;i5<2;++i5) {
		   double test=orbitStretch(a1,i3,i4,i5);
		   if(str<test) str=test;
		}
	    }
	}
	return(str);
    }








}

